/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.mimetype.ExtensionBasedMimeTypeDetector;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.mimetype.MimeTypeDetectorConfig;
import org.modeshape.graph.mimetype.MimeTypeDetectors;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathExpression;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.text.TextExtractor;
import org.modeshape.graph.text.TextExtractorConfig;
import org.modeshape.graph.text.TextExtractors;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.repository.ModeShapeConfigurationException;
import org.modeshape.repository.ModeShapeLexicon;
import org.modeshape.repository.RepositoryI18n;
import org.modeshape.repository.RepositoryService;
import org.modeshape.repository.SimpleRepositoryContext;
import org.modeshape.repository.cluster.ClusteringConfig;
import org.modeshape.repository.cluster.ClusteringService;
import org.modeshape.repository.sequencer.SequencerConfig;
import org.modeshape.repository.sequencer.SequencingService;

@Immutable
public class ModeShapeEngine {
    public static final int DEFAULT_GARBAGE_COLLECTION_INTERVAL_IN_SECONDS = 600;
    public static final String CONFIGURATION_REPOSITORY_NAME = "dna:configuration";
    protected final ModeShapeConfiguration.ConfigurationDefinition configuration;
    protected final ConfigurationScanner scanner;
    protected final Problems problems;
    protected final ExecutionContext context;
    private final RepositoryService repositoryService;
    private final SequencingService sequencingService;
    private final ExecutorService executorService;
    private final ClusteringService clusteringService;
    private final MimeTypeDetectors detectors;
    private final TextExtractors extractors;
    private final String engineId = UUID.randomUUID().toString();
    private final Logger logger;
    private final ScheduledExecutorService gcService = new ScheduledThreadPoolExecutor(1);

    protected ModeShapeEngine(ExecutionContext context, ModeShapeConfiguration.ConfigurationDefinition configuration) {
        this.problems = new SimpleProblems();
        this.logger = Logger.getLogger(this.getClass());
        this.detectors = new MimeTypeDetectors();
        this.extractors = new TextExtractors();
        this.context = context.with(this.detectors).with(this.extractors).with(this.engineId);
        this.configuration = configuration;
        this.scanner = this.newConfigurationScanner(this.problems, this.context, this.configuration);
        for (MimeTypeDetectorConfig mimeTypeDetectorConfig : this.scanner.getMimeTypeDetectors()) {
            this.detectors.addDetector(mimeTypeDetectorConfig);
        }
        this.detectors.addDetector(new MimeTypeDetectorConfig("ExtensionDetector", "Extension-based MIME type detector", ExtensionBasedMimeTypeDetector.class));
        for (TextExtractorConfig textExtractorConfig : this.scanner.getTextExtractors()) {
            this.extractors.addExtractor(textExtractorConfig);
        }
        ClusteringConfig clusterConfig = this.scanner.getClusteringConfiguration();
        this.clusteringService = new ClusteringService();
        this.clusteringService.setExecutionContext(context);
        this.clusteringService.setClusteringConfig(clusterConfig);
        Path path = this.configuration.getPath();
        String configWorkspaceName = this.configuration.getWorkspace();
        RepositorySource configSource = this.configuration.getRepositorySource();
        this.repositoryService = new RepositoryService(configSource, configWorkspaceName, path, context, this.clusteringService, this.problems);
        NamedThreadFactory threadPoolFactory = new NamedThreadFactory(configuration.getName());
        this.executorService = Executors.newCachedThreadPool(threadPoolFactory);
        this.sequencingService = new SequencingService();
        this.sequencingService.setExecutionContext(context);
        this.sequencingService.setExecutorService(this.executorService);
        this.sequencingService.setRepositoryLibrary(this.repositoryService.getRepositoryLibrary());
        for (SequencerConfig sequencerConfig : this.scanner.getSequencingConfigurations()) {
            this.sequencingService.addSequencer(sequencerConfig);
        }
    }

    protected ConfigurationScanner newConfigurationScanner(Problems problems, ExecutionContext context, ModeShapeConfiguration.ConfigurationDefinition configuration) {
        return new ConfigurationScanner(problems, context, configuration);
    }

    protected Logger logger() {
        return this.logger;
    }

    public Problems getProblems() {
        return this.problems;
    }

    public final ExecutionContext getExecutionContext() {
        return this.context;
    }

    public final RepositorySource getRepositorySource(String repositoryName) {
        this.checkRunning();
        return this.repositoryService.getRepositoryLibrary().getSource(repositoryName);
    }

    public final RepositoryConnectionFactory getRepositoryConnectionFactory() {
        this.checkRunning();
        return this.repositoryService.getRepositoryLibrary();
    }

    public final RepositoryService getRepositoryService() {
        this.checkRunning();
        return this.repositoryService;
    }

    public final Graph getGraph(String sourceName) {
        CheckArg.isNotNull(sourceName, "sourceName");
        return this.getGraph(this.getExecutionContext(), sourceName);
    }

    public final Graph getGraph(ExecutionContext context, String sourceName) {
        CheckArg.isNotNull(context, "context");
        CheckArg.isNotNull(sourceName, "sourceName");
        this.checkRunning();
        Graph graph = Graph.create(sourceName, this.getRepositoryService().getRepositoryLibrary(), context);
        if (this.configuration.getRepositorySource().getName().equals(sourceName) && this.configuration.getWorkspace() != null) {
            graph.useWorkspace(this.configuration.getWorkspace());
        }
        return graph;
    }

    public final SequencingService getSequencingService() {
        this.checkRunning();
        return this.sequencingService;
    }

    protected final MimeTypeDetector getMimeTypeDetector() {
        this.checkRunning();
        return this.detectors;
    }

    protected final TextExtractor getTextExtractor() {
        this.checkRunning();
        return this.extractors;
    }

    protected final boolean checkRunning() {
        if (this.repositoryService.getAdministrator().isStarted() && this.sequencingService.getAdministrator().isStarted()) {
            return true;
        }
        throw new IllegalStateException(RepositoryI18n.engineIsNotRunning.text(new Object[0]));
    }

    protected void checkProblemsOnStartup() throws ModeShapeConfigurationException {
        boolean errors = this.problems.hasErrors();
        if (errors || this.problems.hasWarnings()) {
            Logger.Level level = errors ? Logger.Level.ERROR : Logger.Level.WARNING;
            this.logger().log(level, RepositoryI18n.warningsWhileStarting, this.problems.size());
            for (Problem problem : this.getProblems()) {
                Throwable t = problem.getThrowable();
                Logger.Level logLevel = problem.getStatus().getLogLevel();
                this.logger().log(logLevel, t, problem.getMessage(), problem.getParameters());
            }
        }
        if (errors) {
            System.err.println(this.problems);
            System.err.flush();
            throw this.newConfigurationException(RepositoryI18n.errorsPreventStarting.text(this.problems.size()));
        }
    }

    protected ModeShapeConfigurationException newConfigurationException(String msg) {
        throw new ModeShapeConfigurationException(msg);
    }

    protected void checkConfiguration(Subgraph configuration) {
    }

    public void start() {
        this.checkProblemsOnStartup();
        SimpleRepositoryContext configContext = new SimpleRepositoryContext(this.context, this.clusteringService, null);
        this.configuration.getRepositorySource().initialize(configContext);
        try {
            this.checkConfiguration(this.getConfigurationSubgraph(false));
        }
        catch (RuntimeException e) {
            this.problems.addError((Throwable)e, RepositoryI18n.errorVerifyingConfiguration, e.getLocalizedMessage());
        }
        this.checkProblemsOnStartup();
        this.clusteringService.getAdministrator().start();
        this.repositoryService.getAdministrator().start();
        this.sequencingService.getAdministrator().start();
        this.clusteringService.register(this.repositoryService);
        this.startGcService();
        this.checkProblemsOnStartup();
    }

    protected void startGcService() {
        if (!this.getRepositoryService().requiresGarbageCollection()) {
            return;
        }
        long intervalInSeconds = 600L;
        Property intervalProp = this.configuration.getGlobalProperty(ModeShapeLexicon.GARBAGE_COLLECTION_INTERVAL);
        if (intervalProp != null && !intervalProp.isEmpty()) {
            try {
                intervalInSeconds = this.context.getValueFactories().getLongFactory().create(intervalProp.getFirstValue());
            }
            catch (RuntimeException e) {
                String actualValue = this.context.getValueFactories().getStringFactory().create(intervalProp.getFirstValue());
                this.problems.addError(RepositoryI18n.unableToUseGarbageCollectionIntervalValue, actualValue);
            }
        }
        Runnable gcTask = new Runnable(){

            @Override
            public void run() {
                ModeShapeEngine.this.getRepositoryService().runGarbageCollection(null);
            }
        };
        try {
            this.gcService.scheduleAtFixedRate(gcTask, intervalInSeconds, intervalInSeconds, TimeUnit.SECONDS);
            this.checkProblemsOnStartup();
        }
        catch (RuntimeException e) {
            try {
                this.shutdown();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
    }

    public void shutdown() {
        this.preShutdown();
        this.postShutdown();
    }

    protected void preShutdown() {
        this.gcService.shutdown();
        this.executorService.shutdown();
        this.sequencingService.getAdministrator().shutdown();
        this.repositoryService.getAdministrator().shutdown();
    }

    protected void postShutdown() {
        this.clusteringService.shutdown();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.gcService.awaitTermination(timeout, unit)) {
            return false;
        }
        if (!this.sequencingService.getAdministrator().awaitTermination(timeout, unit)) {
            return false;
        }
        if (!this.executorService.awaitTermination(timeout, unit)) {
            return false;
        }
        return this.repositoryService.getAdministrator().awaitTermination(timeout, unit);
    }

    protected Graph getConfigurationGraph() {
        Graph graph = Graph.create(this.configuration.getRepositorySource(), this.context);
        if (this.configuration.getWorkspace() != null) {
            graph.useWorkspace(this.configuration.getWorkspace());
        }
        return graph;
    }

    protected Subgraph getConfigurationSubgraph(boolean refresh) {
        return this.scanner.subgraph(refresh);
    }

    protected class ConfigurationScanner {
        protected static final String CLUSTERED_OBSERVATION_BUS_CLASSNAME = "org.modeshape.clustering.ClusteredObservationBus";
        private final Problems problems;
        private final ExecutionContext context;
        private final ModeShapeConfiguration.ConfigurationDefinition configurationRepository;
        private Subgraph cachedSubgraph;

        protected ConfigurationScanner(Problems problems, ExecutionContext context, ModeShapeConfiguration.ConfigurationDefinition configurationRepository) {
            this.problems = problems;
            this.context = context;
            this.configurationRepository = configurationRepository;
        }

        protected Subgraph subgraph(boolean refresh) {
            if (this.cachedSubgraph == null || refresh) {
                Graph graph = ModeShapeEngine.this.getConfigurationGraph();
                Path configRootPath = this.configurationRepository.getPath();
                this.cachedSubgraph = graph.getSubgraphOfDepth(this.getMaxDepth()).at(configRootPath);
            }
            return this.cachedSubgraph;
        }

        protected int getMaxDepth() {
            return 10;
        }

        protected void refresh() {
            this.cachedSubgraph = null;
        }

        public List<MimeTypeDetectorConfig> getMimeTypeDetectors() {
            ArrayList<MimeTypeDetectorConfig> detectors = new ArrayList<MimeTypeDetectorConfig>();
            try {
                HashSet<Name> skipProperties = new HashSet<Name>();
                skipProperties.add(ModeShapeLexicon.READABLE_NAME);
                skipProperties.add(ModeShapeLexicon.DESCRIPTION);
                skipProperties.add(ModeShapeLexicon.CLASSNAME);
                skipProperties.add(ModeShapeLexicon.CLASSPATH);
                skipProperties.add(ModeShapeLexicon.PATH_EXPRESSION);
                HashSet<String> skipNamespaces = new HashSet<String>();
                skipNamespaces.add("http://www.jcp.org/jcr/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/nt/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/mix/1.0");
                Subgraph subgraph = this.subgraph(false);
                SubgraphNode detectorsNode = subgraph.getNode(ModeShapeLexicon.MIME_TYPE_DETECTORS);
                if (detectorsNode == null) {
                    return detectors;
                }
                for (Location detectorLocation : detectorsNode.getChildren()) {
                    Object node = subgraph.getNode(detectorLocation);
                    String name = this.stringValueOf((Node)node, ModeShapeLexicon.READABLE_NAME);
                    if (name == null) {
                        name = this.stringValueOf((Node)node);
                    }
                    String desc = this.stringValueOf((Node)node, ModeShapeLexicon.DESCRIPTION);
                    String classname = this.stringValueOf((Node)node, ModeShapeLexicon.CLASSNAME);
                    String[] classpath = this.stringValuesOf((Node)node, ModeShapeLexicon.CLASSPATH);
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    for (Property property : node.getProperties()) {
                        Name propertyName = property.getName();
                        if (skipNamespaces.contains(propertyName.getNamespaceUri()) || skipProperties.contains(propertyName)) continue;
                        if (property.isSingle()) {
                            properties.put(propertyName.getLocalName(), property.getFirstValue());
                            continue;
                        }
                        properties.put(propertyName.getLocalName(), property.getValuesAsArray());
                    }
                    MimeTypeDetectorConfig config = new MimeTypeDetectorConfig(name, desc, properties, classname, classpath);
                    detectors.add(config);
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
            return detectors;
        }

        public List<TextExtractorConfig> getTextExtractors() {
            ArrayList<TextExtractorConfig> extractors = new ArrayList<TextExtractorConfig>();
            try {
                HashSet<Name> skipProperties = new HashSet<Name>();
                skipProperties.add(ModeShapeLexicon.READABLE_NAME);
                skipProperties.add(ModeShapeLexicon.DESCRIPTION);
                skipProperties.add(ModeShapeLexicon.CLASSNAME);
                skipProperties.add(ModeShapeLexicon.CLASSPATH);
                skipProperties.add(ModeShapeLexicon.PATH_EXPRESSION);
                HashSet<String> skipNamespaces = new HashSet<String>();
                skipNamespaces.add("http://www.jcp.org/jcr/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/nt/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/mix/1.0");
                Subgraph subgraph = this.subgraph(false);
                SubgraphNode extractorsNode = subgraph.getNode(ModeShapeLexicon.TEXT_EXTRACTORS);
                if (extractorsNode == null) {
                    return extractors;
                }
                for (Location detectorLocation : extractorsNode.getChildren()) {
                    Object node = subgraph.getNode(detectorLocation);
                    String name = this.stringValueOf((Node)node, ModeShapeLexicon.READABLE_NAME);
                    if (name == null) {
                        name = this.stringValueOf((Node)node);
                    }
                    String desc = this.stringValueOf((Node)node, ModeShapeLexicon.DESCRIPTION);
                    String classname = this.stringValueOf((Node)node, ModeShapeLexicon.CLASSNAME);
                    String[] classpath = this.stringValuesOf((Node)node, ModeShapeLexicon.CLASSPATH);
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    for (Property property : node.getProperties()) {
                        Name propertyName = property.getName();
                        if (skipNamespaces.contains(propertyName.getNamespaceUri()) || skipProperties.contains(propertyName)) continue;
                        if (property.isSingle()) {
                            properties.put(propertyName.getLocalName(), property.getFirstValue());
                            continue;
                        }
                        properties.put(propertyName.getLocalName(), property.getValuesAsArray());
                    }
                    TextExtractorConfig config = new TextExtractorConfig(name, desc, properties, classname, classpath);
                    extractors.add(config);
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
            return extractors;
        }

        public ClusteringConfig getClusteringConfiguration() {
            try {
                HashSet<Name> skipProperties = new HashSet<Name>();
                skipProperties.add(ModeShapeLexicon.DESCRIPTION);
                skipProperties.add(ModeShapeLexicon.CLASSNAME);
                skipProperties.add(ModeShapeLexicon.CLASSPATH);
                HashSet<String> skipNamespaces = new HashSet<String>();
                skipNamespaces.add("http://www.jcp.org/jcr/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/nt/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/mix/1.0");
                Subgraph subgraph = this.subgraph(false);
                SubgraphNode clusterNode = subgraph.getNode(ModeShapeLexicon.CLUSTERING);
                if (clusterNode != null) {
                    String clusterName = this.stringValueOf(clusterNode, ModeShapeLexicon.CLUSTER_NAME);
                    String desc = this.stringValueOf(clusterNode, ModeShapeLexicon.DESCRIPTION);
                    String classname = this.stringValueOf(clusterNode, ModeShapeLexicon.CLASSNAME);
                    String[] classpath = this.stringValuesOf(clusterNode, ModeShapeLexicon.CLASSPATH);
                    if (classname == null || classname.trim().length() == 0) {
                        classname = CLUSTERED_OBSERVATION_BUS_CLASSNAME;
                    }
                    if (clusterName == null || clusterName.trim().length() == 0) {
                        ModeShapeEngine.this.logger().warn(RepositoryI18n.clusteringConfigurationRequiresClusterName, new Object[0]);
                        this.problems.addWarning(RepositoryI18n.clusteringConfigurationRequiresClusterName, new Object[0]);
                        return null;
                    }
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    for (Property property : clusterNode.getProperties()) {
                        Name propertyName = property.getName();
                        if (skipNamespaces.contains(propertyName.getNamespaceUri()) || skipProperties.contains(propertyName)) continue;
                        if (property.isSingle()) {
                            properties.put(propertyName.getLocalName(), property.getFirstValue());
                            continue;
                        }
                        properties.put(propertyName.getLocalName(), property.getValuesAsArray());
                    }
                    return new ClusteringConfig(clusterName, desc, properties, classname, classpath);
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
            return null;
        }

        public List<SequencerConfig> getSequencingConfigurations() {
            ArrayList<SequencerConfig> configs = new ArrayList<SequencerConfig>();
            try {
                HashSet<Name> skipProperties = new HashSet<Name>();
                skipProperties.add(ModeShapeLexicon.READABLE_NAME);
                skipProperties.add(ModeShapeLexicon.DESCRIPTION);
                skipProperties.add(ModeShapeLexicon.CLASSNAME);
                skipProperties.add(ModeShapeLexicon.CLASSPATH);
                skipProperties.add(ModeShapeLexicon.PATH_EXPRESSION);
                HashSet<String> skipNamespaces = new HashSet<String>();
                skipNamespaces.add("http://www.jcp.org/jcr/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/nt/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/mix/1.0");
                Subgraph subgraph = this.subgraph(false);
                SubgraphNode sequencersNode = subgraph.getNode(ModeShapeLexicon.SEQUENCERS);
                if (sequencersNode == null) {
                    return configs;
                }
                for (Location sequencerLocation : sequencersNode.getChildren()) {
                    Object sequencerNode = subgraph.getNode(sequencerLocation);
                    String name = this.stringValueOf((Node)sequencerNode, ModeShapeLexicon.READABLE_NAME);
                    if (name == null) {
                        name = this.stringValueOf((Node)sequencerNode);
                    }
                    String desc = this.stringValueOf((Node)sequencerNode, ModeShapeLexicon.DESCRIPTION);
                    String classname = this.stringValueOf((Node)sequencerNode, ModeShapeLexicon.CLASSNAME);
                    String[] classpath = this.stringValuesOf((Node)sequencerNode, ModeShapeLexicon.CLASSPATH);
                    String[] expressionStrings = this.stringValuesOf((Node)sequencerNode, ModeShapeLexicon.PATH_EXPRESSION);
                    ArrayList<PathExpression> pathExpressions = new ArrayList<PathExpression>();
                    if (expressionStrings != null) {
                        for (String expressionString : expressionStrings) {
                            try {
                                pathExpressions.add(PathExpression.compile(expressionString));
                            }
                            catch (Throwable t) {
                                this.problems.addError(t, RepositoryI18n.pathExpressionIsInvalidOnSequencer, expressionString, name, t.getLocalizedMessage());
                            }
                        }
                    }
                    String[] goodExpressionStrings = new String[pathExpressions.size()];
                    for (int i = 0; i != pathExpressions.size(); ++i) {
                        PathExpression expression = (PathExpression)pathExpressions.get(i);
                        goodExpressionStrings[i] = expression.getExpression();
                    }
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    for (Property property : sequencerNode.getProperties()) {
                        Name propertyName = property.getName();
                        if (skipNamespaces.contains(propertyName.getNamespaceUri()) || skipProperties.contains(propertyName)) continue;
                        if (property.isSingle()) {
                            properties.put(propertyName.getLocalName(), property.getFirstValue());
                            continue;
                        }
                        properties.put(propertyName.getLocalName(), property.getValuesAsArray());
                    }
                    SequencerConfig config = new SequencerConfig(name, desc, (Map<String, Object>)properties, classname, classpath, goodExpressionStrings);
                    configs.add(config);
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
            return configs;
        }

        private String stringValueOf(Node node) {
            return node.getLocation().getPath().getLastSegment().getString(this.context.getNamespaceRegistry());
        }

        private String stringValueOf(Node node, Name propertyName) {
            Property property = node.getProperty(propertyName);
            if (property == null && (property = node.getProperty((Name)this.context.getValueFactories().getNameFactory().create(propertyName.getLocalName()))) == null) {
                return null;
            }
            if (property.isEmpty()) {
                return null;
            }
            return this.context.getValueFactories().getStringFactory().create(property.getFirstValue());
        }

        private String[] stringValuesOf(Node node, Name propertyName) {
            Property property = node.getProperty(propertyName);
            if (property == null && (property = node.getProperty((Name)this.context.getValueFactories().getNameFactory().create(propertyName.getLocalName()))) == null) {
                return null;
            }
            return this.context.getValueFactories().getStringFactory().create(property.getValuesAsArray());
        }
    }
}

