/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidLifecycleTransitionException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.query.QueryBuilder;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.CorrespondenceId;
import org.modeshape.jcr.JcrBinary;
import org.modeshape.jcr.JcrChildNodeIterator;
import org.modeshape.jcr.JcrEmptyNodeIterator;
import org.modeshape.jcr.JcrEmptyPropertyIterator;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrLockManager;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeIterator;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrPropertyIterator;
import org.modeshape.jcr.JcrSharedNode;
import org.modeshape.jcr.JcrSingleNodeIterator;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrVersionHistoryNode;
import org.modeshape.jcr.JcrVersionManager;
import org.modeshape.jcr.JcrVersionNode;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.SessionCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
abstract class AbstractJcrNode
extends AbstractJcrItem
implements Node {
    private static final NodeType[] EMPTY_NODE_TYPES = new NodeType[0];
    private static final Set<Name> INTERNAL_NODE_TYPE_NAMES = Collections.singleton(ModeShapeLexicon.SHARE);
    protected final GraphSession.NodeId nodeId;
    protected Location location;

    AbstractJcrNode(SessionCache cache, GraphSession.NodeId nodeId, Location location) {
        super(cache);
        this.nodeId = nodeId;
        this.location = location;
    }

    abstract boolean isRoot();

    public abstract AbstractJcrNode getParent() throws ItemNotFoundException, RepositoryException;

    final GraphSession.NodeId internalId() {
        return this.nodeId;
    }

    Location location() {
        return this.location;
    }

    void setLocation(Location location) {
        this.location = location;
    }

    Path.Segment segment() throws RepositoryException {
        return this.nodeInfo().getSegment();
    }

    JcrLockManager lockManager() {
        return this.session().lockManager();
    }

    GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> nodeInfo() throws InvalidItemStateException, AccessDeniedException, RepositoryException {
        try {
            return this.cache.findNode(this.nodeId, this.location.getPath());
        }
        catch (ItemNotFoundException infe) {
            try {
                GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> info = null;
                info = this.location.getUuid() != null ? this.cache.findNodeWith(this.location.with((Path)null)) : this.cache.findNodeWith(this.location);
                Location newLocation = info.getLocation();
                if (!newLocation.equals(this.location)) {
                    this.location = newLocation;
                }
                return info;
            }
            catch (ItemNotFoundException infe2) {
                throw new InvalidItemStateException(infe.getMessage());
            }
        }
    }

    GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> parentNodeInfo() throws InvalidItemStateException, AccessDeniedException, RepositoryException {
        return this.nodeInfo().getParent();
    }

    SessionCache.NodeEditor editorForParent() throws RepositoryException {
        try {
            GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> parent = this.parentNodeInfo();
            return this.cache.getEditorFor(parent);
        }
        catch (ItemNotFoundException err) {
            String msg = JcrI18n.nodeHasAlreadyBeenRemovedFromThisSession.text(this.nodeId, this.cache.workspaceName());
            throw new RepositoryException(msg);
        }
        catch (InvalidItemStateException err) {
            String msg = JcrI18n.nodeHasAlreadyBeenRemovedFromThisSession.text(this.nodeId, this.cache.workspaceName());
            throw new RepositoryException(msg);
        }
    }

    final SessionCache.NodeEditor editor() throws RepositoryException {
        try {
            return this.cache.getEditorFor(this.nodeId, this.location.getPath());
        }
        catch (ItemNotFoundException err) {
            String msg = JcrI18n.nodeHasAlreadyBeenRemovedFromThisSession.text(this.nodeId, this.cache.workspaceName());
            throw new RepositoryException(msg);
        }
        catch (InvalidItemStateException err) {
            String msg = JcrI18n.nodeHasAlreadyBeenRemovedFromThisSession.text(this.nodeId, this.cache.workspaceName());
            throw new RepositoryException(msg);
        }
    }

    final JcrValue valueFrom(int propertyType, Object value) {
        if (value instanceof JcrBinary) {
            value = ((JcrBinary)value).binary();
        }
        return new JcrValue(this.cache.factories(), this.cache, propertyType, value);
    }

    final JcrValue valueFrom(String value) {
        return new JcrValue(this.cache.factories(), this.cache, 1, value);
    }

    final JcrValue valueFrom(UUID value) {
        ValueFactories factories = this.cache.factories();
        Reference ref = (Reference)factories.getReferenceFactory().create(value);
        return new JcrValue(this.cache.factories(), this.cache, 9, ref);
    }

    final JcrValue valueFrom(Calendar value) {
        ValueFactories factories = this.cache.factories();
        DateTime dateTime = (DateTime)factories.getDateFactory().create(value);
        return new JcrValue(factories, this.cache, 5, dateTime);
    }

    final JcrValue valueFrom(InputStream value) {
        ValueFactories factories = this.cache.factories();
        org.modeshape.graph.property.Binary binary = (org.modeshape.graph.property.Binary)factories.getBinaryFactory().create(value);
        return new JcrValue(factories, this.cache, 2, binary);
    }

    final JcrValue valueFrom(Binary value) {
        ValueFactories factories = this.cache.factories();
        org.modeshape.graph.property.Binary binary = ((JcrBinary)value).binary();
        return new JcrValue(factories, this.cache, 2, binary);
    }

    final JcrValue valueFrom(Node value) throws UnsupportedRepositoryOperationException, RepositoryException {
        ValueFactories factories = this.cache.factories();
        Reference ref = (Reference)factories.getReferenceFactory().create(value.getIdentifier());
        return new JcrValue(factories, this.cache, 9, ref);
    }

    final JcrValue[] valuesFrom(int propertyType, Object[] values) {
        int len = values.length;
        ValueFactories factories = this.cache.factories();
        ArrayList<JcrValue> results = new ArrayList<JcrValue>(len);
        for (int i = 0; i != len; ++i) {
            if (values[i] == null) continue;
            results.add(new JcrValue(factories, this.cache, propertyType, values[i]));
        }
        return results.toArray(new JcrValue[results.size()]);
    }

    @Override
    Path path() throws RepositoryException {
        return this.nodeInfo().getPath();
    }

    boolean isReferenceable() throws RepositoryException {
        return this.isNodeType(JcrMixLexicon.REFERENCEABLE);
    }

    boolean isLockable() throws RepositoryException {
        return this.isNodeType(JcrMixLexicon.LOCKABLE);
    }

    boolean isShareable() throws RepositoryException {
        return this.isNodeType(JcrMixLexicon.SHAREABLE);
    }

    boolean isShared() {
        return false;
    }

    UUID uuid() throws RepositoryException {
        UUID uuid = this.nodeInfo().getLocation().getUuid();
        if (uuid == null) {
            GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload> uuidProp = this.nodeInfo().getProperty(JcrLexicon.UUID);
            if (uuidProp == null) {
                uuidProp = this.nodeInfo().getProperty(ModeShapeLexicon.UUID);
            }
            assert (uuidProp != null);
            assert (!uuidProp.getProperty().isEmpty());
            uuid = (UUID)this.context().getValueFactories().getUuidFactory().create(uuidProp.getProperty().getFirstValue());
        }
        assert (uuid != null);
        return uuid;
    }

    String identifier() throws RepositoryException {
        String identifier = null;
        UUID uuid = this.nodeInfo().getLocation().getUuid();
        if (uuid == null) {
            GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload> uuidProp = this.nodeInfo().getProperty(JcrLexicon.UUID);
            if (uuidProp == null) {
                uuidProp = this.nodeInfo().getProperty(ModeShapeLexicon.UUID);
            }
            if (uuidProp != null) {
                assert (!uuidProp.getProperty().isEmpty());
                identifier = this.context().getValueFactories().getStringFactory().create(uuidProp.getProperty().getFirstValue());
            } else {
                identifier = this.getPath();
            }
        } else {
            identifier = uuid.toString();
        }
        assert (identifier != null);
        return identifier;
    }

    String identifierPath() throws RepositoryException {
        return "[" + this.identifier() + "]";
    }

    @Deprecated
    public String getUUID() throws RepositoryException {
        if (!this.isReferenceable()) {
            throw new UnsupportedRepositoryOperationException(JcrI18n.nodeNotReferenceable.text(new Object[0]));
        }
        return this.identifier();
    }

    public String getIdentifier() throws RepositoryException {
        return this.identifier();
    }

    public final boolean isNode() {
        return true;
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        return this.isNodeType(this.nameFrom(nodeTypeName));
    }

    public final boolean isNodeType(Name nodeTypeName) throws RepositoryException {
        this.checkSession();
        return this.cache.isNodeType(this.nodeInfo(), nodeTypeName);
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        this.checkSession();
        NodeDefinitionId definitionId = this.nodeInfo().getPayload().getDefinitionId();
        return this.session().nodeTypeManager().getNodeDefinition(definitionId);
    }

    public JcrNodeType getPrimaryNodeType() throws RepositoryException {
        this.checkSession();
        return this.session().nodeTypeManager().getNodeType(this.getPrimaryTypeName());
    }

    Name getPrimaryTypeName() throws RepositoryException {
        return this.nodeInfo().getPayload().getPrimaryTypeName();
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        this.checkSession();
        JcrNodeTypeManager nodeTypeManager = this.session().nodeTypeManager();
        AbstractJcrProperty mixinTypesProperty = this.getProperty(JcrLexicon.MIXIN_TYPES);
        if (mixinTypesProperty == null) {
            return EMPTY_NODE_TYPES;
        }
        LinkedList<NodeType> mixinNodeTypes = new LinkedList<NodeType>();
        for (Value value : mixinTypesProperty.getValues()) {
            String nodeTypeName = value.getString();
            NodeType nodeType = nodeTypeManager.getNodeType(nodeTypeName);
            if (nodeType == null) continue;
            mixinNodeTypes.add(nodeType);
        }
        return mixinNodeTypes.toArray(new NodeType[mixinNodeTypes.size()]);
    }

    List<Name> getMixinTypeNames() throws RepositoryException {
        return this.nodeInfo().getPayload().getMixinTypeNames();
    }

    public final Item getPrimaryItem() throws RepositoryException {
        this.checkSession();
        JcrNodeType primaryType = this.getPrimaryNodeType();
        String primaryItemNameString = primaryType.getPrimaryItemName();
        if (primaryItemNameString == null) {
            I18n msg = JcrI18n.noPrimaryItemNameDefinedOnPrimaryType;
            throw new ItemNotFoundException(msg.text(primaryType.getName(), this.getPath(), this.cache.workspaceName()));
        }
        try {
            Path primaryItemPath = (Path)this.context().getValueFactories().getPathFactory().create(primaryItemNameString);
            if (primaryItemPath.size() != 1 || primaryItemPath.isAbsolute()) {
                I18n msg = JcrI18n.primaryItemNameForPrimaryTypeIsNotValid;
                throw new ItemNotFoundException(msg.text(primaryType.getName(), primaryItemNameString, this.getPath(), this.cache.workspaceName()));
            }
            return this.cache.findJcrItem(this.nodeId, this.location.getPath(), primaryItemPath);
        }
        catch (javax.jcr.ValueFormatException error) {
            I18n msg = JcrI18n.primaryItemNameForPrimaryTypeIsNotValid;
            throw new ItemNotFoundException(msg.text(primaryType.getName(), primaryItemNameString, this.getPath(), this.cache.workspaceName()));
        }
        catch (PathNotFoundException error) {
            I18n msg = JcrI18n.primaryItemDoesNotExist;
            throw new ItemNotFoundException(msg.text(primaryType.getName(), primaryItemNameString, this.getPath(), this.cache.workspaceName()));
        }
    }

    @Override
    public boolean isSame(Item otherItem) throws RepositoryException {
        CheckArg.isNotNull(otherItem, "otherItem");
        this.checkSession();
        if (super.isSame(otherItem) && otherItem instanceof Node) {
            if (otherItem instanceof AbstractJcrNode) {
                AbstractJcrNode that = (AbstractJcrNode)otherItem;
                if (this.isReferenceable() && that.isReferenceable()) {
                    return this.getUUID().equals(((AbstractJcrNode)otherItem).getUUID());
                }
                CorrespondenceId thisId = this.getCorrespondenceId();
                CorrespondenceId thatId = that.getCorrespondenceId();
                return thisId.equals(thatId);
            }
            return otherItem.isSame((Item)this);
        }
        return false;
    }

    protected CorrespondenceId getCorrespondenceId() throws RepositoryException {
        if (this.isReferenceable()) {
            return new CorrespondenceId(this.getUUID());
        }
        assert (!this.isRoot());
        Path currentPath = this.path();
        AbstractJcrNode node = this.getParent();
        int beginIndex = currentPath.size() - 1;
        while (!node.isRoot() && !node.isReferenceable()) {
            node = node.getParent();
            --beginIndex;
        }
        Path relativePath = currentPath.relativeTo(node.path());
        assert (!relativePath.isAbsolute());
        return new CorrespondenceId(node.getUUID(), relativePath);
    }

    public final boolean hasProperties() throws RepositoryException {
        this.checkSession();
        return this.nodeInfo().getPropertyCount() > 0;
    }

    public final boolean hasProperty(String relativePath) throws RepositoryException {
        CheckArg.isNotEmpty(relativePath, "relativePath");
        this.checkSession();
        if (relativePath.indexOf(47) >= 0 || relativePath.startsWith("[")) {
            try {
                this.getProperty(relativePath);
                return true;
            }
            catch (PathNotFoundException e) {
                return false;
            }
        }
        if (relativePath.equals(".")) {
            return false;
        }
        if (relativePath.equals("..")) {
            return false;
        }
        return this.nodeInfo().getProperty(this.nameFrom(relativePath)) != null;
    }

    public final boolean hasProperty(Name name) throws RepositoryException {
        this.checkSession();
        return this.nodeInfo().getProperty(name) != null;
    }

    public PropertyIterator getProperties() throws RepositoryException {
        this.checkSession();
        return new JcrPropertyIterator(this.cache.findJcrPropertiesFor(this.nodeId, this.location.getPath()));
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        CheckArg.isNotNull(namePattern, "namePattern");
        this.checkSession();
        namePattern = namePattern.trim();
        if (namePattern.length() == 0) {
            return new JcrEmptyPropertyIterator();
        }
        if ("*".equals(namePattern)) {
            Collection<AbstractJcrProperty> properties = this.cache.findJcrPropertiesFor(this.nodeId, this.location.getPath());
            return new JcrPropertyIterator(properties);
        }
        return this.getProperties(namePattern.split("[|]"));
    }

    public PropertyIterator getProperties(String[] nameGlobs) throws RepositoryException {
        CheckArg.isNotNull(nameGlobs, "nameGlobs");
        if (nameGlobs.length == 0) {
            return new JcrEmptyPropertyIterator();
        }
        Collection<AbstractJcrProperty> properties = this.cache.findJcrPropertiesFor(this.nodeId, this.location.getPath());
        List<Object> patterns = AbstractJcrNode.createPatternsFor(nameGlobs);
        boolean foundMatch = false;
        LinkedList<AbstractJcrProperty> matchingProperties = new LinkedList<AbstractJcrProperty>();
        for (AbstractJcrProperty property : properties) {
            String propName = property.getName();
            assert (!foundMatch);
            for (Object patternOrMatch : patterns) {
                if (patternOrMatch instanceof Pattern) {
                    Pattern pattern = (Pattern)patternOrMatch;
                    if (!pattern.matcher(propName).matches()) continue;
                    foundMatch = true;
                    break;
                }
                String match = (String)patternOrMatch;
                if (!propName.equals(match)) continue;
                foundMatch = true;
                break;
            }
            if (!foundMatch) continue;
            matchingProperties.add(property);
            foundMatch = false;
        }
        return new JcrPropertyIterator(matchingProperties);
    }

    protected final NodeIterator referencingNodes(int maxNumberOfNodes) throws RepositoryException {
        if (!this.isReferenceable()) {
            return new JcrEmptyNodeIterator();
        }
        if (maxNumberOfNodes < 0) {
            maxNumberOfNodes = Integer.MAX_VALUE;
        }
        String uuid = this.getUUID();
        QueryBuilder builder = new QueryBuilder(this.context().getValueFactories().getTypeSystem());
        QueryCommand query = builder.select("jcr:primaryType").fromAllNodesAs("allNodes").where().referenceValue("allNodes").isEqualTo(uuid).end().limit(maxNumberOfNodes).query();
        Query jcrQuery = this.session().workspace().queryManager().createQuery(query);
        QueryResult result = jcrQuery.execute();
        return result.getNodes();
    }

    protected final boolean hasIncomingReferences() throws RepositoryException {
        return this.referencingNodes(1).hasNext();
    }

    public final PropertyIterator getReferences() throws RepositoryException {
        return this.getReferences(null);
    }

    public final PropertyIterator getReferences(String propertyName) throws RepositoryException {
        this.checkSession();
        return this.propertiesOnOtherNodesReferencingThis(propertyName, 9);
    }

    public PropertyIterator getWeakReferences() throws RepositoryException {
        return this.getWeakReferences(null);
    }

    public PropertyIterator getWeakReferences(String propertyName) throws RepositoryException {
        this.checkSession();
        return this.propertiesOnOtherNodesReferencingThis(propertyName, 10);
    }

    protected PropertyIterator propertiesOnOtherNodesReferencingThis(String propertyName, int referenceType) throws RepositoryException {
        if (!this.isReferenceable()) {
            return new JcrEmptyPropertyIterator();
        }
        NodeIterator iter = this.referencingNodes(Integer.MAX_VALUE);
        if (!iter.hasNext()) {
            return new JcrEmptyPropertyIterator();
        }
        String id = this.getIdentifier();
        LinkedList<Property> references = new LinkedList<Property>();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            PropertyIterator propIter = node.getProperties();
            block1: while (propIter.hasNext()) {
                Property prop = propIter.nextProperty();
                int propType = prop.getDefinition().getRequiredType();
                if (propType != referenceType && propType != 0 && propType != 1 || propertyName != null && !propertyName.equals(prop.getName())) continue;
                if (prop.getDefinition().isMultiple()) {
                    for (Value value : prop.getValues()) {
                        if (!id.equals(value.getString())) continue;
                        references.add(prop);
                        continue block1;
                    }
                    continue;
                }
                Value value = prop.getValue();
                if (!id.equals(value.getString())) continue;
                references.add(prop);
            }
        }
        if (references.isEmpty()) {
            return new JcrEmptyPropertyIterator();
        }
        return new JcrPropertyIterator(references);
    }

    public final AbstractJcrProperty getProperty(Name propertyName) throws RepositoryException {
        AbstractJcrProperty property = this.cache.findJcrProperty(this.nodeId, this.location.getPath(), propertyName);
        if (property != null && JcrLexicon.UUID.equals(propertyName) && !this.isReferenceable()) {
            return null;
        }
        return property;
    }

    public Property getProperty(String relativePath) throws RepositoryException {
        CheckArg.isNotEmpty(relativePath, "relativePath");
        this.checkSession();
        int indexOfFirstSlash = relativePath.indexOf(47);
        if (indexOfFirstSlash == 0 || relativePath.startsWith("[")) {
            throw new IllegalArgumentException(JcrI18n.invalidPathParameter.text(relativePath, "relativePath"));
        }
        Name propertyName = null;
        if (indexOfFirstSlash != -1) {
            Path path = this.pathFrom(relativePath).getNormalizedPath();
            assert (!path.isIdentifier());
            if (path.size() > 1) {
                try {
                    AbstractJcrItem item = this.cache.findJcrItem(this.nodeId, this.location.getPath(), path);
                    if (item instanceof Property) {
                        return (Property)item;
                    }
                }
                catch (ItemNotFoundException e) {
                    I18n msg = JcrI18n.propertyNotFoundAtPathRelativeToReferenceNode;
                    throw new PathNotFoundException(msg.text(relativePath, this.getPath(), this.cache.workspaceName()));
                }
                I18n msg = JcrI18n.propertyNotFoundAtPathRelativeToReferenceNode;
                throw new PathNotFoundException(msg.text(relativePath, this.getPath(), this.cache.workspaceName()));
            }
            propertyName = path.getLastSegment().getName();
        } else {
            propertyName = this.nameFrom(relativePath);
        }
        AbstractJcrProperty result = this.getProperty(propertyName);
        if (result != null) {
            return result;
        }
        I18n msg = JcrI18n.pathNotFoundRelativeTo;
        throw new PathNotFoundException(msg.text(relativePath, this.getPath(), this.cache.workspaceName()));
    }

    public final boolean hasNode(String relativePath) throws RepositoryException {
        CheckArg.isNotEmpty(relativePath, "relativePath");
        this.checkSession();
        if (relativePath.equals(".")) {
            return true;
        }
        if (relativePath.equals("..")) {
            return !this.isRoot();
        }
        int indexOfFirstSlash = relativePath.indexOf(47);
        if (indexOfFirstSlash == 0 || relativePath.startsWith("[")) {
            throw new IllegalArgumentException(JcrI18n.invalidPathParameter.text(relativePath, "relativePath"));
        }
        if (indexOfFirstSlash != -1) {
            Path path = this.pathFrom(relativePath).getNormalizedPath();
            try {
                AbstractJcrNode item = this.cache.findJcrNode(this.nodeId, this.location.getPath(), path);
                return item != null;
            }
            catch (PathNotFoundException e) {
                return false;
            }
        }
        try {
            Path.Segment segment = this.segmentFrom(relativePath);
            return this.nodeInfo().getChild(segment) != null;
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            return false;
        }
    }

    public final boolean hasNodes() throws RepositoryException {
        this.checkSession();
        return this.nodeInfo().getChildrenCount() > 0;
    }

    public final AbstractJcrNode getNode(Name childNodeName) throws RepositoryException {
        try {
            Path childPath = this.context().getValueFactories().getPathFactory().createRelativePath(childNodeName);
            return this.cache.findJcrNode(this.nodeId, this.location.getPath(), childPath);
        }
        catch (PathNotFoundException infe) {
            return null;
        }
        catch (ItemNotFoundException infe) {
            return null;
        }
    }

    public final AbstractJcrNode getNode(Path relativePath) throws RepositoryException {
        return this.getNode(relativePath.getString(this.namespaces()));
    }

    public final AbstractJcrNode getNode(String relativePath) throws RepositoryException {
        CheckArg.isNotEmpty(relativePath, "relativePath");
        this.checkSession();
        if (relativePath.equals(".")) {
            return this;
        }
        if (relativePath.equals("..")) {
            return this.getParent();
        }
        int indexOfFirstSlash = relativePath.indexOf(47);
        if (indexOfFirstSlash == 0 || relativePath.startsWith("[")) {
            throw new IllegalArgumentException(JcrI18n.invalidPathParameter.text(relativePath, "relativePath"));
        }
        Path.Segment segment = null;
        if (indexOfFirstSlash != -1) {
            Path path = this.pathFrom(relativePath).getNormalizedPath();
            if (path.size() == 1) {
                if (path.getLastSegment().isSelfReference()) {
                    return this;
                }
                if (path.getLastSegment().isParentReference()) {
                    return this.getParent();
                }
            }
            if (path.size() > 1) {
                return this.cache.findJcrNode(this.nodeId, this.location.getPath(), path);
            }
            segment = path.getLastSegment();
        } else {
            segment = this.segmentFrom(relativePath);
        }
        assert (!segment.isIdentifier());
        try {
            return this.nodeInfo().getChild(segment).getPayload().getJcrNode();
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            String msg = JcrI18n.childNotFoundUnderNode.text(segment, this.getPath(), this.cache.workspaceName());
            throw new PathNotFoundException(msg);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public final NodeIterator getNodes() throws RepositoryException {
        this.checkSession();
        int childCount = this.nodeInfo().getChildrenCount();
        if (childCount == 0) {
            return new JcrEmptyNodeIterator();
        }
        LinkedList<AbstractJcrNode> matchingChildren = new LinkedList<AbstractJcrNode>();
        for (GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> child : this.nodeInfo().getChildren()) {
            matchingChildren.add(child.getPayload().getJcrNode());
        }
        return new JcrChildNodeIterator(matchingChildren, childCount);
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        CheckArg.isNotNull(namePattern, "namePattern");
        this.checkSession();
        namePattern = namePattern.trim();
        if (namePattern.length() == 0) {
            return new JcrEmptyNodeIterator();
        }
        if ("*".equals(namePattern)) {
            return this.getNodes();
        }
        return this.getNodes(namePattern.split("[|]"));
    }

    public NodeIterator getNodes(String[] nameGlobs) throws RepositoryException {
        CheckArg.isNotNull(nameGlobs, "nameGlobs");
        if (nameGlobs.length == 0) {
            return new JcrEmptyNodeIterator();
        }
        List<Object> patterns = AbstractJcrNode.createPatternsFor(nameGlobs);
        LinkedList<AbstractJcrNode> matchingChildren = new LinkedList<AbstractJcrNode>();
        NamespaceRegistry registry = this.namespaces();
        boolean foundMatch = false;
        block0: for (GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> child : this.nodeInfo().getChildren()) {
            String childName = child.getName().getString(registry);
            for (Object patternOrMatch : patterns) {
                if (patternOrMatch instanceof Pattern) {
                    Pattern pattern = (Pattern)patternOrMatch;
                    if (pattern.matcher(childName).matches()) {
                        foundMatch = true;
                    }
                } else {
                    String match = (String)patternOrMatch;
                    if (childName.equals(match)) {
                        foundMatch = true;
                    }
                }
                if (!foundMatch) continue;
                foundMatch = false;
                matchingChildren.add(child.getPayload().getJcrNode());
                continue block0;
            }
        }
        return new JcrChildNodeIterator(matchingChildren, matchingChildren.size());
    }

    public final void accept(ItemVisitor visitor) throws RepositoryException {
        CheckArg.isNotNull(visitor, "visitor");
        this.checkSession();
        visitor.visit((Node)this);
    }

    public final boolean canAddMixin(String mixinName) throws NoSuchNodeTypeException, RepositoryException {
        CheckArg.isNotNull(mixinName, "mixinName");
        CheckArg.isNotZeroLength(mixinName, "mixinName");
        this.checkSession();
        this.session().checkPermission(this.path(), "set_property");
        JcrNodeType mixinCandidateType = this.cache.nodeTypes().getNodeType(mixinName);
        if (this.isLocked()) {
            return false;
        }
        if (!this.isCheckedOut()) {
            return false;
        }
        if (this.getDefinition().isProtected()) {
            return false;
        }
        if (mixinCandidateType.isAbstract()) {
            return false;
        }
        if (!mixinCandidateType.isMixin()) {
            return false;
        }
        if (this.isNodeType(mixinCandidateType.getInternalName())) {
            return true;
        }
        for (JcrPropertyDefinition propertyDefinition : mixinCandidateType.propertyDefinitions()) {
            AbstractJcrProperty existingProp;
            if (!this.hasProperty(propertyDefinition.getInternalName()) || (existingProp = this.cache.findJcrProperty(this.nodeId, this.location.getPath(), propertyDefinition.getInternalName())) == null || !(propertyDefinition.isMultiple() ? !propertyDefinition.canCastToTypeAndSatisfyConstraints(existingProp.getValues()) : !propertyDefinition.canCastToTypeAndSatisfyConstraints(existingProp.getValue()))) continue;
            return false;
        }
        HashSet<Name> mixinChildNodeNames = new HashSet<Name>();
        for (JcrNodeDefinition nodeDefinition : mixinCandidateType.childNodeDefinitions()) {
            mixinChildNodeNames.add(nodeDefinition.getInternalName());
        }
        for (Name nodeName : mixinChildNodeNames) {
            int snsCount = this.nodeInfo().getChildrenCount(nodeName);
            for (GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> child : this.nodeInfo().getChildren(nodeName)) {
                JcrNodeDefinition match = this.cache.nodeTypes().findChildNodeDefinition(mixinCandidateType.getInternalName(), Collections.<Name>emptyList(), nodeName, child.getPayload().getPrimaryTypeName(), snsCount, false);
                if (match != null) continue;
                return false;
            }
        }
        return true;
    }

    public final void addMixin(String mixinName) throws RepositoryException {
        CheckArg.isNotNull(mixinName, "mixinName");
        CheckArg.isNotZeroLength(mixinName, "mixinName");
        this.checkSession();
        JcrNodeType mixinCandidateType = this.cache.nodeTypes().getNodeType(mixinName);
        if (this.isLocked() && !this.getLock().isLockOwningSession()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(this.location));
        }
        if (!this.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(this.getPath()));
        }
        if (!this.canAddMixin(mixinName)) {
            throw new ConstraintViolationException(JcrI18n.cannotAddMixin.text(mixinName));
        }
        if (this.isNodeType(mixinName)) {
            return;
        }
        this.editor().addMixin(mixinCandidateType);
    }

    public void removeMixin(String mixinName) throws RepositoryException {
        this.checkSession();
        if (this.isLocked() && !this.getLock().isLockOwningSession()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(this.location));
        }
        if (!this.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(this.getPath()));
        }
        if (this.getDefinition().isProtected()) {
            throw new ConstraintViolationException(JcrI18n.cannotRemoveFromProtectedNode.text(this.getPath()));
        }
        AbstractJcrProperty existingMixinProperty = this.getProperty(JcrLexicon.MIXIN_TYPES);
        if (existingMixinProperty == null) {
            throw new NoSuchNodeTypeException(JcrI18n.invalidMixinTypeForNode.text(mixinName, this.getPath()));
        }
        Value[] existingMixinValues = existingMixinProperty.getValues();
        if (existingMixinValues.length == 0) {
            throw new NoSuchNodeTypeException(JcrI18n.invalidMixinTypeForNode.text(mixinName, this.getPath()));
        }
        int newMixinValuesCount = existingMixinValues.length - 1;
        Value[] newMixinValues = new Value[newMixinValuesCount];
        ArrayList<Name> newMixinNames = new ArrayList<Name>(newMixinValuesCount);
        Name primaryTypeName = this.getPrimaryNodeType().getInternalName();
        int j = 0;
        for (int i = 0; i < existingMixinValues.length; ++i) {
            if (existingMixinValues[i].getString().equals(mixinName)) continue;
            if (j < newMixinValuesCount) {
                newMixinValues[j++] = existingMixinValues[i];
                newMixinNames.add((Name)this.cache.nameFactory.create(existingMixinValues[i].getString()));
                continue;
            }
            throw new NoSuchNodeTypeException(JcrI18n.invalidMixinTypeForNode.text(mixinName, this.getPath()));
        }
        PropertyIterator iter = this.getProperties();
        while (iter.hasNext()) {
            JcrPropertyDefinition match;
            Property property = iter.nextProperty();
            if (!mixinName.equals(property.getDefinition().getDeclaringNodeType().getName()) || (match = property.getDefinition().isMultiple() ? this.cache.nodeTypes().findPropertyDefinition(primaryTypeName, newMixinNames, JcrNodeType.RESIDUAL_NAME, property.getValues(), true) : this.cache.nodeTypes().findPropertyDefinition(primaryTypeName, newMixinNames, JcrNodeType.RESIDUAL_NAME, property.getValue(), true, true)) != null) continue;
            throw new ConstraintViolationException(JcrI18n.noDefinition.text("property", property.getName(), this.getPath(), primaryTypeName, newMixinNames));
        }
        iter = this.getNodes();
        while (iter.hasNext()) {
            JcrNodeDefinition match;
            AbstractJcrNode node = (AbstractJcrNode)iter.nextNode();
            Name childNodeName = (Name)this.cache.nameFactory.create(node.getName());
            int snsCount = node.nodeInfo().getChildrenCount(childNodeName);
            if (!mixinName.equals(node.getDefinition().getDeclaringNodeType().getName()) || (match = this.cache.nodeTypes().findChildNodeDefinition(primaryTypeName, newMixinNames, JcrNodeType.RESIDUAL_NAME, node.getPrimaryNodeType().getInternalName(), snsCount, true)) != null) continue;
            throw new ConstraintViolationException(JcrI18n.noDefinition.text("child node", node.getName(), this.getPath(), primaryTypeName, newMixinNames));
        }
        this.editor().setProperty(JcrLexicon.MIXIN_TYPES, newMixinValues, 7, false);
    }

    public void setPrimaryType(String nodeTypeName) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.checkSession();
        if (this.isLocked() && !this.getLock().isLockOwningSession()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(this.location));
        }
        if (!this.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(this.getPath()));
        }
        JcrNodeType nodeType = this.session().nodeTypeManager().getNodeType(nodeTypeName);
        if (nodeType.equals(this.getPrimaryNodeType())) {
            return;
        }
        if (nodeType.isMixin()) {
            throw new ConstraintViolationException(JcrI18n.cannotUseMixinTypeAsPrimaryType.text(nodeTypeName));
        }
        throw new ConstraintViolationException(JcrI18n.setPrimaryTypeNotSupported.text(new Object[0]));
    }

    public final Node addNode(String relPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        return this.addNode(relPath, null, null);
    }

    public final Node addNode(String relPath, String primaryNodeTypeName) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        return this.addNode(relPath, primaryNodeTypeName, null);
    }

    final AbstractJcrNode addNode(String relPath, String primaryNodeTypeName, UUID desiredUuid) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.checkSession();
        if (this.isLocked() && !this.getLock().isLockOwningSession()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(this.location));
        }
        SessionCache.NodeEditor editor = null;
        Path path = null;
        try {
            path = (Path)this.cache.pathFactory().create(relPath);
        }
        catch (ValueFormatException e) {
            throw new RepositoryException(JcrI18n.invalidPathParameter.text(relPath, "relPath"));
        }
        if (path.size() == 0) {
            throw new RepositoryException(JcrI18n.invalidPathParameter.text(relPath, "relPath"));
        }
        if (path.isIdentifier()) {
            throw new RepositoryException(JcrI18n.invalidPathParameter.text(relPath, "relPath"));
        }
        if (path.getLastSegment().getIndex() > 1 || relPath.endsWith("]")) {
            throw new RepositoryException(JcrI18n.invalidPathParameter.text(relPath, "relPath"));
        }
        if (path.size() > 1) {
            Path parentPath = path.getParent();
            try {
                GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> parentOfNewNode = this.cache.findNode(this.nodeId, this.location.getPath(), parentPath);
                editor = this.cache.getEditorFor(parentOfNewNode);
            }
            catch (RepositoryException e) {
                try {
                    GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> grandparent;
                    if (parentPath.size() > 1) {
                        Path grandparentPath = parentPath.getParent();
                        assert (grandparentPath != null);
                        grandparent = this.cache.findNode(this.nodeId, this.location.getPath(), grandparentPath);
                    } else {
                        grandparent = this.nodeInfo();
                    }
                    if (grandparent.getProperty(parentPath.getLastSegment().getName()) != null) {
                        throw new ConstraintViolationException(JcrI18n.invalidPathParameter.text(relPath, "relPath"));
                    }
                }
                catch (PathNotFoundException e2) {
                    // empty catch block
                }
                throw e;
            }
        }
        assert (path.size() == 1);
        editor = this.editor();
        Name childName = path.getLastSegment().getName();
        Name childPrimaryTypeName = null;
        if (primaryNodeTypeName != null) {
            try {
                childPrimaryTypeName = (Name)this.cache.nameFactory().create(primaryNodeTypeName);
            }
            catch (ValueFormatException e) {
                throw new RepositoryException(JcrI18n.invalidNodeTypeNameParameter.text(primaryNodeTypeName, "primaryNodeTypeName"));
            }
            if (INTERNAL_NODE_TYPE_NAMES.contains(childPrimaryTypeName)) {
                String workspaceName = this.getSession().getWorkspace().getName();
                String childPath = this.cache.readable(path);
                throw new ConstraintViolationException(JcrI18n.unableToCreateNodeWithInternalPrimaryType.text(primaryNodeTypeName, childPath, workspaceName));
            }
        }
        return editor.createChild(childName, desiredUuid, childPrimaryTypeName);
    }

    final boolean canAddNode(String relPath, String primaryNodeTypeName) throws RepositoryException {
        CheckArg.isNotEmpty(relPath, relPath);
        this.checkSession();
        if (this.isLocked() && !this.getLock().isLockOwningSession()) {
            return false;
        }
        Path path = null;
        try {
            path = (Path)this.cache.pathFactory().create(relPath);
        }
        catch (ValueFormatException e) {
            return false;
        }
        if (path.size() == 0) {
            return false;
        }
        if (path.isIdentifier()) {
            return false;
        }
        if (path.getLastSegment().getIndex() > 1 || relPath.endsWith("]")) {
            return false;
        }
        if (path.size() > 1) {
            Path parentPath = path.getParent();
            try {
                this.cache.findNode(this.nodeId, this.location.getPath(), parentPath);
            }
            catch (RepositoryException e) {
                return false;
            }
        }
        if (primaryNodeTypeName != null) {
            if (!this.session().nodeTypeManager().hasNodeType(primaryNodeTypeName)) {
                return false;
            }
            JcrNodeType nodeType = this.session().nodeTypeManager().getNodeType(primaryNodeTypeName);
            if (nodeType.isAbstract()) {
                return false;
            }
            if (nodeType.isMixin()) {
                return false;
            }
            if (INTERNAL_NODE_TYPE_NAMES.contains(nodeType.getInternalName())) {
                return false;
            }
        }
        return true;
    }

    protected final Property removeExistingValuedProperty(String name) throws ConstraintViolationException, RepositoryException {
        AbstractJcrProperty property = this.cache.findJcrProperty(this.nodeId, this.location.getPath(), this.nameFrom(name));
        if (property != null) {
            property.remove();
            return property;
        }
        return null;
    }

    public final Property setProperty(String name, boolean value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(6, value));
    }

    public Property setProperty(String name, Binary value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(2, value));
    }

    public Property setProperty(String name, BigDecimal value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(12, value));
    }

    public final Property setProperty(String name, Calendar value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(value));
    }

    public final Property setProperty(String name, double value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(4, value));
    }

    public final Property setProperty(String name, InputStream value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(value));
    }

    public final Property setProperty(String name, long value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(3, value));
    }

    public final Property setProperty(String name, Node value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(value));
    }

    public final Property setProperty(String name, String value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(1, value));
    }

    public final Property setProperty(String name, String value, int type) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(type, value));
    }

    public final Property setProperty(String name, String[] values) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        if (values == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valuesFrom(1, values), 0);
    }

    public final Property setProperty(String name, String[] values, int type) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        if (values == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valuesFrom(type, values), 0);
    }

    public final Property setProperty(String name, Value value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        JcrValue jcrValue = (JcrValue)value;
        if (jcrValue.value() == null) {
            throw new javax.jcr.ValueFormatException(JcrI18n.valueMayNotContainNull.text(name));
        }
        return this.editor().setProperty(this.nameFrom(name), jcrValue);
    }

    public final Property setProperty(String name, Value value, int type) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        JcrValue jcrValue = (JcrValue)value;
        if (jcrValue.value() == null) {
            throw new javax.jcr.ValueFormatException(JcrI18n.valueMayNotContainNull.text(name));
        }
        return this.editor().setProperty(this.nameFrom(name), jcrValue.asType(type));
    }

    public final Property setProperty(String name, Value[] values) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        if (values == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.setProperty(name, values, 0);
    }

    public final Property setProperty(String name, Value[] values, int type) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(name, "name");
        this.checkSession();
        if (values == null) {
            return this.removeExistingValuedProperty(name);
        }
        for (Value value : values) {
            JcrValue jcrValue = (JcrValue)value;
            if (jcrValue == null || jcrValue.value() != null) continue;
            throw new javax.jcr.ValueFormatException(JcrI18n.valueMayNotContainNull.text(name));
        }
        return this.editor().setProperty(this.nameFrom(name), values, type);
    }

    private void checkNotProtected() throws ConstraintViolationException, RepositoryException {
        JcrNodeDefinition nodeDefn = this.cache.nodeTypes().getNodeDefinition(this.nodeInfo().getPayload().getDefinitionId());
        if (nodeDefn.isProtected()) {
            throw new ConstraintViolationException(JcrI18n.cannotRemoveItemWithProtectedDefinition.text(this.getPath()));
        }
    }

    final JcrVersionManager versionManager() {
        return this.session().workspace().versionManager();
    }

    public final boolean isCheckedOut() throws RepositoryException {
        this.checkSession();
        return this.editor().isCheckedOut();
    }

    public final Version checkin() throws RepositoryException {
        return this.versionManager().checkin(this);
    }

    public final void checkout() throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.versionManager().checkout(this);
    }

    public final NodeIterator merge(String srcWorkspace, boolean bestEffort) throws ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull(srcWorkspace, "source workspace name");
        this.checkNotProtected();
        return this.versionManager().merge(this, srcWorkspace, bestEffort, false);
    }

    public final void cancelMerge(Version version) throws RepositoryException {
        this.versionManager().cancelMerge(this, version);
    }

    public final void doneMerge(Version version) throws RepositoryException {
        this.versionManager().doneMerge(this, version);
    }

    public final JcrVersionHistoryNode getVersionHistory() throws RepositoryException {
        return this.versionManager().getVersionHistory(this);
    }

    public final JcrVersionNode getBaseVersion() throws RepositoryException {
        this.checkSession();
        if (!this.hasProperty(JcrLexicon.BASE_VERSION)) {
            throw new UnsupportedRepositoryOperationException(JcrI18n.requiresVersionable.text(new Object[0]));
        }
        return (JcrVersionNode)this.session().getNodeByUUID(this.getProperty(JcrLexicon.BASE_VERSION).getString());
    }

    public final void restore(String versionName, boolean removeExisting) throws RepositoryException {
        this.restore(this.getVersionHistory().getVersion(versionName), removeExisting);
    }

    public final void restore(Version version, boolean removeExisting) throws RepositoryException {
        try {
            this.checkNotProtected();
        }
        catch (ConstraintViolationException cve) {
            throw new UnsupportedRepositoryOperationException((Throwable)cve);
        }
        this.versionManager().restore(this.path(), version, null, removeExisting);
    }

    public final void restore(Version version, String relPath, boolean removeExisting) throws RepositoryException {
        this.checkNotProtected();
        PathFactory pathFactory = this.context().getValueFactories().getPathFactory();
        Path relPathAsPath = (Path)pathFactory.create(relPath);
        if (relPathAsPath.isAbsolute()) {
            throw new RepositoryException(JcrI18n.invalidRelativePath.text(relPath));
        }
        Path actualPath = pathFactory.create(this.path(), relPathAsPath).getCanonicalPath();
        this.versionManager().restore(actualPath, version, null, removeExisting);
    }

    public final void restoreByLabel(String versionLabel, boolean removeExisting) throws RepositoryException {
        this.restore(this.getVersionHistory().getVersionByLabel(versionLabel), removeExisting);
    }

    public final boolean holdsLock() throws RepositoryException {
        this.checkSession();
        return this.lockManager().holdsLock(this);
    }

    public final boolean isLocked() throws LockException, RepositoryException {
        return this.lockManager().isLocked(this);
    }

    public final Lock lock(boolean isDeep, boolean isSessionScoped) throws LockException, RepositoryException {
        this.checkSession();
        return this.lockManager().lock(this, isDeep, isSessionScoped, -1L, null);
    }

    public final void unlock() throws LockException, RepositoryException {
        this.checkSession();
        this.lockManager().unlock(this);
    }

    public final Lock getLock() throws LockException, RepositoryException {
        this.checkSession();
        return this.lockManager().getLock(this);
    }

    public final boolean isModified() {
        try {
            this.checkSession();
            GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> node = this.nodeInfo();
            return !node.isNew() && node.isChanged(true);
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public final boolean isNew() {
        try {
            this.checkSession();
            return this.nodeInfo().isNew();
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public final String getCorrespondingNodePath(String workspaceName) throws NoSuchWorkspaceException, ItemNotFoundException, RepositoryException {
        CheckArg.isNotNull(workspaceName, "workspace name");
        this.checkSession();
        NamespaceRegistry namespaces = this.context().getNamespaceRegistry();
        return this.correspondingNodePath(workspaceName).getString(namespaces);
    }

    protected final Path correspondingNodePath(String workspaceName) throws NoSuchWorkspaceException, ItemNotFoundException, RepositoryException {
        assert (workspaceName != null);
        NamespaceRegistry namespaces = this.context().getNamespaceRegistry();
        AbstractJcrNode referenceableRoot = this;
        while (!referenceableRoot.isNodeType(JcrMixLexicon.REFERENCEABLE.getString(namespaces))) {
            referenceableRoot = referenceableRoot.getParent();
        }
        Path relativePath = this.path().equals(referenceableRoot.path()) ? null : this.path().relativeTo(referenceableRoot.path());
        UUID uuid = UUID.fromString(referenceableRoot.getUUID());
        return this.cache.getPathForCorrespondingNode(workspaceName, uuid, relativePath);
    }

    public final void update(String srcWorkspaceName) throws NoSuchWorkspaceException, RepositoryException {
        CheckArg.isNotNull(srcWorkspaceName, "workspace name");
        this.checkSession();
        if (this.session().hasPendingChanges()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowed.text(new Object[0]));
        }
        this.checkNotProtected();
        Path correspondingPath = null;
        try {
            correspondingPath = this.correspondingNodePath(srcWorkspaceName);
        }
        catch (ItemNotFoundException infe) {
            return;
        }
        this.cache.graphSession().immediateClone(correspondingPath, srcWorkspaceName, this.path(), true, true);
        this.session().refresh(false);
    }

    public final void orderBefore(String srcChildRelPath, String destChildRelPath) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkSession();
        if (!this.getPrimaryNodeType().hasOrderableChildNodes()) {
            throw new UnsupportedRepositoryOperationException(JcrI18n.notOrderable.text(this.getPrimaryNodeType().getName(), this.getPath()));
        }
        PathFactory pathFactory = this.cache.pathFactory();
        Path srcPath = (Path)pathFactory.create(srcChildRelPath);
        if (srcPath.isAbsolute()) {
            throw new IllegalArgumentException(JcrI18n.invalidPathParameter.text(srcChildRelPath, "relativePath"));
        }
        if (srcPath.isAbsolute() || srcPath.size() != 1) {
            throw new ItemNotFoundException(JcrI18n.pathNotFound.text(srcPath.getString(this.namespaces()), this.cache.workspaceName()));
        }
        Path.Segment sourceSegment = srcPath.getLastSegment();
        try {
            this.nodeInfo().getChild(sourceSegment);
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            String workspaceName = this.cache.workspaceName();
            throw new ItemNotFoundException(JcrI18n.pathNotFound.text(srcPath, workspaceName));
        }
        Path.Segment destSegment = null;
        if (destChildRelPath != null) {
            Path destPath = (Path)pathFactory.create(destChildRelPath);
            if (destPath.isAbsolute()) {
                throw new IllegalArgumentException(JcrI18n.invalidPathParameter.text(destChildRelPath, "relativePath"));
            }
            if (destPath.size() != 1) {
                throw new ItemNotFoundException(JcrI18n.pathNotFound.text(destPath.getString(this.namespaces()), this.cache.workspaceName()));
            }
            destSegment = destPath.getLastSegment();
            try {
                this.nodeInfo().getChild(destSegment);
            }
            catch (org.modeshape.graph.property.PathNotFoundException e) {
                String workspaceName = this.cache.session().getWorkspace().getName();
                throw new ItemNotFoundException(JcrI18n.pathNotFound.text(destPath, workspaceName));
            }
        }
        this.editor().orderChildBefore(sourceSegment, destSegment);
    }

    protected static List<Object> createPatternsFor(String[] namePatterns) throws RepositoryException {
        LinkedList<Object> patterns = new LinkedList<Object>();
        for (String stringPattern : namePatterns) {
            int length = (stringPattern = stringPattern.trim()).length();
            if (length == 0) continue;
            if (stringPattern.indexOf("*") == -1) {
                patterns.add(stringPattern);
                continue;
            }
            StringBuilder sb = new StringBuilder(length);
            block6: for (int i = 0; i != length; ++i) {
                char c = stringPattern.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case '\"': 
                    case '\'': 
                    case '/': 
                    case '[': 
                    case ']': 
                    case '|': {
                        String msg = JcrI18n.invalidNamePattern.text(Character.valueOf(c), stringPattern);
                        throw new RepositoryException(msg);
                    }
                    case '$': 
                    case '(': 
                    case ')': 
                    case '.': 
                    case '?': 
                    case '\\': 
                    case '^': 
                    case '{': 
                    case '}': {
                        sb.append("\\");
                        sb.append(c);
                        continue block6;
                    }
                    case '*': {
                        sb.append(".*");
                        continue block6;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            String escapedString = sb.toString();
            Pattern pattern = Pattern.compile(escapedString);
            patterns.add(pattern);
        }
        return patterns;
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.checkSession();
        this.cache.refresh(this.nodeId, this.location.getPath(), keepChanges);
    }

    public void save() throws RepositoryException {
        this.checkSession();
        this.session().checkReferentialIntegrityOfChanges(this);
        this.cache.save(this.nodeId, this.location.getPath());
    }

    public String toString() {
        try {
            PropertyIterator iter = this.getProperties();
            StringBuffer propertyBuff = new StringBuffer();
            while (iter.hasNext()) {
                AbstractJcrProperty prop = (AbstractJcrProperty)iter.nextProperty();
                propertyBuff.append(prop).append(", ");
            }
            return this.getPath() + " {" + propertyBuff.toString() + "}";
        }
        catch (RepositoryException re) {
            return re.getMessage();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractJcrNode) {
            AbstractJcrNode that = (AbstractJcrNode)obj;
            if (this.cache != that.cache) {
                return false;
            }
            return this.location.equals(that.location);
        }
        return false;
    }

    public int hashCode() {
        return HashCode.compute(this.cache, this.location.getUuid());
    }

    public void followLifecycleTransition(String transition) throws UnsupportedRepositoryOperationException, InvalidLifecycleTransitionException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public String[] getAllowedLifecycleTransistions() throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeIterator getSharedSet() throws RepositoryException {
        if (this.isShareable()) {
            return this.sharedSet();
        }
        return new JcrSingleNodeIterator(this);
    }

    NodeIterator sharedSet() throws RepositoryException {
        AbstractJcrNode original = this;
        String identifierOfSharedNode = this.getIdentifier();
        if (this instanceof JcrSharedNode) {
            original = ((JcrSharedNode)this).originalNode();
        }
        QueryBuilder builder = new QueryBuilder(this.context().getValueFactories().getTypeSystem());
        QueryCommand query = builder.select("jcr:primaryType").from("mode:share").where().referenceValue("mode:share", "mode:sharedUuid").isEqualTo(identifierOfSharedNode).end().query();
        Query jcrQuery = this.session().workspace().queryManager().createQuery(query);
        QueryResult result = jcrQuery.execute();
        return new JcrNodeIterator(original, result.getNodes());
    }

    public void removeShare() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (this.isShareable()) {
            NodeIterator sharedSetNodes = this.sharedSet();
            long sharedSetSize = sharedSetNodes.getSize();
            if (sharedSetSize <= 1L) {
                this.doRemove();
                return;
            }
            AbstractJcrNode originalNode = (AbstractJcrNode)sharedSetNodes.nextNode();
            if (originalNode == this) {
                JcrSharedNode firstProxy = (JcrSharedNode)sharedSetNodes.nextNode();
                assert (!this.isRoot());
                assert (!firstProxy.isRoot());
                boolean sameParent = firstProxy.getParent().equals(this.getParent());
                SessionCache.NodeEditor parentEditor = firstProxy.editorForParent();
                if (sameParent) {
                    parentEditor.orderChildBefore(this.segment(), firstProxy.segment());
                    firstProxy.doRemove();
                } else {
                    GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> proxyNode = firstProxy.proxyInfo();
                    GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> nextChild = parentEditor.node().getChildAfter(proxyNode);
                    Name newName = proxyNode.getName();
                    firstProxy.doRemove();
                    GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> newNode = parentEditor.moveToBeChild(this, newName);
                    if (nextChild != null) {
                        parentEditor.orderChildBefore(newNode.getSegment(), nextChild.getSegment());
                    }
                }
            } else {
                this.doRemove();
            }
            return;
        }
        this.doRemove();
    }

    public void removeSharedSet() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (this.isShareable()) {
            NodeIterator sharedSetNodes = this.sharedSet();
            while (sharedSetNodes.hasNext()) {
                AbstractJcrNode nodeInSharedSet = (AbstractJcrNode)sharedSetNodes.nextNode();
                nodeInSharedSet.doRemove();
            }
        } else {
            this.doRemove();
        }
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        this.removeShare();
    }

    protected abstract void doRemove() throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException;
}

