/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.xpath;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.CommonI18n;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.text.TokenStream;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.xml.XmlCharacters;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.Order;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.jcr.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathParser {
    private final TypeSystem typeSystem;
    private final XmlNameEncoder decoder = new XmlNameEncoder();

    public XPathParser(TypeSystem context) {
        this.typeSystem = context;
    }

    public XPath.Component parseXPath(String xpath) {
        XPathTokenizer tokenizer = new XPathTokenizer(false);
        TokenStream tokens = new TokenStream(xpath, tokenizer, true).start();
        return this.parseXPath(tokens);
    }

    protected XPath.Component parseXPath(TokenStream tokens) {
        return this.parseExpr(tokens);
    }

    protected XPath.Component parseExpr(TokenStream tokens) {
        XPath.Component result = this.parseExprSingle(tokens);
        if (tokens.matches(',')) {
            throw new ParsingException(tokens.nextPosition(), "Multiple XPath expressions are not supported");
        }
        return result;
    }

    protected XPath.Component parseExprSingle(TokenStream tokens) {
        if (tokens.matches("for", "$", "any value", "IN")) {
            throw new ParsingException(tokens.nextPosition(), "XPath 'for' expressions are not supported");
        }
        if (tokens.matches("some", "$", "any value", "IN")) {
            throw new ParsingException(tokens.nextPosition(), "XPath 'some' expressions are not supported");
        }
        if (tokens.matches("every", "$", "any value", "IN")) {
            throw new ParsingException(tokens.nextPosition(), "XPath 'every' expressions are not supported");
        }
        if (tokens.matches("if", "(", "any value", "IN")) {
            throw new ParsingException(tokens.nextPosition(), "XPath if-then-else expressions are not supported");
        }
        return this.parseOrExpr(tokens);
    }

    protected XPath.Component parseOrExpr(TokenStream tokens) {
        XPath.Component result = this.parseAndExpr(tokens);
        while (tokens.canConsume("or")) {
            result = new XPath.Or(result, this.parseInstanceofExpr(tokens));
        }
        return result;
    }

    protected XPath.Component parseAndExpr(TokenStream tokens) {
        XPath.Component result = this.parseInstanceofExpr(tokens);
        while (tokens.canConsume("and")) {
            result = new XPath.And(result, this.parseInstanceofExpr(tokens));
        }
        return result;
    }

    protected XPath.Component parseInstanceofExpr(TokenStream tokens) {
        XPath.Component result = this.parseTreatExpr(tokens);
        if (tokens.matches("instance", "of")) {
            throw new ParsingException(tokens.nextPosition(), "XPath 'instance of' expressions are not supported");
        }
        return result;
    }

    protected XPath.Component parseTreatExpr(TokenStream tokens) {
        XPath.Component result = this.parseCastableExpr(tokens);
        if (tokens.matches("treat", "as")) {
            throw new ParsingException(tokens.nextPosition(), "XPath 'treat as' expressions are not supported");
        }
        return result;
    }

    protected XPath.Component parseCastableExpr(TokenStream tokens) {
        XPath.Component result = this.parseCastExpr(tokens);
        if (tokens.matches("castable", "as")) {
            throw new ParsingException(tokens.nextPosition(), "XPath 'castable as' expressions are not supported");
        }
        return result;
    }

    protected XPath.Component parseCastExpr(TokenStream tokens) {
        XPath.Component result = this.parseComparisonExpr(tokens);
        if (tokens.matches("cast", "as")) {
            throw new ParsingException(tokens.nextPosition(), "XPath 'cast as' expressions are not supported");
        }
        return result;
    }

    protected XPath.Component parseComparisonExpr(TokenStream tokens) {
        XPath.Component result = this.parseRangeExpr(tokens);
        Operator operator = this.parseGeneralComp(tokens);
        if (operator == null) {
            this.parseValueComp(tokens);
        }
        if (operator != null) {
            return new XPath.Comparison(result, operator, this.parseRangeExpr(tokens));
        }
        XPath.NodeComparisonOperator nodeComp = this.parseNodeComp(tokens);
        if (nodeComp != null) {
            return new XPath.NodeComparison(result, nodeComp, this.parseRangeExpr(tokens));
        }
        return result;
    }

    protected XPath.Component parseValueComp(TokenStream tokens) {
        if (tokens.matchesAnyOf("eq", "ne", "lt", "le", "gt")) {
            throw new ParsingException(tokens.nextPosition(), "XPath value comparisons using 'eq', 'ne', 'lt', 'le', or 'gt' are not supported");
        }
        return null;
    }

    protected XPath.NodeComparisonOperator parseNodeComp(TokenStream tokens) {
        if (tokens.matches("is") || tokens.matches("<", "<") || tokens.matches(">", ">")) {
            throw new ParsingException(tokens.nextPosition(), "XPath 'is', '<<' and '>>' expressions are not supported");
        }
        return null;
    }

    protected XPath.Component parseRangeExpr(TokenStream tokens) {
        XPath.Component result = this.parseAdditiveExpr(tokens);
        if (tokens.matches("to")) {
            throw new ParsingException(tokens.nextPosition(), "XPath range expressions with 'to' are not supported");
        }
        return result;
    }

    protected XPath.Component parseAdditiveExpr(TokenStream tokens) {
        XPath.Component result = this.parseMultiplicativeExpr(tokens);
        while (true) {
            if (tokens.canConsume("+")) {
                result = new XPath.Add(result, this.parseMultiplicativeExpr(tokens));
                continue;
            }
            if (!tokens.canConsume("-")) break;
            result = new XPath.Subtract(result, this.parseMultiplicativeExpr(tokens));
        }
        return result;
    }

    protected XPath.Component parseMultiplicativeExpr(TokenStream tokens) {
        XPath.Component result = this.parseUnaryExpr(tokens);
        if (tokens.matchesAnyOf("+", "div", "idiv", "mod")) {
            throw new ParsingException(tokens.nextPosition(), "XPath multiplicative expressions using '+', 'div', 'idiv', or 'mod' are not supported");
        }
        return result;
    }

    protected XPath.Component parseUnaryExpr(TokenStream tokens) {
        boolean negative = false;
        while (tokens.matchesAnyOf("+", "-")) {
            if (tokens.canConsume("-")) {
                negative = true;
            }
            tokens.canConsume("+");
        }
        XPath.Component result = this.parseUnionExpr(tokens);
        return negative ? new XPath.Negation(result) : result;
    }

    protected XPath.Component parseUnionExpr(TokenStream tokens) {
        XPath.Component result = this.parseIntersectExceptExpr(tokens);
        while (tokens.canConsumeAnyOf("union", "|")) {
            result = new XPath.Union(result, this.parseIntersectExceptExpr(tokens));
        }
        return result;
    }

    protected XPath.Component parseIntersectExceptExpr(TokenStream tokens) {
        XPath.Component result = this.parseValueExpr(tokens);
        while (true) {
            if (tokens.canConsumeAnyOf("intersect", new String[0])) {
                result = new XPath.Intersect(result, this.parseValueExpr(tokens));
                continue;
            }
            if (!tokens.canConsumeAnyOf("except", new String[0])) break;
            result = new XPath.Except(result, this.parseValueExpr(tokens));
        }
        return result;
    }

    protected XPath.Component parseValueExpr(TokenStream tokens) {
        return this.parsePathExpr(tokens);
    }

    protected XPath.PathExpression parsePathExpr(TokenStream tokens) {
        boolean relative = true;
        boolean prependDependentOrSelf = false;
        if (tokens.canConsume('/')) {
            if (tokens.canConsume('/')) {
                if (!tokens.hasNext()) {
                    throw new ParsingException(tokens.previousPosition(), "'//' is not a valid XPath expression");
                }
                prependDependentOrSelf = true;
            }
            relative = false;
        }
        XPath.PathExpression relativeExpr = this.parseRelativePathExpr(tokens);
        XPath.PathExpression result = new XPath.PathExpression(relative, relativeExpr.getSteps(), relativeExpr.getOrderBy());
        if (prependDependentOrSelf) {
            result.getSteps().add(0, new XPath.DescendantOrSelf());
        }
        return result;
    }

    protected XPath.PathExpression parseRelativePathExpr(TokenStream tokens) {
        ArrayList<XPath.StepExpression> steps = new ArrayList<XPath.StepExpression>();
        steps.add(this.parseStepExpr(tokens));
        while (tokens.canConsume('/')) {
            if (tokens.canConsume('/')) {
                steps.add(new XPath.DescendantOrSelf());
            }
            if (!tokens.hasNext()) continue;
            steps.add(this.parseStepExpr(tokens));
        }
        XPath.OrderBy orderBy = this.parseOrderBy(tokens);
        return new XPath.PathExpression(true, steps, orderBy);
    }

    protected XPath.StepExpression parseStepExpr(TokenStream tokens) {
        XPath.KindTest kindTest = this.parseKindTest(tokens);
        if (kindTest != null) {
            List<XPath.Component> predicates = this.parsePredicates(tokens);
            return new XPath.AxisStep(kindTest, predicates);
        }
        if (tokens.matches('(') || tokens.matches('.') || tokens.matches(8) || tokens.matches("any value", "(") || tokens.matches("any value", ":", "any value", "(")) {
            return this.parseFilterExpr(tokens);
        }
        XPath.AxisStep result = this.parseAxisStep(tokens);
        if (result != null) {
            return result;
        }
        return this.parseFilterExpr(tokens);
    }

    protected XPath.AxisStep parseAxisStep(TokenStream tokens) {
        XPath.NodeTest nodeTest = null;
        if (tokens.canConsume('@')) {
            nodeTest = new XPath.AttributeNameTest(this.parseNameTest(tokens));
        } else if (tokens.matches('*')) {
            nodeTest = this.parseNodeTest(tokens);
        } else {
            if (tokens.matches("child", ":", ":") || tokens.matches("attribute", ":", ":") || tokens.matches("self", ":", ":") || tokens.matches("descendant", ":", ":") || tokens.matches("descendant-or-self", ":", ":") || tokens.matches("following-sibling", ":", ":") || tokens.matches("following", ":", ":") || tokens.matches("namespace", ":", ":")) {
                throw new ParsingException(tokens.nextPosition(), "XPath non-abbreviated forward steps (e.g., 'child::', 'attribute::', 'self::', 'descendant::', 'descendant-or-self::', 'following-sibling::', 'following::', or 'namespace::') are not supported");
            }
            if (tokens.matches("..")) {
                throw new ParsingException(tokens.nextPosition(), "XPath abbreviated reverse steps (e.g., '..') are not supported");
            }
            if (tokens.matches("parent", ":", ":") || tokens.matches("ancestor-or-self", ":", ":") || tokens.matches("preceding-sibling", ":", ":") || tokens.matches("preceding", ":", ":") || tokens.matches("ancestor", ":", ":")) {
                throw new ParsingException(tokens.nextPosition(), "XPath non-abbreviated reverse steps (e.g., 'parent::', 'ancestor::', 'ancestor-or-self::', 'preceding-or-sibling::', or 'preceding::') are not supported");
            }
            if (tokens.matches("any value", ":", "any value") && tokens.matches(2, 4, 2)) {
                nodeTest = this.parseQName(tokens);
            } else if (tokens.matches(2)) {
                nodeTest = this.parseNodeTest(tokens);
            } else {
                return null;
            }
        }
        List<XPath.Component> predicates = this.parsePredicates(tokens);
        return new XPath.AxisStep(nodeTest, predicates);
    }

    protected List<XPath.Component> parsePredicates(TokenStream tokens) {
        ArrayList<XPath.Component> predicates = new ArrayList<XPath.Component>();
        while (tokens.canConsume('[')) {
            predicates.add(this.collapse(this.parseExpr(tokens)));
            tokens.consume(']');
        }
        return predicates;
    }

    protected XPath.FilterStep parseFilterExpr(TokenStream tokens) {
        XPath.Component primaryExpr = this.parsePrimaryExpr(tokens);
        List<XPath.Component> predicates = this.parsePredicates(tokens);
        return new XPath.FilterStep(primaryExpr, predicates);
    }

    protected XPath.Component parsePrimaryExpr(TokenStream tokens) {
        if (tokens.matches('(')) {
            return this.parseParenthesizedExpr(tokens);
        }
        if (tokens.matches('.')) {
            return this.parseContextItemExpr(tokens);
        }
        if (tokens.matches(8)) {
            return this.parseStringLiteral(tokens);
        }
        if (tokens.matches("any value", "(") || tokens.matches("any value", ":", "any value", "(")) {
            return this.parseFunctionCall(tokens);
        }
        return this.parseNumericLiteral(tokens);
    }

    protected XPath.ContextItem parseContextItemExpr(TokenStream tokens) {
        tokens.consume('.');
        return new XPath.ContextItem();
    }

    protected XPath.ParenthesizedExpression parseParenthesizedExpr(TokenStream tokens) {
        tokens.consume('(');
        if (tokens.canConsume(')')) {
            return new XPath.ParenthesizedExpression();
        }
        XPath.Component expr = this.collapse(this.parseExpr(tokens));
        tokens.consume(')');
        return new XPath.ParenthesizedExpression(expr);
    }

    protected XPath.Literal parseNumericLiteral(TokenStream tokens) {
        Position pos = tokens.nextPosition();
        String sign = "";
        if (tokens.canConsume('-')) {
            sign = "-";
        } else if (tokens.canConsume('+')) {
            sign = "";
        }
        String number = tokens.consume();
        if (number.indexOf(".") != -1) {
            String value = sign + number;
            if (value.endsWith("e") && (tokens.matches('+') || tokens.matches('-'))) {
                value = value + tokens.consume() + tokens.consume();
            }
            try {
                String canonical = this.typeSystem.getDoubleFactory().asString(value);
                return new XPath.Literal(canonical);
            }
            catch (ValueFormatException e) {
                String msg = GraphI18n.expectingLiteralAndUnableToParseAsDouble.text(value, pos.getLine(), pos.getColumn());
                throw new ParsingException(pos, msg);
            }
        }
        String value = sign + number;
        try {
            String canonical = this.typeSystem.getLongFactory().asString(value);
            return new XPath.Literal(canonical);
        }
        catch (ValueFormatException e) {
            String msg = GraphI18n.expectingLiteralAndUnableToParseAsLong.text(value, pos.getLine(), pos.getColumn());
            throw new ParsingException(pos, msg);
        }
    }

    protected XPath.Literal parseStringLiteral(TokenStream tokens) {
        boolean removeQuotes = tokens.matches(8);
        String value = tokens.consume();
        if (removeQuotes) {
            value = this.removeQuotes(value);
        }
        return new XPath.Literal(value);
    }

    protected XPath.FunctionCall parseFunctionCall(TokenStream tokens) {
        XPath.NameTest name = this.parseQName(tokens);
        tokens.consume("(");
        ArrayList<XPath.Component> args = new ArrayList<XPath.Component>();
        if (!tokens.matches(')')) {
            do {
                args.add(this.collapse(this.parseExprSingle(tokens)));
            } while (tokens.canConsume(","));
            tokens.consume(")");
        }
        return new XPath.FunctionCall(name, args);
    }

    protected Operator parseGeneralComp(TokenStream tokens) {
        if (tokens.canConsume("!", "=")) {
            return Operator.NOT_EQUAL_TO;
        }
        if (tokens.canConsume("=")) {
            return Operator.EQUAL_TO;
        }
        if (tokens.canConsume("<", "=")) {
            return Operator.LESS_THAN_OR_EQUAL_TO;
        }
        if (tokens.canConsume(">", "=")) {
            return Operator.GREATER_THAN_OR_EQUAL_TO;
        }
        if (tokens.canConsume("<")) {
            return Operator.LESS_THAN;
        }
        if (tokens.canConsume(">")) {
            return Operator.GREATER_THAN;
        }
        return null;
    }

    protected XPath.NodeTest parseNodeTest(TokenStream tokens) {
        XPath.KindTest kind = this.parseKindTest(tokens);
        if (kind != null) {
            return kind;
        }
        return this.parseNameTest(tokens);
    }

    protected XPath.NameTest parseNameTest(TokenStream tokens) {
        XPath.NameTest wildcard = this.parseWildcard(tokens);
        if (wildcard != null) {
            return wildcard;
        }
        return this.parseQName(tokens);
    }

    protected XPath.NameTest parseQName(TokenStream tokens) {
        String firstPart = this.parseNCName(tokens);
        if (tokens.canConsume(':')) {
            String secondPart = tokens.consume();
            return new XPath.NameTest(this.decode(firstPart), this.decode(secondPart));
        }
        return new XPath.NameTest(null, this.decode(firstPart));
    }

    protected String decode(String string) {
        return this.decoder.decode(string);
    }

    protected String parseNCName(TokenStream tokens) {
        String name = tokens.consume();
        if (!XmlCharacters.isValidNcName(name)) {
            throw new ParsingException(tokens.previousPosition(), "Expected valid NCName but found " + name);
        }
        return name;
    }

    protected XPath.NameTest parseWildcard(TokenStream tokens) {
        if (tokens.canConsume('*')) {
            if (tokens.canConsume(':')) {
                if (tokens.canConsume('*')) {
                    return new XPath.NameTest(null, null);
                }
                String localName = tokens.consume();
                return new XPath.NameTest(null, this.decode(localName));
            }
            return new XPath.NameTest(null, null);
        }
        if (tokens.matches(2, 4, 4) && tokens.matches("any value", ":", "*")) {
            String prefix = tokens.consume();
            tokens.consume(':');
            tokens.consume('*');
            return new XPath.NameTest(this.decode(prefix), null);
        }
        return null;
    }

    protected XPath.NameTest parseItemType(TokenStream tokens) {
        return this.parseQName(tokens);
    }

    protected XPath.NameTest parseAtomicType(TokenStream tokens) {
        return this.parseQName(tokens);
    }

    protected XPath.KindTest parseKindTest(TokenStream tokens) {
        XPath.KindTest result = this.parseAnyKindTest(tokens);
        if (result == null) {
            result = this.parseDocumentTest(tokens);
        }
        if (result == null) {
            result = this.parseElementTest(tokens);
        }
        if (result == null) {
            result = this.parseAttributeTest(tokens);
        }
        if (result == null) {
            result = this.parseSchemaElementTest(tokens);
        }
        if (result == null) {
            result = this.parseSchemaAttributeTest(tokens);
        }
        if (result == null) {
            result = this.parsePITest(tokens);
        }
        if (result == null) {
            result = this.parseCommentTest(tokens);
        }
        if (result == null) {
            result = this.parseTextTest(tokens);
        }
        return result;
    }

    protected XPath.AnyKindTest parseAnyKindTest(TokenStream tokens) {
        if (tokens.canConsume("node", "(", ")")) {
            return new XPath.AnyKindTest();
        }
        return null;
    }

    protected XPath.ProcessingInstructionTest parsePITest(TokenStream tokens) {
        if (tokens.canConsume("processing-instruction", "(")) {
            if (tokens.canConsume(")")) {
                return new XPath.ProcessingInstructionTest(null);
            }
            String nameOrStringLiteral = tokens.consume();
            tokens.consume(")");
            return new XPath.ProcessingInstructionTest(nameOrStringLiteral);
        }
        return null;
    }

    protected XPath.CommentTest parseCommentTest(TokenStream tokens) {
        if (tokens.canConsume("comment", "(", ")")) {
            return new XPath.CommentTest();
        }
        return null;
    }

    protected XPath.TextTest parseTextTest(TokenStream tokens) {
        if (tokens.canConsume("text", "(", ")")) {
            return new XPath.TextTest();
        }
        return null;
    }

    protected XPath.DocumentTest parseDocumentTest(TokenStream tokens) {
        if (tokens.canConsume("document-node", "(")) {
            XPath.SchemaElementTest schemaTest;
            XPath.ElementTest elementTest = this.parseElementTest(tokens);
            XPath.DocumentTest result = null;
            result = elementTest != null ? new XPath.DocumentTest(elementTest) : ((schemaTest = this.parseSchemaElementTest(tokens)) != null ? new XPath.DocumentTest(schemaTest) : null);
            tokens.consume(")");
            return result;
        }
        return null;
    }

    protected XPath.ElementTest parseElementTest(TokenStream tokens) {
        if (tokens.canConsume("element", "(")) {
            if (tokens.canConsume(")") || tokens.canConsume("*", ")")) {
                return new XPath.ElementTest(new XPath.NameTest(null, null), new XPath.NameTest(null, null));
            }
            XPath.ElementTest result = null;
            XPath.NameTest elementName = this.parseNameTest(tokens);
            if (tokens.canConsume(",")) {
                XPath.NameTest typeName = this.parseNameTest(tokens);
                result = new XPath.ElementTest(elementName, typeName);
                tokens.canConsume('?');
            } else {
                result = new XPath.ElementTest(elementName, new XPath.NameTest(null, null));
            }
            tokens.consume(")");
            return result;
        }
        return null;
    }

    protected XPath.SchemaElementTest parseSchemaElementTest(TokenStream tokens) {
        if (tokens.canConsume("schema-element", "(")) {
            XPath.NameTest elementDeclarationName = this.parseNameTest(tokens);
            XPath.SchemaElementTest result = new XPath.SchemaElementTest(elementDeclarationName);
            tokens.consume(")");
            return result;
        }
        return null;
    }

    protected XPath.AttributeTest parseAttributeTest(TokenStream tokens) {
        if (tokens.canConsume("attribute", "(")) {
            if (tokens.canConsume(")") || tokens.canConsume("*", ")")) {
                return new XPath.AttributeTest(new XPath.NameTest(null, null), new XPath.NameTest(null, null));
            }
            XPath.AttributeTest result = null;
            XPath.NameTest attributeName = this.parseNameTest(tokens);
            if (tokens.canConsume(",")) {
                XPath.NameTest typeName = this.parseNameTest(tokens);
                result = new XPath.AttributeTest(attributeName, typeName);
            } else {
                result = new XPath.AttributeTest(attributeName, new XPath.NameTest(null, null));
            }
            tokens.consume(")");
            return result;
        }
        return null;
    }

    protected XPath.SchemaAttributeTest parseSchemaAttributeTest(TokenStream tokens) {
        if (tokens.canConsume("schema-attribute", "(")) {
            XPath.NameTest attributeDeclarationName = this.parseNameTest(tokens);
            XPath.SchemaAttributeTest result = new XPath.SchemaAttributeTest(attributeDeclarationName);
            tokens.consume(")");
            return result;
        }
        return null;
    }

    protected void parseSingleType(TokenStream tokens) {
    }

    protected void parseSequenceType(TokenStream tokens) {
    }

    protected XPath.OrderBy parseOrderBy(TokenStream tokens) {
        if (tokens.canConsume("order", "by")) {
            ArrayList<XPath.OrderBySpec> specs = new ArrayList<XPath.OrderBySpec>();
            do {
                XPath.OrderBySpec spec = this.parseOrderBySpec(tokens);
                specs.add(spec);
            } while (tokens.canConsume(','));
            if (!specs.isEmpty()) {
                return new XPath.OrderBy(specs);
            }
        }
        return null;
    }

    protected XPath.OrderBySpec parseOrderBySpec(TokenStream tokens) {
        if (tokens.canConsume('@')) {
            XPath.NameTest attributeName = this.parseQName(tokens);
            Order order = Order.ASCENDING;
            if (tokens.canConsume("ascending")) {
                order = Order.ASCENDING;
            } else if (tokens.canConsume("descending")) {
                order = Order.DESCENDING;
            }
            return new XPath.OrderBySpec(order, attributeName);
        }
        if (tokens.matches("jcr", ":", "score", "(")) {
            XPath.FunctionCall scoreFunction = this.parseFunctionCall(tokens);
            Order order = Order.ASCENDING;
            if (tokens.canConsume("ascending")) {
                order = Order.ASCENDING;
            } else if (tokens.canConsume("descending")) {
                order = Order.DESCENDING;
            }
            return new XPath.OrderBySpec(order, scoreFunction);
        }
        throw new ParsingException(tokens.nextPosition(), "Expected either 'jcr:score(tableName)' or '@<propertyName>' but found " + tokens.consume());
    }

    protected String removeQuotes(String text) {
        int indexOfLast;
        char last;
        char first;
        assert (text != null);
        if (text.length() > 2 && ((first = text.charAt(0)) == '\"' || first == '\'') && (last = text.charAt(indexOfLast = text.length() - 1)) == first) {
            text = text.substring(1, indexOfLast);
        }
        return text;
    }

    protected XPath.Component collapse(XPath.Component component) {
        return component.collapse();
    }

    public static class XPathTokenizer
    implements TokenStream.Tokenizer {
        public static final int NAME = 2;
        public static final int SYMBOL = 4;
        public static final int QUOTED_STRING = 8;
        public static final int COMMENT = 16;
        public static final int OTHER = 32;
        private final boolean useComments;

        public XPathTokenizer(boolean useComments) {
            this.useComments = useComments;
        }

        public void tokenize(TokenStream.CharacterStream input, TokenStream.Tokens tokens) throws ParsingException {
            block6: while (input.hasNext()) {
                int tokenType;
                int endIndex;
                Position pos;
                int startIndex;
                char c = input.next();
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block6;
                    }
                    case '!': 
                    case '#': 
                    case '$': 
                    case '%': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '?': 
                    case '@': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 4);
                        continue block6;
                    }
                    case '\"': 
                    case '\'': {
                        startIndex = input.index();
                        char closingChar = c;
                        pos = input.position(startIndex);
                        boolean foundClosingQuote = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c == closingChar && input.isNext(closingChar)) {
                                c = input.next();
                                continue;
                            }
                            if (c != closingChar) continue;
                            foundClosingQuote = true;
                            break;
                        }
                        if (!foundClosingQuote) {
                            String msg = CommonI18n.noMatchingDoubleQuoteFound.text(pos.getLine(), pos.getColumn());
                            if (closingChar == '\'') {
                                msg = CommonI18n.noMatchingSingleQuoteFound.text(pos.getLine(), pos.getColumn());
                            }
                            throw new ParsingException(pos, msg);
                        }
                        endIndex = input.index() + 1;
                        tokens.addToken(pos, startIndex, endIndex, 8);
                        continue block6;
                    }
                    case '(': {
                        startIndex = input.index();
                        if (input.isNext(':')) {
                            pos = input.position(startIndex);
                            while (input.hasNext() && !input.isNext(':', ')')) {
                                c = input.next();
                            }
                            if (input.hasNext()) {
                                input.next();
                            }
                            if (input.hasNext()) {
                                input.next();
                            }
                            if (!this.useComments) continue block6;
                            endIndex = input.index() + 1;
                            tokens.addToken(pos, startIndex, endIndex, 16);
                            continue block6;
                        }
                        tokens.addToken(input.position(startIndex), input.index(), input.index() + 1, 4);
                        continue block6;
                    }
                }
                startIndex = input.index();
                pos = input.position(startIndex);
                int n = tokenType = XmlCharacters.isValidNcNameStart(c) ? 2 : 32;
                while (input.isNextValidXmlNcNameCharacter()) {
                    c = input.next();
                }
                endIndex = input.index() + 1;
                tokens.addToken(pos, startIndex, endIndex, tokenType);
            }
        }
    }
}

