/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.MockitoAnnotations;
import org.modeshape.common.FixFor;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.MockObservable;
import org.modeshape.graph.observe.Observable;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.CndNodeTypeReader;
import org.modeshape.jcr.JaasTestUtil;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrTools;

public class ImportExportTest {
    private static final String BAD_CHARACTER_STRING = "Test & <Test>*";
    private InMemoryRepositorySource source;
    private JcrSession session;
    private JcrRepository repository;
    private JcrTools tools;
    private Credentials credentials;

    @BeforeClass
    public static void beforeAll() {
        JaasTestUtil.initJaas("security/jaas.conf.xml");
    }

    @AfterClass
    public static void afterAll() {
        JaasTestUtil.releaseJaas();
    }

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.tools = new JcrTools();
        String workspace1 = "workspace1";
        String workspace2 = "workspace2";
        this.source = new InMemoryRepositorySource();
        this.source.setName("Store");
        this.source.setDefaultWorkspaceName(workspace1);
        this.source.setPredefinedWorkspaceNames(new String[]{workspace1, workspace2});
        ExecutionContext context = new ExecutionContext();
        context.getNamespaceRegistry().register("modetest", "http://www.modeshape.org/test/1.0");
        RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                return ImportExportTest.this.source.getConnection();
            }
        };
        Map options = Collections.emptyMap();
        this.repository = new JcrRepository(context, connectionFactory, "unused", (Observable)new MockObservable(), null, null, options, null, null);
        this.credentials = new SimpleCredentials("superuser", "superuser".toCharArray());
        this.session = (JcrSession)this.repository.login(this.credentials);
    }

    @After
    public void after() throws Exception {
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
        }
    }

    private void testImportExport(String sourcePath, String targetPath, ExportType useSystemView, boolean skipBinary, boolean noRecurse, boolean useWorkspace) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (useSystemView == ExportType.SYSTEM) {
            this.session.exportSystemView(sourcePath, (OutputStream)baos, skipBinary, noRecurse);
        } else {
            this.session.exportDocumentView(sourcePath, (OutputStream)baos, skipBinary, noRecurse);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        if (useWorkspace) {
            this.session.getWorkspace().importXML(targetPath, (InputStream)bais, 0);
        } else {
            this.session.importXML(targetPath, (InputStream)bais, 0);
        }
    }

    @Test
    public void shouldImportExportEscapedXmlCharactersInSystemViewUsingSession() throws Exception {
        String testName = "importExportEscapedXmlCharacters";
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node sourceNode = rootNode.addNode(testName + "Source", "nt:unstructured");
        Node targetNode = rootNode.addNode(testName + "Target", "nt:unstructured");
        sourceNode.setProperty("badcharacters", BAD_CHARACTER_STRING);
        Assert.assertThat((Object)sourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
        sourceNode.addNode(BAD_CHARACTER_STRING);
        this.testImportExport(sourceNode.getPath(), targetNode.getPath(), ExportType.SYSTEM, false, false, false);
        Node newSourceNode = targetNode.getNode(testName + "Source");
        newSourceNode.getNode(BAD_CHARACTER_STRING);
        Assert.assertThat((Object)newSourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
    }

    @Test
    public void shouldImportExportEscapedXmlCharactersInSystemViewUsingWorkspace() throws Exception {
        String testName = "importExportEscapedXmlCharacters";
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node sourceNode = rootNode.addNode(testName + "Source", "nt:unstructured");
        Node targetNode = rootNode.addNode(testName + "Target", "nt:unstructured");
        sourceNode.setProperty("badcharacters", BAD_CHARACTER_STRING);
        Assert.assertThat((Object)sourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
        sourceNode.addNode(BAD_CHARACTER_STRING);
        this.session.save();
        this.testImportExport(sourceNode.getPath(), targetNode.getPath(), ExportType.SYSTEM, false, false, true);
        Node newSourceNode = targetNode.getNode(testName + "Source");
        newSourceNode.getNode(BAD_CHARACTER_STRING);
        Assert.assertThat((Object)newSourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
    }

    @Ignore(value="JR TCK is broken")
    @Test
    public void shouldImportExportEscapedXmlCharactersInDocumentViewUsingSession() throws Exception {
        String testName = "importExportEscapedXmlCharacters";
        AbstractJcrNode rootNode = this.session.getRootNode();
        Node sourceNode = rootNode.addNode(testName + "Source", "nt:unstructured");
        Node targetNode = rootNode.addNode(testName + "Target", "nt:unstructured");
        sourceNode.setProperty("badcharacters", BAD_CHARACTER_STRING);
        Assert.assertThat((Object)sourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
        sourceNode.addNode(BAD_CHARACTER_STRING);
        this.testImportExport(sourceNode.getPath(), targetNode.getPath(), ExportType.DOCUMENT, false, false, false);
        Node newSourceNode = targetNode.getNode(testName + "Source");
        newSourceNode.getNode(BAD_CHARACTER_STRING);
        Assert.assertThat((Object)newSourceNode.getProperty("badcharacters").getString(), (Matcher)Is.is((Object)BAD_CHARACTER_STRING));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importFile(String importIntoPath, String resourceName, int importBehavior) throws Exception {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        try {
            this.session.importXML(importIntoPath, stream, importBehavior);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            stream.close();
            throw throwable;
        }
        stream.close();
    }

    protected Node assertNode(String path) throws Exception {
        AbstractJcrNode node = this.session.getNode(path);
        Assert.assertThat((Object)node, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        return node;
    }

    protected void assertNoNode(String path) throws Exception {
        try {
            this.session.getNode(path);
            Assert.fail((String)("Did not expect to find node at \"" + path + "\""));
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void shouldImportSystemViewWithUuidsAfterNodesWithSameUuidsAreDeletedInSessionAndSaved() throws Exception {
        CndNodeTypeReader reader = new CndNodeTypeReader((Session)this.session);
        reader.read("cars.cnd");
        this.session.getWorkspace().getNodeTypeManager().registerNodeTypes(reader.getNodeTypeDefinitions(), true);
        this.session.getRootNode().addNode("/someNode");
        this.session.save();
        this.importFile("/someNode", "io/cars-system-view-with-uuids.xml", 3);
        this.session.save();
        Node cars = this.assertNode("/someNode/Cars");
        Assert.assertThat((Object)cars.getIdentifier(), (Matcher)Is.is((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd"));
        this.assertNoNode("/someNode/Cars[2]");
        this.assertNoNode("/someNode[2]");
        cars.remove();
        this.session.save();
        this.importFile("/someNode", "io/cars-system-view-with-uuids.xml", 3);
        this.session.save();
        cars = this.assertNode("/someNode/Cars");
        Assert.assertThat((Object)cars.getIdentifier(), (Matcher)Is.is((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd"));
        this.assertNoNode("/someNode/Cars[2]");
        this.assertNoNode("/someNode[2]");
    }

    @Test
    public void shouldImportSystemViewWithUuidsAfterNodesWithSameUuidsAreDeletedInSessionButNotSaved() throws Exception {
        CndNodeTypeReader reader = new CndNodeTypeReader((Session)this.session);
        reader.read("cars.cnd");
        this.session.getWorkspace().getNodeTypeManager().registerNodeTypes(reader.getNodeTypeDefinitions(), true);
        this.session.getRootNode().addNode("/someNode");
        this.session.save();
        this.importFile("/someNode", "io/cars-system-view-with-uuids.xml", 3);
        this.session.save();
        Node cars = this.assertNode("/someNode/Cars");
        Assert.assertThat((Object)cars.getIdentifier(), (Matcher)Is.is((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd"));
        this.assertNoNode("/someNode/Cars[2]");
        this.assertNoNode("/someNode[2]");
        cars.remove();
        this.importFile("/someNode", "io/cars-system-view-with-uuids.xml", 3);
        this.session.save();
        cars = this.assertNode("/someNode/Cars");
        Assert.assertThat((Object)cars.getIdentifier(), (Matcher)Is.is((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd"));
        this.assertNoNode("/someNode/Cars[2]");
        this.assertNoNode("/someNode[2]");
    }

    @Test
    public void shouldImportSystemViewWithUuidsIntoDifferentSpotAfterNodesWithSameUuidsAreDeletedInSessionButNotSaved() throws Exception {
        CndNodeTypeReader reader = new CndNodeTypeReader((Session)this.session);
        reader.read("cars.cnd");
        this.session.getWorkspace().getNodeTypeManager().registerNodeTypes(reader.getNodeTypeDefinitions(), true);
        Node someNode = this.session.getRootNode().addNode("/someNode");
        this.session.getRootNode().addNode("/otherNode");
        this.session.save();
        this.importFile("/someNode", "io/cars-system-view-with-uuids.xml", 3);
        this.session.save();
        Node cars = this.assertNode("/someNode/Cars");
        Assert.assertThat((Object)cars.getIdentifier(), (Matcher)Is.is((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd"));
        this.assertNoNode("/someNode/Cars[2]");
        this.assertNoNode("/someNode[2]");
        cars.remove();
        Node newCars = someNode.addNode("Cars");
        Assert.assertThat((Object)newCars.getIdentifier(), (Matcher)Is.is((Matcher)IsNot.not((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd")));
        this.importFile("/otherNode", "io/cars-system-view-with-uuids.xml", 3);
        this.session.save();
        cars = this.assertNode("/otherNode/Cars");
        Assert.assertThat((Object)cars.getIdentifier(), (Matcher)Is.is((Object)"e41075cb-a09a-4910-87b1-90ce8b4ca9dd"));
        this.assertNoNode("/sameNode/Cars[2]");
        this.assertNoNode("/sameNode[2]");
        this.assertNoNode("/otherNode/Cars[2]");
        this.assertNoNode("/otherNode[2]");
    }

    @Test
    @FixFor(value={"MODE-1137"})
    public void shouldExportContentWithUnicodeCharactersAsDocumentView() throws Exception {
        Node unicode = this.session.getRootNode().addNode("unicodeContent");
        Node desc = unicode.addNode("descriptionNode");
        desc.setProperty("ex1", "\u00e9tudiant (student)");
        desc.setProperty("ex2", "o\u00f9 (where)");
        desc.setProperty("ex3", "for\u00eat (forest)");
        desc.setProperty("ex4", "na\u00efve (na\u00efve)");
        desc.setProperty("ex5", "gar\u00e7on (boy)");
        desc.setProperty("ex6", "multi\nline\nvalue");
        desc.setProperty("ex7", "prop \"value\" with quotes");
        desc.setProperty("ex7", "values with \r various \t\n : characters");
        this.session.save();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.session.exportDocumentView("/unicodeContent", (OutputStream)baos, false, false);
        baos.close();
        ByteArrayInputStream istream = new ByteArrayInputStream(baos.toByteArray());
        Session session2 = this.repository.login(this.credentials, "workspace2");
        session2.getWorkspace().importXML("/", (InputStream)istream, 3);
        Node desc2 = session2.getNode("/unicodeContent/descriptionNode");
        this.assertSameProperties(desc, desc2, new String[0]);
    }

    @Test
    @FixFor(value={"MODE-1137"})
    public void shouldExportContentWithUnicodeCharactersAsSystemView() throws Exception {
        Node unicode = this.session.getRootNode().addNode("unicodeContent");
        Node desc = unicode.addNode("descriptionNode");
        desc.setProperty("ex1", "\u00e9tudiant (student)");
        desc.setProperty("ex2", "o\u00f9 (where)");
        desc.setProperty("ex3", "for\u00eat (forest)");
        desc.setProperty("ex4", "na\u00efve (na\u00efve)");
        desc.setProperty("ex5", "gar\u00e7on (boy)");
        desc.setProperty("ex6", "multi\nline\nvalue");
        desc.setProperty("ex7", "prop \"value\" with quotes");
        desc.setProperty("ex7", "values with \n various \t\n : characters");
        this.session.save();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.session.exportSystemView("/unicodeContent", (OutputStream)baos, false, false);
        baos.close();
        ByteArrayInputStream istream = new ByteArrayInputStream(baos.toByteArray());
        Session session2 = this.repository.login(this.credentials, "workspace2");
        session2.getWorkspace().importXML("/", (InputStream)istream, 3);
        Node desc2 = session2.getNode("/unicodeContent/descriptionNode");
        this.assertSameProperties(desc, desc2, new String[0]);
    }

    protected void assertSameProperties(Node node1, Node node2, String ... excludedPropertyNames) throws RepositoryException {
        HashSet<String> excludedNames = new HashSet<String>(Arrays.asList(excludedPropertyNames));
        HashSet<String> node2Names = new HashSet<String>();
        PropertyIterator iter = node2.getProperties();
        while (iter.hasNext()) {
            Property prop2 = iter.nextProperty();
            node2Names.add(prop2.getName());
        }
        node2Names.removeAll(excludedNames);
        iter = node1.getProperties();
        while (iter.hasNext()) {
            Property prop1 = iter.nextProperty();
            String name = prop1.getName();
            if (excludedNames.contains(name)) continue;
            Property prop2 = node2.getProperty(prop1.getName());
            Assert.assertThat((Object)prop1.isMultiple(), (Matcher)Is.is((Object)prop2.isMultiple()));
            if (prop1.isMultiple()) {
                Value[] values1 = prop1.getValues();
                Value[] values2 = prop2.getValues();
                Assert.assertThat((Object)values1, (Matcher)Is.is((Object)values2));
            } else {
                Assert.assertThat((Object)prop1.getValue().getString(), (Matcher)Is.is((Object)prop2.getValue().getString()));
            }
            node2Names.remove(name);
        }
        if (!node2Names.isEmpty()) {
            Assert.fail((String)("Found extra properties in node2: " + node2Names));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExportType {
        SYSTEM,
        DOCUMENT;

    }
}

