/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.version.Version;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrQueryManagerTest;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.repository.ModeShapeConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareableNodesTest {
    protected static final String CAR_CARRIER_TYPENAME = "car:Carrier";
    protected static final String CAR_TYPENAME = "car:Car";
    protected static final String MIX_SHAREABLE = "mix:shareable";
    protected static final String MIX_VERSIONABLE = "mix:versionable";
    protected static final String JCR_BASEVERSION = "jcr:baseVersion";
    private JcrConfiguration configuration;
    private JcrEngine engine;
    private JcrRepository repository;
    private Session session;
    private Workspace workspace;
    private JcrRepository repository2;
    private Session session2;

    protected static URI resourceUri(String name) throws URISyntaxException {
        return ShareableNodesTest.resourceUrl(name).toURI();
    }

    protected static URL resourceUrl(String name) {
        return JcrQueryManagerTest.class.getClassLoader().getResource(name);
    }

    protected static InputStream resourceStream(String name) {
        return JcrQueryManagerTest.class.getClassLoader().getResourceAsStream(name);
    }

    protected static String[] carColumnNames() {
        return new String[]{"car:mpgCity", "car:lengthInInches", "car:maker", "car:userRating", "car:engine", "car:mpgHighway", "car:valueRating", "jcr:primaryType", "car:wheelbaseInInches", "car:year", "car:model", "car:msrp", "jcr:created", "jcr:createdBy"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void beforeEach() throws Exception {
        this.configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content");
        ((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("import-source").usingClass(InMemoryRepositorySource.class)).setDescription("The source used to import content");
        this.configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(ShareableNodesTest.resourceUrl("cars.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.configuration.repository("import-repo").setSource("import-source").addNodeTypes(ShareableNodesTest.resourceUrl("cars.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.engine = this.configuration.build();
        this.engine.start();
        this.repository = this.engine.getRepository("cars");
        this.session = this.repository.login();
        try {
            InputStream stream = ShareableNodesTest.resourceStream("io/cars-system-view.xml");
            try {
                this.session.getWorkspace().importXML("/", stream, 0);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                stream.close();
            }
            this.session.getRootNode().addNode("NewArea");
            this.session.getRootNode().addNode("NewSecondArea");
            this.session.save();
        }
        finally {
            this.session.logout();
        }
        this.session = this.repository.login();
        this.workspace = this.session.getWorkspace();
        this.repository2 = this.engine.getRepository("import-repo");
        this.session2 = this.repository2.login();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.session != null) {
            Object v3;
            Object v2;
            try {
                this.session.logout();
                Object var2_1 = null;
                this.session = null;
                this.workspace = null;
                this.repository = null;
            }
            catch (Throwable throwable) {
                Object v1;
                Object v0;
                Object var2_2 = null;
                this.session = null;
                this.workspace = null;
                this.repository = null;
                try {
                    this.session2.logout();
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var4_6 = v0;
                this.session2 = null;
                this.repository2 = null;
                try {
                    this.engine.shutdown();
                    this.engine.awaitTermination(3L, TimeUnit.SECONDS);
                    v1 = null;
                }
                catch (Throwable throwable3) {
                    v1 = null;
                }
                Object var6_10 = v1;
                this.configuration = null;
                this.engine = null;
                throw throwable;
            }
            try {
                this.session2.logout();
                v2 = null;
            }
            catch (Throwable throwable) {
                v2 = null;
            }
            Object var4_5 = v2;
            this.session2 = null;
            this.repository2 = null;
            try {
                this.engine.shutdown();
                this.engine.awaitTermination(3L, TimeUnit.SECONDS);
                v3 = null;
            }
            catch (Throwable throwable) {
                v3 = null;
            }
            Object var6_9 = v3;
            this.configuration = null;
            this.engine = null;
            {
            }
        }
    }

    @Test
    public void shouldCreateOneSharedNode() throws RepositoryException {
        String originalPath = "/Cars/Utility";
        String sharedPath = "/NewArea/SharedUtility";
        Node original = this.makeShareable(originalPath);
        this.session.save();
        Node sharedNode = this.makeShare(originalPath, sharedPath);
        this.assertSharedSetIs(original, originalPath, sharedPath);
        this.assertSharedSetIs(sharedNode, originalPath, sharedPath);
    }

    @Test
    public void shouldCreateMultipleSharedNode() throws RepositoryException {
        String originalPath = "/Cars/Utility";
        String sharedPath = "/NewArea/SharedUtility";
        Node original = this.makeShareable(originalPath);
        this.session.save();
        Node sharedNode1 = this.makeShare(originalPath, sharedPath);
        this.assertSharedSetIs(original, originalPath, sharedPath);
        this.assertSharedSetIs(sharedNode1, originalPath, sharedPath);
        String sharedPath2 = "/NewArea/SharedUtility[2]";
        Node sharedNode2 = this.makeShare(originalPath, sharedPath2);
        this.assertSharedSetIs(original, originalPath, sharedPath, sharedPath2);
        this.assertSharedSetIs(sharedNode1, originalPath, sharedPath, sharedPath2);
        this.assertSharedSetIs(sharedNode2, originalPath, sharedPath, sharedPath2);
        String sharedPath3 = "/NewSecondArea/SharedUtility";
        Node sharedNode3 = this.makeShare(originalPath, sharedPath3);
        this.assertSharedSetIs(original, originalPath, sharedPath, sharedPath2, sharedPath3);
        this.assertSharedSetIs(sharedNode1, originalPath, sharedPath, sharedPath2, sharedPath3);
        this.assertSharedSetIs(sharedNode2, originalPath, sharedPath, sharedPath2, sharedPath3);
        this.assertSharedSetIs(sharedNode3, originalPath, sharedPath, sharedPath2, sharedPath3);
    }

    @Test
    public void shouldAllowingMovingSharedNode() throws RepositoryException {
        String originalPath = "/Cars/Utility";
        String sharedPath = "/NewArea/SharedUtility";
        Node original = this.makeShareable(originalPath);
        this.session.save();
        Node sharedNode = this.makeShare(originalPath, sharedPath);
        this.assertSharedSetIncludes(original, originalPath, sharedPath);
        this.assertSharedSetIncludes(sharedNode, originalPath, sharedPath);
        String newPath = "/NewSecondArea/SharedUtility";
        this.session.move(sharedPath, newPath);
        this.session.save();
        Node newSharedNode = this.session.getNode(newPath);
        this.assertSharedSetIs(original, originalPath, newPath);
        this.assertSharedSetIs(newSharedNode, originalPath, newPath);
        this.verifyShare(original, newSharedNode);
        Assert.assertThat((Object)sharedNode.getPath(), (Matcher)Is.is((Object)newSharedNode.getPath()));
    }

    @Test
    public void shouldAllowingCopyingSharedNode() throws RepositoryException {
        String originalPath = "/Cars/Utility";
        String sharedPath = "/NewArea/SharedUtility";
        Node original = this.makeShareable(originalPath);
        this.session.save();
        Node sharedNode = this.makeShare(originalPath, sharedPath);
        this.assertSharedSetIncludes(original, originalPath, sharedPath);
        this.assertSharedSetIncludes(sharedNode, originalPath, sharedPath);
        this.workspace.copy("/NewArea", "/NewSecondArea/NewArea");
        String copiedSharedPath = "/NewSecondArea" + sharedPath;
        this.session.refresh(false);
        Node node = this.session.getNode(copiedSharedPath);
        this.assertSharedSetIncludes(original, originalPath, sharedPath, copiedSharedPath);
        this.assertSharedSetIncludes(sharedNode, originalPath, sharedPath, copiedSharedPath);
        this.assertSharedSetIncludes(node, originalPath, sharedPath, copiedSharedPath);
        this.verifyShare(original, node);
    }

    @Test
    public void shouldAllowCreatingShareUnderNodeWithTypeThatDoesNotAllowProxyNodeButAllowsPrimaryTypeOfOriginal() throws RepositoryException {
        this.registerCarCarrierNodeType(this.session);
        Node myCarrier = this.session.getNode("/NewArea").addNode("MyCarrier", CAR_CARRIER_TYPENAME);
        Node prius = this.session.getNode("/Cars/Hybrid/Toyota Prius");
        prius.addMixin(MIX_SHAREABLE);
        this.session.save();
        String sharedPath = myCarrier.getPath() + "/The Prius";
        String originalPath = prius.getPath();
        Node sharedNode = this.makeShare(originalPath, sharedPath);
        this.assertSharedSetIncludes(prius, originalPath, sharedPath);
        this.assertSharedSetIncludes(sharedNode, originalPath, sharedPath);
        this.session.refresh(false);
        prius = this.session.getNode(prius.getPath());
        sharedNode = this.session.getNode(sharedNode.getPath());
        this.assertSharedSetIncludes(prius, originalPath, sharedPath);
        this.assertSharedSetIncludes(sharedNode, originalPath, sharedPath);
    }

    @Test
    @FixFor(value={"MODE-883"})
    public void shouldAllowCreatingShareableNodeUnderParentThatDoesNotAllowSameNameSiblings() throws RepositoryException {
        NodeTypeManager ntManager = this.session.getWorkspace().getNodeTypeManager();
        NodeTypeTemplate template = ntManager.createNodeTypeTemplate();
        template.setName("car:Owner");
        NodeDefinitionTemplate childDefn = ntManager.createNodeDefinitionTemplate();
        childDefn.setSameNameSiblings(false);
        childDefn.setName("*");
        childDefn.setRequiredPrimaryTypeNames(new String[]{CAR_TYPENAME});
        template.getNodeDefinitionTemplates().add(childDefn);
        ntManager.registerNodeType((NodeTypeDefinition)template, false);
        Node joe = this.session.getNode("/NewSecondArea").addNode("Joe", "car:Owner");
        Node sally = this.session.getNode("/NewSecondArea").addNode("Sally", "car:Owner");
        this.session.save();
        Node minibus = joe.addNode("Type 2", CAR_TYPENAME);
        minibus.setProperty("car:maker", "Volkswagen");
        minibus.setProperty("car:year", "1952");
        minibus.addMixin(MIX_SHAREABLE);
        this.session.save();
        String originalPath = minibus.getPath();
        String sharedPath = sally.getPath() + "/Our Bus";
        Node sharedNode = this.makeShare(originalPath, sharedPath);
        this.assertSharedSetIs(minibus, originalPath, sharedPath);
        this.assertSharedSetIs(sharedNode, originalPath, sharedPath);
        minibus.remove();
        this.session.save();
    }

    @Test(expected=ConstraintViolationException.class)
    public void shouldNotBeAbleToCreateNodeWithProxyNodeTypeAsPrimaryType() throws RepositoryException {
        this.session.getRootNode().addNode("ShouldNotBePossible", this.string(ModeShapeLexicon.SHARE));
    }

    @Test
    public void shouldReturnFalseFromCanAddNodeIfUsingProxyNodeTypeAsPrimaryType() throws RepositoryException {
        boolean can = ((AbstractJcrNode)this.session.getRootNode()).canAddNode("ShouldNotBePossible", this.string(ModeShapeLexicon.SHARE));
        Assert.assertThat((Object)can, (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldBeAbleToRegisterCarCarrierNodeType() throws RepositoryException {
        this.registerCarCarrierNodeType(this.session);
    }

    @Test
    public void shouldExportSharedNodesAsSystemViewXml() throws RepositoryException, IOException {
        this.createExportableContent();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.session.exportSystemView("/", (OutputStream)baos, false, false);
        this.session2.importXML("/", (InputStream)new ByteArrayInputStream(baos.toByteArray()), 0);
        this.session2.save();
        this.checkImportedContent(this.session2);
    }

    @Test
    public void shouldExportSharedNodesAsDocumentViewXml() throws RepositoryException, IOException {
        this.createExportableContent();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.session.exportDocumentView("/", (OutputStream)baos, false, false);
        this.session2.importXML("/", (InputStream)new ByteArrayInputStream(baos.toByteArray()), 0);
        this.session2.save();
        this.checkImportedContent(this.session2);
    }

    @Test
    public void shouldAllowingCreatingShareOfVersionedNode() throws RepositoryException {
        String originalPath = "/Cars/Utility";
        Node original = this.makeVersionable(originalPath);
        this.session.save();
        Version version1 = this.checkin(originalPath);
        Assert.assertThat((Object)version1, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Node baseVersion = this.findBaseVersion(originalPath);
        System.out.println("original     => " + original);
        System.out.println("baseVersion  => " + baseVersion);
        this.checkout(originalPath);
        String sharedPath = "/NewArea/SharedUtility";
        Node original2 = this.makeShareable(originalPath);
        this.session.save();
        Version version2 = this.checkin(originalPath);
        Assert.assertThat((Object)version2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Node baseVersion2 = this.findBaseVersion(original2);
        System.out.println("original2    => " + original2);
        System.out.println("baseVersion2 => " + baseVersion2);
        Node sharedNode = this.makeShare(originalPath, sharedPath);
        this.assertSharedSetIs(original2, originalPath, sharedPath);
        this.assertSharedSetIs(sharedNode, originalPath, sharedPath);
        System.out.println("sharedNode => " + sharedNode);
        this.session.getWorkspace().copy("/NewArea", "/OtherNewArea");
        Node baseVersion3 = this.findBaseVersion(originalPath);
        System.out.println("baseVersion3 => " + baseVersion3);
    }

    protected void createExportableContent() throws RepositoryException {
        String originalPath = "/Cars/Utility";
        String sharedPath = "/NewArea/SharedUtility";
        Node original = this.makeShareable(originalPath);
        this.session.save();
        Node sharedNode1 = this.makeShare(originalPath, sharedPath);
        this.assertSharedSetIs(original, originalPath, sharedPath);
        this.assertSharedSetIs(sharedNode1, originalPath, sharedPath);
        String sharedPath2 = "/NewArea/SharedUtility[2]";
        Node sharedNode2 = this.makeShare(originalPath, sharedPath2);
        this.assertSharedSetIs(original, originalPath, sharedPath, sharedPath2);
        this.assertSharedSetIs(sharedNode1, originalPath, sharedPath, sharedPath2);
        this.assertSharedSetIs(sharedNode2, originalPath, sharedPath, sharedPath2);
        String sharedPath3 = "/NewSecondArea/SharedUtility";
        Node sharedNode3 = this.makeShare(originalPath, sharedPath3);
        this.assertSharedSetIs(original, originalPath, sharedPath, sharedPath2, sharedPath3);
        this.assertSharedSetIs(sharedNode1, originalPath, sharedPath, sharedPath2, sharedPath3);
        this.assertSharedSetIs(sharedNode2, originalPath, sharedPath, sharedPath2, sharedPath3);
        this.assertSharedSetIs(sharedNode3, originalPath, sharedPath, sharedPath2, sharedPath3);
    }

    protected void checkImportedContent(Session session) throws RepositoryException {
        String originalPath = "/Cars/Utility";
        String sharedPath = "/NewArea/SharedUtility";
        String sharedPath2 = "/NewArea/SharedUtility[2]";
        String sharedPath3 = "/NewSecondArea/SharedUtility";
        Node original = session.getNode(originalPath);
        Node sharedNode1 = session.getNode(sharedPath);
        Node sharedNode2 = session.getNode(sharedPath2);
        Node sharedNode3 = session.getNode(sharedPath3);
        this.assertSharedSetIs(original, originalPath, sharedPath, sharedPath2, sharedPath3);
        this.assertSharedSetIs(sharedNode1, originalPath, sharedPath, sharedPath2, sharedPath3);
        this.assertSharedSetIs(sharedNode2, originalPath, sharedPath, sharedPath2, sharedPath3);
        this.assertSharedSetIs(sharedNode3, originalPath, sharedPath, sharedPath2, sharedPath3);
    }

    protected Path path(String path) {
        return (Path)this.engine.getExecutionContext().getValueFactories().getPathFactory().create(path);
    }

    protected String string(Object object) {
        return (String)this.engine.getExecutionContext().getValueFactories().getStringFactory().create(object);
    }

    protected Node makeShareable(String absPath) throws RepositoryException {
        Node node = this.session.getNode(absPath);
        if (!node.isNodeType(MIX_SHAREABLE)) {
            node.addMixin(MIX_SHAREABLE);
        }
        return node;
    }

    protected Node makeShare(String sourcePath, String newSharePath) throws RepositoryException {
        Node original = this.session.getNode(sourcePath);
        boolean exists = this.session.nodeExists(newSharePath);
        this.workspace.clone(this.workspace.getName(), sourcePath, newSharePath, false);
        Assert.assertThat((Object)exists, (Matcher)Is.is((Object)false));
        Node node = this.session.getNode(newSharePath);
        Assert.assertThat((Object)node.getPath(), (Matcher)Is.is((Object)newSharePath));
        Assert.assertThat((Object)node.getName(), (Matcher)Is.is((Object)this.string(this.path(newSharePath).getLastSegment().getName())));
        Assert.assertThat((Object)node.getIndex(), (Matcher)Is.is((Object)this.path(newSharePath).getLastSegment().getIndex()));
        this.verifyShare(original, node);
        return node;
    }

    protected Node makeVersionable(String absPath) throws RepositoryException {
        Node node = this.session.getNode(absPath);
        if (!node.isNodeType(MIX_VERSIONABLE)) {
            node.addMixin(MIX_VERSIONABLE);
        }
        return node;
    }

    protected Version checkin(String absPath) throws RepositoryException {
        return this.session.getWorkspace().getVersionManager().checkin(absPath);
    }

    protected void checkout(String absPath) throws RepositoryException {
        this.session.getWorkspace().getVersionManager().checkout(absPath);
    }

    protected void verifyShare(Node original, Node sharedNode) throws RepositoryException {
        Assert.assertThat((Object)sharedNode.getIdentifier(), (Matcher)Is.is((Object)original.getIdentifier()));
        Assert.assertThat((Object)sharedNode.isSame((Item)original), (Matcher)Is.is((Object)true));
        this.assertSameProperties(sharedNode, original);
        this.assertSameChildren(sharedNode, original);
        Assert.assertThat((Object)sharedNode.isNodeType(MIX_SHAREABLE), (Matcher)Is.is((Object)true));
        this.assertSharedSetIncludes(original, original.getPath(), sharedNode.getPath());
        this.assertSharedSetIncludes(sharedNode, original.getPath(), sharedNode.getPath());
    }

    protected Node findBaseVersion(Node node) throws RepositoryException {
        String baseVersionUuid = node.getProperty(JCR_BASEVERSION).getString();
        return this.session.getNodeByIdentifier(baseVersionUuid);
    }

    protected Node findBaseVersion(String path) throws RepositoryException {
        Node node = this.session.getNode(path);
        return this.findBaseVersion(node);
    }

    protected void assertSharedSetIs(Node node, String ... paths) throws RepositoryException {
        Set<String> pathsInShare = this.sharedSetPathsFor(node);
        for (String path : paths) {
            pathsInShare.remove(path);
        }
        Assert.assertThat((Object)pathsInShare.isEmpty(), (Matcher)Is.is((Object)true));
    }

    protected void assertSharedSetIncludes(Node node, String ... paths) throws RepositoryException {
        Set<String> pathsInShare = this.sharedSetPathsFor(node);
        for (String path : paths) {
            pathsInShare.remove(path);
        }
    }

    protected Set<String> sharedSetPathsFor(Node node) throws RepositoryException {
        HashSet<String> paths = new HashSet<String>();
        NodeIterator iter = node.getSharedSet();
        while (iter.hasNext()) {
            Node nodeInShare = iter.nextNode();
            paths.add(nodeInShare.getPath());
        }
        return paths;
    }

    protected void assertSameProperties(Node share, Node original) throws RepositoryException {
        Property property;
        HashSet<String> originalPropertyNames = new HashSet<String>();
        PropertyIterator iter = original.getProperties();
        while (iter.hasNext()) {
            property = iter.nextProperty();
            originalPropertyNames.add(property.getName());
        }
        iter = share.getProperties();
        while (iter.hasNext()) {
            property = iter.nextProperty();
            Property originalProperty = original.getProperty(property.getName());
            originalPropertyNames.remove(property.getName());
            Assert.assertThat((Object)property.isModified(), (Matcher)Is.is((Object)originalProperty.isModified()));
            Assert.assertThat((Object)property.isMultiple(), (Matcher)Is.is((Object)originalProperty.isMultiple()));
            Assert.assertThat((Object)property.isNew(), (Matcher)Is.is((Object)originalProperty.isNew()));
            Assert.assertThat((Object)property.isNode(), (Matcher)Is.is((Object)originalProperty.isNode()));
            Assert.assertThat((Object)property.isSame((Item)originalProperty), (Matcher)Is.is((Object)true));
            if (property.isMultiple()) {
                Value[] values = property.getValues();
                Value[] originalValues = originalProperty.getValues();
                Assert.assertThat((Object)values.length, (Matcher)Is.is((Object)originalValues.length));
                for (int i = 0; i != values.length; ++i) {
                    Assert.assertThat((Object)values[i].equals(originalValues[i]), (Matcher)Is.is((Object)true));
                }
                continue;
            }
            Assert.assertThat((Object)property.getValue(), (Matcher)Is.is((Object)originalProperty.getValue()));
        }
        Assert.assertThat((String)("Extra properties in original: " + originalPropertyNames), (Object)originalPropertyNames.isEmpty(), (Matcher)Is.is((Object)true));
    }

    protected void assertSameChildren(Node share, Node original) throws RepositoryException {
        HashSet<String> originalChildNames = new HashSet<String>();
        NodeIterator iter = original.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            originalChildNames.add(node.getName());
        }
        iter = share.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            Node originalChild = original.getNode(child.getName());
            originalChildNames.remove(child.getName());
            Assert.assertThat((Object)child.isSame((Item)originalChild), (Matcher)Is.is((Object)true));
        }
        Assert.assertThat((String)("Extra children in original: " + originalChildNames), (Object)originalChildNames.isEmpty(), (Matcher)Is.is((Object)true));
    }

    protected void registerCarCarrierNodeType(Session session) throws RepositoryException {
        NodeTypeManager ntManager = session.getWorkspace().getNodeTypeManager();
        try {
            ntManager.getNodeType(CAR_CARRIER_TYPENAME);
        }
        catch (NoSuchNodeTypeException e) {
            NodeTypeTemplate nt = ntManager.createNodeTypeTemplate();
            nt.setName(CAR_CARRIER_TYPENAME);
            NodeDefinitionTemplate carChildType = ntManager.createNodeDefinitionTemplate();
            carChildType.setRequiredPrimaryTypeNames(new String[]{CAR_TYPENAME});
            nt.getNodeDefinitionTemplates().add(carChildType);
            ntManager.registerNodeType((NodeTypeDefinition)nt, true);
        }
        ntManager.getNodeType(CAR_CARRIER_TYPENAME);
    }
}

