/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.joda.time.DateTimeZone;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.IoException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.AbstractValueFactory;
import org.modeshape.graph.property.basic.JodaDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class JodaDateTimeValueFactory
extends AbstractValueFactory<DateTime>
implements DateTimeFactory {
    public JodaDateTimeValueFactory(TextDecoder decoder, ValueFactory<String> stringValueFactory) {
        super(PropertyType.DATE, decoder, stringValueFactory);
    }

    @Override
    public DateTime create(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new JodaDateTime(value.trim());
        }
        catch (IllegalArgumentException err) {
            try {
                Long longValue = Long.parseLong(value);
                return new JodaDateTime(longValue);
            }
            catch (NumberFormatException e) {
                throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.errorConvertingType.text(String.class.getSimpleName(), DateTime.class.getSimpleName(), value), err);
            }
        }
    }

    @Override
    public DateTime create(String value, TextDecoder decoder) {
        return this.create(this.getDecoder(decoder).decode(value));
    }

    @Override
    public DateTime create(int value) {
        return this.create((long)value);
    }

    @Override
    public DateTime create(long value) {
        return new JodaDateTime(value);
    }

    @Override
    public DateTime create(boolean value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Date.class.getSimpleName(), value));
    }

    @Override
    public DateTime create(float value) {
        return this.create((long)value);
    }

    @Override
    public DateTime create(double value) {
        return this.create((long)value);
    }

    @Override
    public DateTime create(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return this.create(value.longValue());
    }

    @Override
    public DateTime create(Calendar value) {
        if (value == null) {
            return null;
        }
        return new JodaDateTime(value);
    }

    @Override
    public DateTime create(Date value) {
        if (value == null) {
            return null;
        }
        return new JodaDateTime(value);
    }

    @Override
    public DateTime create(DateTime value) throws ValueFormatException {
        return value;
    }

    @Override
    public DateTime create(Name value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Name.class.getSimpleName(), value));
    }

    @Override
    public DateTime create(Path value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Path.class.getSimpleName(), value));
    }

    @Override
    public DateTime create(Path.Segment value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Path.Segment.class.getSimpleName(), value));
    }

    @Override
    public DateTime create(Reference value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), Reference.class.getSimpleName(), value));
    }

    @Override
    public DateTime create(URI value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), URI.class.getSimpleName(), value));
    }

    @Override
    public DateTime create(UUID value) {
        throw new ValueFormatException((Object)value, this.getPropertyType(), GraphI18n.unableToCreateValue.text(this.getPropertyType().getName(), UUID.class.getSimpleName(), value));
    }

    @Override
    public DateTime create(byte[] value) {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public DateTime create(Binary value) throws ValueFormatException, IoException {
        return this.create(this.getStringValueFactory().create(value));
    }

    @Override
    public DateTime create(InputStream stream, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(stream, approximateLength));
    }

    @Override
    public DateTime create(Reader reader, long approximateLength) throws IoException {
        return this.create(this.getStringValueFactory().create(reader, approximateLength));
    }

    @Override
    public DateTime create() {
        return new JodaDateTime();
    }

    @Override
    public DateTime createUtc() {
        return new JodaDateTime(DateTimeZone.UTC);
    }

    @Override
    public DateTime create(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondsOfSecond) {
        return new JodaDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisecondsOfSecond);
    }

    @Override
    public DateTime create(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondsOfSecond, int timeZoneOffsetHours) {
        return new JodaDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisecondsOfSecond, timeZoneOffsetHours);
    }

    @Override
    public DateTime create(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisecondsOfSecond, String timeZoneId) {
        return new JodaDateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisecondsOfSecond, timeZoneId);
    }

    @Override
    public DateTime create(DateTime original, long offsetInMillis) {
        assert (original != null);
        if (offsetInMillis == 0L) {
            return original;
        }
        long newMillis = original.getMilliseconds() + offsetInMillis;
        return new JodaDateTime(newMillis, original.getTimeZoneId());
    }

    protected DateTime[] createEmptyArray(int length) {
        return new DateTime[length];
    }
}

