/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.security.AccessControlException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.WorkspaceLockManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrLockManager
implements LockManager {
    private final JcrSession session;
    private final WorkspaceLockManager lockManager;
    private final Set<String> lockTokens;

    JcrLockManager(JcrSession session, WorkspaceLockManager lockManager) {
        this.session = session;
        this.lockManager = lockManager;
        this.lockTokens = new HashSet<String>();
    }

    public void addLockToken(String lockToken) throws LockException {
        CheckArg.isNotNull(lockToken, "lock token");
        if (this.lockTokens.contains(lockToken)) {
            return;
        }
        if (this.lockManager.isHeldBySession(this.session, lockToken)) {
            throw new LockException(JcrI18n.lockTokenAlreadyHeld.text(lockToken));
        }
        this.lockManager.setHeldBySession(this.session, lockToken, true);
        this.lockTokens.add(lockToken);
    }

    public Lock getLock(String absPath) throws PathNotFoundException, LockException, AccessDeniedException, RepositoryException {
        AbstractJcrNode node = this.session.getNode(absPath);
        return this.getLock(node);
    }

    Lock getLock(AbstractJcrNode node) throws PathNotFoundException, LockException, AccessDeniedException, RepositoryException {
        WorkspaceLockManager.ModeShapeLock lock = this.lockFor(node);
        if (lock != null) {
            return lock.lockFor(node.cache);
        }
        throw new LockException(JcrI18n.notLocked.text(node.location()));
    }

    public String[] getLockTokens() {
        HashSet<String> publicTokens = new HashSet<String>(this.lockTokens);
        Iterator iter = publicTokens.iterator();
        while (iter.hasNext()) {
            String token = (String)iter.next();
            WorkspaceLockManager.ModeShapeLock lock = this.lockManager.lockFor(token);
            if (!lock.isSessionScoped()) continue;
            iter.remove();
        }
        return publicTokens.toArray(new String[publicTokens.size()]);
    }

    Set<String> lockTokens() {
        return this.lockTokens;
    }

    public boolean holdsLock(String absPath) throws PathNotFoundException, RepositoryException {
        AbstractJcrNode node = this.session.getNode(absPath);
        return this.holdsLock(node);
    }

    boolean holdsLock(AbstractJcrNode node) {
        WorkspaceLockManager.ModeShapeLock lock = this.lockManager.lockFor(this.session, node.location());
        return lock != null;
    }

    public boolean isLocked(String absPath) throws PathNotFoundException, RepositoryException {
        AbstractJcrNode node = this.session.getNode(absPath);
        return this.isLocked(node);
    }

    boolean isLocked(AbstractJcrNode node) throws PathNotFoundException, RepositoryException {
        return this.lockFor(node) != null;
    }

    public Lock lock(String absPath, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerInfo) throws LockException, PathNotFoundException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        AbstractJcrNode node = this.session.getNode(absPath);
        return this.lock(node, isDeep, isSessionScoped, timeoutHint, ownerInfo);
    }

    Lock lock(AbstractJcrNode node, boolean isDeep, boolean isSessionScoped, long timeoutHint, String ownerInfo) throws LockException, PathNotFoundException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        if (!node.isLockable()) {
            throw new LockException(JcrI18n.nodeNotLockable.text(node.getPath()));
        }
        if (node.isLocked()) {
            throw new LockException(JcrI18n.alreadyLocked.text(node.location()));
        }
        if (node.isModified()) {
            throw new InvalidItemStateException();
        }
        if (isDeep) {
            LinkedList nodesToVisit = new LinkedList();
            nodesToVisit.add(node.nodeInfo());
            while (!nodesToVisit.isEmpty()) {
                GraphSession.Node graphNode = (GraphSession.Node)nodesToVisit.remove(nodesToVisit.size() - 1);
                if (this.lockManager.lockFor(this.session, graphNode.getLocation()) != null) {
                    throw new LockException(JcrI18n.parentAlreadyLocked.text(node.location, graphNode.getLocation()));
                }
                for (GraphSession.Node child : graphNode.getChildren()) {
                    nodesToVisit.add(child);
                }
            }
        }
        WorkspaceLockManager.ModeShapeLock lock = this.lockManager.lock(this.session, node.location(), isDeep, isSessionScoped);
        this.addLockToken(lock.getLockToken());
        return lock.lockFor(this.session.cache());
    }

    public void removeLockToken(String lockToken) throws LockException {
        CheckArg.isNotNull(lockToken, "lockToken");
        if (!this.lockTokens.contains(lockToken)) {
            throw new LockException(JcrI18n.invalidLockToken.text(lockToken));
        }
        WorkspaceLockManager.ModeShapeLock lock = this.lockManager.lockFor(lockToken);
        if (lock == null) {
            this.lockTokens.remove(lockToken);
            return;
        }
        if (lock.isSessionScoped()) {
            throw new IllegalStateException(JcrI18n.cannotRemoveLockToken.text(lockToken));
        }
        this.lockManager.setHeldBySession(this.session, lockToken, false);
        this.lockTokens.remove(lockToken);
    }

    public void unlock(String absPath) throws PathNotFoundException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        AbstractJcrNode node = this.session.getNode(absPath);
        this.unlock(node);
    }

    void unlock(AbstractJcrNode node) throws PathNotFoundException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        WorkspaceLockManager.ModeShapeLock lock = this.lockManager.lockFor(this.session, node.location());
        if (lock == null) {
            throw new LockException(JcrI18n.notLocked.text(node.location()));
        }
        if (this.lockTokens.contains(lock.getLockToken())) {
            this.lockManager.unlock(this.session.getExecutionContext(), lock);
            this.removeLockToken(lock.getLockToken());
        } else {
            try {
                this.session.checkPermission(this.session.cache().workspaceName(), null, "unlock_any");
                this.lockManager.unlock(this.session.getExecutionContext(), lock);
            }
            catch (AccessControlException iae) {
                throw new LockException(JcrI18n.lockTokenNotHeld.text(node.location()));
            }
        }
    }

    final void cleanLocks() {
        this.lockManager.cleanLocks(this.session);
    }

    final WorkspaceLockManager.ModeShapeLock lockFor(AbstractJcrNode node) throws RepositoryException {
        if (this.session == null || this.session.workspace() == null) {
            return null;
        }
        WorkspaceLockManager.ModeShapeLock lock = this.lockManager.lockFor(this.session, node.location());
        if (lock != null) {
            return lock;
        }
        AbstractJcrNode parent = node;
        while (!parent.isRoot()) {
            WorkspaceLockManager.ModeShapeLock parentLock = this.lockManager.lockFor(this.session, (parent = parent.getParent()).location());
            if (parentLock == null || !parentLock.isLive()) continue;
            return parentLock.isDeep() ? parentLock : null;
        }
        return null;
    }

    final WorkspaceLockManager.ModeShapeLock lockFor(UUID nodeUuid) {
        if (this.session == null || this.session.workspace() == null) {
            return null;
        }
        return this.lockManager.lockFor(nodeUuid);
    }
}

