/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.spi.ObjectFactory;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.jcr.api.Repository;
import org.modeshape.repository.ModeShapeEngine;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiRepositoryFactory
implements ObjectFactory {
    private static final String CONFIG_FILE = "configFile";
    private static final String REPOSITORY_NAME = "repositoryName";
    private static final String TYPE = "type";
    private static JcrEngine engine;
    protected static final Logger log;

    private static synchronized void initializeEngine(String configFileName) throws IOException, SAXException, RepositoryException {
        if (engine != null) {
            return;
        }
        log.info(JcrI18n.engineStarting, new Object[0]);
        long start = System.currentTimeMillis();
        JcrConfiguration config = new JcrConfiguration();
        InputStream configStream = JndiRepositoryFactory.class.getResourceAsStream(configFileName);
        if (configStream == null) {
            try {
                configStream = new FileInputStream(configFileName);
            }
            catch (IOException ioe) {
                throw new RepositoryException((Throwable)ioe);
            }
        }
        engine = config.loadFrom(configStream).build();
        engine.start();
        Problems problems = engine.getProblems();
        for (Problem problem : problems) {
            switch (problem.getStatus()) {
                case ERROR: {
                    log.error(problem.getThrowable(), problem.getMessage(), problem.getParameters());
                    break;
                }
                case WARNING: {
                    log.warn(problem.getThrowable(), problem.getMessage(), problem.getParameters());
                    break;
                }
                case INFO: {
                    log.info(problem.getThrowable(), problem.getMessage(), problem.getParameters());
                }
            }
        }
        if (problems.hasErrors()) {
            throw new RepositoryException(JcrI18n.couldNotStartEngine.text(new Object[0]));
        }
        log.info(JcrI18n.engineStarted, System.currentTimeMillis() - start);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws IOException, SAXException, RepositoryException, NamingException {
        JcrRepository repository;
        RefAddr type;
        if (!(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (engine == null) {
            RefAddr configFile = ref.get(CONFIG_FILE);
            assert (configFile != null);
            JndiRepositoryFactory.initializeEngine(configFile.getContent().toString());
            if (nameCtx instanceof EventContext) {
                EventContext evtCtx = (EventContext)nameCtx;
                NamespaceChangeListener listener = new NamespaceChangeListener(){

                    public void namingExceptionThrown(NamingExceptionEvent evt) {
                        evt.getException().printStackTrace();
                    }

                    public void objectAdded(NamingEvent evt) {
                    }

                    public void objectRemoved(NamingEvent evt) {
                        Object oldObject = evt.getOldBinding().getObject();
                        if (!(oldObject instanceof JcrEngine)) {
                            return;
                        }
                        JcrEngine engine = (JcrEngine)oldObject;
                        log.info(JcrI18n.engineStopping, new Object[0]);
                        long start = System.currentTimeMillis();
                        engine.shutdown();
                        try {
                            engine.awaitTermination(30L, TimeUnit.SECONDS);
                            log.info(JcrI18n.engineStopped, System.currentTimeMillis() - start);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }

                    public void objectRenamed(NamingEvent evt) {
                    }
                };
                evtCtx.addNamingListener(name, 0, (NamingListener)listener);
            }
        }
        assert (engine != null);
        RefAddr repositoryName = ref.get(REPOSITORY_NAME);
        String repoName = null;
        if (repositoryName != null && (repoName = repositoryName.getContent().toString()) != null && repoName.trim().length() == 0) {
            repoName = null;
        }
        if ((type = ref.get(TYPE)) != null) {
            String typeName = type.getContent().toString();
            if (typeName != null && typeName.trim().length() == 0) {
                typeName = null;
            }
            if (Repositories.class.getName().equals(typeName) || JcrEngine.class.getName().equals(typeName) || ModeShapeEngine.class.getName().equals(typeName)) {
                if (repositoryName != null) {
                    log.warn(JcrI18n.repositoryNameProvidedWhenRegisteringEngineInJndi, name, repoName, typeName);
                }
                return engine;
            }
            if (!(javax.jcr.Repository.class.getName().equals(typeName) || JcrRepository.class.getName().equals(typeName) || Repository.class.getName().equals(typeName))) {
                return null;
            }
        } else {
            log.warn(JcrI18n.typeMissingWhenRegisteringEngineInJndi, name, Repositories.class.getName());
            if (repoName == null) {
                return engine;
            }
        }
        if (repoName == null) {
            if (repositoryName == null) {
                log.error(JcrI18n.repositoryNameNotProvidedWhenRegisteringRepositoryInJndi, name);
            } else {
                log.error(JcrI18n.emptyRepositoryNameProvidedWhenRegisteringRepositoryInJndi, name);
            }
        }
        if ((repository = engine.getRepository(repoName)) == null) {
            StringBuilder repoNames = new StringBuilder();
            boolean first = true;
            for (String existingName : engine.getRepositoryNames()) {
                if (first) {
                    first = false;
                } else {
                    repoNames.append(", ");
                }
                repoNames.append('\"').append(existingName).append('\"');
            }
            log.error(JcrI18n.invalidRepositoryNameWhenRegisteringRepositoryInJndi, name, repoName, repoNames);
            return null;
        }
        return repository;
    }

    static {
        log = Logger.getLogger(JndiRepositoryFactory.class);
    }
}

