/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.qom;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.query.JcrQueryContext;

public abstract class JcrAbstractQuery
implements Query {
    protected final JcrQueryContext context;
    protected final String language;
    protected final String statement;
    private Path storedAtPath;

    protected JcrAbstractQuery(JcrQueryContext context, String statement, String language, Path storedAtPath) {
        assert (context != null);
        assert (statement != null);
        assert (language != null);
        this.context = context;
        this.language = language;
        this.statement = statement;
        this.storedAtPath = storedAtPath;
    }

    protected final JcrQueryContext context() {
        return this.context;
    }

    protected final Path pathFor(String path) {
        return (Path)this.context.getExecutionContext().getValueFactories().getPathFactory().create(path);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getStatement() {
        return this.statement;
    }

    public String getStoredQueryPath() throws ItemNotFoundException {
        if (this.storedAtPath == null) {
            throw new ItemNotFoundException(JcrI18n.notStoredQuery.text(this.statement));
        }
        return this.storedAtPath.getString(this.context.getExecutionContext().getNamespaceRegistry());
    }

    public Node storeAsNode(String absPath) throws PathNotFoundException, ConstraintViolationException, RepositoryException {
        this.context.isLive();
        Node queryNode = this.context.store(absPath, JcrNtLexicon.QUERY, this.language, this.statement);
        this.storedAtPath = this.pathFor(queryNode.getPath());
        return queryNode;
    }

    protected void checkForProblems(Problems problems) throws RepositoryException {
        if (problems.hasErrors()) {
            StringBuilder msg = new StringBuilder();
            for (Problem problem : problems) {
                if (problem.getStatus() != Problem.Status.ERROR) continue;
                msg.append(problem.getMessageString()).append("\n");
            }
            throw new InvalidQueryException(msg.toString());
        }
    }
}

