/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.security;

import java.util.Map;
import javax.jcr.Credentials;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.SecurityContext;
import org.modeshape.jcr.api.ServletCredentials;
import org.modeshape.jcr.security.AuthenticationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletProvider
implements AuthenticationProvider {
    @Override
    public ExecutionContext authenticate(Credentials credentials, String repositoryName, String workspaceName, ExecutionContext repositoryContext, Map<String, Object> sessionAttributes) {
        ServletCredentials creds;
        HttpServletRequest request;
        if (credentials instanceof ServletCredentials && (request = (creds = (ServletCredentials)credentials).getRequest()) != null) {
            return repositoryContext.with(new ServletSecurityContext(request));
        }
        return null;
    }

    protected static class ServletSecurityContext
    implements SecurityContext {
        private HttpServletRequest request;
        private final String username;

        protected ServletSecurityContext(HttpServletRequest request) {
            this.request = request;
            this.username = request.getUserPrincipal() != null ? request.getUserPrincipal().getName() : null;
        }

        public final String getUserName() {
            return this.username;
        }

        public final boolean hasRole(String roleName) {
            return this.request != null && this.request.isUserInRole(roleName);
        }

        public void logout() {
            this.request = null;
        }
    }
}

