/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.cluster;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.component.ComponentLibrary;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.LocalObservationBus;
import org.modeshape.graph.observe.ObservationBus;
import org.modeshape.graph.observe.Observer;
import org.modeshape.repository.RepositoryI18n;
import org.modeshape.repository.cluster.ClusteringConfig;
import org.modeshape.repository.service.AbstractServiceAdministrator;
import org.modeshape.repository.service.AdministeredService;
import org.modeshape.repository.service.ServiceAdministrator;

public class ClusteringService
implements AdministeredService,
ObservationBus {
    private ExecutionContext executionContext;
    private ObservationBus bus;
    private final ComponentLibrary<ObservationBus, ClusteringConfig> busLibrary = new ComponentLibrary();

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        CheckArg.isNotNull(executionContext, "execution context");
        if (this.getAdministrator().isStarted()) {
            throw new IllegalStateException(RepositoryI18n.unableToChangeExecutionContextWhileRunning.text(new Object[0]));
        }
        this.executionContext = executionContext;
        this.busLibrary.setClassLoaderFactory(executionContext);
    }

    public boolean setClusteringConfig(ClusteringConfig config) {
        if (config == null) {
            config = this.createDefaultConfiguration();
        }
        return this.busLibrary.removeAllAndAdd(config);
    }

    @Override
    public boolean hasObservers() {
        return this.bus != null && this.bus.hasObservers();
    }

    @Override
    public boolean register(Observer observer) {
        if (this.bus == null) {
            throw new IllegalStateException(RepositoryI18n.unableToRegisterObserverOnUnstartedClusteringService.text(new Object[0]));
        }
        return this.bus.register(observer);
    }

    @Override
    public boolean unregister(Observer observer) {
        if (this.bus == null) {
            throw new IllegalStateException(RepositoryI18n.unableToUnregisterObserverOnUnstartedClusteringService.text(new Object[0]));
        }
        return this.bus.unregister(observer);
    }

    @Override
    public void notify(Changes changes) {
        if (this.bus == null) {
            throw new IllegalStateException(RepositoryI18n.unableToNotifyObserversOnUnstartedClusteringService.text(new Object[0]));
        }
        this.bus.notify(changes);
    }

    @Override
    public ServiceAdministrator getAdministrator() {
        return new Administrator();
    }

    @Override
    public void start() {
        this.getAdministrator().start();
    }

    @Override
    public void shutdown() {
        this.getAdministrator().shutdown();
    }

    protected void startService() {
        List<ObservationBus> instances = this.busLibrary.getInstances();
        if (instances.isEmpty()) {
            this.setClusteringConfig(null);
            instances = this.busLibrary.getInstances();
            assert (instances.size() > 0);
        }
        this.bus = instances.get(0);
        this.bus.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownService() {
        try {
            if (this.bus != null) {
                this.bus.shutdown();
            }
        }
        finally {
            this.bus = null;
        }
    }

    protected boolean isServiceTerminated() {
        return this.bus != null;
    }

    protected ClusteringConfig createDefaultConfiguration() {
        return new ClusteringConfig("bus", "Local observation bus", LocalObservationBus.class.getName(), null);
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(RepositoryI18n.clusteringServiceName, ServiceAdministrator.State.PAUSED);
        }

        @Override
        protected void doStart(ServiceAdministrator.State fromState) {
            super.doStart(fromState);
            ClusteringService.this.startService();
        }

        @Override
        protected void doShutdown(ServiceAdministrator.State fromState) {
            super.doShutdown(fromState);
            ClusteringService.this.shutdownService();
        }

        @Override
        protected boolean doCheckIsTerminated() {
            return ClusteringService.this.isServiceTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            return true;
        }
    }
}

