/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;

public class ScoreQuery
extends Query {
    private static final long serialVersionUID = 1L;
    protected final Query operand;

    public ScoreQuery(Query operand) {
        this.operand = operand;
    }

    @Override
    public Weight createWeight(Searcher searcher) {
        return new NotWeight(searcher);
    }

    @Override
    public Object clone() {
        return new ScoreQuery(this.operand);
    }

    @Override
    public String toString(String field) {
        return "NOT(" + this.operand.toString(field) + ")";
    }

    protected static class NotScorer
    extends Scorer {
        private int docId = -1;
        private int nextScoredDocId = -1;
        private final Scorer operandScorer;
        private final IndexReader reader;
        private final int pastMaxDocId;

        protected NotScorer(Scorer operandScorer, IndexReader reader, Weight weight) {
            super(weight);
            this.operandScorer = operandScorer;
            this.reader = reader;
            assert (this.operandScorer != null);
            assert (this.reader != null);
            this.pastMaxDocId = this.reader.maxDoc();
        }

        @Override
        public int docID() {
            return this.docId;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.nextScoredDocId == -1) {
                this.nextScoredDocId = this.operandScorer.nextDoc();
            }
            while (true) {
                ++this.docId;
                if (this.docId == this.pastMaxDocId) {
                    return Integer.MAX_VALUE;
                }
                if (this.docId == this.nextScoredDocId) {
                    this.nextScoredDocId = this.operandScorer.nextDoc();
                    continue;
                }
                if (!this.reader.isDeleted(this.docId)) break;
            }
            return this.docId;
        }

        @Override
        public int advance(int target) throws IOException {
            int doc;
            if (target == Integer.MAX_VALUE) {
                return target;
            }
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        @Override
        public float score() {
            return 1.0f;
        }
    }

    protected class NotWeight
    extends Weight {
        private static final long serialVersionUID = 1L;
        private final Searcher searcher;

        protected NotWeight(Searcher searcher) {
            this.searcher = searcher;
            assert (this.searcher != null);
        }

        @Override
        public Query getQuery() {
            return ScoreQuery.this;
        }

        @Override
        public float getValue() {
            return 1.0f;
        }

        @Override
        public float sumOfSquaredWeights() {
            return 1.0f;
        }

        @Override
        public void normalize(float norm) {
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer operandScorer = ScoreQuery.this.operand.weight(this.searcher).scorer(reader, scoreDocsInOrder, topScorer);
            return new NotScorer(operandScorer, reader, this);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation operandExplanation = ScoreQuery.this.operand.weight(this.searcher).explain(reader, doc);
            String desc = operandExplanation.getDescription();
            return new Explanation(this.getValue(), "NOT(" + desc + ")");
        }
    }
}

