/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.collection.Problem;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrConfigurationException;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.JcrQueryManagerTest;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.repository.ModeShapeConfiguration;

public class JcrEngineTest {
    private JcrConfiguration configuration;
    private JcrEngine engine;
    private JcrRepository repository;
    private Session session;

    protected static URL resourceUrl(String name) {
        return JcrQueryManagerTest.class.getClassLoader().getResource(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() {
        this.configuration = null;
        try {
            if (this.session != null) {
                this.session.logout();
            }
            Object var2_1 = null;
            this.session = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.session = null;
            try {
                if (this.engine != null) {
                    this.engine.shutdown();
                }
                Object var4_5 = null;
                this.engine = null;
            }
            catch (Throwable throwable2) {
                Object var4_6 = null;
                this.engine = null;
                throw throwable2;
            }
            throw throwable;
        }
        try {
            if (this.engine != null) {
                this.engine.shutdown();
            }
            Object var4_3 = null;
            this.engine = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.engine = null;
            throw throwable;
        }
    }

    @Test
    public void shouldCreateRepositoryEngineFromConfigurationFileWithDefaultNamespace() throws Exception {
        this.configuration = new JcrConfiguration().loadFrom("src/test/resources/config/configRepositoryWithDefaultNamespace.xml");
        this.engine = this.configuration.build();
        this.engine.start();
        this.repository = this.engine.getRepository("mode:Car Repository");
        this.session = this.repository.login();
    }

    @Test
    public void shouldCreateRepositoryConfiguredWithOneCompactNodeTypeDefinitionFile() throws Exception {
        this.configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content");
        this.configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrEngineTest.resourceUrl("cars.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.engine = this.configuration.build();
        this.engine.start();
        this.repository = this.engine.getRepository("cars");
        this.session = this.repository.login();
        this.assertNodeType("car:Car", false, false, true, false, null, 0, 12, "nt:unstructured", "mix:created");
    }

    @Test(expected=JcrConfigurationException.class)
    public void shouldFailToStartIfAnyRepositorySourceDoesNotDefineClass() throws Exception {
        this.configuration = new JcrConfiguration();
        this.configuration.repositorySource("car-source").setDescription("The automobile content");
        this.configuration.repository("cars").setSource("car-source-non-existant").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrEngineTest.resourceUrl("cars.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.engine = this.configuration.build();
        this.engine.start();
    }

    @Test(expected=JcrConfigurationException.class)
    public void shouldFailToStartIfAnyRepositoryReferencesNonExistantSource() throws Exception {
        this.configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content");
        this.configuration.repository("cars").setSource("car-source-non-existant").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrEngineTest.resourceUrl("cars.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.engine = this.configuration.build();
        this.engine.start();
    }

    @Test
    public void shouldCreateRepositoryEngineFromConfigurationFileWithInitialContentInFileWithRelativePath() throws Exception {
        this.configuration = new JcrConfiguration().loadFrom("src/test/resources/config/configRepositoryWithInitialContent.xml");
        this.engine = this.configuration.build();
        this.engine.start();
        this.repository = this.engine.getRepository("My Repository");
        this.session = this.repository.login();
        Node cars = this.session.getRootNode().getNode("Cars");
        Node prius = this.session.getRootNode().getNode("Cars/Hybrid/Toyota Prius");
        Node g37 = this.session.getRootNode().getNode("Cars/Sports/Infiniti G37");
        Assert.assertThat((Object)cars, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)prius, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)g37, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldCreateRepositoryEngineFromConfigurationFileWithInitialContentInFileOnClasspath() throws Exception {
        this.configuration = new JcrConfiguration().loadFrom("src/test/resources/config/configRepositoryWithInitialContentOnClasspath.xml");
        this.engine = this.configuration.build();
        this.engine.start();
        this.repository = this.engine.getRepository("My Repository");
        this.session = this.repository.login();
        Node cars = this.session.getRootNode().getNode("Cars");
        Node prius = this.session.getRootNode().getNode("Cars/Hybrid/Toyota Prius");
        Node g37 = this.session.getRootNode().getNode("Cars/Sports/Infiniti G37");
        Assert.assertThat((Object)cars, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)prius, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)g37, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    protected void assertNodeType(String name, boolean isAbstract, boolean isMixin, boolean isQueryable, boolean hasOrderableChildNodes, String primaryItemName, int numberOfDeclaredChildNodeDefinitions, int numberOfDeclaredPropertyDefinitions, String ... supertypes) throws Exception {
        NodeType nodeType = this.session.getWorkspace().getNodeTypeManager().getNodeType(name);
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isAbstract(), (Matcher)Is.is((Object)isAbstract));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)isMixin));
        Assert.assertThat((Object)nodeType.isQueryable(), (Matcher)Is.is((Object)isQueryable));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)hasOrderableChildNodes));
        Assert.assertThat((Object)nodeType.getPrimaryItemName(), (Matcher)Is.is((Object)primaryItemName));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)supertypes.length));
        for (int i = 0; i != supertypes.length; ++i) {
            Assert.assertThat((Object)nodeType.getDeclaredSupertypes()[i].getName(), (Matcher)Is.is((Object)supertypes[i]));
        }
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)numberOfDeclaredChildNodeDefinitions));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)numberOfDeclaredPropertyDefinitions));
    }

    @Test
    public void shouldAllowCreatingWorkspaces() throws Exception {
        this.configuration = new JcrConfiguration().loadFrom("src/test/resources/config/configRepositoryWithDefaultNamespace.xml");
        this.engine = this.configuration.build();
        this.engine.start();
        this.repository = this.engine.getRepository("mode:Car Repository");
        String workspaceName = "MyNewWorkspace";
        Session jcrSession = this.repository.login();
        Workspace defaultWorkspace = jcrSession.getWorkspace();
        defaultWorkspace.createWorkspace(workspaceName);
        this.assertAccessibleWorkspace(defaultWorkspace, workspaceName);
        jcrSession.logout();
    }

    @Test
    @FixFor(value={"MODE-1180"})
    public void shouldCreateRepositoriesUponStartup() throws Exception {
        this.configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content")).setProperty("defaultWorkspaceName", "default");
        this.configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrEngineTest.resourceUrl("cars.cnd")).setInitialContent("src/test/resources/initialWorkspaceContent.xml", "default", new String[0]).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("product-source").usingClass(InMemoryRepositorySource.class)).setDescription("The products content")).setProperty("defaultWorkspaceName", "default");
        this.configuration.repository("products").setSource("product-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrEngineTest.resourceUrl("cars.cnd")).setInitialContent("src/test/resources/initialWorkspaceContent.xml", "default", new String[0]).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.engine = this.configuration.build();
        Assert.assertThat((Object)this.engine.getProblems().hasErrors(), (Matcher)Is.is((Object)false));
        this.engine.start(true, 1L, TimeUnit.NANOSECONDS);
        this.repository = this.engine.getRepository("products");
        this.repository = this.engine.getRepository("cars");
        this.session = this.repository.login();
        this.assertNodeType("car:Car", false, false, true, false, null, 0, 12, "nt:unstructured", "mix:created");
        Assert.assertThat((Object)this.session.getRootNode().hasNode("Cars"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.session.getNode("/Cars"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    @FixFor(value={"MODE-1119"})
    public void shouldCreateRepositoryConfiguredWithNoInitialContent() throws Exception {
        this.configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content")).setProperty("defaultWorkspaceName", "default");
        this.configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrEngineTest.resourceUrl("cars.cnd")).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.engine = this.configuration.build();
        Assert.assertThat((Object)this.engine.getProblems().hasErrors(), (Matcher)Is.is((Object)false));
        this.engine.start();
        this.repository = this.engine.getRepository("cars");
        this.session = this.repository.login();
        this.assertNodeType("car:Car", false, false, true, false, null, 0, 12, "nt:unstructured", "mix:created");
        Assert.assertThat((Object)this.session.getRootNode().hasNode("Cars"), (Matcher)Is.is((Object)false));
    }

    @Test
    @FixFor(value={"MODE-1119"})
    public void shouldCreateRepositoryConfiguredWithCorrectInitialContentPath() throws Exception {
        this.configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content")).setProperty("defaultWorkspaceName", "default");
        this.configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrEngineTest.resourceUrl("cars.cnd")).setInitialContent("src/test/resources/initialWorkspaceContent.xml", "default", new String[0]).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.engine = this.configuration.build();
        Assert.assertThat((Object)this.engine.getProblems().hasErrors(), (Matcher)Is.is((Object)false));
        this.engine.start();
        this.repository = this.engine.getRepository("cars");
        this.session = this.repository.login();
        this.assertNodeType("car:Car", false, false, true, false, null, 0, 12, "nt:unstructured", "mix:created");
        Assert.assertThat((Object)this.session.getRootNode().hasNode("Cars"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.session.getNode("/Cars"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test(expected=RepositoryException.class)
    @FixFor(value={"MODE-1119"})
    public void shouldCreateRepositoryConfiguredWithValidInitialContentPathButEmptyFile() throws Exception {
        this.configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content")).setProperty("defaultWorkspaceName", "default");
        this.configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrEngineTest.resourceUrl("cars.cnd")).setInitialContent("src/test/resources/emptyFile.xml", "default", new String[0]).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.engine = this.configuration.build();
        Assert.assertThat((Object)this.engine.getProblems().hasErrors(), (Matcher)Is.is((Object)false));
        this.engine.start();
        this.repository = this.engine.getRepository("cars");
    }

    @Test(expected=RepositoryException.class)
    @FixFor(value={"MODE-1119"})
    public void shouldCreateRepositoryConfiguredWithIncorrectInitialContentPath() throws Exception {
        this.configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content")).setProperty("defaultWorkspaceName", "default");
        this.configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrEngineTest.resourceUrl("cars.cnd")).setInitialContent("src/test/resources/blah/blah/blah", "default", new String[0]).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.engine = this.configuration.build();
        Assert.assertThat((Object)this.engine.getProblems().hasErrors(), (Matcher)Is.is((Object)false));
        this.engine.start();
        this.repository = this.engine.getRepository("cars");
    }

    @Test
    @FixFor(value={"MODE-1119"})
    public void shouldRecordProblemWhenStartingRepositoriesConfiguredWithValidInitialContentPathButEmptyFile() throws Exception {
        this.configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content")).setProperty("defaultWorkspaceName", "default");
        this.configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrEngineTest.resourceUrl("cars.cnd")).setInitialContent("src/test/resources/emptyFile.xml", "default", new String[0]).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.engine = this.configuration.build();
        Assert.assertThat((Object)this.engine.getProblems().hasErrors(), (Matcher)Is.is((Object)false));
        this.engine.start(true);
        Assert.assertThat((Object)this.engine.getProblems().hasErrors(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.engine.getProblems().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((Problem)this.engine.getProblems().iterator().next()).getStatus(), (Matcher)Is.is((Object)Problem.Status.ERROR));
    }

    @Test(expected=RepositoryException.class)
    @FixFor(value={"MODE-1119"})
    public void shouldRecordProblemWhenStartingRepositoriesConfiguredWithValidInitialContentPathButEmptyFileAndFailWhenGettingRepository() throws Exception {
        this.configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content")).setProperty("defaultWorkspaceName", "default");
        this.configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrEngineTest.resourceUrl("cars.cnd")).setInitialContent("src/test/resources/emptyFile.xml", "default", new String[0]).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.engine = this.configuration.build();
        Assert.assertThat((Object)this.engine.getProblems().hasErrors(), (Matcher)Is.is((Object)false));
        this.engine.start(true);
        Assert.assertThat((Object)this.engine.getProblems().hasErrors(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.engine.getProblems().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((Problem)this.engine.getProblems().iterator().next()).getStatus(), (Matcher)Is.is((Object)Problem.Status.ERROR));
        this.engine.getRepository("cars");
    }

    @Test
    @FixFor(value={"MODE-1119"})
    public void shouldRecordProblemWhenStartingRepositoriesConfiguredWithIncorrectInitialContentPath() throws Exception {
        this.configuration = new JcrConfiguration();
        ((ModeShapeConfiguration.RepositorySourceDefinition)((ModeShapeConfiguration.RepositorySourceDefinition)this.configuration.repositorySource("car-source").usingClass(InMemoryRepositorySource.class)).setDescription("The automobile content")).setProperty("defaultWorkspaceName", "default");
        this.configuration.repository("cars").setSource("car-source").registerNamespace("car", "http://www.modeshape.org/examples/cars/1.0").addNodeTypes(JcrEngineTest.resourceUrl("cars.cnd")).setInitialContent("src/test/resources/blah/blah/blah", "default", new String[0]).setOption(JcrRepository.Option.ANONYMOUS_USER_ROLES, "admin");
        this.engine = this.configuration.build();
        Assert.assertThat((Object)this.engine.getProblems().hasErrors(), (Matcher)Is.is((Object)false));
        this.engine.start(true);
        Assert.assertThat((Object)this.engine.getProblems().hasErrors(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.engine.getProblems().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((Problem)this.engine.getProblems().iterator().next()).getStatus(), (Matcher)Is.is((Object)Problem.Status.ERROR));
    }

    protected void assertAccessibleWorkspace(Session session, String workspaceName) throws Exception {
        this.assertAccessibleWorkspace(session.getWorkspace(), workspaceName);
    }

    protected void assertAccessibleWorkspace(Workspace workspace, String workspaceName) throws Exception {
        this.assertContains(workspace.getAccessibleWorkspaceNames(), workspaceName);
    }

    protected void assertContains(String[] actuals, String ... expected) {
        for (String expect : expected) {
            if (expect == null) continue;
            boolean found = false;
            for (String actual : actuals) {
                if (!expect.equals(actual)) continue;
                found = true;
                break;
            }
            Assert.assertThat((String)("Did not find '" + expect + "' in the actuals: " + actuals), (Object)found, (Matcher)Is.is((Object)true));
        }
    }
}

