/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.api.RepositoryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrRepositoryFactoryTest {
    private String url;
    private Map<String, String> params;
    private Repository repository;

    @Test
    public void shouldReturnRepositoryFromConfigurationFile() {
        this.url = "file:src/test/resources/tck/default/configRepository.xml?repositoryName=Test Repository Source";
        this.params = Collections.singletonMap("org.modeshape.jcr.URL", this.url);
        this.repository = this.repositoryFor(this.params);
        Assert.assertThat((Object)this.repository, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void shouldReturnRepositoryFromConfigurationClasspathResource() {
        this.url = "file:///tck/default/configRepository.xml?repositoryName=Test Repository Source";
        this.params = Collections.singletonMap("org.modeshape.jcr.URL", this.url);
        this.repository = this.repositoryFor(this.params);
        Assert.assertThat((Object)this.repository, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void shouldReturnSameRepositoryFromSameConfigurationFile() {
        this.url = "file:src/test/resources/tck/default/configRepository.xml?repositoryName=Test Repository Source";
        this.params = Collections.singletonMap("org.modeshape.jcr.URL", this.url);
        this.repository = this.repositoryFor(this.params);
        Assert.assertThat((Object)this.repository, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Repository repository2 = this.repositoryFor(this.params);
        Assert.assertThat((Object)repository2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.repository, (Matcher)CoreMatchers.is((Object)repository2));
    }

    @Test
    public void shouldNotReturnRepositoryForInvalidUrl() {
        this.url = "file:?Test Repository Source";
        Assert.assertThat((Object)this.repositoryFor(Collections.singletonMap("org.modeshape.jcr.URL", this.url)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.url = "file:src/test/resources/tck/default/nonExistentFile";
        Assert.assertThat((Object)this.repositoryFor(Collections.singletonMap("org.modeshape.jcr.URL", this.url)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        this.url = "file:src/test/resources/tck/default/nonExistentFile";
        Assert.assertThat((Object)this.repositoryFor(Collections.singletonMap("org.modeshape.jcr.URL", this.url)), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldReturnRepositoryWithoutNameIfOnlyOneRepositoryInEngine() {
        this.url = "file:src/test/resources/tck/default/configRepository.xml";
        this.params = Collections.singletonMap("org.modeshape.jcr.URL", this.url);
        this.repository = this.repositoryFor(this.params);
        Assert.assertThat((Object)this.repository, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    protected Repository repositoryFor(Map<String, String> parameters) {
        for (RepositoryFactory factory : ServiceLoader.load(RepositoryFactory.class)) {
            try {
                Repository repository = factory.getRepository(parameters);
                if (repository == null) continue;
                return repository;
            }
            catch (RepositoryException re) {
                throw new IllegalStateException(re);
            }
        }
        return null;
    }
}

