/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.TokenStream;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.Join;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.NamedSelector;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.Not;
import org.modeshape.graph.query.model.Or;
import org.modeshape.graph.query.model.Order;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.Query;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.SameNodeJoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Source;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.parse.SqlQueryParser;
import org.modeshape.jcr.query.JcrSqlQueryParser;

public class JcrSqlQueryParserTest {
    private TypeSystem typeSystem;
    private JcrSqlQueryParser parser;
    private Query query;

    @Before
    public void beforeEach() {
        this.typeSystem = new ExecutionContext().getValueFactories().getTypeSystem();
        this.parser = new JcrSqlQueryParser();
    }

    @Test
    public void shouldParseNominalQueries() {
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNameArchived1' AND jcr:path LIKE '/drools:repository/drools:package_area/%' AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNameArchived1' AND jcr:path LIKE '/drools:repository/drools:package_area/%'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNameArchived2' AND jcr:path LIKE '/drools:repository/drools:package_area/%' AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNameArchived%' AND jcr:path LIKE '/drools:repository/drools:package_area/%' AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNameArchived2' AND jcr:path LIKE '/drools:repository/drools:package_area/%' AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNameArchived1' AND jcr:path LIKE '/drools:repository/drools:package_area/%'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNameArchived1' AND jcr:path LIKE '/drools:repository/drools:package_area/%' AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNameArchived%' AND jcr:path LIKE '/drools:repository/drools:package_area/%' AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNameArchived%' AND jcr:path LIKE '/drools:repository/drools:package_area/%'");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/testRestPost/assets[%]/%' and  ( drools:format='drl' OR drools:format='xls' )  AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/testRestDelete/assets[%]/%' and drools:format='drl' AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/testRestDelete/assets[%]/%' and drools:archive = 'true' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/testRestDelete/assets[%]/%' and drools:format='drl' AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/testPackageSnapshot/assets[%]/%' and drools:format='drl' AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/testPackageSnapshot/assets[%]/%' and drools:format='drl' AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:packagesnapshot_area/testPackageSnapshot/PROD 2.0/assets[%]/%' and drools:format='drl' AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/searchByFormat/assets[%]/%' and drools:format='xyz' AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/searchByFormat/assets[%]/%' and drools:format='xyz' AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/searchByFormat/assets[%]/%' and  ( drools:format='xyz' OR drools:format='ABC' )  AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/globalArea/assets[%]/%' and drools:format='testSearchSharedAssetByFormat' AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/org.drools.archivedtest/assets[%]/%' and drools:archive = 'true' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/org.drools.archivedtest/assets[%]/%' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/testExcludeAssetTypes/assets[%]/%' and not drools:format='drl' AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/testExcludeAssetTypes/assets[%]/%' and not ( drools:format='drl' OR drools:format='wang' )  AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/testExcludeAssetTypes/assets[%]/%' and not ( drools:format='drl' OR drools:format='xls' )  AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNamex1' AND jcr:path LIKE '/drools:repository/drools:package_area/%' AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNamex2' AND jcr:path LIKE '/drools:repository/drools:package_area/%' AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNamex%' AND jcr:path LIKE '/drools:repository/drools:package_area/%' AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNamex2' AND jcr:path LIKE '/drools:repository/drools:package_area/%' AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE drools:title LIKE 'findRulesByNamex%' AND jcr:path LIKE '/drools:repository/drools:package_area/%' AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/%' AND drools:subject LIKE 'testQueryXXX42' AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/%' AND drools:subject LIKE 'testQueryXXX42' AND drools:source LIKE 'database'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/%' AND (drools:subject LIKE 'testQueryXXX42' OR drools:subject LIKE 'wankle') AND (drools:source LIKE 'database' OR drools:source LIKE 'wankle') AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/%' AND (drools:source LIKE 'database' OR drools:source LIKE 'wankle') AND drools:archive = 'false'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/%' AND (drools:subject LIKE 'testQueryXXX42' OR drools:subject LIKE 'wankle') AND (drools:source LIKE 'database' OR drools:source LIKE 'wankle') AND drools:archive = 'false' AND jcr:created > TIMESTAMP '1974-07-10T00:00:00.000-05:00' AND jcr:created < TIMESTAMP '3074-07-10T00:00:00.000-05:00'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/%' AND (drools:subject LIKE 'testQueryXXX42' OR drools:subject LIKE 'wankle') AND (drools:source LIKE 'database' OR drools:source LIKE 'wankle') AND drools:archive = 'false' AND jcr:created > TIMESTAMP '1974-07-10T00:00:00.000-05:00'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/%' AND (drools:subject LIKE 'testQueryXXX42' OR drools:subject LIKE 'wankle') AND (drools:source LIKE 'database' OR drools:source LIKE 'wankle') AND drools:archive = 'false' AND jcr:created < TIMESTAMP '3074-07-10T00:00:00.000-05:00'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/%' AND (drools:subject LIKE 'testQueryXXX42' OR drools:subject LIKE 'wankle') AND (drools:source LIKE 'database' OR drools:source LIKE 'wankle') AND drools:archive = 'false' AND jcr:created > TIMESTAMP '3074-07-10T00:00:00.000-05:00'");
        this.parse("SELECT drools:title, drools:description, drools:archive FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/%' AND (drools:subject LIKE 'testQueryXXX42' OR drools:subject LIKE 'wankle') AND (drools:source LIKE 'database' OR drools:source LIKE 'wankle') AND drools:archive = 'false' AND jcr:created < TIMESTAMP '1974-07-10T00:00:00.000-05:00'");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/globalArea/assets[%]/%' and drools:format='xyz' AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("SELECT * FROM drools:assetNodeType WHERE jcr:path LIKE '/drools:repository/drools:package_area/globalArea/assets[%]/%' and drools:format='xyz' AND drools:archive = 'false' ORDER BY drools:title");
        this.parse("select * from mgnl:content where jcr:path like '/modules/%/templates'");
    }

    @Test
    public void shouldParseQueriesUsedInJcrTckTests() {
        this.parse("SELECT * FROM nt:unstructured, mix:referenceable WHERE nt:unstructured.jcr:path = mix:referenceable.jcr:path AND jcr:path LIKE '/testroot/%'");
        this.parse("SELECT * FROM nt:unstructured, nt:base WHERE nt:unstructured.jcr:path = nt:base.jcr:path AND jcr:path LIKE '/testroot/%'");
        this.parse("SELECT * FROM nt:base, mix:referenceable WHERE nt:base.jcr:path = mix:referenceable.jcr:path AND jcr:path LIKE '/testroot/%'");
        this.parse("SELECT * FROM nt:unstructured, mix:referenceable WHERE nt:unstructured.jcr:path = mix:referenceable.jcr:path AND jcr:path LIKE '/testroot/%'");
        this.parse("SELECT prop1 FROM nt:unstructured WHERE 'two' IN prop2 AND 'existence' IN prop1 AND jcr:path LIKE '/testroot/%'");
    }

    @Test
    public void shouldParseSelectStarFromSingleSourceWithWhereContainingPathLikeConstraint() {
        this.query = this.parse("SELECT * FROM mgnl:content WHERE jcr:path LIKE '/modules/%/templates'");
        Assert.assertThat((Object)this.query.source(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(NamedSelector.class)));
        Assert.assertThat((Object)this.query.columns().isEmpty(), (Matcher)Is.is((Object)true));
        NamedSelector selector = (NamedSelector)this.query.source();
        Assert.assertThat((Object)selector.name(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)selector.aliasOrName(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)selector.alias(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Comparison comparison = this.isComparison(this.query.constraint());
        Assert.assertThat((Object)comparison.operand1(), (Matcher)Is.is((Object)this.nodePath(this.selectorName("mgnl:content"))));
        Assert.assertThat((Object)comparison.operand2(), (Matcher)Is.is((Object)this.literal("/modules/%/templates")));
    }

    @Test
    public void shouldParseSelectStarFromSingleSourceWithWhereContainingTwoPathLikeConstraints() {
        this.query = this.parse("SELECT * FROM mgnl:content WHERE jcr:path LIKE '/modules/%/templates' or jcr:path like '/modules/%/other'");
        Assert.assertThat((Object)this.query.source(), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(NamedSelector.class)));
        Assert.assertThat((Object)this.query.columns().isEmpty(), (Matcher)Is.is((Object)true));
        NamedSelector selector = (NamedSelector)this.query.source();
        Assert.assertThat((Object)selector.name(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)selector.aliasOrName(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)selector.alias(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Or and = this.isOr(this.query.constraint());
        Comparison comparison1 = this.isComparison(and.left());
        Assert.assertThat((Object)comparison1.operand1(), (Matcher)Is.is((Object)this.nodePath(this.selectorName("mgnl:content"))));
        Assert.assertThat((Object)comparison1.operand2(), (Matcher)Is.is((Object)this.literal("/modules/%/templates")));
        Comparison comparison2 = this.isComparison(and.right());
        Assert.assertThat((Object)comparison2.operand1(), (Matcher)Is.is((Object)this.nodePath(this.selectorName("mgnl:content"))));
        Assert.assertThat((Object)comparison2.operand2(), (Matcher)Is.is((Object)this.literal("/modules/%/other")));
    }

    @Test
    public void shouldParseSelectStarFromTwoJoinedSourcesWithWhereContainingJoinCriteria() {
        this.query = this.parse("SELECT * FROM mgnl:content, acme:stuff WHERE mgnl:content.jcr:path = acme:stuff.jcr:path");
        Assert.assertThat((Object)this.query.columns().isEmpty(), (Matcher)Is.is((Object)true));
        Join join = this.isJoin(this.query.source());
        Assert.assertThat((Object)join.left(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("mgnl:content"))));
        Assert.assertThat((Object)join.right(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("acme:stuff"))));
        Assert.assertThat((Object)join.type(), (Matcher)Is.is((Object)JoinType.INNER));
        SameNodeJoinCondition joinCondition = this.isSameNodeJoinCondition(join.joinCondition());
        Assert.assertThat((Object)joinCondition.selector1Name(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)joinCondition.selector2Name(), (Matcher)Is.is((Object)this.selectorName("acme:stuff")));
        Assert.assertThat((Object)joinCondition.selector2Path(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.query.constraint(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseSelectStarFromThreeJoinedSourcesWithWhereContainingJoinCriteria() {
        this.query = this.parse("SELECT * FROM mgnl:content, acme:stuff, foo:bar WHERE mgnl:content.jcr:path = acme:stuff.jcr:path AND mgnl:content.jcr:path = foo:bar.jcr:path");
        Assert.assertThat((Object)this.query.columns().isEmpty(), (Matcher)Is.is((Object)true));
        Join join = this.isJoin(this.query.source());
        Join join2 = this.isJoin(join.left());
        Assert.assertThat((Object)join2.left(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("mgnl:content"))));
        Assert.assertThat((Object)join2.right(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("acme:stuff"))));
        Assert.assertThat((Object)join2.type(), (Matcher)Is.is((Object)JoinType.INNER));
        SameNodeJoinCondition joinCondition2 = this.isSameNodeJoinCondition(join2.joinCondition());
        Assert.assertThat((Object)joinCondition2.selector1Name(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)joinCondition2.selector2Name(), (Matcher)Is.is((Object)this.selectorName("acme:stuff")));
        Assert.assertThat((Object)joinCondition2.selector2Path(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)join.right(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("foo:bar"))));
        Assert.assertThat((Object)join.type(), (Matcher)Is.is((Object)JoinType.INNER));
        SameNodeJoinCondition joinCondition = this.isSameNodeJoinCondition(join.joinCondition());
        Assert.assertThat((Object)joinCondition.selector1Name(), (Matcher)Is.is((Object)this.selectorName("mgnl:content")));
        Assert.assertThat((Object)joinCondition.selector2Name(), (Matcher)Is.is((Object)this.selectorName("foo:bar")));
        Assert.assertThat((Object)joinCondition.selector2Path(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.query.constraint(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldParseSelectStarFromEquijoinAndAdditionalCriteria() {
        this.query = this.parse("SELECT * FROM modetest:queryable, mix:referenceable WHERE modetest:queryable.jcr:path = mix:referenceable.jcr:path AND jcr:path LIKE '/testroot/someQueryableNodeD/%'");
        Assert.assertThat((Object)this.query.columns().isEmpty(), (Matcher)Is.is((Object)true));
        Join join = this.isJoin(this.query.source());
        Assert.assertThat((Object)join.left(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("modetest:queryable"))));
        Assert.assertThat((Object)join.right(), (Matcher)Is.is((Object)this.namedSelector(this.selectorName("mix:referenceable"))));
        Assert.assertThat((Object)join.type(), (Matcher)Is.is((Object)JoinType.INNER));
        SameNodeJoinCondition joinCondition = this.isSameNodeJoinCondition(join.joinCondition());
        Assert.assertThat((Object)joinCondition.selector1Name(), (Matcher)Is.is((Object)this.selectorName("modetest:queryable")));
        Assert.assertThat((Object)joinCondition.selector2Name(), (Matcher)Is.is((Object)this.selectorName("mix:referenceable")));
        Assert.assertThat((Object)joinCondition.selector2Path(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Comparison comparison = this.isComparison(this.query.constraint());
        Assert.assertThat((Object)comparison.operand1(), (Matcher)Is.is((Object)this.nodePath(this.selectorName("modetest:queryable"))));
        Assert.assertThat((Object)comparison.operand2(), (Matcher)Is.is((Object)this.literal("/testroot/someQueryableNodeD/%")));
    }

    @Test
    public void shouldParseSelectWithOrderByClause() {
        this.query = this.parse("SELECT car:model FROM car:Car WHERE car:model IS NOT NULL ORDER BY car:model ASC");
        Assert.assertThat((Object)this.query.columns().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((Column)this.query.columns().get(0)).selectorName(), (Matcher)Is.is((Object)this.selectorName("car:Car")));
        Assert.assertThat((Object)((Column)this.query.columns().get(0)).columnName(), (Matcher)Is.is((Object)"car:model"));
        Assert.assertThat((Object)((Column)this.query.columns().get(0)).propertyName(), (Matcher)Is.is((Object)"car:model"));
        NamedSelector selector = (NamedSelector)this.query.source();
        Assert.assertThat((Object)selector.name(), (Matcher)Is.is((Object)this.selectorName("car:Car")));
        Assert.assertThat((Object)selector.aliasOrName(), (Matcher)Is.is((Object)this.selectorName("car:Car")));
        Assert.assertThat((Object)selector.alias(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        PropertyExistence constraint = this.isPropertyExistence(this.query.constraint());
        Assert.assertThat((Object)constraint.propertyName(), (Matcher)Is.is((Object)"car:model"));
        Assert.assertThat((Object)constraint.selectorName(), (Matcher)Is.is((Object)this.selectorName("car:Car")));
        Assert.assertThat((Object)this.query.orderings().size(), (Matcher)Is.is((Object)1));
        Ordering ordering = (Ordering)this.query.orderings().get(0);
        Assert.assertThat((Object)ordering.order(), (Matcher)Is.is((Object)Order.ASCENDING));
        Assert.assertThat((Object)ordering.operand(), (Matcher)Is.is((Object)this.propertyValue(this.selectorName("car:Car"), "car:model")));
    }

    @Test
    public void shouldParseSelectWithChildAxisCriteria() {
        this.query = this.parse("SELECT * FROM nt:base WHERE jcr:path LIKE '/a/b/%' AND NOT jcr:path LIKE '/a/b/%/%'");
        Assert.assertThat((Object)this.query.columns().isEmpty(), (Matcher)Is.is((Object)true));
        NamedSelector selector = (NamedSelector)this.query.source();
        Assert.assertThat((Object)selector.name(), (Matcher)Is.is((Object)this.selectorName("nt:base")));
        Assert.assertThat((Object)selector.aliasOrName(), (Matcher)Is.is((Object)this.selectorName("nt:base")));
        Assert.assertThat((Object)selector.alias(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        And and = this.isAnd(this.query.constraint());
        Comparison comparison1 = this.isComparison(and.left());
        Assert.assertThat((Object)comparison1.operand1(), (Matcher)Is.is((Object)this.nodePath(this.selectorName("nt:base"))));
        Assert.assertThat((Object)comparison1.operand2(), (Matcher)Is.is((Object)this.literal("/a/b/%")));
        Not not = this.isNot(and.right());
        Comparison comparison2a = this.isComparison(not.constraint());
        Assert.assertThat((Object)comparison2a.operand1(), (Matcher)Is.is((Object)this.nodePath(this.selectorName("nt:base"))));
        Assert.assertThat((Object)comparison2a.operand2(), (Matcher)Is.is((Object)this.literal("/a/b/%/%")));
    }

    protected Join isJoin(Source source) {
        Assert.assertThat((Object)source, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Join.class)));
        return (Join)source;
    }

    protected PropertyExistence isPropertyExistence(Constraint constraint) {
        Assert.assertThat((Object)constraint, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(PropertyExistence.class)));
        return (PropertyExistence)constraint;
    }

    protected Not isNot(Constraint constraint) {
        Assert.assertThat((Object)constraint, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Not.class)));
        return (Not)constraint;
    }

    protected Comparison isComparison(Constraint constraint) {
        Assert.assertThat((Object)constraint, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Comparison.class)));
        return (Comparison)constraint;
    }

    protected SameNodeJoinCondition isSameNodeJoinCondition(JoinCondition condition) {
        Assert.assertThat((Object)condition, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(SameNodeJoinCondition.class)));
        return (SameNodeJoinCondition)condition;
    }

    protected And isAnd(Constraint constraint) {
        Assert.assertThat((Object)constraint, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(And.class)));
        return (And)constraint;
    }

    protected Or isOr(Constraint constraint) {
        Assert.assertThat((Object)constraint, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Or.class)));
        return (Or)constraint;
    }

    protected NodePath nodePath(SelectorName name) {
        return new NodePath(name);
    }

    protected PropertyValue propertyValue(SelectorName selectorName, String propertyName) {
        return new PropertyValue(selectorName, propertyName);
    }

    protected Literal literal(Object value) {
        return new Literal(value);
    }

    protected NamedSelector namedSelector(SelectorName selectorName) {
        return new NamedSelector(selectorName);
    }

    protected NamedSelector namedSelector(SelectorName selectorName, SelectorName alias) {
        return new NamedSelector(selectorName, alias);
    }

    @Test
    public void shouldParseNonPrefixedNameFromUnquotedString() {
        Assert.assertThat((Object)this.parser.parseName(this.tokens("name"), this.typeSystem), (Matcher)Is.is((Object)"name"));
    }

    @Test
    public void shouldParsePrefixedNameFromUnquotedString() {
        Assert.assertThat((Object)this.parser.parseName(this.tokens("jcr:name"), this.typeSystem), (Matcher)Is.is((Object)"jcr:name"));
    }

    @Test
    public void shouldParseNameFromSingleQuotedString() {
        Assert.assertThat((Object)this.parser.parseName(this.tokens("'jcr:name'"), this.typeSystem), (Matcher)Is.is((Object)"jcr:name"));
    }

    @Test
    public void shouldParseNameFromUnquotedStringWithoutPrefix() {
        Assert.assertThat((Object)this.parser.parseName(this.tokens("name"), this.typeSystem), (Matcher)Is.is((Object)"name"));
    }

    @Test
    public void shouldParseNameFromSingleQuotedStringWithoutPrefix() {
        Assert.assertThat((Object)this.parser.parseName(this.tokens("'name'"), this.typeSystem), (Matcher)Is.is((Object)"name"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNameIfNoMoreTokens() {
        this.parser.parseName(this.tokens("  "), this.typeSystem);
    }

    @Test
    public void shouldRemoveBracketsAndQuotes() {
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("string", null), (Matcher)Is.is((Object)"string"));
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("'string'", null), (Matcher)Is.is((Object)"string"));
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("word one and two", null), (Matcher)Is.is((Object)"word one and two"));
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("'word one and two'", null), (Matcher)Is.is((Object)"word one and two"));
    }

    @Test
    public void shouldFailToRemoveDoubleQuotesAroundOneWord() {
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("\"string\"", null), (Matcher)Is.is((Object)"\"string\""));
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("\"string\"", null), (Matcher)Is.is((Object)"\"string\""));
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("\"word one and two\"", null), (Matcher)Is.is((Object)"\"word one and two\""));
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("[word one and two]", null), (Matcher)Is.is((Object)"[word one and two]"));
    }

    protected Query parse(String query) {
        QueryCommand command = this.parseCommand(query);
        Assert.assertThat((Object)command, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(Query.class)));
        return (Query)command;
    }

    protected QueryCommand parseCommand(String query) {
        return this.parser.parseQuery(query, this.typeSystem);
    }

    protected SelectorName selectorName(String name) {
        return new SelectorName(name);
    }

    protected Name name(String name) {
        return (Name)this.typeSystem.getTypeFactory(PropertyType.NAME.getName()).create(name);
    }

    protected Path path(String path) {
        return (Path)this.typeSystem.getTypeFactory(PropertyType.PATH.getName()).create(path);
    }

    protected TokenStream tokens(String content) {
        return new TokenStream(content, (TokenStream.Tokenizer)new SqlQueryParser.SqlTokenizer(false), false).start();
    }
}

