/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.nl;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import org.apache.lucene.analysis.nl.DutchStemFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.ext.DutchStemmer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DutchAnalyzer
extends ReusableAnalyzerBase {
    @Deprecated
    public static final String[] DUTCH_STOP_WORDS = DutchAnalyzer.getDefaultStopSet().toArray(new String[0]);
    public static final String DEFAULT_STOPWORD_FILE = "dutch_stop.txt";
    private final Set<?> stoptable;
    private Set<?> excltable = Collections.emptySet();
    private Map<String, String> stemdict = new HashMap<String, String>();
    private final Version matchVersion;

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public DutchAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
        this.stemdict.put("fiets", "fiets");
        this.stemdict.put("bromfiets", "bromfiets");
        this.stemdict.put("ei", "eier");
        this.stemdict.put("kind", "kinder");
    }

    public DutchAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, CharArraySet.EMPTY_SET);
    }

    public DutchAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclusionTable) {
        this.stoptable = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, stopwords));
        this.excltable = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, stemExclusionTable));
        this.matchVersion = matchVersion;
    }

    @Deprecated
    public DutchAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet(matchVersion, stopwords));
    }

    @Deprecated
    public DutchAnalyzer(Version matchVersion, HashSet<?> stopwords) {
        this(matchVersion, (Set<?>)stopwords);
    }

    @Deprecated
    public DutchAnalyzer(Version matchVersion, File stopwords) {
        try {
            this.stoptable = WordlistLoader.getWordSet(stopwords);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.matchVersion = matchVersion;
    }

    @Deprecated
    public void setStemExclusionTable(String ... exclusionlist) {
        this.excltable = StopFilter.makeStopSet(this.matchVersion, exclusionlist);
        this.setPreviousTokenStream(null);
    }

    @Deprecated
    public void setStemExclusionTable(HashSet<?> exclusionlist) {
        this.excltable = exclusionlist;
        this.setPreviousTokenStream(null);
    }

    @Deprecated
    public void setStemExclusionTable(File exclusionlist) {
        try {
            this.excltable = WordlistLoader.getWordSet(exclusionlist);
            this.setPreviousTokenStream(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setStemDictionary(File stemdictFile) {
        try {
            this.stemdict = WordlistLoader.getStemDict(stemdictFile);
            this.setPreviousTokenStream(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader aReader) {
        if (this.matchVersion.onOrAfter(Version.LUCENE_31)) {
            StandardTokenizer source = new StandardTokenizer(this.matchVersion, aReader);
            TokenFilter result = new StandardFilter(this.matchVersion, source);
            result = new LowerCaseFilter(this.matchVersion, result);
            result = new StopFilter(this.matchVersion, (TokenStream)result, this.stoptable);
            if (!this.excltable.isEmpty()) {
                result = new KeywordMarkerFilter((TokenStream)result, this.excltable);
            }
            if (!this.stemdict.isEmpty()) {
                result = new StemmerOverrideFilter(this.matchVersion, result, this.stemdict);
            }
            result = new SnowballFilter((TokenStream)result, new DutchStemmer());
            return new ReusableAnalyzerBase.TokenStreamComponents(source, result);
        }
        StandardTokenizer source = new StandardTokenizer(this.matchVersion, aReader);
        TokenFilter result = new StandardFilter(this.matchVersion, source);
        result = new StopFilter(this.matchVersion, (TokenStream)result, this.stoptable);
        if (!this.excltable.isEmpty()) {
            result = new KeywordMarkerFilter((TokenStream)result, this.excltable);
        }
        result = new DutchStemFilter((TokenStream)result, this.stemdict);
        return new ReusableAnalyzerBase.TokenStreamComponents(source, result);
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet(SnowballFilter.class, DutchAnalyzer.DEFAULT_STOPWORD_FILE);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

