/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ThreadInterruptedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NRTManager
implements Closeable {
    private final IndexWriter writer;
    private final ExecutorService es;
    private final AtomicLong indexingGen;
    private final AtomicLong searchingGen;
    private final AtomicLong noDeletesSearchingGen;
    private final List<WaitingListener> waitingListeners = new CopyOnWriteArrayList<WaitingListener>();
    private volatile IndexSearcher currentSearcher;
    private volatile IndexSearcher noDeletesCurrentSearcher;

    public NRTManager(IndexWriter writer) throws IOException {
        this(writer, null);
    }

    public NRTManager(IndexWriter writer, ExecutorService es) throws IOException {
        this.writer = writer;
        this.es = es;
        this.indexingGen = new AtomicLong(1L);
        this.searchingGen = new AtomicLong(-1L);
        this.noDeletesSearchingGen = new AtomicLong(-1L);
        this.swapSearcher(new IndexSearcher(IndexReader.open(writer, true), es), 0L, true);
        writer.getConfig().setMergedSegmentWarmer(new IndexWriter.IndexReaderWarmer(){

            public void warm(IndexReader reader) throws IOException {
                NRTManager.this.warm(reader);
            }
        });
    }

    public void addWaitingListener(WaitingListener l) {
        this.waitingListeners.add(l);
    }

    public void removeWaitingListener(WaitingListener l) {
        this.waitingListeners.remove(l);
    }

    public long updateDocument(Term t, Document d, Analyzer a) throws IOException {
        this.writer.updateDocument(t, d, a);
        return this.indexingGen.get();
    }

    public long updateDocument(Term t, Document d) throws IOException {
        this.writer.updateDocument(t, d);
        return this.indexingGen.get();
    }

    public long updateDocuments(Term t, Collection<Document> docs, Analyzer a) throws IOException {
        this.writer.updateDocuments(t, docs, a);
        return this.indexingGen.get();
    }

    public long updateDocuments(Term t, Collection<Document> docs) throws IOException {
        this.writer.updateDocuments(t, docs);
        return this.indexingGen.get();
    }

    public long deleteDocuments(Term t) throws IOException {
        this.writer.deleteDocuments(t);
        return this.indexingGen.get();
    }

    public long deleteDocuments(Query q) throws IOException {
        this.writer.deleteDocuments(q);
        return this.indexingGen.get();
    }

    public long addDocument(Document d, Analyzer a) throws IOException {
        this.writer.addDocument(d, a);
        return this.indexingGen.get();
    }

    public long addDocuments(Collection<Document> docs, Analyzer a) throws IOException {
        this.writer.addDocuments(docs, a);
        return this.indexingGen.get();
    }

    public long addDocument(Document d) throws IOException {
        this.writer.addDocument(d);
        return this.indexingGen.get();
    }

    public long addDocuments(Collection<Document> docs) throws IOException {
        this.writer.addDocuments(docs);
        return this.indexingGen.get();
    }

    public synchronized IndexSearcher get() {
        return this.get(true);
    }

    public synchronized IndexSearcher get(boolean requireDeletes) {
        IndexSearcher s = requireDeletes ? this.currentSearcher : (this.noDeletesSearchingGen.get() > this.searchingGen.get() ? this.noDeletesCurrentSearcher : this.currentSearcher);
        s.getIndexReader().incRef();
        return s;
    }

    public synchronized IndexSearcher get(long targetGen) {
        return this.get(targetGen, true);
    }

    public synchronized IndexSearcher get(long targetGen, boolean requireDeletes) {
        assert (this.noDeletesSearchingGen.get() >= this.searchingGen.get());
        if (targetGen > this.getCurrentSearchingGen(requireDeletes)) {
            for (WaitingListener listener : this.waitingListeners) {
                listener.waiting(requireDeletes, targetGen);
            }
            while (targetGen > this.getCurrentSearchingGen(requireDeletes)) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw new ThreadInterruptedException(ie);
                }
            }
        }
        return this.get(requireDeletes);
    }

    public long getCurrentSearchingGen(boolean requiresDeletes) {
        return requiresDeletes ? this.searchingGen.get() : this.noDeletesSearchingGen.get();
    }

    public void release(IndexSearcher s) throws IOException {
        s.getIndexReader().decRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reopen(boolean applyDeletes) throws IOException {
        long newSearcherGen = this.indexingGen.getAndIncrement();
        if (applyDeletes && this.currentSearcher.getIndexReader().isCurrent()) {
            this.searchingGen.set(newSearcherGen);
            this.noDeletesSearchingGen.set(newSearcherGen);
            NRTManager nRTManager = this;
            synchronized (nRTManager) {
                this.notifyAll();
            }
            return false;
        }
        if (!applyDeletes && this.noDeletesCurrentSearcher.getIndexReader().isCurrent()) {
            this.noDeletesSearchingGen.set(newSearcherGen);
            NRTManager nRTManager = this;
            synchronized (nRTManager) {
                this.notifyAll();
            }
            return false;
        }
        IndexSearcher startSearcher = this.noDeletesSearchingGen.get() > this.searchingGen.get() ? this.noDeletesCurrentSearcher : this.currentSearcher;
        IndexReader nextReader = startSearcher.getIndexReader().reopen(this.writer, applyDeletes);
        this.warm(nextReader);
        this.swapSearcher(new IndexSearcher(nextReader, this.es), newSearcherGen, applyDeletes);
        return true;
    }

    protected void warm(IndexReader reader) throws IOException {
    }

    private synchronized void swapSearcher(IndexSearcher newSearcher, long newSearchingGen, boolean applyDeletes) throws IOException {
        if (this.noDeletesCurrentSearcher != null) {
            this.noDeletesCurrentSearcher.getIndexReader().decRef();
        }
        this.noDeletesCurrentSearcher = newSearcher;
        assert (newSearchingGen > this.noDeletesSearchingGen.get()) : "newSearchingGen=" + newSearchingGen + " noDeletesSearchingGen=" + this.noDeletesSearchingGen;
        this.noDeletesSearchingGen.set(newSearchingGen);
        if (applyDeletes) {
            if (this.currentSearcher != null) {
                this.currentSearcher.getIndexReader().decRef();
            }
            this.currentSearcher = newSearcher;
            if (newSearcher != null) {
                newSearcher.getIndexReader().incRef();
            }
            assert (newSearchingGen > this.searchingGen.get()) : "newSearchingGen=" + newSearchingGen + " searchingGen=" + this.searchingGen;
            this.searchingGen.set(newSearchingGen);
        }
        this.notifyAll();
    }

    @Override
    public void close() throws IOException {
        this.swapSearcher(null, this.indexingGen.getAndIncrement(), true);
    }

    public static interface WaitingListener {
        public void waiting(boolean var1, long var2);
    }
}

