/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.util.StringHelper;

public class TermVectorAccessor {
    private TermVectorMapperDecorator decoratedMapper = new TermVectorMapperDecorator();
    private List<String> tokens;
    private List<int[]> positions;
    private List<Integer> frequencies;

    public void accept(IndexReader indexReader, int documentNumber, String fieldName, TermVectorMapper mapper) throws IOException {
        fieldName = StringHelper.intern(fieldName);
        this.decoratedMapper.decorated = mapper;
        this.decoratedMapper.termVectorStored = false;
        indexReader.getTermFreqVector(documentNumber, fieldName, this.decoratedMapper);
        if (!this.decoratedMapper.termVectorStored) {
            mapper.setDocumentNumber(documentNumber);
            this.build(indexReader, fieldName, mapper, documentNumber);
        }
    }

    private void build(IndexReader indexReader, String field, TermVectorMapper mapper, int documentNumber) throws IOException {
        if (this.tokens == null) {
            this.tokens = new ArrayList<String>(500);
            this.positions = new ArrayList<int[]>(500);
            this.frequencies = new ArrayList<Integer>(500);
        } else {
            this.tokens.clear();
            this.frequencies.clear();
            this.positions.clear();
        }
        TermEnum termEnum = indexReader.terms(new Term(field, ""));
        if (termEnum.term() != null) {
            while (termEnum.term().field() == field) {
                TermPositions termPositions = indexReader.termPositions(termEnum.term());
                if (termPositions.skipTo(documentNumber)) {
                    this.frequencies.add(termPositions.freq());
                    this.tokens.add(termEnum.term().text());
                    if (!mapper.isIgnoringPositions()) {
                        int[] positions = new int[termPositions.freq()];
                        for (int i = 0; i < positions.length; ++i) {
                            positions[i] = termPositions.nextPosition();
                        }
                        this.positions.add(positions);
                    } else {
                        this.positions.add(null);
                    }
                }
                termPositions.close();
                if (termEnum.next()) continue;
                break;
            }
            mapper.setDocumentNumber(documentNumber);
            mapper.setExpectations(field, this.tokens.size(), false, !mapper.isIgnoringPositions());
            for (int i = 0; i < this.tokens.size(); ++i) {
                mapper.map(this.tokens.get(i), this.frequencies.get(i), null, this.positions.get(i));
            }
        }
        termEnum.close();
    }

    private static class TermVectorMapperDecorator
    extends TermVectorMapper {
        private TermVectorMapper decorated;
        private boolean termVectorStored = false;

        private TermVectorMapperDecorator() {
        }

        public boolean isIgnoringPositions() {
            return this.decorated.isIgnoringPositions();
        }

        public boolean isIgnoringOffsets() {
            return this.decorated.isIgnoringOffsets();
        }

        public void setExpectations(String field, int numTerms, boolean storeOffsets, boolean storePositions) {
            this.decorated.setExpectations(field, numTerms, storeOffsets, storePositions);
            this.termVectorStored = true;
        }

        public void map(String term, int frequency, TermVectorOffsetInfo[] offsets, int[] positions) {
            this.decorated.map(term, frequency, offsets, positions);
        }

        public void setDocumentNumber(int documentNumber) {
            this.decorated.setDocumentNumber(documentNumber);
        }
    }
}

