/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.i18n;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.modeshape.common.i18n.LocalizationRepository;

public class ClasspathLocalizationRepository
implements LocalizationRepository {
    private final ClassLoader classLoader;

    public ClasspathLocalizationRepository() {
        this(null);
    }

    public ClasspathLocalizationRepository(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        this.classLoader = classLoader;
    }

    @Override
    public URL getLocalizationBundle(String bundleName, Locale locale) {
        URL url = null;
        List<String> paths = this.getPathsToSearchForBundle(bundleName, locale);
        for (String path : paths) {
            url = this.classLoader.getResource(path);
            if (url == null) continue;
            return url;
        }
        return url;
    }

    @Override
    public List<String> getPathsToSearchForBundle(String bundleName, Locale locale) {
        ArrayList<String> result = new ArrayList<String>();
        String pathPrefix = bundleName.replaceAll("\\.", "/");
        String localeVariant = '_' + locale.toString();
        int ndx = localeVariant.lastIndexOf(95);
        while (ndx >= 0) {
            String path = pathPrefix + localeVariant + ".properties";
            result.add(path);
            localeVariant = localeVariant.substring(0, ndx);
            ndx = localeVariant.lastIndexOf(95);
        }
        result.add(pathPrefix + localeVariant + ".properties");
        return result;
    }
}

