/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.federation.FederatedWorkspace;
import org.modeshape.graph.request.InvalidWorkspaceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class FederatedRepository {
    private final String sourceName;
    private final CachePolicy defaultCachePolicy;
    private final RepositoryConnectionFactory connectionFactory;
    private final Map<String, FederatedWorkspace> workspacesByName;
    private final FederatedWorkspace defaultWorkspace;
    private final ExecutorService executor;

    public FederatedRepository(String sourceName, RepositoryConnectionFactory connectionFactory, Iterable<FederatedWorkspace> workspaces, CachePolicy defaultCachePolicy, ExecutorService executor) {
        CheckArg.isNotNull(sourceName, "sourceName");
        CheckArg.isNotNull(connectionFactory, "connectionFactory");
        CheckArg.isNotNull(workspaces, "workspaces");
        CheckArg.isNotNull(executor, "executor");
        this.sourceName = sourceName;
        this.connectionFactory = connectionFactory;
        this.executor = executor;
        this.defaultCachePolicy = defaultCachePolicy;
        this.workspacesByName = new HashMap<String, FederatedWorkspace>();
        FederatedWorkspace defaultWorkspace = null;
        for (FederatedWorkspace workspace : workspaces) {
            if (defaultWorkspace == null) {
                defaultWorkspace = workspace;
            }
            this.workspacesByName.put(workspace.getName(), workspace);
        }
        this.defaultWorkspace = defaultWorkspace;
        assert (this.defaultWorkspace != null);
        assert (this.workspacesByName.size() > 0);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public RepositoryConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public FederatedWorkspace getWorkspace(String name) {
        if (name == null) {
            assert (this.defaultWorkspace != null);
            return this.defaultWorkspace;
        }
        FederatedWorkspace workspace = this.workspacesByName.get(name);
        if (workspace == null) {
            String msg = GraphI18n.workspaceDoesNotExistInFederatedRepository.text(name, this.getSourceName());
            throw new InvalidWorkspaceException(msg);
        }
        return workspace;
    }

    Set<String> getWorkspaceNames() {
        return Collections.unmodifiableSet(new HashSet<String>(this.workspacesByName.keySet()));
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public String toString() {
        return "Federated repository \"" + this.getSourceName() + "\" with workspaces " + this.workspacesByName.keySet();
    }
}

