/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.path;

import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.path.PathRepository;
import org.modeshape.graph.connector.path.PathRepositorySource;
import org.modeshape.graph.connector.path.PathRepositoryTransaction;
import org.modeshape.graph.connector.path.PathRequestProcessor;
import org.modeshape.graph.request.Request;

public class PathRepositoryConnection
implements RepositoryConnection {
    private final PathRepositorySource source;
    private final PathRepository repository;

    public PathRepositoryConnection(PathRepositorySource source, PathRepository repository) {
        assert (source != null);
        assert (repository != null);
        this.source = source;
        this.repository = repository;
    }

    public String getSourceName() {
        return this.source.getName();
    }

    public CachePolicy getDefaultCachePolicy() {
        return this.source.getCachePolicy();
    }

    public XAResource getXAResource() {
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        return true;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        Stopwatch sw;
        Logger logger;
        block46: {
            boolean commit;
            PathRepositoryTransaction txn;
            PathRequestProcessor processor;
            block42: {
                logger = context.getLogger(this.getClass());
                sw = null;
                if (logger.isTraceEnabled()) {
                    sw = new Stopwatch();
                    sw.start();
                }
                processor = this.repository.createRequestProcessor(context, this.source);
                txn = processor.getTransaction();
                commit = true;
                processor.process(request);
                if (!request.hasError() || request.isReadOnly()) break block42;
                commit = false;
            }
            Object var10_8 = null;
            try {
                processor.close();
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    if (commit) {
                        txn.commit();
                    } else {
                        txn.rollback();
                    }
                }
                catch (Throwable commitOrRollbackError) {
                    if (commit && !request.hasError() && !request.isFrozen()) {
                        request.setError(commitOrRollbackError);
                    }
                    commit = false;
                }
                if (commit) {
                    processor.notifyObserverOfChanges();
                }
                throw throwable;
            }
            try {
                if (commit) {
                    txn.commit();
                } else {
                    txn.rollback();
                }
            }
            catch (Throwable commitOrRollbackError) {
                if (commit && !request.hasError() && !request.isFrozen()) {
                    request.setError(commitOrRollbackError);
                }
                commit = false;
            }
            if (commit) {
                processor.notifyObserverOfChanges();
            }
            break block46;
            {
                catch (Throwable error) {
                    commit = false;
                    Object var10_9 = null;
                    try {
                        processor.close();
                        Object var12_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_14 = null;
                        try {
                            if (commit) {
                                txn.commit();
                            } else {
                                txn.rollback();
                            }
                        }
                        catch (Throwable commitOrRollbackError) {
                            if (commit && !request.hasError() && !request.isFrozen()) {
                                request.setError(commitOrRollbackError);
                            }
                            commit = false;
                        }
                        if (commit) {
                            processor.notifyObserverOfChanges();
                        }
                        throw throwable;
                    }
                    try {
                        if (commit) {
                            txn.commit();
                        } else {
                            txn.rollback();
                        }
                    }
                    catch (Throwable commitOrRollbackError) {
                        if (commit && !request.hasError() && !request.isFrozen()) {
                            request.setError(commitOrRollbackError);
                        }
                        commit = false;
                    }
                    if (commit) {
                        processor.notifyObserverOfChanges();
                    }
                    break block46;
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    processor.close();
                    Object var12_15 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_16 = null;
                    try {
                        if (commit) {
                            txn.commit();
                        } else {
                            txn.rollback();
                        }
                    }
                    catch (Throwable commitOrRollbackError) {
                        if (commit && !request.hasError() && !request.isFrozen()) {
                            request.setError(commitOrRollbackError);
                        }
                        commit = false;
                    }
                    if (commit) {
                        processor.notifyObserverOfChanges();
                    }
                    throw throwable2;
                }
                try {
                    if (commit) {
                        txn.commit();
                    } else {
                        txn.rollback();
                    }
                }
                catch (Throwable commitOrRollbackError) {
                    if (commit && !request.hasError() && !request.isFrozen()) {
                        request.setError(commitOrRollbackError);
                    }
                    commit = false;
                }
                if (commit) {
                    processor.notifyObserverOfChanges();
                }
                throw throwable;
            }
        }
        if (logger.isTraceEnabled()) {
            assert (sw != null);
            sw.stop();
            logger.trace(this.getClass().getSimpleName() + ".execute(...) took " + sw.getTotalDuration(), new Object[0]);
        }
    }

    public String toString() {
        return "Connection to the \"" + this.getSourceName() + "\" " + this.repository.getClass().getSimpleName();
    }
}

