/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.path;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.connector.path.PathNode;
import org.modeshape.graph.connector.path.PathRepository;
import org.modeshape.graph.connector.path.PathRepositoryTransaction;
import org.modeshape.graph.connector.path.PathWorkspace;
import org.modeshape.graph.connector.path.WritablePathRepository;
import org.modeshape.graph.connector.path.WritablePathWorkspace;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.InvalidRequestException;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.graph.request.LockBranchRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.UnlockBranchRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;
import org.modeshape.graph.request.processor.RequestProcessor;

public class PathRequestProcessor
extends RequestProcessor {
    private final PathFactory pathFactory;
    private final PathRepository repository;
    private final boolean updatesAllowed;
    private final PathRepositoryTransaction txn;

    public PathRequestProcessor(ExecutionContext context, PathRepository repository, Observer observer, boolean updatesAllowed, PathRepositoryTransaction txn) {
        super(repository.getSourceName(), context, observer);
        this.repository = repository;
        this.pathFactory = context.getValueFactories().getPathFactory();
        this.updatesAllowed = updatesAllowed;
        this.txn = txn;
    }

    protected boolean updatesAllowed(Request request) {
        if (!this.updatesAllowed) {
            request.setError(new InvalidRequestException(GraphI18n.sourceIsReadOnly.text(this.getSourceName())));
        }
        return !request.hasError();
    }

    public void process(VerifyWorkspaceRequest request) {
        PathWorkspace original = this.getWorkspace(request, request.workspaceName());
        if (original != null) {
            Path path = this.getExecutionContext().getValueFactories().getPathFactory().createRootPath();
            request.setActualRootLocation(Location.create(path, this.repository.getRootNodeUuid()));
            request.setActualWorkspaceName(original.getName());
        }
    }

    public void process(GetWorkspacesRequest request) {
        Set<String> names = this.repository.getWorkspaceNames();
        request.setAvailableWorkspaceNames(new HashSet<String>(names));
        this.setCacheableInfo(request);
    }

    public void process(CreateWorkspaceRequest request) {
        if (!this.repository.isWritable()) {
            String msg = GraphI18n.sourceIsReadOnly.text(this.repository.getSourceName());
            request.setError(new InvalidRequestException(msg));
            return;
        }
        WritablePathRepository writableRepo = (WritablePathRepository)this.repository;
        WritablePathWorkspace workspace = writableRepo.createWorkspace(this.getExecutionContext(), request.desiredNameOfNewWorkspace(), request.conflictBehavior());
        if (workspace == null) {
            String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(request.desiredNameOfNewWorkspace(), this.repository.getSourceName());
            request.setError(new InvalidWorkspaceException(msg));
        } else {
            request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), this.repository.getRootNodeUuid()));
            request.setActualWorkspaceName(workspace.getName());
            this.recordChange(request);
        }
    }

    public void process(CloneBranchRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.getWorkspace(request, request.fromWorkspace());
        PathWorkspace intoWorkspace = this.getWorkspace(request, request.intoWorkspace());
        if (workspace == null || intoWorkspace == null) {
            return;
        }
        PathNode node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        if (!(intoWorkspace instanceof WritablePathWorkspace)) {
            I18n msg = GraphI18n.workspaceIsReadOnly;
            request.setError(new InvalidRequestException(msg.text(this.repository.getSourceName(), intoWorkspace.getName())));
            return;
        }
        WritablePathWorkspace newWorkspace = (WritablePathWorkspace)intoWorkspace;
        Path newParentPath = request.into().getPath();
        PathNode newParent = newWorkspace.getNode(newParentPath);
        HashSet removedExistingNodes = new HashSet();
        Name desiredName = request.desiredName();
        PathNode newNode = newWorkspace.copyNode(this.getExecutionContext(), node, workspace, newParent, desiredName, true);
        Location oldLocation = Location.create(node.getPath(), node.getUuid());
        Location newLocation = Location.create(newNode.getPath(), newNode.getUuid());
        request.setActualLocations(oldLocation, newLocation);
        request.setRemovedNodes(Collections.unmodifiableSet(removedExistingNodes));
        this.recordChange(request);
    }

    public void process(CloneWorkspaceRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        ExecutionContext context = this.getExecutionContext();
        String targetWorkspaceName = request.desiredNameOfTargetWorkspace();
        String nameOfWorkspaceToBeCloned = request.nameOfWorkspaceToBeCloned();
        PathWorkspace original = this.repository.getWorkspace(nameOfWorkspaceToBeCloned);
        PathWorkspace target = this.repository.getWorkspace(targetWorkspaceName);
        if (!this.repository.isWritable()) {
            String msg = GraphI18n.sourceIsReadOnly.text(this.repository.getSourceName());
            request.setError(new InvalidRequestException(msg));
            return;
        }
        WritablePathRepository writableRepo = (WritablePathRepository)this.repository;
        if (target != null) {
            String msg = GraphI18n.workspaceAlreadyExistsInRepository.text(targetWorkspaceName, this.repository.getSourceName());
            request.setError(new InvalidWorkspaceException(msg));
            return;
        }
        if (original == null) {
            switch (request.cloneConflictBehavior()) {
                case DO_NOT_CLONE: {
                    String msg = GraphI18n.workspaceDoesNotExistInRepository.text(nameOfWorkspaceToBeCloned, this.repository.getSourceName());
                    request.setError(new InvalidWorkspaceException(msg));
                    return;
                }
                case SKIP_CLONE: {
                    target = writableRepo.createWorkspace(context, targetWorkspaceName, request.targetConflictBehavior());
                    assert (target != null);
                    request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), writableRepo.getRootNodeUuid()));
                    request.setActualWorkspaceName(target.getName());
                    return;
                }
            }
        }
        assert (original != null);
        target = writableRepo.createWorkspace(context, targetWorkspaceName, request.targetConflictBehavior(), nameOfWorkspaceToBeCloned);
        assert (target != null);
        request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), writableRepo.getRootNodeUuid()));
        request.setActualWorkspaceName(target.getName());
        this.recordChange(request);
    }

    public void process(DestroyWorkspaceRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.repository.getWorkspace(request.workspaceName());
        if (workspace != null) {
            request.setActualRootLocation(Location.create(this.pathFactory.createRootPath(), this.repository.getRootNodeUuid()));
            this.recordChange(request);
        } else {
            String msg = GraphI18n.workspaceDoesNotExistInRepository.text(request.workspaceName(), this.repository.getSourceName());
            request.setError(new InvalidWorkspaceException(msg));
        }
    }

    public void process(CopyBranchRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.getWorkspace(request, request.fromWorkspace());
        PathWorkspace intoWorkspace = this.getWorkspace(request, request.intoWorkspace());
        if (workspace == null || intoWorkspace == null) {
            return;
        }
        PathNode node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        if (!(intoWorkspace instanceof WritablePathWorkspace)) {
            I18n msg = GraphI18n.workspaceIsReadOnly;
            request.setError(new InvalidRequestException(msg.text(this.repository.getSourceName(), intoWorkspace.getName())));
            return;
        }
        WritablePathWorkspace newWorkspace = (WritablePathWorkspace)intoWorkspace;
        Path newParentPath = request.into().getPath();
        Name desiredName = request.desiredName();
        PathNode newParent = newWorkspace.getNode(newParentPath);
        PathNode newNode = newWorkspace.copyNode(this.getExecutionContext(), node, workspace, newParent, desiredName, true);
        Location oldLocation = Location.create(node.getPath(), node.getUuid());
        Location newLocation = Location.create(newNode.getPath(), newNode.getUuid());
        request.setActualLocations(oldLocation, newLocation);
        this.recordChange(request);
    }

    public void process(CreateNodeRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        Path parent = request.under().getPath();
        CheckArg.isNotNull(parent, "request.under().getPath()");
        PathNode node = null;
        PathNode parentNode = workspace.getNode(parent);
        if (parentNode == null) {
            Path lowestExisting = workspace.getLowestExistingPath(parent);
            request.setError(new PathNotFoundException(request.under(), lowestExisting, GraphI18n.nodeDoesNotExist.text(parent)));
            return;
        }
        if (!(workspace instanceof WritablePathWorkspace)) {
            I18n msg = GraphI18n.workspaceIsReadOnly;
            request.setError(new InvalidRequestException(msg.text(this.repository.getSourceName(), workspace.getName())));
            return;
        }
        WritablePathWorkspace newWorkspace = (WritablePathWorkspace)workspace;
        HashMap<Name, Property> propsToStore = new HashMap<Name, Property>(request.properties().size());
        for (Property property : request.properties()) {
            if (property.size() <= 0) continue;
            propsToStore.put(property.getName(), property);
        }
        NodeConflictBehavior conflictBehavior = request.conflictBehavior();
        switch (conflictBehavior) {
            case APPEND: {
                node = newWorkspace.createNode(this.getExecutionContext(), parentNode, request.named(), propsToStore, conflictBehavior);
                break;
            }
            case DO_NOT_REPLACE: {
                for (Path.Segment childSegment : parentNode.getChildSegments()) {
                    if (!request.named().equals(childSegment.getName())) continue;
                    Path childPath = this.pathFactory.create(parent, childSegment);
                    node = newWorkspace.getNode(childPath);
                    break;
                }
                if (node != null) break;
                node = newWorkspace.createNode(this.getExecutionContext(), parentNode, request.named(), propsToStore, conflictBehavior);
                break;
            }
            case REPLACE: {
                node = workspace.getNode(this.pathFactory.create(parent, request.named()));
                if (node != null) {
                    newWorkspace.removeNode(this.getExecutionContext(), node.getPath());
                }
                node = newWorkspace.createNode(this.getExecutionContext(), parentNode, request.named(), propsToStore, conflictBehavior);
                break;
            }
            case UPDATE: {
                node = newWorkspace.getNode(this.pathFactory.create(parent, request.named()));
                if (node != null) break;
                node = newWorkspace.createNode(this.getExecutionContext(), parentNode, request.named(), propsToStore, conflictBehavior);
            }
        }
        assert (node != null);
        Location actualLocation = Location.create(node.getPath(), node.getUuid());
        request.setActualLocationOfNode(actualLocation);
        this.recordChange(request);
    }

    public void process(DeleteBranchRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        PathNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        if (!(workspace instanceof WritablePathWorkspace)) {
            I18n msg = GraphI18n.workspaceIsReadOnly;
            request.setError(new InvalidRequestException(msg.text(this.repository.getSourceName(), workspace.getName())));
            return;
        }
        WritablePathWorkspace newWorkspace = (WritablePathWorkspace)workspace;
        newWorkspace.removeNode(this.getExecutionContext(), node.getPath());
        request.setActualLocationOfNode(Location.create(node.getPath(), node.getUuid()));
        this.recordChange(request);
    }

    public void process(MoveBranchRequest request) {
        Path newParentPath;
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        PathNode beforeNode = request.before() != null ? this.getTargetNode(workspace, request, request.before()) : null;
        PathNode node = this.getTargetNode(workspace, request, request.from());
        if (node == null) {
            return;
        }
        if (request.hasError()) {
            return;
        }
        if (request.into() != null) {
            newParentPath = request.into().getPath();
        } else {
            assert (beforeNode != null);
            newParentPath = beforeNode.getPath().getParent();
        }
        PathNode newParent = workspace.getNode(newParentPath);
        if (newParent == null) {
            Path lowestExisting = workspace.getLowestExistingPath(newParentPath);
            request.setError(new PathNotFoundException(request.into(), lowestExisting, GraphI18n.nodeDoesNotExist.text(newParentPath)));
            return;
        }
        if (!(workspace instanceof WritablePathWorkspace)) {
            I18n msg = GraphI18n.workspaceIsReadOnly;
            request.setError(new InvalidRequestException(msg.text(this.repository.getSourceName(), workspace.getName())));
            return;
        }
        WritablePathWorkspace newWorkspace = (WritablePathWorkspace)workspace;
        node = newWorkspace.moveNode(this.getExecutionContext(), node, request.desiredName(), newWorkspace, newParent, beforeNode);
        assert (node.getPath().getParent().equals(newParent.getPath()));
        Location oldLocation = Location.create(request.from().getPath());
        Location newLocation = Location.create(node.getPath(), node.getUuid());
        request.setActualLocations(oldLocation, newLocation);
        this.recordChange(request);
    }

    public void process(ReadNodeRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        PathNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            request.setError(new PathNotFoundException(request.at(), workspace.getLowestExistingPath(request.at().getPath())));
            return;
        }
        for (Path.Segment childSegment : node.getChildSegments()) {
            request.addChild(Location.create(this.pathFactory.create(node.getPath(), childSegment)));
        }
        request.addProperties(node.getProperties().values());
        request.setActualLocationOfNode(Location.create(node.getPath(), node.getUuid()));
        this.setCacheableInfo(request);
    }

    public void process(ReadAllChildrenRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        PathNode node = this.getTargetNode(workspace, request, request.of());
        if (node == null) {
            request.setError(new PathNotFoundException(request.of(), workspace.getLowestExistingPath(request.of().getPath())));
            return;
        }
        List<Path.Segment> childSegments = node.getChildSegments();
        for (Path.Segment childSegment : childSegments) {
            request.addChild(Location.create(this.pathFactory.create(node.getPath(), childSegment)));
        }
        request.setActualLocationOfNode(Location.create(node.getPath(), node.getUuid()));
        this.setCacheableInfo(request);
    }

    public void process(ReadAllPropertiesRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        if (workspace == null) {
            return;
        }
        PathNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            request.setError(new PathNotFoundException(request.at(), workspace.getLowestExistingPath(request.at().getPath())));
            return;
        }
        request.addProperties(node.getProperties().values());
        request.setActualLocationOfNode(Location.create(node.getPath(), node.getUuid()));
        this.setCacheableInfo(request);
    }

    public void process(AccessQueryRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.workspace());
        if (workspace == null) {
            return;
        }
        ExecutionContext context = this.getExecutionContext();
        QueryResults results = workspace.query(context, request);
        if (results != null) {
            request.setResults(results.getTuples(), results.getStatistics());
        } else {
            super.processUnknownRequest(request);
        }
    }

    public void process(FullTextSearchRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.workspace());
        if (workspace == null) {
            return;
        }
        ExecutionContext context = this.getExecutionContext();
        QueryResults results = workspace.search(context, request.expression());
        if (results != null) {
            request.setResults(results.getColumns(), results.getTuples(), results.getStatistics());
        } else {
            super.processUnknownRequest(request);
        }
    }

    public void process(UpdatePropertiesRequest request) {
        if (!this.updatesAllowed(request)) {
            return;
        }
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        PathNode node = this.getTargetNode(workspace, request, request.on());
        if (node == null) {
            return;
        }
        if (!(workspace instanceof WritablePathWorkspace)) {
            I18n msg = GraphI18n.workspaceIsReadOnly;
            request.setError(new InvalidRequestException(msg.text(this.repository.getSourceName(), workspace.getName())));
            return;
        }
        WritablePathWorkspace newWorkspace = (WritablePathWorkspace)workspace;
        newWorkspace.setProperties(this.getExecutionContext(), node.getPath(), request.properties());
        request.setActualLocationOfNode(Location.create(node.getPath(), node.getUuid()));
        this.recordChange(request);
    }

    public void process(LockBranchRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        PathNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        workspace.lockNode(node, request.lockScope(), request.lockTimeoutInMillis());
        request.setActualLocation(Location.create(node.getPath(), node.getUuid()));
        this.recordChange(request);
    }

    public void process(UnlockBranchRequest request) {
        PathWorkspace workspace = this.getWorkspace(request, request.inWorkspace());
        PathNode node = this.getTargetNode(workspace, request, request.at());
        if (node == null) {
            return;
        }
        workspace.unlockNode(node);
        request.setActualLocation(Location.create(node.getPath(), node.getUuid()));
        this.recordChange(request);
    }

    protected PathWorkspace getWorkspace(Request request, String workspaceName) {
        PathWorkspace workspace = this.repository.getWorkspace(workspaceName);
        if (workspace == null) {
            String msg = GraphI18n.workspaceDoesNotExistInRepository.text(workspaceName, this.repository.getSourceName());
            request.setError(new InvalidWorkspaceException(msg));
        }
        return workspace;
    }

    protected PathNode getTargetNode(PathWorkspace workspace, Request request, Location location) {
        if (workspace == null) {
            return null;
        }
        PathNode node = null;
        if (location.getUuid() != null && this.repository.getRootNodeUuid().equals(location.getUuid())) {
            PathFactory pathFactory = new ExecutionContext().getValueFactories().getPathFactory();
            return workspace.getNode(pathFactory.createRootPath());
        }
        if (!location.hasPath()) {
            I18n msg = GraphI18n.pathConnectorRequestsMustHavePath;
            request.setError(new IllegalArgumentException(msg.text(new Object[0])));
            return null;
        }
        Path path = location.getPath();
        if (path != null) {
            node = workspace.getNode(path);
        }
        if (node == null && request != null) {
            if (path == null) {
                request.setError(new PathNotFoundException(location, this.pathFactory.createRootPath(), GraphI18n.nodeDoesNotExist.text(path)));
                return null;
            }
            Path lowestExisting = workspace.getLowestExistingPath(path);
            request.setError(new PathNotFoundException(location, lowestExisting, GraphI18n.nodeDoesNotExist.text(path)));
        }
        return node;
    }

    public PathRepositoryTransaction getTransaction() {
        return this.txn;
    }
}

