/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.modeshape.common.util.Base64;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.query.model.TypeSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueTypeSystem
implements TypeSystem {
    private final String defaultTypeName;
    protected final ValueFactories valueFactories;
    protected final ValueFactory<String> stringValueFactory;
    private final Map<PropertyType, TypeSystem.TypeFactory<?>> typeFactoriesByPropertyType;
    private final Map<String, TypeSystem.TypeFactory<?>> typeFactoriesByName;
    private final Map<String, PropertyType> propertyTypeByName;
    private final TypeSystem.TypeFactory<String> stringFactory;
    private final TypeSystem.TypeFactory<Boolean> booleanFactory;
    private final TypeSystem.TypeFactory<Long> longFactory;
    private final TypeSystem.TypeFactory<Double> doubleFactory;
    private final TypeSystem.TypeFactory<BigDecimal> decimalFactory;
    private final TypeSystem.TypeFactory<?> dateFactory;
    private final TypeSystem.TypeFactory<?> pathFactory;
    private final TypeSystem.TypeFactory<?> referenceFactory;
    private final TypeSystem.TypeFactory<?> binaryFactory;

    public ValueTypeSystem(ValueFactories valueFactories) {
        this.valueFactories = valueFactories;
        this.defaultTypeName = PropertyType.STRING.getName().toUpperCase();
        HashMap factories = new HashMap();
        this.stringValueFactory = valueFactories.getStringFactory();
        this.stringFactory = new Factory<String>(this.stringValueFactory){

            @Override
            public String asString(Object value) {
                return ValueTypeSystem.this.stringValueFactory.create(value);
            }

            @Override
            public String asReadableString(Object value) {
                return ValueTypeSystem.this.stringValueFactory.create(value);
            }
        };
        this.booleanFactory = new Factory<Boolean>(valueFactories.getBooleanFactory());
        this.longFactory = new Factory<Long>(valueFactories.getLongFactory());
        this.doubleFactory = new Factory<Double>(valueFactories.getDoubleFactory());
        this.decimalFactory = new Factory<BigDecimal>(valueFactories.getDecimalFactory());
        this.dateFactory = new Factory<DateTime>((ValueFactory)valueFactories.getDateFactory()){

            @Override
            public DateTime create(String value) throws ValueFormatException {
                DateTime result = (DateTime)this.valueFactory.create(value);
                return result.toUtcTimeZone();
            }
        };
        this.pathFactory = new Factory<Path>(valueFactories.getPathFactory());
        this.referenceFactory = new Factory<Reference>(valueFactories.getReferenceFactory());
        this.binaryFactory = new Factory<Binary>((ValueFactory)valueFactories.getBinaryFactory()){

            @Override
            public String asReadableString(Object value) {
                Binary binary = (Binary)this.valueFactory.create(value);
                return "(Binary,length=" + binary.getSize() + ",SHA1=" + Base64.encodeBytes(binary.getHash()) + ")";
            }

            @Override
            public long length(Object value) {
                Binary binary = (Binary)this.valueFactory.create(value);
                return binary != null ? binary.getSize() : 0L;
            }
        };
        factories.put(PropertyType.STRING, this.stringFactory);
        factories.put(PropertyType.BOOLEAN, this.booleanFactory);
        factories.put(PropertyType.DATE, this.dateFactory);
        factories.put(PropertyType.DECIMAL, new Factory<BigDecimal>(valueFactories.getDecimalFactory()));
        factories.put(PropertyType.DOUBLE, this.doubleFactory);
        factories.put(PropertyType.LONG, this.longFactory);
        factories.put(PropertyType.NAME, new Factory<Name>(valueFactories.getNameFactory()));
        factories.put(PropertyType.OBJECT, new Factory<Object>(valueFactories.getObjectFactory()));
        factories.put(PropertyType.PATH, this.pathFactory);
        factories.put(PropertyType.REFERENCE, new Factory<Reference>(valueFactories.getReferenceFactory()));
        factories.put(PropertyType.WEAKREFERENCE, new Factory<Reference>(valueFactories.getWeakReferenceFactory()));
        factories.put(PropertyType.URI, new Factory<URI>(valueFactories.getUriFactory()));
        factories.put(PropertyType.UUID, new Factory<UUID>(valueFactories.getUuidFactory()));
        factories.put(PropertyType.BINARY, this.binaryFactory);
        this.typeFactoriesByPropertyType = Collections.unmodifiableMap(factories);
        HashMap<String, PropertyType> propertyTypeByName = new HashMap<String, PropertyType>();
        for (Map.Entry<PropertyType, TypeSystem.TypeFactory<?>> entry : this.typeFactoriesByPropertyType.entrySet()) {
            propertyTypeByName.put(entry.getValue().getTypeName(), entry.getKey());
        }
        this.propertyTypeByName = Collections.unmodifiableMap(propertyTypeByName);
        HashMap<String, TypeSystem.TypeFactory> byName = new HashMap<String, TypeSystem.TypeFactory>();
        for (TypeSystem.TypeFactory factory : factories.values()) {
            byName.put(factory.getTypeName(), factory);
        }
        this.typeFactoriesByName = Collections.unmodifiableMap(byName);
    }

    @Override
    public String asString(Object value) {
        return this.stringValueFactory.create(value);
    }

    @Override
    public TypeSystem.TypeFactory<Boolean> getBooleanFactory() {
        return this.booleanFactory;
    }

    @Override
    public TypeSystem.TypeFactory<String> getStringFactory() {
        return this.stringFactory;
    }

    @Override
    public TypeSystem.TypeFactory<?> getDateTimeFactory() {
        return this.dateFactory;
    }

    @Override
    public String getDefaultType() {
        return this.defaultTypeName;
    }

    @Override
    public Comparator<Object> getDefaultComparator() {
        return PropertyType.OBJECT.getComparator();
    }

    @Override
    public TypeSystem.TypeFactory<Double> getDoubleFactory() {
        return this.doubleFactory;
    }

    @Override
    public TypeSystem.TypeFactory<BigDecimal> getDecimalFactory() {
        return this.decimalFactory;
    }

    @Override
    public TypeSystem.TypeFactory<Long> getLongFactory() {
        return this.longFactory;
    }

    @Override
    public TypeSystem.TypeFactory<?> getPathFactory() {
        return this.pathFactory;
    }

    @Override
    public TypeSystem.TypeFactory<?> getReferenceFactory() {
        return this.referenceFactory;
    }

    @Override
    public TypeSystem.TypeFactory<?> getBinaryFactory() {
        return this.binaryFactory;
    }

    @Override
    public TypeSystem.TypeFactory<?> getTypeFactory(String typeName) {
        if (typeName == null) {
            return null;
        }
        return this.typeFactoriesByName.get(typeName.toUpperCase());
    }

    @Override
    public TypeSystem.TypeFactory<?> getTypeFactory(Object prototype) {
        ValueFactory<?> valueFactory = this.valueFactories.getValueFactory(prototype);
        if (valueFactory == null) {
            return null;
        }
        PropertyType type = valueFactory.getPropertyType();
        assert (type != null);
        return this.typeFactoriesByPropertyType.get((Object)type);
    }

    @Override
    public Set<String> getTypeNames() {
        return this.typeFactoriesByName.keySet();
    }

    @Override
    public String getCompatibleType(String type1, String type2) {
        if (type1 == null) {
            return type2 != null ? type2 : this.getDefaultType();
        }
        if (type2 == null) {
            return type1;
        }
        if (type1.equals(type2)) {
            return type1;
        }
        PropertyType ptype1 = this.propertyTypeByName.get(type1);
        PropertyType ptype2 = this.propertyTypeByName.get(type2);
        assert (ptype1 != null);
        assert (ptype2 != null);
        if (ptype1 == PropertyType.STRING) {
            return type1;
        }
        if (ptype2 == PropertyType.STRING) {
            return type2;
        }
        if (ptype1 == PropertyType.LONG && ptype2 == PropertyType.DATE) {
            return type1;
        }
        if (ptype1 == PropertyType.DATE && ptype2 == PropertyType.LONG) {
            return type2;
        }
        if (ptype1 == PropertyType.LONG && ptype2 == PropertyType.BOOLEAN) {
            return type1;
        }
        if (ptype1 == PropertyType.BOOLEAN && ptype2 == PropertyType.LONG) {
            return type2;
        }
        if (ptype1 == PropertyType.DOUBLE && ptype2 == PropertyType.LONG) {
            return type1;
        }
        if (ptype1 == PropertyType.LONG && ptype2 == PropertyType.DOUBLE) {
            return type2;
        }
        if (ptype1 == PropertyType.PATH && ptype2 == PropertyType.NAME) {
            return type1;
        }
        if (ptype1 == PropertyType.NAME && ptype2 == PropertyType.PATH) {
            return type2;
        }
        return this.getDefaultType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Factory<T>
    implements TypeSystem.TypeFactory<T> {
        protected final PropertyType type;
        protected final ValueFactory<T> valueFactory;
        protected final String typeName;

        protected Factory(ValueFactory<T> valueFactory) {
            this.valueFactory = valueFactory;
            this.type = this.valueFactory.getPropertyType();
            this.typeName = this.type.getName().toUpperCase();
        }

        @Override
        public String asReadableString(Object value) {
            return this.asString(value);
        }

        @Override
        public String asString(Object value) {
            if (value instanceof String) {
                value = this.valueFactory.create((String)value);
            }
            return ValueTypeSystem.this.stringValueFactory.create(value);
        }

        @Override
        public T create(String value) throws ValueFormatException {
            return this.valueFactory.create(value);
        }

        @Override
        public T create(Object value) throws ValueFormatException {
            return this.valueFactory.create(value);
        }

        @Override
        public Class<T> getType() {
            return this.type.getValueClass();
        }

        @Override
        public long length(Object value) {
            String str = this.asString(this.valueFactory.create(value));
            return str != null ? (long)str.length() : 0L;
        }

        @Override
        public Comparator<T> getComparator() {
            return this.type.getComparator();
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }
    }
}

