/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Reference;

@Immutable
public class UuidReference
implements Reference {
    private static final long serialVersionUID = 2299467578161645109L;
    private UUID uuid;
    private boolean isWeak;

    public UuidReference(UUID uuid) {
        this.uuid = uuid;
        this.isWeak = false;
    }

    public UuidReference(UUID uuid, boolean weak) {
        this.uuid = uuid;
        this.isWeak = weak;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getString() {
        return this.uuid.toString();
    }

    public String getString(TextEncoder encoder) {
        if (encoder == null) {
            encoder = Path.DEFAULT_ENCODER;
        }
        return encoder.encode(this.getString());
    }

    public boolean isWeak() {
        return this.isWeak;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public int compareTo(Reference that) {
        if (this == that) {
            return 0;
        }
        if (this.isWeak()) {
            if (!that.isWeak()) {
                return -1;
            }
        } else if (that.isWeak()) {
            return 1;
        }
        if (that instanceof UuidReference) {
            return this.uuid.compareTo(((UuidReference)that).getUuid());
        }
        return this.getString().compareTo(that.getString());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UuidReference) {
            UuidReference that = (UuidReference)obj;
            return this.isWeak() == that.isWeak() && this.uuid.equals(that.getUuid());
        }
        if (obj instanceof Reference) {
            Reference that = (Reference)obj;
            return this.isWeak() == that.isWeak() && this.getString().equals(that.getString());
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.uuid.toString();
    }
}

