/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.parse;

import java.util.ArrayList;
import org.modeshape.common.CommonI18n;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.text.TokenStream;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.query.model.FullTextSearch;

public class FullTextSearchParser {
    public FullTextSearch.Term parse(String fullTextSearchExpression) {
        CheckArg.isNotNull(fullTextSearchExpression, "fullTextSearchExpression");
        TermTokenizer tokenizer = new TermTokenizer();
        TokenStream stream = new TokenStream(fullTextSearchExpression, tokenizer, false);
        return this.parse(stream.start());
    }

    public FullTextSearch.Term parse(TokenStream tokens) {
        FullTextSearch.Term term;
        CheckArg.isNotNull(tokens, "tokens");
        ArrayList<FullTextSearch.Term> terms = new ArrayList<FullTextSearch.Term>();
        while ((term = this.parseDisjunctedTerms(tokens)) != null) {
            terms.add(term);
            if (tokens.canConsume("OR")) continue;
        }
        if (terms.isEmpty()) {
            return null;
        }
        return terms.size() > 1 ? new FullTextSearch.Disjunction(terms) : (FullTextSearch.Term)terms.iterator().next();
    }

    protected FullTextSearch.Term parseDisjunctedTerms(TokenStream tokens) {
        FullTextSearch.Term term;
        ArrayList<FullTextSearch.Term> terms = new ArrayList<FullTextSearch.Term>();
        while ((term = this.parseTerm(tokens)) != null) {
            terms.add(term);
            if (tokens.hasNext() && !tokens.matches("OR")) continue;
        }
        if (terms.isEmpty()) {
            return null;
        }
        return terms.size() > 1 ? new FullTextSearch.Conjunction(terms) : (FullTextSearch.Term)terms.iterator().next();
    }

    protected FullTextSearch.Term parseTerm(TokenStream tokens) {
        boolean negated = tokens.canConsume('-');
        if (!negated) {
            tokens.canConsume('+');
        }
        FullTextSearch.SimpleTerm result = new FullTextSearch.SimpleTerm(this.removeQuotes(tokens.consume()));
        return negated ? new FullTextSearch.NegationTerm(result) : result;
    }

    protected String removeQuotes(String text) {
        return text.replaceFirst("^['\"]+", "").replaceAll("['\"]+$", "");
    }

    public static class TermTokenizer
    implements TokenStream.Tokenizer {
        public static final int WORD = 1;
        public static final int PLUS_MINUS = 2;
        public static final int SINGLE_QUOTED_STRING = 4;
        public static final int DOUBLE_QUOTED_STRING = 8;

        protected TermTokenizer() {
        }

        public void tokenize(TokenStream.CharacterStream input, TokenStream.Tokens tokens) throws ParsingException {
            block6: while (input.hasNext()) {
                int endIndex;
                Position startingPosition;
                int startIndex;
                char c = input.next();
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block6;
                    }
                    case '+': 
                    case '-': {
                        tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 2);
                        continue block6;
                    }
                    case '\"': {
                        startIndex = input.index();
                        startingPosition = input.position(startIndex);
                        boolean foundClosingQuote = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c == '\\' && input.isNext('\"')) {
                                c = input.next();
                                continue;
                            }
                            if (c != '\"') continue;
                            foundClosingQuote = true;
                            break;
                        }
                        if (!foundClosingQuote) {
                            String msg = CommonI18n.noMatchingDoubleQuoteFound.text(startingPosition.getLine(), startingPosition.getColumn());
                            throw new ParsingException(startingPosition, msg);
                        }
                        endIndex = input.index() + 1;
                        tokens.addToken(startingPosition, startIndex, endIndex, 8);
                        continue block6;
                    }
                    case '\'': {
                        startIndex = input.index();
                        startingPosition = input.position(startIndex);
                        boolean foundClosingQuote = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c == '\\' && input.isNext('\'')) {
                                c = input.next();
                                continue;
                            }
                            if (c != '\'') continue;
                            foundClosingQuote = true;
                            break;
                        }
                        if (!foundClosingQuote) {
                            String msg = CommonI18n.noMatchingSingleQuoteFound.text(startingPosition.getLine(), startingPosition.getColumn());
                            throw new ParsingException(startingPosition, msg);
                        }
                        endIndex = input.index() + 1;
                        tokens.addToken(startingPosition, startIndex, endIndex, 4);
                        continue block6;
                    }
                }
                startIndex = input.index();
                startingPosition = input.position(startIndex);
                while (input.hasNext() && !input.isNextWhitespace()) {
                    c = input.next();
                }
                endIndex = input.index() + 1;
                tokens.addToken(startingPosition, startIndex, endIndex, 1);
            }
        }
    }
}

