/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.plan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.modeshape.common.i18n.I18n;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.AllNodes;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.FullTextSearch;
import org.modeshape.graph.query.model.Join;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.NamedSelector;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.Query;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.Selector;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.SetQuery;
import org.modeshape.graph.query.model.Source;
import org.modeshape.graph.query.model.Subquery;
import org.modeshape.graph.query.model.Visitable;
import org.modeshape.graph.query.model.Visitors;
import org.modeshape.graph.query.plan.JoinAlgorithm;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.plan.PlanUtil;
import org.modeshape.graph.query.plan.Planner;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.graph.query.validate.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalPlanner
implements Planner {
    @Override
    public PlanNode createPlan(QueryContext context, QueryCommand query) {
        PlanNode plan = null;
        plan = query instanceof Query ? this.createCanonicalPlan(context, (Query)query) : this.createCanonicalPlan(context, (SetQuery)query);
        return plan;
    }

    protected PlanNode createCanonicalPlan(QueryContext context, Query query) {
        PlanNode plan = null;
        HashMap<SelectorName, Schemata.Table> usedSources = new HashMap<SelectorName, Schemata.Table>();
        plan = this.createPlanNode(context, query.source(), usedSources);
        HashMap<String, Subquery> subqueriesByVariableName = new HashMap<String, Subquery>();
        plan = this.attachCriteria(context, plan, query.constraint(), query.columns(), subqueriesByVariableName);
        plan = this.attachProject(context, plan, query.columns(), usedSources);
        if (query.isDistinct()) {
            plan = this.attachDuplicateRemoval(context, plan);
        }
        plan = this.attachSorting(context, plan, query.orderings());
        plan = this.attachLimits(context, plan, query.limits());
        plan = this.attachSubqueries(context, plan, subqueriesByVariableName);
        this.validate(context, query, usedSources);
        for (Subquery subquery : Visitors.subqueries(query, false)) {
            this.createPlan(context, subquery.query());
        }
        return plan;
    }

    protected void validate(QueryContext context, QueryCommand query, Map<SelectorName, Schemata.Table> usedSelectors) {
        Validator validator = new Validator(context, usedSelectors);
        query.accept(new Visitors.WalkAllVisitor(validator){

            protected void enqueue(Visitable objectToBeVisited) {
                if (objectToBeVisited instanceof Subquery) {
                    return;
                }
                super.enqueue(objectToBeVisited);
            }
        });
    }

    protected PlanNode createCanonicalPlan(QueryContext context, SetQuery query) {
        PlanNode left = this.createPlan(context, query.left());
        PlanNode right = this.createPlan(context, query.right());
        PlanNode plan = new PlanNode(PlanNode.Type.SET_OPERATION);
        plan.addChildren(left, right);
        plan.setProperty(PlanNode.Property.SET_OPERATION, query.operation());
        plan.setProperty(PlanNode.Property.SET_USE_ALL, query.isAll());
        plan = this.attachSorting(context, plan, query.orderings());
        plan = this.attachLimits(context, plan, query.limits());
        return plan;
    }

    protected PlanNode createPlanNode(QueryContext context, Source source, Map<SelectorName, Schemata.Table> usedSelectors) {
        if (source instanceof Selector) {
            assert (source instanceof AllNodes || source instanceof NamedSelector);
            Selector selector = (Selector)source;
            PlanNode node = new PlanNode(PlanNode.Type.SOURCE);
            if (selector.hasAlias()) {
                node.addSelector(selector.alias());
                node.setProperty(PlanNode.Property.SOURCE_ALIAS, selector.alias());
                node.setProperty(PlanNode.Property.SOURCE_NAME, selector.name());
            } else {
                node.addSelector(selector.name());
                node.setProperty(PlanNode.Property.SOURCE_NAME, selector.name());
            }
            Schemata.Table table = context.getSchemata().getTable(selector.name());
            if (table != null) {
                if (table instanceof Schemata.View) {
                    context.getHints().hasView = true;
                }
                if (usedSelectors.put(selector.aliasOrName(), table) != null) {
                    I18n msg = GraphI18n.selectorNamesMayNotBeUsedMoreThanOnce;
                    context.getProblems().addError(msg, selector.aliasOrName().getString());
                }
                node.setProperty(PlanNode.Property.SOURCE_COLUMNS, table.getColumns());
            } else {
                context.getProblems().addError(GraphI18n.tableDoesNotExist, selector.name());
            }
            return node;
        }
        if (source instanceof Join) {
            Join join = (Join)source;
            PlanNode node = new PlanNode(PlanNode.Type.JOIN);
            node.setProperty(PlanNode.Property.JOIN_TYPE, join.type());
            node.setProperty(PlanNode.Property.JOIN_ALGORITHM, (Object)JoinAlgorithm.NESTED_LOOP);
            node.setProperty(PlanNode.Property.JOIN_CONDITION, join.joinCondition());
            context.getHints().hasJoin = true;
            if (join.type() == JoinType.LEFT_OUTER) {
                context.getHints().hasOptionalJoin = true;
            }
            Source[] clauses = new Source[]{join.left(), join.right()};
            for (int i = 0; i < 2; ++i) {
                PlanNode sourceNode = this.createPlanNode(context, clauses[i], usedSelectors);
                node.addLastChild(sourceNode);
                for (PlanNode child : node.getChildren()) {
                    node.addSelectors(child.getSelectors());
                }
            }
            return node;
        }
        assert (false);
        return null;
    }

    protected PlanNode attachCriteria(final QueryContext context, PlanNode plan, Constraint constraint, List<? extends Column> columns, Map<String, Subquery> subqueriesByVariableName) {
        if (constraint == null) {
            return plan;
        }
        context.getHints().hasCriteria = true;
        LinkedList<Constraint> andableConstraints = new LinkedList<Constraint>();
        this.separateAndConstraints(constraint, andableConstraints);
        assert (!andableConstraints.isEmpty());
        HashMap<String, String> propertyNameByAlias = new HashMap<String, String>();
        for (Column column : columns) {
            if (column.columnName().equals(column.propertyName())) continue;
            propertyNameByAlias.put(column.columnName(), column.propertyName());
        }
        while (!andableConstraints.isEmpty()) {
            Constraint criteria = andableConstraints.removeLast();
            criteria = PlanUtil.replaceSubqueriesWithBindVariables(context, criteria, subqueriesByVariableName);
            criteria = PlanUtil.replaceAliasesWithProperties(context, criteria, propertyNameByAlias);
            PlanNode planNode = new PlanNode(PlanNode.Type.SELECT);
            planNode.setProperty(PlanNode.Property.SELECT_CRITERIA, criteria);
            planNode.addSelectors(Visitors.getSelectorsReferencedBy(criteria));
            Visitors.visitAll(criteria, new Visitors.AbstractVisitor(){

                public void visit(FullTextSearch obj) {
                    context.getHints().hasFullTextSearch = true;
                }
            });
            planNode.addFirstChild(plan);
            plan = planNode;
        }
        if (!subqueriesByVariableName.isEmpty()) {
            context.getHints().hasSubqueries = true;
        }
        return plan;
    }

    protected void separateAndConstraints(Constraint constraint, List<Constraint> andableConstraints) {
        if (constraint == null) {
            return;
        }
        assert (andableConstraints != null);
        if (constraint instanceof And) {
            And and = (And)constraint;
            this.separateAndConstraints(and.left(), andableConstraints);
            this.separateAndConstraints(and.right(), andableConstraints);
        } else {
            andableConstraints.add(constraint);
        }
    }

    protected PlanNode attachSorting(QueryContext context, PlanNode plan, List<? extends Ordering> orderings) {
        if (orderings.isEmpty()) {
            return plan;
        }
        PlanNode sortNode = new PlanNode(PlanNode.Type.SORT);
        context.getHints().hasSort = true;
        sortNode.setProperty(PlanNode.Property.SORT_ORDER_BY, orderings);
        for (Ordering ordering : orderings) {
            sortNode.addSelectors(Visitors.getSelectorsReferencedBy(ordering));
        }
        sortNode.addLastChild(plan);
        return sortNode;
    }

    protected PlanNode attachLimits(QueryContext context, PlanNode plan, Limit limit) {
        if (limit.isUnlimited()) {
            return plan;
        }
        context.getHints().hasLimit = true;
        PlanNode limitNode = new PlanNode(PlanNode.Type.LIMIT);
        boolean attach = false;
        if (limit.offset() != 0) {
            limitNode.setProperty(PlanNode.Property.LIMIT_OFFSET, limit.offset());
            attach = true;
        }
        if (!limit.isUnlimited()) {
            limitNode.setProperty(PlanNode.Property.LIMIT_COUNT, limit.rowLimit());
            attach = true;
        }
        if (attach) {
            limitNode.addLastChild(plan);
            plan = limitNode;
        }
        return plan;
    }

    protected PlanNode attachProject(QueryContext context, PlanNode plan, List<? extends Column> columns, Map<SelectorName, Schemata.Table> selectors) {
        PlanNode projectNode = new PlanNode(PlanNode.Type.PROJECT);
        LinkedList<Column> newColumns = new LinkedList<Column>();
        ArrayList<String> newTypes = new ArrayList<String>();
        if (columns == null || columns.isEmpty()) {
            for (Map.Entry<SelectorName, Schemata.Table> entry : selectors.entrySet()) {
                SelectorName tableName = entry.getKey();
                Schemata.Table table = entry.getValue();
                projectNode.addSelector(tableName);
                this.allColumnsFor(table, tableName, newColumns, newTypes);
            }
        } else {
            for (Column column : columns) {
                boolean validateColumnExistance;
                SelectorName tableName = column.selectorName();
                projectNode.addSelector(tableName);
                Schemata.Table table = selectors.get(tableName);
                if (table == null) {
                    context.getProblems().addError(GraphI18n.tableDoesNotExist, tableName);
                    continue;
                }
                String columnName = column.propertyName();
                if ("*".equals(columnName) || columnName == null) {
                    this.allColumnsFor(table, tableName, newColumns, newTypes);
                } else if (!newColumns.contains(column)) {
                    newColumns.add(column);
                    Schemata.Column schemaColumn = table.getColumn(columnName);
                    if (schemaColumn != null) {
                        newTypes.add(schemaColumn.getPropertyType());
                    } else {
                        newTypes.add(context.getTypeSystem().getStringFactory().getTypeName());
                    }
                }
                boolean bl = validateColumnExistance = context.getHints().validateColumnExistance && !table.hasExtraColumns();
                if (table.getColumn(columnName) != null || !validateColumnExistance || "*".equals(columnName)) continue;
                context.getProblems().addError(GraphI18n.columnDoesNotExistOnTable, columnName, tableName);
            }
        }
        projectNode.setProperty(PlanNode.Property.PROJECT_COLUMNS, newColumns);
        projectNode.setProperty(PlanNode.Property.PROJECT_COLUMN_TYPES, newTypes);
        projectNode.addLastChild(plan);
        return projectNode;
    }

    protected void allColumnsFor(Schemata.Table table, SelectorName tableName, List<Column> columns, List<String> columnTypes) {
        for (Schemata.Column column : table.getSelectAllColumns()) {
            String columnName;
            String propertyName = columnName = column.getName();
            Column newColumn = new Column(tableName, propertyName, columnName);
            if (columns.contains(column)) continue;
            columns.add(newColumn);
            columnTypes.add(column.getPropertyType());
        }
    }

    protected PlanNode attachDuplicateRemoval(QueryContext context, PlanNode plan) {
        PlanNode dupNode = new PlanNode(PlanNode.Type.DUP_REMOVE);
        plan.setParent(dupNode);
        return dupNode;
    }

    protected PlanNode attachSubqueries(QueryContext context, PlanNode plan, Map<String, Subquery> subqueriesByVariableName) {
        ArrayList<String> varNames = new ArrayList<String>(subqueriesByVariableName.keySet());
        Collections.sort(varNames);
        Collections.reverse(varNames);
        for (String varName : varNames) {
            Subquery subquery = subqueriesByVariableName.get(varName);
            PlanNode subqueryNode = this.createPlan(context, subquery.query());
            this.setSubqueryVariableName(subqueryNode, varName);
            PlanNode depQuery = new PlanNode(PlanNode.Type.DEPENDENT_QUERY);
            depQuery.addChildren(subqueryNode, plan);
            depQuery.addSelectors(subqueryNode.getSelectors());
            depQuery.addSelectors(plan.getSelectors());
            plan = depQuery;
        }
        return plan;
    }

    protected void setSubqueryVariableName(PlanNode subqueryPlan, String varName) {
        if (subqueryPlan.getType() != PlanNode.Type.DEPENDENT_QUERY) {
            subqueryPlan.setProperty(PlanNode.Property.VARIABLE_NAME, varName);
            return;
        }
        this.setSubqueryVariableName(subqueryPlan.getLastChild(), varName);
    }
}

