/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.RequestType;

public class DeleteBranchRequest
extends ChangeRequest {
    private static final long serialVersionUID = 1L;
    private final Location at;
    private final String workspaceName;
    private Location actualLocation;

    public DeleteBranchRequest(Location at, String workspaceName) {
        CheckArg.isNotNull(at, "at");
        CheckArg.isNotNull(workspaceName, "workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        CheckArg.isNotNull(actual, "actual");
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(actual));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    public boolean changes(String workspace, Path path) {
        return this.workspaceName.equals(workspace) && this.at.hasPath() && this.at.getPath().isAtOrBelow(path);
    }

    public Location changedLocation() {
        return this.actualLocation != null ? this.actualLocation : this.at;
    }

    public String changedWorkspace() {
        return this.workspaceName;
    }

    public void cancel() {
        super.cancel();
        this.actualLocation = null;
    }

    public int hashCode() {
        return HashCode.compute(this.at, this.workspaceName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            DeleteBranchRequest that = (DeleteBranchRequest)obj;
            if (!this.at().isSame(that.at())) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        String workspaceName = this.workspaceName != null ? "'" + this.workspaceName + "'" : "default";
        return "delete " + this.printable(this.at()) + " (in " + workspaceName + " workspace) and all descendants";
    }

    public DeleteBranchRequest clone() {
        DeleteBranchRequest request = new DeleteBranchRequest(this.actualLocation != null ? this.actualLocation : this.at, this.workspaceName);
        request.setActualLocationOfNode(this.actualLocation);
        return request;
    }

    public RequestType getType() {
        return RequestType.DELETE_BRANCH;
    }
}

