/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.RepositoryException;
import org.modeshape.cnd.CndImporter;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.common.component.ComponentConfig;
import org.modeshape.common.component.ComponentLibrary;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.NamedThreadFactory;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.xmlfile.XmlFileRepositorySource;
import org.modeshape.graph.io.GraphBatchDestination;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.basic.GraphNamespaceRegistry;
import org.modeshape.jcr.JcrConfigurationException;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.jcr.security.AuthenticationProvider;
import org.modeshape.repository.ModeShapeConfiguration;
import org.modeshape.repository.ModeShapeConfigurationException;
import org.modeshape.repository.ModeShapeEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class JcrEngine
extends ModeShapeEngine
implements Repositories {
    static final int LOCK_SWEEP_INTERVAL_IN_MILLIS = 30000;
    static final int LOCK_EXTENSION_INTERVAL_IN_MILLIS = 60000;
    private static final Logger log = Logger.getLogger(ModeShapeEngine.class);
    private final Map<String, JcrRepositoryHolder> repositories;
    private final Lock repositoriesLock;
    private final Map<String, Object> descriptors = new HashMap<String, Object>();
    private final ExecutorService repositoryStarterService;
    private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(2);

    JcrEngine(ExecutionContext context, ModeShapeConfiguration.ConfigurationDefinition configuration) {
        super(context, configuration);
        this.repositories = new HashMap<String, JcrRepositoryHolder>();
        this.repositoriesLock = new ReentrantLock();
        this.initDescriptors();
        NamedThreadFactory threadFactory = new NamedThreadFactory("modeshape-start-repo");
        this.repositoryStarterService = Executors.newCachedThreadPool(threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUpLocks() {
        ArrayList<JcrRepositoryHolder> repos = null;
        try {
            this.repositoriesLock.lock();
            repos = new ArrayList<JcrRepositoryHolder>(this.repositories.values());
        }
        finally {
            this.repositoriesLock.unlock();
        }
        for (JcrRepositoryHolder repository : repos) {
            repository.cleanUpLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preShutdown() {
        this.repositoryStarterService.shutdown();
        this.scheduler.shutdown();
        super.preShutdown();
        try {
            this.repositoriesLock.lock();
            for (JcrRepositoryHolder holder : this.repositories.values()) {
                holder.close();
            }
            this.repositories.clear();
        }
        finally {
            this.repositoriesLock.unlock();
        }
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.scheduler.awaitTermination(timeout, unit)) {
            return false;
        }
        return super.awaitTermination(timeout, unit);
    }

    @Override
    protected void checkConfiguration(Subgraph configuration) {
        super.checkConfiguration(configuration);
        HashSet<String> sourceNames = new HashSet<String>();
        for (Location child : configuration.getNode(ModeShapeLexicon.SOURCES)) {
            String name = child.getPath().getLastSegment().getName().getLocalName();
            sourceNames.add(name);
        }
        for (Location child : configuration.getNode(ModeShapeLexicon.REPOSITORIES)) {
            String repositoryName = this.readable(child.getPath().getLastSegment().getName());
            Object repositoryNode = configuration.getNode(child);
            Property property = repositoryNode.getProperty(ModeShapeLexicon.SOURCE_NAME);
            if (property == null) {
                this.getProblems().addError(JcrI18n.repositoryReferencesNonExistantSource, repositoryName, "null");
                continue;
            }
            String sourceName = this.string(property.getFirstValue());
            if (sourceNames.contains(sourceName)) continue;
            this.getProblems().addError(JcrI18n.repositoryReferencesNonExistantSource, repositoryName, sourceName);
        }
    }

    @Override
    public void start() {
        super.start();
        final JcrEngine engine = this;
        Runnable cleanUpTask = new Runnable(){

            public void run() {
                engine.cleanUpLocks();
            }
        };
        try {
            this.scheduler.scheduleAtFixedRate(cleanUpTask, 30000L, 30000L, TimeUnit.MILLISECONDS);
            this.checkProblemsOnStartup();
        }
        catch (RuntimeException e) {
            try {
                super.shutdown();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
    }

    public void start(boolean validateRepositoryConfigs) {
        this.start(validateRepositoryConfigs, -1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean validateRepositoryConfigs, long timeout, TimeUnit timeoutUnit) {
        this.start();
        if (validateRepositoryConfigs) {
            Set<String> repositoryNames = this.getRepositoryNames();
            if (repositoryNames.isEmpty()) {
                return;
            }
            CountDownLatch latch = new CountDownLatch(repositoryNames.size());
            try {
                this.repositoriesLock.lock();
                for (String repositoryName : repositoryNames) {
                    RepositoryInitializer initializer = new RepositoryInitializer(repositoryName, latch);
                    Future<JcrRepository> future = this.repositoryStarterService.submit(initializer);
                    JcrRepositoryHolder holder = new JcrRepositoryHolder(repositoryName, future);
                    this.repositories.put(repositoryName, holder);
                }
            }
            finally {
                this.repositoriesLock.unlock();
            }
            try {
                if (timeout < 0L) {
                    latch.await();
                } else {
                    latch.await(timeout, timeoutUnit);
                }
            }
            catch (InterruptedException e) {
                this.problems.addError((Throwable)e, JcrI18n.startingAllRepositoriesWasInterrupted, e.getMessage());
            }
        }
    }

    @Override
    protected ModeShapeConfigurationException newConfigurationException(String msg) {
        return new JcrConfigurationException(msg);
    }

    public String getEngineVersion() {
        return JcrRepository.getBundleProperty("jcr.repository.version", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JcrRepository getRepository(String repositoryName) throws RepositoryException {
        CheckArg.isNotEmpty(repositoryName, "repositoryName");
        this.checkRunning();
        JcrRepositoryHolder holder = null;
        try {
            this.repositoriesLock.lock();
            holder = this.repositories.get(repositoryName);
            if (holder != null) {
                JcrRepository jcrRepository = holder.getRepository();
                return jcrRepository;
            }
            if (!this.getRepositoryNames().contains(repositoryName)) {
                String msg = JcrI18n.repositoryDoesNotExist.text(repositoryName);
                throw new RepositoryException(msg);
            }
            RepositoryInitializer initializer = new RepositoryInitializer(repositoryName);
            Future<JcrRepository> future = this.repositoryStarterService.submit(initializer);
            holder = new JcrRepositoryHolder(repositoryName, future);
            this.repositories.put(repositoryName, holder);
        }
        finally {
            this.repositoriesLock.unlock();
        }
        JcrRepository repo = holder.getRepository();
        return repo;
    }

    @Override
    public Set<String> getRepositoryNames() {
        this.checkRunning();
        HashSet<String> results = new HashSet<String>();
        PathFactory pathFactory = this.getExecutionContext().getValueFactories().getPathFactory();
        Path repositoriesPath = pathFactory.create(this.configuration.getPath(), ModeShapeLexicon.REPOSITORIES);
        Graph configuration = this.getConfigurationGraph();
        for (Location child : (List)configuration.getChildren().of(repositoriesPath)) {
            Name repositoryName = child.getPath().getLastSegment().getName();
            results.add(this.readable(repositoryName));
        }
        return Collections.unmodifiableSet(results);
    }

    protected JcrRepository doCreateJcrRepository(String repositoryName) throws RepositoryException, PathNotFoundException {
        Path repoPath;
        Object repoNode;
        Path descriptorsPath;
        Object descriptorsNode;
        Path optionsPath;
        RepositoryConnectionFactory connectionFactory = this.getRepositoryConnectionFactory();
        HashMap<String, String> descriptors = new HashMap<String, String>();
        HashMap<JcrRepository.Option, String> options = new HashMap<JcrRepository.Option, String>();
        PathFactory pathFactory = this.getExecutionContext().getValueFactories().getPathFactory();
        Path repositoriesPath = pathFactory.create(this.configuration.getPath(), ModeShapeLexicon.REPOSITORIES);
        Path repositoryPath = pathFactory.create(repositoriesPath, repositoryName);
        Name repoName = (Name)this.getExecutionContext().getValueFactories().getNameFactory().create(repositoryName);
        Graph configuration = null;
        Subgraph subgraph = this.getConfigurationSubgraph(false);
        Object optionsNode = subgraph.getNode(optionsPath = pathFactory.createRelativePath(ModeShapeLexicon.REPOSITORIES, repoName, ModeShapeLexicon.OPTIONS));
        if (optionsNode != null) {
            for (Location optionLocation : optionsNode.getChildren()) {
                Object optionNode = subgraph.getNode(optionLocation);
                Path.Segment segment = optionLocation.getPath().getLastSegment();
                Property valueProperty = optionNode.getProperty(ModeShapeLexicon.VALUE);
                if (valueProperty == null) {
                    log.warn(JcrI18n.noOptionValueProvided, segment.getName().getLocalName());
                    continue;
                }
                JcrRepository.Option option = JcrRepository.Option.findOption(segment.getName().getLocalName());
                if (option == null) {
                    log.warn(JcrI18n.invalidOptionProvided, segment.getName().getLocalName());
                    continue;
                }
                String value = valueProperty.getFirstValue() != null ? valueProperty.getFirstValue().toString() : "";
                options.put(option, value);
            }
        }
        if (!options.containsKey((Object)JcrRepository.Option.REMOVE_DERIVED_CONTENT_WITH_ORIGINAL) && this.getSequencingService().getSequencers().isEmpty()) {
            options.put(JcrRepository.Option.REMOVE_DERIVED_CONTENT_WITH_ORIGINAL, Boolean.FALSE.toString());
        }
        if ((descriptorsNode = subgraph.getNode(descriptorsPath = pathFactory.createRelativePath(ModeShapeLexicon.REPOSITORIES, repoName, ModeShapeLexicon.DESCRIPTORS))) != null) {
            for (Location descriptorLocation : descriptorsNode.getChildren()) {
                Object optionNode = subgraph.getNode(descriptorLocation);
                Path.Segment segment = descriptorLocation.getPath().getLastSegment();
                Property valueProperty = optionNode.getProperty(ModeShapeLexicon.VALUE);
                if (valueProperty == null) continue;
                descriptors.put(segment.getName().getLocalName(), valueProperty.getFirstValue().toString());
            }
        }
        ExecutionContext context = this.getExecutionContext();
        Path namespacesPath = pathFactory.createRelativePath(ModeShapeLexicon.REPOSITORIES, repoName, ModeShapeLexicon.NAMESPACES);
        Object namespacesNode = subgraph.getNode(namespacesPath);
        descriptors.put("custom.rep.name", repositoryName);
        if (namespacesNode != null) {
            configuration = this.getConfigurationGraph();
            GraphNamespaceRegistry registry = new GraphNamespaceRegistry(configuration, namespacesNode.getLocation().getPath(), ModeShapeLexicon.URI, ModeShapeLexicon.GENERATED, new Property[0]);
            context = context.with(registry);
        }
        if ((repoNode = subgraph.getNode(repoPath = pathFactory.createRelativePath(ModeShapeLexicon.REPOSITORIES, repoName))) == null) {
            throw new PathNotFoundException(Location.create(repoPath), repositoriesPath, JcrI18n.repositoryDoesNotExist.text(this.readable(repoName)));
        }
        Property property = repoNode.getProperty(ModeShapeLexicon.SOURCE_NAME);
        if (property == null || property.isEmpty()) {
            if (configuration == null) {
                configuration = this.getConfigurationGraph();
            }
            String readableName = this.readable(ModeShapeLexicon.SOURCE_NAME);
            String readablePath = this.readable(subgraph.getLocation());
            String msg = JcrI18n.propertyNotFoundOnNode.text(readableName, readablePath, configuration.getCurrentWorkspaceName());
            throw new RepositoryException(msg);
        }
        String sourceName = context.getValueFactories().getStringFactory().create(property.getFirstValue());
        RepositorySource source = this.getRepositorySource(sourceName);
        if (source == null) {
            throw new RepositoryException(JcrI18n.repositoryReferencesNonExistantSource.text(repositoryName, sourceName));
        }
        String initialContentForNewWorkspaces = null;
        for (Location initialContentLocation : repoNode.getChildren(ModeShapeLexicon.INITIAL_CONTENT)) {
            Object initialContent = subgraph.getNode(initialContentLocation);
            if (initialContent == null) continue;
            Property contentReference = initialContent.getProperty(ModeShapeLexicon.CONTENT);
            if (contentReference == null || contentReference.isEmpty()) {
                if (configuration == null) {
                    configuration = this.getConfigurationGraph();
                }
                String readableName = this.readable(ModeShapeLexicon.CONTENT);
                String readablePath = this.readable(initialContentLocation);
                String msg = JcrI18n.propertyNotFoundOnNode.text(readableName, readablePath, configuration.getCurrentWorkspaceName());
                throw new RepositoryException(msg);
            }
            String contentRef = this.string(contentReference.getFirstValue());
            Property workspaces = initialContent.getProperty(ModeShapeLexicon.WORKSPACES);
            if (workspaces == null || workspaces.isEmpty()) {
                if (configuration == null) {
                    configuration = this.getConfigurationGraph();
                }
                String readableName = this.readable(ModeShapeLexicon.WORKSPACES);
                String readablePath = this.readable(initialContentLocation);
                String msg = JcrI18n.propertyNotFoundOnNode.text(readableName, readablePath, configuration.getCurrentWorkspaceName());
                throw new RepositoryException(msg);
            }
            XmlFileRepositorySource initialContentSource = new XmlFileRepositorySource();
            initialContentSource.setName("Initial content for " + repositoryName);
            initialContentSource.setContentLocation(contentRef);
            Graph initialContentGraph = Graph.create(initialContentSource, context);
            Graph sourceGraph = Graph.create(sourceName, connectionFactory, context);
            for (Object value : workspaces) {
                String workspaceName = this.string(value);
                if (workspaceName == null || workspaceName.trim().length() == 0) continue;
                sourceGraph.useWorkspace(workspaceName);
                try {
                    sourceGraph.merge(initialContentGraph);
                }
                catch (RuntimeException e) {
                    throw new RepositoryException(JcrI18n.unableToImportInitialContent.text(this.readable(repoName), contentRef), (Throwable)e);
                }
            }
            Property applyToNewWorkspaces = initialContent.getProperty(ModeShapeLexicon.APPLY_TO_NEW_WORKSPACES);
            if (applyToNewWorkspaces == null || applyToNewWorkspaces.isEmpty() || !this.isTrue(applyToNewWorkspaces.getFirstValue())) continue;
            initialContentForNewWorkspaces = contentRef;
        }
        ComponentLibrary<AuthenticationProvider, ComponentConfig> authenticators = new ComponentLibrary<AuthenticationProvider, ComponentConfig>();
        for (Location authProvidersLocation : repoNode.getChildren(ModeShapeLexicon.AUTHENTICATION_PROVIDERS)) {
            Object authProviders = subgraph.getNode(authProvidersLocation);
            if (authProviders == null) continue;
            for (Location authProviderLocation : authProviders.getChildren()) {
                Object authProvider = subgraph.getNode(authProviderLocation);
                if (authProvider == null) continue;
                HashSet<Name> skipProperties = new HashSet<Name>();
                skipProperties.add(ModeShapeLexicon.READABLE_NAME);
                skipProperties.add(ModeShapeLexicon.DESCRIPTION);
                skipProperties.add(ModeShapeLexicon.CLASSNAME);
                skipProperties.add(ModeShapeLexicon.CLASSPATH);
                skipProperties.add(ModeShapeLexicon.PATH_EXPRESSION);
                HashSet<String> skipNamespaces = new HashSet<String>();
                skipNamespaces.add("http://www.jcp.org/jcr/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/nt/1.0");
                skipNamespaces.add("http://www.jcp.org/jcr/mix/1.0");
                String name = this.stringValueOf((Node)authProvider, ModeShapeLexicon.READABLE_NAME);
                if (name == null) {
                    name = this.stringValueOf((Node)authProvider);
                }
                String desc = this.stringValueOf((Node)authProvider, ModeShapeLexicon.DESCRIPTION);
                String classname = this.stringValueOf((Node)authProvider, ModeShapeLexicon.CLASSNAME);
                String[] classpath = this.stringValuesOf((Node)authProvider, ModeShapeLexicon.CLASSPATH);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                for (Property authProp : authProvider.getProperties()) {
                    Name propertyName = authProp.getName();
                    if (skipNamespaces.contains(propertyName.getNamespaceUri()) || skipProperties.contains(propertyName)) continue;
                    if (authProp.isSingle()) {
                        properties.put(propertyName.getLocalName(), authProp.getFirstValue());
                        continue;
                    }
                    properties.put(propertyName.getLocalName(), authProp.getValuesAsArray());
                }
                try {
                    ComponentConfig config = new ComponentConfig(name, desc, properties, classname, classpath);
                    authenticators.add(config);
                }
                catch (Throwable t) {
                    this.problems.addError(t, JcrI18n.unableToInitializeAuthenticationProvider, name, repositoryName, t.getMessage());
                }
            }
        }
        RepositorySourceCapabilities capabilities = source.getCapabilities();
        JcrRepository repository = new JcrRepository(context, connectionFactory, sourceName, this.getRepositoryService().getRepositoryLibrary(), capabilities, descriptors, options, initialContentForNewWorkspaces, authenticators);
        Path nodeTypesPath = pathFactory.createRelativePath(ModeShapeLexicon.REPOSITORIES, repoName, JcrLexicon.NODE_TYPES);
        Object nodeTypesNode = subgraph.getNode(nodeTypesPath);
        if (nodeTypesNode != null) {
            Property resourceProperty;
            boolean needToRefreshSubgraph = false;
            if (configuration == null) {
                configuration = this.getConfigurationGraph();
            }
            if ((resourceProperty = nodeTypesNode.getProperty(ModeShapeLexicon.RESOURCE)) != null) {
                ClassLoader classLoader = this.context.getClassLoader(new String[0]);
                for (Object resourceValue : resourceProperty) {
                    String resources = this.context.getValueFactories().getStringFactory().create(resourceValue);
                    for (String resource : resources.split("\\s*,\\s*")) {
                        Graph.Batch batch = configuration.batch();
                        GraphBatchDestination destination = new GraphBatchDestination(batch);
                        Path nodeTypesAbsPath = pathFactory.create(repositoryPath, JcrLexicon.NODE_TYPES);
                        CndImporter importer = new CndImporter(destination, nodeTypesAbsPath, true, false);
                        InputStream is = IoUtil.getResourceAsStream(resource, classLoader, this.getClass());
                        SimpleProblems cndProblems = new SimpleProblems();
                        if (is == null) {
                            String msg = JcrI18n.unableToFindNodeTypeDefinitionsOnClasspathOrFileOrUrl.text(resource);
                            throw new RepositoryException(msg);
                        }
                        try {
                            this.logger().debug("Loading CND file at '{0}'", resource);
                            importer.importFrom(is, (Problems)cndProblems, resource);
                            this.logger().debug("Finished loading CND file at '{0}'", resource);
                            batch.execute();
                            this.logger().debug("Finished executing changes for node types found in CND file at '{0}'", resource);
                            needToRefreshSubgraph = true;
                        }
                        catch (IOException ioe) {
                            String msg = JcrI18n.errorLoadingNodeTypeDefintions.text(resource, ioe.getMessage());
                            throw new RepositoryException(msg, (Throwable)ioe);
                        }
                        if (cndProblems.isEmpty()) continue;
                        this.getProblems().addAll(cndProblems);
                        if (!cndProblems.hasErrors()) continue;
                        String msg = null;
                        Throwable cause = null;
                        for (Problem problem : cndProblems) {
                            if (problem.getStatus() != Problem.Status.ERROR) continue;
                            msg = problem.getMessageString();
                            cause = problem.getThrowable();
                            break;
                        }
                        throw new RepositoryException(JcrI18n.errorLoadingNodeTypeDefintions.text(resource, msg), cause);
                    }
                }
            }
            Set<NamespaceRegistry.Namespace> namespaces = configuration.getContext().getNamespaceRegistry().getNamespaces();
            this.logger().trace("Registring {0} namespaces found in CND files", namespaces.size());
            NamespaceRegistry repoRegistry = repository.getExecutionContext().getNamespaceRegistry();
            repoRegistry.register(namespaces);
            this.logger().trace("Completed registring {0} namespaces found in CND files", namespaces.size());
            Subgraph nodeTypesSubgraph = subgraph;
            if (needToRefreshSubgraph) {
                nodeTypesSubgraph = configuration.getSubgraphOfDepth(4).at(nodeTypesNode.getLocation().getPath());
            }
            this.logger().info(JcrI18n.registeringNodeTypesDefinedInConfiguration, repositoryName);
            repository.getRepositoryTypeManager().registerNodeTypes(nodeTypesSubgraph, nodeTypesNode.getLocation(), false, !needToRefreshSubgraph);
            this.logger().info(JcrI18n.completedRegisteringNodeTypesDefinedInConfiguration, repositoryName);
        }
        return repository;
    }

    protected final String readable(Name name) {
        return name.getString(this.context.getNamespaceRegistry());
    }

    protected final String readable(Path path) {
        return path.getString(this.context.getNamespaceRegistry());
    }

    protected final String readable(Location location) {
        return location.getString(this.context.getNamespaceRegistry());
    }

    protected final String string(Object value) {
        return this.context.getValueFactories().getStringFactory().create(value);
    }

    protected final boolean isTrue(Object value) {
        return this.context.getValueFactories().getBooleanFactory().create(value);
    }

    private String stringValueOf(Node node) {
        return node.getLocation().getPath().getLastSegment().getString(this.context.getNamespaceRegistry());
    }

    private String stringValueOf(Node node, Name propertyName) {
        Property property = node.getProperty(propertyName);
        if (property == null && (property = node.getProperty((Name)this.context.getValueFactories().getNameFactory().create(propertyName.getLocalName()))) == null) {
            return null;
        }
        if (property.isEmpty()) {
            return null;
        }
        return this.context.getValueFactories().getStringFactory().create(property.getFirstValue());
    }

    private String[] stringValuesOf(Node node, Name propertyName) {
        Property property = node.getProperty(propertyName);
        if (property == null && (property = node.getProperty((Name)this.context.getValueFactories().getNameFactory().create(propertyName.getLocalName()))) == null) {
            return null;
        }
        return this.context.getValueFactories().getStringFactory().create(property.getValuesAsArray());
    }

    public Map<String, Object> initDescriptors() {
        ValueFactories factories = this.getExecutionContext().getValueFactories();
        this.descriptors.put("jcr.specification.name", JcrEngine.valueFor(factories, JcrI18n.SPEC_NAME_DESC.text(new Object[0])));
        this.descriptors.put("jcr.specification.version", JcrEngine.valueFor(factories, "2.0"));
        if (!this.descriptors.containsKey("jcr.repository.name")) {
            this.descriptors.put("jcr.repository.name", JcrEngine.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.name", true)));
        }
        if (!this.descriptors.containsKey("jcr.repository.vendor")) {
            this.descriptors.put("jcr.repository.vendor", JcrEngine.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.vendor", true)));
        }
        if (!this.descriptors.containsKey("jcr.repository.vendor.url")) {
            this.descriptors.put("jcr.repository.vendor.url", JcrEngine.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.vendor.url", true)));
        }
        if (!this.descriptors.containsKey("jcr.repository.version")) {
            this.descriptors.put("jcr.repository.version", JcrEngine.valueFor(factories, this.getEngineVersion()));
        }
        return this.descriptors;
    }

    private static JcrValue valueFor(ValueFactories valueFactories, int type, Object value) {
        return new JcrValue(valueFactories, null, type, value);
    }

    private static JcrValue valueFor(ValueFactories valueFactories, String value) {
        return JcrEngine.valueFor(valueFactories, 1, value);
    }

    public void shutdownAndAwaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.shutdown();
        this.awaitTermination(timeout, unit);
        for (JcrRepositoryHolder repository : this.repositories.values()) {
            if (repository == null) continue;
            repository.terminateAllSessions();
        }
    }

    protected Logger getLogger() {
        return log;
    }

    protected Problems problems() {
        return this.problems;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RepositoryInitializer
    implements Callable<JcrRepository> {
        private final String repositoryName;
        private final CountDownLatch latch;

        protected RepositoryInitializer(String repositoryName) {
            this(repositoryName, null);
        }

        protected RepositoryInitializer(String repositoryName, CountDownLatch latch) {
            this.repositoryName = repositoryName;
            this.latch = latch;
        }

        @Override
        public JcrRepository call() throws Exception {
            JcrRepository repository = null;
            try {
                repository = JcrEngine.this.doCreateJcrRepository(this.repositoryName);
                JcrEngine.this.getLogger().info(JcrI18n.completedStartingRepository, this.repositoryName);
                JcrRepository jcrRepository = repository;
                return jcrRepository;
            }
            catch (RepositoryException t) {
                JcrEngine.this.problems().addError((Throwable)t, JcrI18n.errorStartingRepositoryCheckConfiguration, this.repositoryName, t.getMessage());
                throw t;
            }
            catch (Throwable t) {
                JcrEngine.this.problems().addError(t, JcrI18n.errorStartingRepositoryCheckConfiguration, this.repositoryName, t.getMessage());
                String msg = JcrI18n.errorStartingRepositoryCheckConfiguration.text(this.repositoryName, t.getMessage());
                throw new RepositoryException(msg, t);
            }
            finally {
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JcrRepositoryHolder {
        private final String repositoryName;
        private JcrRepository repository;
        private Future<JcrRepository> future;
        private Throwable error;

        protected JcrRepositoryHolder(String repositoryName, Future<JcrRepository> future) {
            this.repositoryName = repositoryName;
            this.future = future;
            assert (this.future != null);
        }

        public String getName() {
            return this.repositoryName;
        }

        public synchronized JcrRepository getRepository() throws RepositoryException {
            if (this.repository == null) {
                if (this.future != null) {
                    try {
                        this.repository = this.future.get();
                    }
                    catch (Throwable e) {
                        this.error = e.getCause();
                        String msg = JcrI18n.errorStartingRepositoryCheckConfiguration.text(this.repositoryName, this.error.getMessage());
                        throw new RepositoryException(msg, this.error);
                    }
                    finally {
                        this.future = null;
                    }
                }
                if (this.repository == null) {
                    String msg = JcrI18n.errorStartingRepositoryCheckConfiguration.text(this.repositoryName, this.error.getMessage());
                    throw new RepositoryException(msg, this.error);
                }
            }
            return this.repository;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() {
            if (this.future != null) {
                try {
                    this.future.cancel(false);
                }
                finally {
                    this.future = null;
                }
            }
            if (this.repository != null) {
                try {
                    this.repository.close();
                }
                finally {
                    this.repository = null;
                }
            }
        }

        public synchronized void terminateAllSessions() {
            if (this.repository != null) {
                this.repository.terminateAllSessions();
            }
        }

        public synchronized void cleanUpLocks() {
            if (this.repository != null) {
                try {
                    this.repository.getRepositoryLockManager().cleanUpLocks();
                }
                catch (Throwable t) {
                    JcrEngine.this.getLogger().error(t, JcrI18n.errorCleaningUpLocks, this.repository.getRepositorySourceName());
                }
            }
        }

        public String toString() {
            return this.repositoryName;
        }
    }
}

