/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.SessionCache;

@NotThreadSafe
final class JcrMultiValueProperty
extends AbstractJcrProperty {
    static final JcrValue[] EMPTY_VALUES = new JcrValue[0];

    JcrMultiValueProperty(SessionCache cache, AbstractJcrNode node, Name name) {
        super(cache, node, name);
    }

    public boolean isMultiple() {
        return true;
    }

    public boolean getBoolean() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public Calendar getDate() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public double getDouble() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public Node getNode() throws ValueFormatException, RepositoryException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public long getLength() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public long[] getLengths() throws RepositoryException {
        this.checkSession();
        Property dnaProperty = this.propertyInfo().getProperty();
        long[] lengths = new long[dnaProperty.size()];
        Iterator iter = dnaProperty.iterator();
        int ndx = 0;
        while (iter.hasNext()) {
            lengths[ndx] = this.createValue(iter.next()).getLength();
            ++ndx;
        }
        return lengths;
    }

    public long getLong() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public InputStream getStream() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public String getString() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public Value[] getValues() throws RepositoryException {
        this.checkSession();
        Property dnaProperty = this.propertyInfo().getProperty();
        Value[] values = new JcrValue[dnaProperty.size()];
        Iterator iter = dnaProperty.iterator();
        int ndx = 0;
        while (iter.hasNext()) {
            values[ndx] = this.createValue(iter.next());
            ++ndx;
        }
        return values;
    }

    public final void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkForLock();
        if (values == null) {
            this.remove();
            return;
        }
        this.checkSession();
        for (int i = 0; i < values.length; ++i) {
            JcrValue val = (JcrValue)values[i];
            if (val == null) continue;
            if (val.value() == null) {
                throw new ValueFormatException(JcrI18n.valueMayNotContainNull.text(this.getName()));
            }
            val.asType(this.getType());
        }
        this.editor().setProperty(this.name(), values, 0);
    }

    public final void setValue(String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkForLock();
        if (values == null) {
            this.remove();
            return;
        }
        this.checkSession();
        Value[] jcrValues = null;
        if (values.length != 0) {
            int numValues = values.length;
            ArrayList<JcrValue> valuesList = new ArrayList<JcrValue>(numValues);
            jcrValues = new JcrValue[numValues];
            for (int i = 0; i != numValues; ++i) {
                String value = values[i];
                if (value == null) continue;
                valuesList.add(this.createValue(values[i], 1).asType(this.getType()));
            }
            jcrValues = valuesList.isEmpty() ? EMPTY_VALUES : valuesList.toArray(new Value[valuesList.size()]);
        } else {
            jcrValues = EMPTY_VALUES;
        }
        this.editor().setProperty(this.name(), jcrValues, this.getType());
    }

    public Value getValue() throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(Value value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(String value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(InputStream value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(long value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(double value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(Calendar value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(boolean value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public final void setValue(Node value) throws ValueFormatException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public Binary getBinary() throws ValueFormatException, RepositoryException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public javax.jcr.Property getProperty() throws ValueFormatException, RepositoryException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public void setValue(BigDecimal value) throws ValueFormatException, RepositoryException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }

    public void setValue(Binary value) throws ValueFormatException, RepositoryException {
        throw new ValueFormatException(JcrI18n.invalidMethodForMultiValuedProperty.text(new Object[0]));
    }
}

