/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.version.OnParentVersionAction;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.SessionCache;

@NotThreadSafe
class JcrNode
extends AbstractJcrNode {
    JcrNode(SessionCache cache, GraphSession.NodeId nodeId, Location location) {
        super(cache, nodeId, location);
    }

    final boolean isRoot() {
        return false;
    }

    public int getIndex() throws RepositoryException {
        return this.segment().getIndex();
    }

    public String getName() throws RepositoryException {
        return this.segment().getName().getString(this.namespaces());
    }

    public AbstractJcrNode getParent() throws ItemNotFoundException, RepositoryException {
        this.checkSession();
        return this.parentNodeInfo().getPayload().getJcrNode();
    }

    public String getPath() throws RepositoryException {
        return this.path().getString(this.namespaces());
    }

    protected void doRemove() throws RepositoryException, LockException {
        NodeDefinition defn;
        int opv;
        Lock parentLock;
        AbstractJcrNode parentNode = this.getParent();
        if (parentNode.isLocked() && (parentLock = this.lockManager().getLock(parentNode)) != null && !parentLock.isLockOwningSession()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(this.location));
        }
        if (!parentNode.isCheckedOut() && (opv = (defn = this.getDefinition()).getOnParentVersion()) != 5) {
            String path = this.getPath();
            String opvStr = OnParentVersionAction.nameFromValue((int)opv);
            I18n msg = JcrI18n.cannotRemoveChildOnCheckedInNodeSinceOpvOfChildDefinitionIsNotIgnore;
            throw new VersionException(msg.text(path, defn.getName(), opvStr));
        }
        JcrNodeDefinition nodeDefn = this.cache.nodeTypes().getNodeDefinition(this.nodeInfo().getPayload().getDefinitionId());
        if (nodeDefn.isProtected()) {
            throw new ConstraintViolationException(JcrI18n.cannotRemoveItemWithProtectedDefinition.text(this.getPath()));
        }
        this.session().recordRemoval(this.locationToDestroy());
        this.doDestroy();
    }

    protected Location locationToDestroy() {
        return this.location;
    }

    protected void doDestroy() throws AccessDeniedException, RepositoryException {
        this.editor().destroy();
    }
}

