/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.jcr.JcrItemDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.RepositoryNodeTypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class JcrNodeDefinition
extends JcrItemDefinition
implements NodeDefinition {
    private final boolean allowsSameNameSiblings;
    private final Name defaultPrimaryTypeName;
    private volatile Map<Name, JcrNodeType> requiredPrimaryTypesByName;
    private volatile JcrNodeType[] requiredPrimaryTypes;
    private final Name[] requiredPrimaryTypeNames;
    private volatile NodeDefinitionId id;
    private final RepositoryNodeTypeManager nodeTypeManager;

    JcrNodeDefinition(ExecutionContext context, JcrNodeType declaringNodeType, Name name, int onParentVersion, boolean autoCreated, boolean mandatory, boolean protectedItem, boolean allowsSameNameSiblings, Name defaultPrimaryTypeName, Name[] requiredPrimaryTypeNames) {
        this(context, null, declaringNodeType, name, onParentVersion, autoCreated, mandatory, protectedItem, allowsSameNameSiblings, defaultPrimaryTypeName, requiredPrimaryTypeNames);
    }

    JcrNodeDefinition(ExecutionContext context, RepositoryNodeTypeManager nodeTypeManager, JcrNodeType declaringNodeType, Name name, int onParentVersion, boolean autoCreated, boolean mandatory, boolean protectedItem, boolean allowsSameNameSiblings, Name defaultPrimaryTypeName, Name[] requiredPrimaryTypeNames) {
        super(context, declaringNodeType, name, onParentVersion, autoCreated, mandatory, protectedItem);
        this.nodeTypeManager = nodeTypeManager;
        this.allowsSameNameSiblings = allowsSameNameSiblings;
        this.defaultPrimaryTypeName = defaultPrimaryTypeName;
        this.requiredPrimaryTypeNames = requiredPrimaryTypeNames;
        assert (this.requiredPrimaryTypeNames != null);
    }

    private final String string(Name name) {
        if (name == null) {
            return null;
        }
        if (this.context == null) {
            return name.getString();
        }
        return name.getString(this.context.getNamespaceRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureRequiredPrimaryTypesLoaded() {
        if (this.requiredPrimaryTypesByName != null) {
            return;
        }
        int numRequiredPrimaryTypeNames = this.requiredPrimaryTypeNames.length;
        JcrNodeType[] requiredPrimaryTypes = new JcrNodeType[numRequiredPrimaryTypeNames];
        for (int i = 0; i != numRequiredPrimaryTypeNames; ++i) {
            requiredPrimaryTypes[i] = this.nodeTypeManager.getNodeType(this.requiredPrimaryTypeNames[i]);
        }
        Map<Name, JcrNodeType> requiredPrimaryTypesByName = new HashMap();
        for (JcrNodeType requiredPrimaryType : requiredPrimaryTypes) {
            requiredPrimaryTypesByName.put(requiredPrimaryType.getInternalName(), requiredPrimaryType);
        }
        requiredPrimaryTypesByName = Collections.unmodifiableMap(requiredPrimaryTypesByName);
        JcrNodeDefinition jcrNodeDefinition = this;
        synchronized (jcrNodeDefinition) {
            if (this.requiredPrimaryTypes == null) {
                assert (this.requiredPrimaryTypesByName == null);
                this.requiredPrimaryTypes = requiredPrimaryTypes;
                this.requiredPrimaryTypesByName = requiredPrimaryTypesByName;
            }
        }
    }

    public NodeDefinitionId getId() {
        if (this.id == null) {
            this.id = new NodeDefinitionId(this.declaringNodeType.getInternalName(), this.name, this.requiredPrimaryTypeNames);
        }
        return this.id;
    }

    public boolean allowsSameNameSiblings() {
        return this.allowsSameNameSiblings;
    }

    final Name defaultPrimaryTypeName() {
        return this.defaultPrimaryTypeName;
    }

    public NodeType getDefaultPrimaryType() {
        if (this.defaultPrimaryTypeName == null) {
            return null;
        }
        return this.nodeTypeManager.getNodeType(this.defaultPrimaryTypeName);
    }

    public NodeType[] getRequiredPrimaryTypes() {
        this.ensureRequiredPrimaryTypesLoaded();
        if (this.requiredPrimaryTypes.length == 0) {
            NodeType[] result = new NodeType[]{this.nodeTypeManager.getNodeType(JcrNtLexicon.BASE)};
            return result;
        }
        NodeType[] result = new NodeType[this.requiredPrimaryTypes.length];
        for (int i = 0; i != this.requiredPrimaryTypes.length; ++i) {
            result[i] = this.requiredPrimaryTypes[i];
        }
        return result;
    }

    Name[] requiredPrimaryTypeNames() {
        return this.requiredPrimaryTypeNames;
    }

    Set<Name> requiredPrimaryTypeNameSet() {
        this.ensureRequiredPrimaryTypesLoaded();
        return this.requiredPrimaryTypesByName.keySet();
    }

    public String[] getRequiredPrimaryTypeNames() {
        Name[] requiredPrimaryTypeNames = this.requiredPrimaryTypeNames;
        String[] rptNames = new String[requiredPrimaryTypeNames.length];
        for (int i = 0; i < requiredPrimaryTypeNames.length; ++i) {
            rptNames[i] = this.string(requiredPrimaryTypeNames[i]);
        }
        return rptNames;
    }

    public String getDefaultPrimaryTypeName() {
        return this.string(this.defaultPrimaryTypeName);
    }

    final boolean allowsChildWithType(JcrNodeType childPrimaryType) {
        if (childPrimaryType == null) {
            return this.defaultPrimaryTypeName != null;
        }
        if (this.requiredPrimaryTypesByName == null) {
            boolean x = false;
        }
        this.ensureRequiredPrimaryTypesLoaded();
        if (this.requiredPrimaryTypesByName == null) {
            this.ensureRequiredPrimaryTypesLoaded();
        }
        for (Name requiredPrimaryTypeName : this.requiredPrimaryTypesByName.keySet()) {
            if (childPrimaryType.isNodeType(requiredPrimaryTypeName)) continue;
            return false;
        }
        return true;
    }

    JcrNodeDefinition with(JcrNodeType declaringNodeType) {
        return new JcrNodeDefinition(this.context, declaringNodeType.nodeTypeManager(), declaringNodeType, this.name, this.getOnParentVersion(), this.isAutoCreated(), this.isMandatory(), this.isProtected(), this.allowsSameNameSiblings(), this.defaultPrimaryTypeName, this.requiredPrimaryTypeNames);
    }

    JcrNodeDefinition with(ExecutionContext context) {
        return new JcrNodeDefinition(context, this.nodeTypeManager, this.declaringNodeType, this.name, this.getOnParentVersion(), this.isAutoCreated(), this.isMandatory(), this.isProtected(), this.allowsSameNameSiblings(), this.defaultPrimaryTypeName, this.requiredPrimaryTypeNames);
    }

    JcrNodeDefinition with(RepositoryNodeTypeManager nodeTypeManager) {
        return new JcrNodeDefinition(this.context, nodeTypeManager, this.declaringNodeType, this.name, this.getOnParentVersion(), this.isAutoCreated(), this.isMandatory(), this.isProtected(), this.allowsSameNameSiblings(), this.defaultPrimaryTypeName, this.requiredPrimaryTypeNames);
    }

    public int hashCode() {
        return this.getId().toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JcrNodeDefinition other = (JcrNodeDefinition)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        ValueFactory<String> strings = this.context.getValueFactories().getStringFactory();
        StringBuilder sb = new StringBuilder();
        NodeDefinitionId id = this.getId();
        sb.append(strings.create(id.getNodeTypeName()));
        sb.append('/');
        sb.append(strings.create(id.getChildDefinitionName()));
        if (id.hasRequiredPrimaryTypes()) {
            sb.append(" (required primary types = [");
            boolean first = true;
            for (Name requiredPrimaryType : id.getRequiredPrimaryTypes()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(requiredPrimaryType.getString());
            }
            sb.append("])");
        }
        return sb.toString();
    }
}

