/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.AbstractJcrNode;

class JcrSingleNodeIterator
implements NodeIterator {
    private final long size;
    private final Iterator<AbstractJcrNode> iterator;

    protected JcrSingleNodeIterator(AbstractJcrNode singleNode) {
        assert (singleNode != null);
        this.iterator = Collections.singleton(singleNode).iterator();
        this.size = 1L;
    }

    public Node nextNode() {
        return this.iterator.next();
    }

    public long getPosition() {
        return 0L;
    }

    public long getSize() {
        return this.size;
    }

    public void skip(long skipNum) {
        CheckArg.isNonNegative(skipNum, "skipNum");
        if (skipNum == 0L) {
            return;
        }
        throw new NoSuchElementException();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.iterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

