/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ReferenceFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.jcr.JcrBinary;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.SessionCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JcrValueFactory
implements javax.jcr.ValueFactory {
    private static final JcrValue[] EMPTY_ARRAY = new JcrValue[0];
    private final ValueFactories valueFactories;
    private final SessionCache sessionCache;
    private final NamespaceRegistry namespaces;

    protected JcrValueFactory(JcrSession session) {
        this.valueFactories = session.getExecutionContext().getValueFactories();
        this.sessionCache = session.cache();
        this.namespaces = session.namespaces();
    }

    public JcrValue[] createValues(List<?> values, int propertyType) throws javax.jcr.ValueFormatException {
        CheckArg.isNotNull(values, "values");
        int size = values.size();
        if (size == 0) {
            return EMPTY_ARRAY;
        }
        JcrValue[] jcrValues = new JcrValue[size];
        int count = 0;
        ValueFactory<?> valueFactory = this.valueFactoryFor(propertyType);
        for (Object value : values) {
            try {
                Object objectValue = valueFactory.create(value);
                jcrValues[count++] = new JcrValue(this.valueFactories, this.sessionCache, propertyType, objectValue);
            }
            catch (ValueFormatException vfe) {
                throw new javax.jcr.ValueFormatException((Throwable)vfe);
            }
        }
        return jcrValues;
    }

    public JcrValue createValue(String value, int propertyType) throws javax.jcr.ValueFormatException {
        CheckArg.isNotNull(value, "value");
        return new JcrValue(this.valueFactories, this.sessionCache, propertyType, this.convertValueToType(value, propertyType));
    }

    public JcrValue createValue(Node value) throws RepositoryException {
        if (!value.isNodeType(JcrMixLexicon.REFERENCEABLE.getString(this.namespaces))) {
            throw new RepositoryException(JcrI18n.nodeNotReferenceable.text(new Object[0]));
        }
        Reference ref = (Reference)this.valueFactories.getReferenceFactory().create(value.getIdentifier());
        return new JcrValue(this.valueFactories, this.sessionCache, 9, ref);
    }

    public JcrValue createValue(Node value, boolean weak) throws RepositoryException {
        if (!value.isNodeType(JcrMixLexicon.REFERENCEABLE.getString(this.namespaces))) {
            throw new RepositoryException(JcrI18n.nodeNotReferenceable.text(new Object[0]));
        }
        ReferenceFactory factory = weak ? this.valueFactories.getWeakReferenceFactory() : this.valueFactories.getReferenceFactory();
        int refType = weak ? 10 : 9;
        Reference ref = (Reference)factory.create(value.getIdentifier());
        return new JcrValue(this.valueFactories, this.sessionCache, refType, ref);
    }

    public JcrValue createValue(javax.jcr.Binary value) {
        return new JcrValue(this.valueFactories, this.sessionCache, 2, value);
    }

    public JcrValue createValue(InputStream value) {
        Binary binary = (Binary)this.valueFactories.getBinaryFactory().create(value);
        return new JcrValue(this.valueFactories, this.sessionCache, 2, binary);
    }

    public JcrBinary createBinary(InputStream value) {
        Binary binary = (Binary)this.valueFactories.getBinaryFactory().create(value);
        return new JcrBinary(binary);
    }

    public JcrValue createValue(Calendar value) {
        DateTime dateTime = (DateTime)this.valueFactories.getDateFactory().create(value);
        return new JcrValue(this.valueFactories, this.sessionCache, 5, dateTime);
    }

    public JcrValue createValue(boolean value) {
        return new JcrValue(this.valueFactories, this.sessionCache, 6, value);
    }

    public JcrValue createValue(double value) {
        return new JcrValue(this.valueFactories, this.sessionCache, 4, value);
    }

    public JcrValue createValue(long value) {
        return new JcrValue(this.valueFactories, this.sessionCache, 3, value);
    }

    public JcrValue createValue(String value) {
        return new JcrValue(this.valueFactories, this.sessionCache, 1, value);
    }

    public JcrValue createValue(BigDecimal value) {
        return new JcrValue(this.valueFactories, this.sessionCache, 12, value);
    }

    protected ValueFactory<?> valueFactoryFor(int jcrPropertyType) {
        switch (jcrPropertyType) {
            case 6: {
                return this.valueFactories.getBooleanFactory();
            }
            case 5: {
                return this.valueFactories.getDateFactory();
            }
            case 7: {
                return this.valueFactories.getNameFactory();
            }
            case 8: {
                return this.valueFactories.getPathFactory();
            }
            case 9: 
            case 10: {
                return this.valueFactories.getReferenceFactory();
            }
            case 4: {
                return this.valueFactories.getDoubleFactory();
            }
            case 3: {
                return this.valueFactories.getLongFactory();
            }
            case 12: {
                return this.valueFactories.getDecimalFactory();
            }
            case 11: {
                return this.valueFactories.getUriFactory();
            }
            case 2: {
                return this.valueFactories.getBinaryFactory();
            }
            case 1: {
                return this.valueFactories.getStringFactory();
            }
            case 0: {
                return this.valueFactories.getObjectFactory();
            }
        }
        assert (false) : "Unexpected JCR property type " + jcrPropertyType;
        throw new IllegalStateException("Invalid property type " + jcrPropertyType);
    }

    protected Object convertValueToType(Object value, int toType) throws javax.jcr.ValueFormatException {
        try {
            return this.valueFactoryFor(toType).create(value);
        }
        catch (ValueFormatException vfe) {
            throw new javax.jcr.ValueFormatException((Throwable)vfe);
        }
    }
}

