/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.LockFailedException;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrGraph;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.RepositoryLockManager;
import org.modeshape.jcr.SessionCache;

@ThreadSafe
class WorkspaceLockManager {
    private final ExecutionContext context;
    private final Path locksPath;
    private final RepositoryLockManager repositoryLockManager;
    private final String workspaceName;
    private final ConcurrentMap<UUID, ModeShapeLock> workspaceLocksByNodeUuid;

    WorkspaceLockManager(ExecutionContext context, RepositoryLockManager repositoryLockManager, String workspaceName, Path locksPath) {
        this.context = context;
        this.repositoryLockManager = repositoryLockManager;
        this.workspaceName = workspaceName;
        this.locksPath = locksPath;
        this.workspaceLocksByNodeUuid = new ConcurrentHashMap<UUID, ModeShapeLock>();
    }

    ModeShapeLock lock(JcrSession session, Location nodeLocation, boolean isDeep, boolean isSessionScoped) throws RepositoryException {
        assert (nodeLocation != null);
        UUID lockUuid = UUID.randomUUID();
        UUID nodeUuid = this.uuidFor(session, nodeLocation);
        if (nodeUuid == null) {
            throw new RepositoryException(JcrI18n.uuidRequiredForLock.text(nodeLocation));
        }
        ExecutionContext sessionContext = session.getExecutionContext();
        String lockOwner = session.getUserID();
        DateTimeFactory dateFactory = sessionContext.getValueFactories().getDateFactory();
        DateTime expirationDate = dateFactory.create();
        expirationDate = expirationDate.plusMillis(60000);
        this.lockNodeInSystemGraph(sessionContext, nodeUuid, lockUuid, this.workspaceName, isSessionScoped, isDeep, session.sessionId(), session.getUserID(), expirationDate);
        try {
            this.lockNodeInRepository(session, nodeUuid, session.getUserID(), isDeep);
        }
        catch (LockFailedException lfe) {
            this.unlockNodeInSystemGraph(session.getExecutionContext(), nodeUuid);
            throw new RepositoryException((Throwable)lfe);
        }
        ModeShapeLock lock = this.lockNodeInternally(lockOwner, lockUuid, nodeUuid, isDeep, isSessionScoped);
        session.cache().refreshProperties(Location.create(nodeUuid));
        return lock;
    }

    ModeShapeLock lockNodeInternally(String lockOwner, UUID lockUuid, UUID lockedNodeUuid, boolean isDeep, boolean isSessionScoped) {
        ModeShapeLock lock = this.createLock(lockOwner, lockUuid, lockedNodeUuid, isDeep, isSessionScoped);
        this.workspaceLocksByNodeUuid.put(lockedNodeUuid, lock);
        return lock;
    }

    ModeShapeLock createLock(org.modeshape.graph.Node lockNode) {
        return new ModeShapeLock(lockNode);
    }

    ModeShapeLock createLock(String lockOwner, UUID lockUuid, UUID nodeUuid, boolean isDeep, boolean isSessionScoped) {
        return new ModeShapeLock(lockOwner, lockUuid, nodeUuid, isDeep, isSessionScoped);
    }

    void lockNodeInRepository(JcrSession session, UUID nodeUuid, String lockOwner, boolean isDeep) throws LockFailedException, RepositoryException {
        PropertyFactory propFactory = session.getExecutionContext().getPropertyFactory();
        Property lockOwnerProp = propFactory.create(JcrLexicon.LOCK_OWNER, lockOwner);
        Property lockIsDeepProp = propFactory.create(JcrLexicon.LOCK_IS_DEEP, isDeep);
        Graph.Batch workspaceBatch = this.repositoryLockManager.createWorkspaceGraph(this.workspaceName, session.getExecutionContext()).batch();
        workspaceBatch.set(lockOwnerProp, lockIsDeepProp).on(nodeUuid);
        if (isDeep) {
            workspaceBatch.lock(nodeUuid).andItsDescendants().withDefaultTimeout();
        } else {
            workspaceBatch.lock(nodeUuid).only().withDefaultTimeout();
        }
        workspaceBatch.execute();
    }

    private final void lockNodeInSystemGraph(ExecutionContext sessionContext, UUID nodeUuid, UUID lockUuid, String workspaceName, boolean isSessionScoped, boolean lockIsDeep, String sessionId, String lockOwner, DateTime expirationDate) {
        PathFactory pathFactory = sessionContext.getValueFactories().getPathFactory();
        PropertyFactory propFactory = sessionContext.getPropertyFactory();
        JcrGraph graph = this.repositoryLockManager.createSystemGraph(sessionContext);
        graph.create(pathFactory.create(this.locksPath, pathFactory.createSegment(lockUuid.toString())), propFactory.create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.LOCK), propFactory.create(ModeShapeLexicon.WORKSPACE, workspaceName), propFactory.create(ModeShapeLexicon.LOCKED_UUID, nodeUuid.toString()), propFactory.create(ModeShapeLexicon.IS_SESSION_SCOPED, isSessionScoped), propFactory.create(ModeShapeLexicon.LOCKING_SESSION, sessionId), propFactory.create(ModeShapeLexicon.EXPIRATION_DATE, expirationDate), propFactory.create(ModeShapeLexicon.IS_HELD_BY_SESSION, false), propFactory.create(JcrLexicon.LOCK_OWNER, lockOwner), propFactory.create(JcrLexicon.LOCK_IS_DEEP, lockIsDeep)).ifAbsent().and();
    }

    void unlock(ExecutionContext sessionExecutionContext, ModeShapeLock lock) {
        try {
            this.unlockNodeInSystemGraph(sessionExecutionContext, lock.getUuid());
            this.unlockNodeInRepository(sessionExecutionContext, lock);
            this.unlockNodeInternally(lock.nodeUuid);
        }
        catch (PathNotFoundException pnfe) {
            if (!lock.nodeUuid.equals(pnfe.getLocation().getUuid())) {
                throw new IllegalStateException(pnfe);
            }
            this.workspaceLocksByNodeUuid.remove(lock.nodeUuid);
        }
    }

    void unlockNodeInRepository(ExecutionContext sessionExecutionContext, ModeShapeLock lock) {
        Graph.Batch workspaceBatch = this.repositoryLockManager.createWorkspaceGraph(this.workspaceName, sessionExecutionContext).batch();
        workspaceBatch.remove(JcrLexicon.LOCK_OWNER, JcrLexicon.LOCK_IS_DEEP).on(lock.nodeUuid);
        workspaceBatch.unlock(lock.nodeUuid);
        workspaceBatch.execute();
    }

    void unlockNodeInSystemGraph(ExecutionContext sessionExecutionContext, UUID lockUuid) {
        PathFactory pathFactory = sessionExecutionContext.getValueFactories().getPathFactory();
        JcrGraph systemGraph = this.repositoryLockManager.createSystemGraph(sessionExecutionContext);
        systemGraph.delete(pathFactory.create(this.locksPath, pathFactory.createSegment(lockUuid.toString())));
    }

    boolean unlockNodeInternally(UUID lockedNodeUuid) {
        return this.workspaceLocksByNodeUuid.remove(lockedNodeUuid) != null;
    }

    boolean isHeldBySession(JcrSession session, String lockToken) throws LockException {
        assert (lockToken != null);
        ExecutionContext context = session.getExecutionContext();
        ValueFactory<Boolean> booleanFactory = context.getValueFactories().getBooleanFactory();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        try {
            org.modeshape.graph.Node lockNode = this.repositoryLockManager.createSystemGraph(context).getNodeAt(pathFactory.create(this.locksPath, pathFactory.createSegment(lockToken)));
            return booleanFactory.create(lockNode.getProperty(ModeShapeLexicon.IS_HELD_BY_SESSION).getFirstValue());
        }
        catch (PathNotFoundException pnfe) {
            I18n msg = JcrI18n.invalidLockToken;
            throw new LockException(msg.text(lockToken));
        }
    }

    void setHeldBySession(JcrSession session, String lockToken, boolean value) {
        assert (lockToken != null);
        ExecutionContext context = session.getExecutionContext();
        PropertyFactory propFactory = context.getPropertyFactory();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        this.repositoryLockManager.createSystemGraph(context).set(propFactory.create(ModeShapeLexicon.IS_HELD_BY_SESSION, value)).on(pathFactory.create(this.locksPath, pathFactory.createSegment(lockToken)));
    }

    ModeShapeLock lockFor(String lockToken) {
        for (ModeShapeLock lock : this.workspaceLocksByNodeUuid.values()) {
            if (!lockToken.equals(lock.getLockToken())) continue;
            return lock;
        }
        return null;
    }

    ModeShapeLock lockFor(JcrSession session, Location nodeLocation) {
        UUID nodeUuid = this.uuidFor(session, nodeLocation);
        return this.lockFor(nodeUuid);
    }

    ModeShapeLock lockFor(UUID nodeUuid) {
        if (nodeUuid == null) {
            return null;
        }
        return (ModeShapeLock)this.workspaceLocksByNodeUuid.get(nodeUuid);
    }

    UUID uuidFor(JcrSession session, Location location) {
        assert (location != null);
        if (location.getUuid() != null) {
            return location.getUuid();
        }
        Property uuidProp = location.getIdProperty(JcrLexicon.UUID);
        if (uuidProp == null) {
            return null;
        }
        ExecutionContext context = session.getExecutionContext();
        return (UUID)context.getValueFactories().getUuidFactory().create(uuidProp.getFirstValue());
    }

    void cleanLocks(JcrSession session) {
        ExecutionContext context = session.getExecutionContext();
        Set<String> lockTokens = session.lockManager().lockTokens();
        for (String lockToken : lockTokens) {
            ModeShapeLock lock = this.lockFor(lockToken);
            if (lock == null || !lock.isSessionScoped()) continue;
            this.unlock(context, lock);
        }
    }

    @ThreadSafe
    public class ModeShapeLock {
        final UUID nodeUuid;
        private final UUID lockUuid;
        private final String lockOwner;
        private final boolean deep;
        private final boolean sessionScoped;

        ModeShapeLock(org.modeshape.graph.Node lockNode) {
            ValueFactory<String> stringFactory = WorkspaceLockManager.this.context.getValueFactories().getStringFactory();
            UuidFactory uuidFactory = WorkspaceLockManager.this.context.getValueFactories().getUuidFactory();
            ValueFactory<Boolean> booleanFactory = WorkspaceLockManager.this.context.getValueFactories().getBooleanFactory();
            assert (lockNode.getLocation().getPath() != null);
            String lockUuidAsString = lockNode.getLocation().getPath().getLastSegment().getName().getLocalName();
            Property lockOwnerProperty = lockNode.getProperty(JcrLexicon.LOCK_OWNER);
            Property nodeUuidProperty = lockNode.getProperty(ModeShapeLexicon.LOCKED_UUID);
            Property lockIsDeepProperty = lockNode.getProperty(JcrLexicon.LOCK_IS_DEEP);
            Property isSessionScopedProperty = lockNode.getProperty(ModeShapeLexicon.IS_SESSION_SCOPED);
            assert (lockUuidAsString != null);
            assert (lockOwnerProperty != null);
            assert (nodeUuidProperty != null);
            assert (lockIsDeepProperty != null);
            assert (isSessionScopedProperty != null);
            this.lockOwner = stringFactory.create(lockOwnerProperty.getFirstValue());
            this.lockUuid = UUID.fromString(lockUuidAsString);
            this.nodeUuid = (UUID)uuidFactory.create(nodeUuidProperty.getFirstValue());
            this.deep = booleanFactory.create(lockIsDeepProperty.getFirstValue());
            this.sessionScoped = booleanFactory.create(isSessionScopedProperty.getFirstValue());
        }

        ModeShapeLock(String lockOwner, UUID lockUuid, UUID nodeUuid, boolean deep, boolean sessionScoped) {
            this.lockOwner = lockOwner;
            this.lockUuid = lockUuid;
            this.nodeUuid = nodeUuid;
            this.deep = deep;
            this.sessionScoped = sessionScoped;
        }

        public boolean isLive() {
            return WorkspaceLockManager.this.workspaceLocksByNodeUuid.containsKey(this.nodeUuid);
        }

        public UUID getUuid() {
            return this.lockUuid;
        }

        public boolean isDeep() {
            return this.deep;
        }

        public String getLockOwner() {
            return this.lockOwner;
        }

        public boolean isSessionScoped() {
            return this.sessionScoped;
        }

        public String getLockToken() {
            return this.lockUuid.toString();
        }

        public Lock lockFor(SessionCache cache) throws RepositoryException {
            final AbstractJcrNode node = cache.findJcrNode(Location.create(this.nodeUuid));
            final JcrSession session = cache.session();
            return new Lock(){

                public String getLockOwner() {
                    return ModeShapeLock.this.lockOwner;
                }

                public String getLockToken() {
                    if (ModeShapeLock.this.sessionScoped) {
                        return null;
                    }
                    String uuidString = ModeShapeLock.this.lockUuid.toString();
                    return session.lockManager().lockTokens().contains(uuidString) ? uuidString : null;
                }

                public Node getNode() {
                    return node;
                }

                public boolean isDeep() {
                    return ModeShapeLock.this.deep;
                }

                public boolean isLive() {
                    return WorkspaceLockManager.this.workspaceLocksByNodeUuid.containsKey(ModeShapeLock.this.nodeUuid);
                }

                public boolean isSessionScoped() {
                    return ModeShapeLock.this.sessionScoped;
                }

                public void refresh() throws LockException {
                    String uuidString = ModeShapeLock.this.lockUuid.toString();
                    if (!session.lockManager().lockTokens().contains(uuidString)) {
                        throw new LockException(JcrI18n.notLocked.text(node.location));
                    }
                }

                public long getSecondsRemaining() {
                    return this.isLockOwningSession() ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                }

                public boolean isLockOwningSession() {
                    String uuidString = ModeShapeLock.this.lockUuid.toString();
                    return session.lockManager().lockTokens().contains(uuidString);
                }
            };
        }
    }
}

