/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.LinkedList;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.Between;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.EquiJoinCondition;
import org.modeshape.graph.query.model.FullTextSearchScore;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.NodeDepth;
import org.modeshape.graph.query.model.NodeLocalName;
import org.modeshape.graph.query.model.NodeName;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.Not;
import org.modeshape.graph.query.model.Or;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.SameNodeJoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.SetCriteria;
import org.modeshape.graph.query.optimize.OptimizerRule;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.jcr.JcrI18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class RewritePseudoColumns
implements OptimizerRule {
    public static final RewritePseudoColumns INSTANCE = new RewritePseudoColumns();

    @Override
    public PlanNode execute(QueryContext context, PlanNode plan, LinkedList<OptimizerRule> ruleStack) {
        for (PlanNode join : plan.findAllAtOrBelow(PlanNode.Traversal.PRE_ORDER, PlanNode.Type.JOIN)) {
            Constraint constraint;
            Constraint newConstraint;
            JoinCondition condition = join.getProperty(PlanNode.Property.JOIN_CONDITION, JoinCondition.class);
            JoinCondition newCondition = this.rewrite(context, condition);
            if (newCondition != condition) {
                join.setProperty(PlanNode.Property.JOIN_CONDITION, newCondition);
            }
            if ((newConstraint = this.rewrite(context, constraint = join.getProperty(PlanNode.Property.JOIN_CONSTRAINTS, Constraint.class))) == constraint) continue;
            join.setProperty(PlanNode.Property.JOIN_CONSTRAINTS, newConstraint);
        }
        for (PlanNode node : plan.findAllAtOrBelow(PlanNode.Traversal.PRE_ORDER, PlanNode.Type.SELECT)) {
            Constraint constraint = node.getProperty(PlanNode.Property.SELECT_CRITERIA, Constraint.class);
            Constraint newConstraint = this.rewrite(context, constraint);
            if (newConstraint == constraint) continue;
            node.setProperty(PlanNode.Property.SELECT_CRITERIA, newConstraint);
        }
        return plan;
    }

    protected JoinCondition rewrite(QueryContext context, JoinCondition condition) {
        if (condition instanceof EquiJoinCondition) {
            EquiJoinCondition equiJoin = (EquiJoinCondition)condition;
            if ("jcr:path".equals(equiJoin.property1Name())) {
                SelectorName selector1 = equiJoin.selector1Name();
                SelectorName selector2 = equiJoin.selector2Name();
                if ("jcr:path".equals(equiJoin.property2Name())) {
                    return new SameNodeJoinCondition(selector1, selector2);
                }
                context.getProblems().addError(JcrI18n.equiJoinWithOneJcrPathPseudoColumnIsInvalid, selector1, selector2);
            } else if ("jcr:path".equals(equiJoin.property2Name())) {
                SelectorName selector1 = equiJoin.selector1Name();
                SelectorName selector2 = equiJoin.selector2Name();
                context.getProblems().addError(JcrI18n.equiJoinWithOneJcrPathPseudoColumnIsInvalid, selector1, selector2);
            }
        }
        return condition;
    }

    protected Constraint rewrite(QueryContext context, Constraint constraint) {
        PropertyExistence exist;
        String property;
        if (constraint instanceof Comparison) {
            Comparison comparison = (Comparison)constraint;
            DynamicOperand operand = comparison.operand1();
            DynamicOperand newOperand = this.rewrite(context, operand);
            if (newOperand != operand) {
                return new Comparison(newOperand, comparison.operator(), comparison.operand2());
            }
        } else if (constraint instanceof And) {
            And and = (And)constraint;
            Constraint left = and.left();
            Constraint right = and.right();
            Constraint newLeft = this.rewrite(context, left);
            Constraint newRight = this.rewrite(context, right);
            if (newLeft != left || newRight != right) {
                return new And(newLeft, newRight);
            }
        } else if (constraint instanceof Or) {
            Or or = (Or)constraint;
            Constraint left = or.left();
            Constraint right = or.right();
            Constraint newLeft = this.rewrite(context, left);
            Constraint newRight = this.rewrite(context, right);
            if (newLeft != left || newRight != right) {
                return new Or(newLeft, newRight);
            }
        } else if (constraint instanceof Not) {
            Constraint newInner;
            Not not = (Not)constraint;
            Constraint oldInner = not.constraint();
            if (oldInner != (newInner = this.rewrite(context, oldInner))) {
                return new Not(newInner);
            }
        } else if (constraint instanceof Between) {
            Between between = (Between)constraint;
            DynamicOperand operand = between.operand();
            DynamicOperand newOperand = this.rewrite(context, operand);
            if (newOperand != operand) {
                return new Between(newOperand, between.lowerBound(), between.upperBound(), between.isLowerBoundIncluded(), between.isUpperBoundIncluded());
            }
        } else if (constraint instanceof SetCriteria) {
            SetCriteria set = (SetCriteria)constraint;
            DynamicOperand operand = set.leftOperand();
            DynamicOperand newOperand = this.rewrite(context, operand);
            if (newOperand != operand) {
                return new SetCriteria(newOperand, set.rightOperands());
            }
        } else if (constraint instanceof PropertyExistence && ("jcr:path".equals(property = (exist = (PropertyExistence)constraint).propertyName()) || "jcr:name".equals(property) || "mode:localName".equals(property) || "jcr:localName".equals(property) || "mode:depth".equals(property) || "jcr:depth".equals(property) || "jcr:score".equals(property))) {
            return new PropertyExistence(exist.selectorName(), "jcr:primaryType");
        }
        return constraint;
    }

    protected DynamicOperand rewrite(QueryContext context, DynamicOperand operand) {
        if (operand instanceof PropertyValue) {
            PropertyValue propValue = (PropertyValue)operand;
            String property = propValue.propertyName();
            if ("jcr:path".equals(property)) {
                return new NodePath(propValue.selectorName());
            }
            if ("jcr:name".equals(property)) {
                return new NodeName(propValue.selectorName());
            }
            if ("mode:localName".equals(property) || "jcr:localName".equals(property)) {
                return new NodeLocalName(propValue.selectorName());
            }
            if ("mode:depth".equals(property) || "jcr:depth".equals(property)) {
                return new NodeDepth(propValue.selectorName());
            }
            if ("jcr:score".equals(property)) {
                return new FullTextSearchScore(propValue.selectorName());
            }
        }
        return operand;
    }
}

