/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import javax.jcr.Value;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.Visitable;
import org.modeshape.graph.query.model.Visitors;
import org.modeshape.jcr.query.qom.JcrLiteral;

public class Visitors
extends org.modeshape.graph.query.model.Visitors {
    protected static final char OPEN_SQUARE = '[';
    protected static final char CLOSE_SQUARE = ']';
    protected static final char DOUBLE_QUOTE = '\"';
    protected static final char SINGLE_QUOTE = '\'';

    public static String readable(Visitable visitable) {
        return Visitors.visit(visitable, new JcrSql2Writer(DEFAULT_CONTEXT)).getString();
    }

    public static String readable(Visitable visitable, ExecutionContext context) {
        return Visitors.visit(visitable, new JcrSql2Writer(context)).getString();
    }

    public static class JcrSql2Writer
    extends Visitors.JcrSql2Writer {
        public JcrSql2Writer(ExecutionContext context) {
            super(context);
        }

        protected JcrSql2Writer append(String string) {
            return (JcrSql2Writer)super.append(string);
        }

        public void visit(Literal literal) {
            if (literal instanceof JcrLiteral) {
                JcrLiteral literalValue = (JcrLiteral)literal;
                Value value = literalValue.getLiteralValue();
                String typeName = null;
                ValueFactories factories = this.context.getValueFactories();
                switch (value.getType()) {
                    case 0: 
                    case 1: {
                        this.append('\'');
                        String str = factories.getStringFactory().create(literalValue.value());
                        this.append(str);
                        this.append('\'');
                        return;
                    }
                    case 8: {
                        this.append("CAST(");
                        this.append((Path)factories.getPathFactory().create(literalValue.value()));
                        this.append(" AS ").append("Path".toUpperCase()).append(')');
                        return;
                    }
                    case 7: {
                        this.append("CAST(");
                        this.append((Name)factories.getNameFactory().create(literalValue.value()));
                        this.append(" AS ").append("Name".toUpperCase()).append(')');
                        return;
                    }
                    case 9: {
                        typeName = "Reference";
                        break;
                    }
                    case 10: {
                        typeName = "WeakReference";
                        break;
                    }
                    case 2: {
                        typeName = "Binary";
                        break;
                    }
                    case 6: {
                        typeName = "Boolean";
                        break;
                    }
                    case 5: {
                        typeName = "Date";
                        break;
                    }
                    case 12: {
                        typeName = "Decimal";
                        break;
                    }
                    case 4: {
                        typeName = "Double";
                        break;
                    }
                    case 3: {
                        typeName = "Long";
                        break;
                    }
                    case 11: {
                        typeName = "URI";
                    }
                }
                assert (typeName != null);
                String str = factories.getStringFactory().create(literalValue.value());
                this.append("CAST('").append(str).append("' AS ").append(typeName.toUpperCase()).append(')');
            } else {
                super.visit(literal);
            }
        }
    }
}

