/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.security;

import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Credentials;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.security.AuthenticationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationProviders
implements AuthenticationProvider {
    private final List<AuthenticationProvider> providers;

    public AuthenticationProviders() {
        this.providers = new CopyOnWriteArrayList<AuthenticationProvider>();
    }

    public AuthenticationProviders(List<AuthenticationProvider> providers) {
        this.providers = new CopyOnWriteArrayList<AuthenticationProvider>(providers);
    }

    public AuthenticationProviders(AuthenticationProvider ... providers) {
        this.providers = new CopyOnWriteArrayList<AuthenticationProvider>(providers);
    }

    @Override
    public ExecutionContext authenticate(Credentials credentials, String repositoryName, String workspaceName, ExecutionContext repositoryContext, Map<String, Object> sessionAttributes) {
        ExecutionContext result = null;
        for (AuthenticationProvider provider : this.providers) {
            try {
                sessionAttributes.clear();
                result = provider.authenticate(credentials, repositoryName, workspaceName, repositoryContext, sessionAttributes);
                if (result == null) continue;
                return result;
            }
            catch (Exception e) {
                if (e instanceof PrivilegedActionException) {
                    e = ((PrivilegedActionException)e).getException();
                }
                Logger.getLogger(AuthenticationProviders.class).warn(e, JcrI18n.mustBeInPrivilegedAction, repositoryName, workspaceName, provider.getClass().getName());
            }
        }
        return null;
    }

    public AuthenticationProviders with(AuthenticationProvider provider) {
        CopyOnWriteArrayList<AuthenticationProvider> providers = new CopyOnWriteArrayList<AuthenticationProvider>(this.providers);
        providers.add(provider);
        return new AuthenticationProviders(providers);
    }

    public static AuthenticationProviders with(AuthenticationProvider ... providers) {
        CopyOnWriteArrayList<AuthenticationProvider> providerList = new CopyOnWriteArrayList<AuthenticationProvider>();
        for (AuthenticationProvider provider : providers) {
            if (provider == null) continue;
            providerList.add(provider);
        }
        return new AuthenticationProviders(providerList);
    }
}

