/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.xpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.query.QueryBuilder;
import org.modeshape.graph.query.model.AllNodes;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.Query;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.parse.InvalidQueryException;
import org.modeshape.jcr.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathToQueryTranslator {
    protected static final Map<XPath.NameTest, String> CAST_FUNCTION_NAME_TO_TYPE;
    private final String query;
    private final TypeSystem typeSystem;
    private final QueryBuilder builder;
    private final Set<String> aliases = new HashSet<String>();

    public XPathToQueryTranslator(TypeSystem context, String query) {
        this.query = query;
        this.typeSystem = context;
        this.builder = new QueryBuilder(this.typeSystem);
    }

    public QueryCommand createQuery(XPath.Component xpath) {
        if (xpath instanceof XPath.BinaryComponent) {
            XPath.BinaryComponent binary = (XPath.BinaryComponent)xpath;
            if (binary instanceof XPath.Union) {
                this.createQuery(binary.getLeft());
                this.builder.union();
                this.createQuery(binary.getRight());
                return this.builder.query();
            }
            if (binary instanceof XPath.Intersect) {
                this.createQuery(binary.getLeft());
                this.builder.intersect();
                this.createQuery(binary.getRight());
                return this.builder.query();
            }
            if (binary instanceof XPath.Except) {
                this.createQuery(binary.getLeft());
                this.builder.except();
                this.createQuery(binary.getRight());
                return this.builder.query();
            }
        } else if (xpath instanceof XPath.PathExpression) {
            this.translate((XPath.PathExpression)xpath);
            return this.builder.query();
        }
        throw new InvalidQueryException(this.query, "Acceptable XPath queries must lead with a path expression or must be a union, intersect or except");
    }

    protected void translate(XPath.PathExpression pathExpression) {
        Query query;
        XPath.Component first;
        List<XPath.StepExpression> steps = pathExpression.getSteps();
        assert (!steps.isEmpty());
        if (!pathExpression.isRelative() && !((first = steps.get(0).collapse()) instanceof XPath.DescendantOrSelf)) {
            if (first instanceof XPath.NameTest && steps.size() == 1 && ((XPath.NameTest)first).matches("jcr", "root")) {
                steps = steps.subList(1, steps.size());
            } else if (first instanceof XPath.NameTest && steps.size() > 1 && ((XPath.NameTest)first).matches("jcr", "root")) {
                steps = steps.subList(1, steps.size());
            } else {
                throw new InvalidQueryException(this.query, "An absolute path expression must start with '//' or '/jcr:root/...'");
            }
        }
        QueryBuilder.ConstraintBuilder where = this.builder.where();
        ArrayList<XPath.StepExpression> path = new ArrayList<XPath.StepExpression>();
        String tableName = null;
        for (XPath.StepExpression step : steps) {
            if (step instanceof XPath.AxisStep) {
                XPath.AxisStep axis = (XPath.AxisStep)step;
                XPath.NodeTest nodeTest = axis.getNodeTest();
                if (nodeTest instanceof XPath.NameTest) {
                    if (this.appliesToPathConstraint(axis.getPredicates())) {
                        path.add(step);
                        continue;
                    }
                    path.add(step);
                    tableName = this.translateSource(tableName, path, where);
                    this.translatePredicates(axis.getPredicates(), tableName, where);
                    path.clear();
                    continue;
                }
                if (nodeTest instanceof XPath.ElementTest) {
                    tableName = this.translateElementTest((XPath.ElementTest)nodeTest, path, where);
                    this.translatePredicates(axis.getPredicates(), tableName, where);
                    path.clear();
                    continue;
                }
                if (nodeTest instanceof XPath.AttributeNameTest) {
                    XPath.AttributeNameTest attributeName = (XPath.AttributeNameTest)nodeTest;
                    this.builder.select(this.nameFrom(attributeName.getNameTest()));
                    continue;
                }
                throw new InvalidQueryException(this.query, "The '" + step + "' step is not supported");
            }
            if (step instanceof XPath.FilterStep) {
                XPath.FilterStep filter = (XPath.FilterStep)step;
                XPath.Component primary = filter.getPrimaryExpression();
                List<XPath.Component> predicates = filter.getPredicates();
                if (primary instanceof XPath.ContextItem) {
                    if (this.appliesToPathConstraint(predicates)) continue;
                    path.add(step);
                    tableName = this.translateSource(tableName, path, where);
                    this.translatePredicates(predicates, tableName, where);
                    path.clear();
                    continue;
                }
                if (primary instanceof XPath.Literal) {
                    throw new InvalidQueryException(this.query, "A literal is not supported in the primary path expression; therefore '" + primary + "' is not valid");
                }
                if (primary instanceof XPath.FunctionCall) {
                    throw new InvalidQueryException(this.query, "A function call is not supported in the primary path expression; therefore '" + primary + "' is not valid");
                }
                if (!(primary instanceof XPath.ParenthesizedExpression)) continue;
                XPath.ParenthesizedExpression paren = (XPath.ParenthesizedExpression)primary;
                XPath.Component wrapped = paren.getWrapped().collapse();
                if (wrapped instanceof XPath.AttributeNameTest) {
                    XPath.AttributeNameTest attributeName = (XPath.AttributeNameTest)wrapped;
                    this.builder.select(this.nameFrom(attributeName.getNameTest()));
                    continue;
                }
                if (wrapped instanceof XPath.BinaryComponent) {
                    for (XPath.AttributeNameTest attributeName : this.extractAttributeNames((XPath.BinaryComponent)wrapped)) {
                        this.builder.select(this.nameFrom(attributeName.getNameTest()));
                    }
                    path.add(filter);
                    continue;
                }
                throw new InvalidQueryException(this.query, "A parenthesized expression of this type is not supported in the primary path expression; therefore '" + primary + "' is not valid");
            }
            path.add(step);
        }
        if (steps.isEmpty() || !path.isEmpty()) {
            this.translateSource(tableName, path, where);
        }
        where.end();
        XPath.OrderBy orderBy = pathExpression.getOrderBy();
        if (orderBy != null) {
            QueryBuilder.OrderByBuilder orderByBuilder = this.builder.orderBy();
            for (XPath.OrderBySpec spec : orderBy) {
                QueryBuilder.OrderByOperandBuilder operandBuilder = null;
                switch (spec.getOrder()) {
                    case ASCENDING: {
                        operandBuilder = orderByBuilder.ascending();
                        break;
                    }
                    case DESCENDING: {
                        operandBuilder = orderByBuilder.descending();
                    }
                }
                assert (operandBuilder != null);
                if (spec.getAttributeName() != null) {
                    XPath.NameTest attribute = spec.getAttributeName();
                    assert (!attribute.isWildcard());
                    if (attribute.matches("jcr", "path")) {
                        String pathOf = tableName;
                        if (pathOf == null) {
                            pathOf = this.aliases.iterator().next();
                        }
                        operandBuilder.path(pathOf);
                        continue;
                    }
                    operandBuilder.propertyValue(tableName, attribute.toString());
                    this.builder.select(tableName + "." + attribute.toString());
                    continue;
                }
                XPath.FunctionCall scoreFunction = spec.getScoreFunction();
                assert (scoreFunction != null);
                List<XPath.Component> args = scoreFunction.getParameters();
                String nameOfTableToScore = tableName;
                if (!args.isEmpty() && args.size() == 1 && args.get(0) instanceof XPath.NameTest) {
                    XPath.NameTest tableNameTest = (XPath.NameTest)args.get(0);
                    nameOfTableToScore = tableNameTest.toString();
                }
                operandBuilder.fullTextSearchScore(nameOfTableToScore);
            }
            orderByBuilder.end();
        }
        if ((query = (Query)this.builder.query()).columns().isEmpty() && query.source() instanceof AllNodes) {
            this.builder.select("jcr:primaryType");
        }
    }

    protected List<XPath.AttributeNameTest> extractAttributeNames(XPath.BinaryComponent binary) {
        ArrayList<XPath.AttributeNameTest> results = new ArrayList<XPath.AttributeNameTest>();
        boolean failed = false;
        if (binary instanceof XPath.Union) {
            for (int i = 0; i != 2; ++i) {
                XPath.Component comp = i == 0 ? binary.getLeft() : binary.getRight();
                if ((comp = comp.collapse()) instanceof XPath.Union) {
                    results.addAll(this.extractAttributeNames((XPath.BinaryComponent)comp));
                    continue;
                }
                if (comp instanceof XPath.AttributeNameTest) {
                    results.add((XPath.AttributeNameTest)comp);
                    continue;
                }
                if (comp instanceof XPath.NameTest) continue;
                failed = true;
                break;
            }
        } else {
            failed = true;
        }
        if (failed) {
            throw new InvalidQueryException(this.query, "A parenthesized expression in a path step may only contain ORed and ANDed attribute names or element names; therefore '" + binary + "' is not valid");
        }
        return results;
    }

    protected List<XPath.NameTest> extractElementNames(XPath.BinaryComponent binary) {
        ArrayList<XPath.NameTest> results = new ArrayList<XPath.NameTest>();
        boolean failed = false;
        if (binary instanceof XPath.Union) {
            for (int i = 0; i != 2; ++i) {
                XPath.Component comp = i == 0 ? binary.getLeft() : binary.getRight();
                if ((comp = comp.collapse()) instanceof XPath.Union) {
                    results.addAll(this.extractElementNames((XPath.BinaryComponent)comp));
                    continue;
                }
                if (comp instanceof XPath.AttributeNameTest) continue;
                if (comp instanceof XPath.NameTest) {
                    results.add((XPath.NameTest)comp);
                    continue;
                }
                failed = true;
                break;
            }
        } else {
            failed = true;
        }
        if (failed) {
            throw new InvalidQueryException(this.query, "A parenthesized expression in a path step may only contain ORed element names; therefore '" + binary + "' is not valid");
        }
        return results;
    }

    protected String translateSource(String tableName, List<XPath.StepExpression> path, QueryBuilder.ConstraintBuilder where) {
        if (path.size() == 0) {
            String alias = this.newAlias();
            this.builder.fromAllNodesAs(alias);
            where.path(alias).isEqualTo("/");
            return alias;
        }
        String alias = this.newAlias();
        if (tableName != null) {
            this.builder.joinAllNodesAs(alias);
            alias = tableName;
        } else {
            this.builder.fromAllNodesAs(alias);
            tableName = alias;
        }
        if (path.size() == 1 && path.get(0).collapse() instanceof XPath.NameTest) {
            XPath.NameTest nodeName = (XPath.NameTest)path.get(0).collapse();
            where.path(alias).isLike("/" + this.nameFrom(nodeName) + "[%]");
        } else if (path.size() == 2 && path.get(0) instanceof XPath.DescendantOrSelf && path.get(1).collapse() instanceof XPath.NameTest) {
            XPath.NameTest nodeName = (XPath.NameTest)path.get(1).collapse();
            if (!nodeName.isWildcard()) {
                where.nodeName(alias).isEqualTo(this.nameFrom(nodeName));
            }
        } else {
            this.translatePathExpressionConstraint(new XPath.PathExpression(true, path, null), where, alias);
        }
        return tableName;
    }

    protected String translateElementTest(XPath.ElementTest elementTest, List<XPath.StepExpression> pathConstraint, QueryBuilder.ConstraintBuilder where) {
        XPath.NameTest nodeName;
        String tableName = null;
        XPath.NameTest typeName = elementTest.getTypeName();
        if (typeName.isWildcard()) {
            tableName = this.newAlias();
            this.builder.fromAllNodesAs(tableName);
        } else {
            if (typeName.getLocalTest() == null) {
                throw new InvalidQueryException(this.query, "The '" + elementTest + "' clause uses a partial wildcard in the type name, but only a wildcard on the whole name is supported");
            }
            tableName = this.nameFrom(typeName);
            this.builder.from(tableName);
        }
        if (elementTest.getElementName() != null && !(nodeName = elementTest.getElementName()).isWildcard()) {
            where.nodeName(tableName).isEqualTo(this.nameFrom(nodeName));
        }
        if (pathConstraint.isEmpty()) {
            where.depth(tableName).isEqualTo(1);
        } else {
            ArrayList<XPath.StepExpression> path = new ArrayList<XPath.StepExpression>(pathConstraint);
            if (!path.isEmpty() && path.get(path.size() - 1) instanceof XPath.AxisStep) {
                path.add(new XPath.AxisStep(new XPath.NameTest(null, null), Collections.<XPath.Component>emptyList()));
            }
            this.translatePathExpressionConstraint(new XPath.PathExpression(true, path, null), where, tableName);
        }
        return tableName;
    }

    protected void translatePredicates(List<XPath.Component> predicates, String tableName, QueryBuilder.ConstraintBuilder where) {
        assert (tableName != null);
        for (XPath.Component predicate : predicates) {
            this.translatePredicate(predicate, tableName, where);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String translatePredicate(XPath.Component predicate, String tableName, QueryBuilder.ConstraintBuilder where) {
        predicate = predicate.collapse();
        assert (tableName != null);
        if (predicate instanceof XPath.ParenthesizedExpression) {
            XPath.ParenthesizedExpression paren = (XPath.ParenthesizedExpression)predicate;
            where = where.openParen();
            this.translatePredicate(paren.getWrapped(), tableName, where);
            where.closeParen();
            return tableName;
        }
        if (predicate instanceof XPath.And) {
            XPath.And and = (XPath.And)predicate;
            where = where.openParen();
            this.translatePredicate(and.getLeft(), tableName, where);
            where.and();
            this.translatePredicate(and.getRight(), tableName, where);
            where.closeParen();
            return tableName;
        }
        if (predicate instanceof XPath.Or) {
            XPath.Or or = (XPath.Or)predicate;
            where = where.openParen();
            this.translatePredicate(or.getLeft(), tableName, where);
            where.or();
            this.translatePredicate(or.getRight(), tableName, where);
            where.closeParen();
            return tableName;
        }
        if (predicate instanceof XPath.Union) {
            XPath.Union union = (XPath.Union)predicate;
            where = where.openParen();
            this.translatePredicate(union.getLeft(), tableName, where);
            where.or();
            this.translatePredicate(union.getRight(), tableName, where);
            where.closeParen();
            return tableName;
        }
        if (predicate instanceof XPath.Literal) {
            XPath.Literal literal = (XPath.Literal)predicate;
            if (!literal.isInteger()) return tableName;
            return tableName;
        }
        if (predicate instanceof XPath.AttributeNameTest) {
            XPath.AttributeNameTest attribute = (XPath.AttributeNameTest)predicate;
            String propertyName = this.nameFrom(attribute.getNameTest());
            where.hasProperty(tableName, propertyName);
            return tableName;
        }
        if (predicate instanceof XPath.NameTest) {
            XPath.NameTest childName = (XPath.NameTest)predicate;
            String alias = this.newAlias();
            this.builder.joinAllNodesAs(alias).onChildNode(tableName, alias);
            if (childName.isWildcard()) return alias;
            where.nodeName(alias).isEqualTo(this.nameFrom(childName));
            return alias;
        }
        if (predicate instanceof XPath.Comparison) {
            XPath.Comparison comparison = (XPath.Comparison)predicate;
            XPath.Component left = comparison.getLeft();
            XPath.Component right = comparison.getRight();
            Operator operator = comparison.getOperator();
            if (left instanceof XPath.Literal) {
                XPath.Component temp = left;
                left = right;
                right = temp;
                operator = operator.reverse();
            }
            if (left instanceof XPath.NodeTest) {
                XPath.NodeTest nodeTest = (XPath.NodeTest)left;
                String propertyName = null;
                if (nodeTest instanceof XPath.AttributeNameTest) {
                    XPath.AttributeNameTest attribute = (XPath.AttributeNameTest)left;
                    propertyName = this.nameFrom(attribute.getNameTest());
                } else {
                    if (!(nodeTest instanceof XPath.NameTest)) throw new InvalidQueryException(this.query, "Left hand side of a comparison must be a name test or attribute name test; therefore '" + comparison + "' is not valid");
                    XPath.NameTest nameTest = (XPath.NameTest)left;
                    propertyName = this.nameFrom(nameTest);
                }
                if (right instanceof XPath.Literal) {
                    String value = ((XPath.Literal)right).getValue();
                    where.propertyValue(tableName, propertyName).is(operator, value);
                    return tableName;
                }
                if (!(right instanceof XPath.FunctionCall)) return tableName;
                XPath.FunctionCall call = (XPath.FunctionCall)right;
                XPath.NameTest functionName = call.getName();
                List<XPath.Component> parameters = call.getParameters();
                String castType = CAST_FUNCTION_NAME_TO_TYPE.get(functionName);
                if (castType == null) throw new InvalidQueryException(this.query, "Only the 'jcr:score' function is allowed in a comparison predicate; therefore '" + comparison + "' is not valid");
                if (parameters.size() != 1) throw new InvalidQueryException(this.query, "A cast function requires one literal parameter; therefore '" + comparison + "' is not valid");
                if (!(parameters.get(0).collapse() instanceof XPath.Literal)) throw new InvalidQueryException(this.query, "A cast function requires one literal parameter; therefore '" + comparison + "' is not valid");
                XPath.Literal value = (XPath.Literal)parameters.get(0).collapse();
                where.propertyValue(tableName, propertyName).is(operator).cast(value.getValue()).as(castType);
                return tableName;
            }
            if (!(left instanceof XPath.FunctionCall)) return tableName;
            if (!(right instanceof XPath.Literal)) return tableName;
            XPath.FunctionCall call = (XPath.FunctionCall)left;
            XPath.NameTest functionName = call.getName();
            List<XPath.Component> parameters = call.getParameters();
            String value = ((XPath.Literal)right).getValue();
            if (!functionName.matches("jcr", "score")) throw new InvalidQueryException(this.query, "Only the 'jcr:score' function is allowed in a comparison predicate; therefore '" + comparison + "' is not valid");
            String scoreTableName = tableName;
            if (parameters.isEmpty()) {
                scoreTableName = tableName;
            } else {
                if (parameters.size() != 1) throw new InvalidQueryException(this.query, "The 'jcr:score' function may have no parameters or the type name as the only parameter.");
                if (!(parameters.get(0) instanceof XPath.NameTest)) throw new InvalidQueryException(this.query, "The 'jcr:score' function may have no parameters or the type name as the only parameter.");
                XPath.NameTest name = (XPath.NameTest)parameters.get(0);
                if (!name.isWildcard()) {
                    scoreTableName = this.nameFrom(name);
                }
            }
            where.fullTextSearchScore(scoreTableName).is(operator, value);
            return tableName;
        }
        if (predicate instanceof XPath.FunctionCall) {
            XPath.Component param2;
            XPath.FunctionCall call = (XPath.FunctionCall)predicate;
            XPath.NameTest functionName = call.getName();
            List<XPath.Component> parameters = call.getParameters();
            XPath.Component param1 = parameters.size() > 0 ? parameters.get(0) : null;
            XPath.Component component = param2 = parameters.size() > 1 ? parameters.get(1) : null;
            if (functionName.matches(null, "not")) {
                if (parameters.size() != 1) {
                    throw new InvalidQueryException(this.query, "The 'not' function requires one parameter; therefore '" + predicate + "' is not valid");
                }
                where = where.not().openParen();
                this.translatePredicate(param1, tableName, where);
                where.closeParen();
                return tableName;
            }
            if (functionName.matches("jcr", "like")) {
                if (parameters.size() != 2) {
                    throw new InvalidQueryException(this.query, "The 'jcr:like' function requires two parameters; therefore '" + predicate + "' is not valid");
                }
                if (!(param1 instanceof XPath.AttributeNameTest)) {
                    throw new InvalidQueryException(this.query, "The first parameter of 'jcr:like' must be an property reference with the '@' symbol; therefore '" + predicate + "' is not valid");
                }
                if (!(param2 instanceof XPath.Literal)) {
                    throw new InvalidQueryException(this.query, "The second parameter of 'jcr:like' must be a literal; therefore '" + predicate + "' is not valid");
                }
                XPath.NameTest attributeName = ((XPath.AttributeNameTest)param1).getNameTest();
                String value = ((XPath.Literal)param2).getValue();
                where.propertyValue(tableName, this.nameFrom(attributeName)).isLike(value);
                return tableName;
            }
            if (!functionName.matches("jcr", "contains")) {
                if (!functionName.matches("jcr", "deref")) throw new InvalidQueryException(this.query, "Only the 'jcr:like' and 'jcr:contains' functions are allowed in a predicate; therefore '" + predicate + "' is not valid");
                throw new InvalidQueryException(this.query, "The 'jcr:deref' function is not required by JCR and is not currently supported; therefore '" + predicate + "' is not valid");
            }
            if (parameters.size() != 2) {
                throw new InvalidQueryException(this.query, "The 'jcr:contains' function requires two parameters; therefore '" + predicate + "' is not valid");
            }
            if (!(param2 instanceof XPath.Literal)) {
                throw new InvalidQueryException(this.query, "The second parameter of 'jcr:contains' must be a literal; therefore '" + predicate + "' is not valid");
            }
            String value = ((XPath.Literal)param2).getValue();
            if (param1 instanceof XPath.ContextItem) {
                where.search(tableName, value);
                return tableName;
            }
            if (param1 instanceof XPath.AttributeNameTest) {
                XPath.NameTest attributeName = ((XPath.AttributeNameTest)param1).getNameTest();
                where.search(tableName, this.nameFrom(attributeName), value);
                return tableName;
            }
            if (param1 instanceof XPath.NameTest) {
                String alias = this.newAlias();
                this.builder.joinAllNodesAs(alias).onChildNode(tableName, alias);
                where.search(alias, value);
                return alias;
            }
            if (!(param1 instanceof XPath.PathExpression)) throw new InvalidQueryException(this.query, "The first parameter of 'jcr:contains' must be a relative path (e.g., '.', an attribute name, a child name, etc.); therefore '" + predicate + "' is not valid");
            XPath.PathExpression pathExpr = (XPath.PathExpression)param1;
            if (!(pathExpr.getLastStep().collapse() instanceof XPath.AttributeNameTest)) {
                String searchTable = this.translatePredicate(param1, tableName, where);
                where.search(searchTable, value);
                return tableName;
            }
            XPath.AttributeNameTest attributeName = (XPath.AttributeNameTest)pathExpr.getLastStep().collapse();
            pathExpr = pathExpr.withoutLast();
            String searchTable = this.translatePredicate(pathExpr, tableName, where);
            if (attributeName.getNameTest().isWildcard()) {
                where.search(searchTable, value);
                return tableName;
            }
            where.search(searchTable, this.nameFrom(attributeName.getNameTest()), value);
            return tableName;
        }
        if (!(predicate instanceof XPath.PathExpression)) throw new InvalidQueryException(this.query, "Unsupported criteria '" + predicate + "'");
        XPath.PathExpression pathExpr = (XPath.PathExpression)predicate;
        List<XPath.StepExpression> steps = pathExpr.getSteps();
        XPath.OrderBy orderBy = pathExpr.getOrderBy();
        assert (steps.size() > 1);
        XPath.Component firstStep = steps.get(0).collapse();
        if (firstStep instanceof XPath.ContextItem) {
            return this.translatePredicate(new XPath.PathExpression(true, steps.subList(1, steps.size()), orderBy), tableName, where);
        }
        if (firstStep instanceof XPath.NameTest) {
            XPath.NameTest childName = (XPath.NameTest)firstStep;
            String alias = this.newAlias();
            this.builder.joinAllNodesAs(alias).onChildNode(tableName, alias);
            if (childName.isWildcard()) return this.translatePredicate(new XPath.PathExpression(true, steps.subList(1, steps.size()), orderBy), alias, where);
            where.nodeName(alias).isEqualTo(this.nameFrom(childName));
            return this.translatePredicate(new XPath.PathExpression(true, steps.subList(1, steps.size()), orderBy), alias, where);
        }
        if (firstStep instanceof XPath.DescendantOrSelf) {
            String alias = this.newAlias();
            this.builder.joinAllNodesAs(alias).onDescendant(tableName, alias);
            return this.translatePredicate(new XPath.PathExpression(true, steps.subList(1, steps.size()), orderBy), alias, where);
        }
        String alias = this.newAlias();
        this.builder.joinAllNodesAs(alias).onDescendant(tableName, alias);
        this.translatePathExpressionConstraint(pathExpr, where, alias);
        return tableName;
    }

    protected boolean appliesToPathConstraint(List<XPath.Component> predicates) {
        if (predicates.isEmpty()) {
            return true;
        }
        if (predicates.size() > 1) {
            return false;
        }
        assert (predicates.size() == 1);
        XPath.Component predicate = predicates.get(0);
        if (predicate instanceof XPath.Literal && ((XPath.Literal)predicate).isInteger()) {
            return true;
        }
        return predicate instanceof XPath.NameTest && ((XPath.NameTest)predicate).isWildcard();
    }

    protected boolean translatePathExpressionConstraint(XPath.PathExpression pathExrp, QueryBuilder.ConstraintBuilder where, String tableName) {
        RelativePathLikeExpressions expressions = this.relativePathLikeExpressions(pathExrp);
        if (expressions.isEmpty()) {
            return false;
        }
        where = where.openParen();
        boolean first = true;
        int number = 0;
        for (String path : expressions) {
            if (path == null || path.length() == 0 || path.equals("%/") || path.equals("%/%") || path.equals("%//%")) continue;
            if (first) {
                first = false;
            } else {
                where.or();
            }
            if (path.indexOf(37) != -1 || path.indexOf(95) != -1) {
                where.path(tableName).isLike(path);
                switch (expressions.depthMode) {
                    case AT_LEAST: {
                        where.and().depth(tableName).isGreaterThanOrEqualTo().cast(expressions.depth).asLong();
                        break;
                    }
                    case EXACT: {
                        where.and().depth(tableName).isEqualTo().cast(expressions.depth).asLong();
                        break;
                    }
                }
            } else {
                where.path(tableName).isEqualTo(path);
            }
            ++number;
        }
        if (number > 0) {
            where.closeParen();
        }
        return true;
    }

    protected RelativePathLikeExpressions relativePathLikeExpressions(XPath.PathExpression pathExpression) {
        List<XPath.StepExpression> steps = pathExpression.getSteps();
        if (steps.isEmpty()) {
            return new RelativePathLikeExpressions();
        }
        if (steps.size() == 1 && steps.get(0) instanceof XPath.DescendantOrSelf) {
            return new RelativePathLikeExpressions();
        }
        PathLikeBuilder builder = new SinglePathLikeBuilder();
        int depth = 0;
        DepthMode depthMode = DepthMode.EXACT;
        Iterator<XPath.StepExpression> iterator = steps.iterator();
        while (iterator.hasNext()) {
            XPath.ParenthesizedExpression paren;
            XPath.Component wrapped;
            XPath.FilterStep filter;
            XPath.Component primary;
            XPath.StepExpression step = iterator.next();
            if (step instanceof XPath.DescendantOrSelf) {
                ++depth;
                depthMode = DepthMode.DEFAULT;
                if (builder.isEmpty()) {
                    builder.append("%/");
                    continue;
                }
                if (iterator.hasNext()) {
                    builder.append('/');
                    builder = new DualPathLikeBuilder(builder.clone(), builder.append("%"));
                    continue;
                }
                builder.append('/').append('%');
                continue;
            }
            if (step instanceof XPath.AxisStep) {
                ++depth;
                XPath.AxisStep axis = (XPath.AxisStep)step;
                XPath.NodeTest nodeTest = axis.getNodeTest();
                assert (!(nodeTest instanceof XPath.ElementTest));
                if (!(nodeTest instanceof XPath.NameTest)) continue;
                XPath.NameTest nameTest = (XPath.NameTest)nodeTest;
                builder.append('/');
                boolean addSns = true;
                if (nameTest.getPrefixTest() != null) {
                    builder.append(nameTest.getPrefixTest()).append(':');
                }
                if (nameTest.getLocalTest() != null) {
                    builder.append(nameTest.getLocalTest());
                } else {
                    builder.append('%');
                    addSns = false;
                }
                List<XPath.Component> predicates = axis.getPredicates();
                boolean addedSns = false;
                if (!predicates.isEmpty()) {
                    assert (predicates.size() == 1);
                    XPath.Component predicate = predicates.get(0);
                    if (predicate instanceof XPath.Literal && ((XPath.Literal)predicate).isInteger()) {
                        builder.append('[').append(((XPath.Literal)predicate).getValue()).append(']');
                        addedSns = true;
                    }
                }
                if (!addSns || addedSns) continue;
                builder.append("[%]");
                continue;
            }
            if (!(step instanceof XPath.FilterStep) || (primary = (filter = (XPath.FilterStep)step).getPrimaryExpression()) instanceof XPath.ContextItem || !(primary instanceof XPath.ParenthesizedExpression) || (wrapped = (paren = (XPath.ParenthesizedExpression)primary).getWrapped().collapse()) instanceof XPath.AttributeNameTest) continue;
            if (wrapped instanceof XPath.BinaryComponent) {
                List<XPath.NameTest> names = this.extractElementNames((XPath.BinaryComponent)wrapped);
                if (names.size() < 1) continue;
                PathLikeBuilder orig = builder.clone();
                builder.append('/').append(this.nameFrom(names.get(0)));
                if (names.size() <= 1) continue;
                for (XPath.NameTest name : names.subList(1, names.size())) {
                    builder = new DualPathLikeBuilder(orig.clone().append('/').append(this.nameFrom(name)), builder);
                }
                continue;
            }
            throw new InvalidQueryException(this.query, "A parenthesized expression of this type is not supported in the primary path expression; therefore '" + primary + "' is not valid");
        }
        return new RelativePathLikeExpressions(builder.getPaths(), depth, depthMode);
    }

    protected String nameFrom(XPath.NameTest name) {
        String prefix = name.getPrefixTest();
        String local = name.getLocalTest();
        assert (local != null);
        return (prefix != null ? prefix + ":" : "") + local;
    }

    protected String newAlias() {
        String root = "nodeSet";
        int num = 1;
        String alias = root + num;
        while (this.aliases.contains(alias)) {
            alias = root + ++num;
        }
        this.aliases.add(alias);
        return alias;
    }

    static {
        HashMap<XPath.NameTest, String> map = new HashMap<XPath.NameTest, String>();
        map.put(new XPath.NameTest("fn", "string"), PropertyType.STRING.getName().toUpperCase());
        map.put(new XPath.NameTest("xs", "string"), PropertyType.STRING.getName().toUpperCase());
        map.put(new XPath.NameTest("xs", "base64Binary"), PropertyType.BINARY.getName().toUpperCase());
        map.put(new XPath.NameTest("xs", "double"), PropertyType.DOUBLE.getName().toUpperCase());
        map.put(new XPath.NameTest("xs", "long"), PropertyType.LONG.getName().toUpperCase());
        map.put(new XPath.NameTest("xs", "boolean"), PropertyType.BOOLEAN.getName().toUpperCase());
        map.put(new XPath.NameTest("xs", "dateTime"), PropertyType.DATE.getName().toUpperCase());
        map.put(new XPath.NameTest("xs", "string"), PropertyType.PATH.getName().toUpperCase());
        map.put(new XPath.NameTest("xs", "string"), PropertyType.NAME.getName().toUpperCase());
        map.put(new XPath.NameTest("xs", "IDREF"), PropertyType.REFERENCE.getName().toUpperCase());
        CAST_FUNCTION_NAME_TO_TYPE = Collections.unmodifiableMap(map);
    }

    protected static class DualPathLikeBuilder
    implements PathLikeBuilder {
        private final PathLikeBuilder builder1;
        private final PathLikeBuilder builder2;

        protected DualPathLikeBuilder(PathLikeBuilder builder1, PathLikeBuilder builder2) {
            this.builder1 = builder1;
            this.builder2 = builder2;
        }

        public DualPathLikeBuilder append(String string) {
            this.builder1.append(string);
            this.builder2.append(string);
            return this;
        }

        public DualPathLikeBuilder append(char c) {
            this.builder1.append(c);
            this.builder2.append(c);
            return this;
        }

        public boolean isEmpty() {
            return false;
        }

        public DualPathLikeBuilder clone() {
            return new DualPathLikeBuilder(this.builder1.clone(), this.builder2.clone());
        }

        public String[] getPaths() {
            String[] paths1 = this.builder1.getPaths();
            String[] paths2 = this.builder2.getPaths();
            String[] result = new String[paths1.length + paths2.length];
            System.arraycopy(paths1, 0, result, 0, paths1.length);
            System.arraycopy(paths2, 0, result, paths1.length, paths2.length);
            return result;
        }
    }

    protected static class SinglePathLikeBuilder
    implements PathLikeBuilder {
        private final StringBuilder builder = new StringBuilder();
        private char lastChar;

        protected SinglePathLikeBuilder() {
        }

        public SinglePathLikeBuilder append(String string) {
            this.builder.append(string);
            if (string.length() > 0) {
                this.lastChar = string.charAt(string.length() - 1);
            }
            return this;
        }

        public SinglePathLikeBuilder append(char c) {
            if (this.lastChar != c) {
                this.builder.append(c);
                this.lastChar = c;
            }
            return this;
        }

        public boolean isEmpty() {
            return this.builder.length() == 0;
        }

        public SinglePathLikeBuilder clone() {
            return new SinglePathLikeBuilder().append(this.builder.toString());
        }

        public String toString() {
            return this.builder.toString();
        }

        public String[] getPaths() {
            String[] stringArray;
            if (this.isEmpty()) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.builder.toString();
            }
            return stringArray;
        }
    }

    protected static interface PathLikeBuilder {
        public PathLikeBuilder append(String var1);

        public PathLikeBuilder append(char var1);

        public boolean isEmpty();

        public PathLikeBuilder clone();

        public String[] getPaths();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class RelativePathLikeExpressions
    implements Iterable<String> {
        protected final List<String> paths;
        protected final int depth;
        protected final DepthMode depthMode;

        protected RelativePathLikeExpressions() {
            this.paths = null;
            this.depth = 0;
            this.depthMode = DepthMode.DEFAULT;
        }

        protected RelativePathLikeExpressions(String[] paths, int depth, DepthMode depthMode) {
            this.paths = Arrays.asList(paths);
            this.depth = depth;
            this.depthMode = depthMode;
        }

        protected boolean isEmpty() {
            return this.paths == null || this.paths.isEmpty();
        }

        @Override
        public Iterator<String> iterator() {
            return this.paths.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DepthMode {
        DEFAULT,
        EXACT,
        AT_LEAST;

    }
}

