/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.service;

import java.util.Locale;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.Logger;
import org.modeshape.repository.RepositoryI18n;
import org.modeshape.repository.service.ServiceAdministrator;

@ThreadSafe
public abstract class AbstractServiceAdministrator
implements ServiceAdministrator {
    private volatile ServiceAdministrator.State state;
    private final I18n serviceName;
    private final Logger logger;

    protected AbstractServiceAdministrator(I18n serviceName, ServiceAdministrator.State initialState) {
        assert (initialState != null);
        assert (serviceName != null);
        this.state = initialState;
        this.serviceName = serviceName;
        this.logger = Logger.getLogger(this.getClass());
    }

    @Override
    public ServiceAdministrator.State getState() {
        return this.state;
    }

    @Override
    public synchronized ServiceAdministrator setState(ServiceAdministrator.State state) {
        switch (state) {
            case STARTED: {
                this.start();
                break;
            }
            case PAUSED: {
                this.pause();
                break;
            }
            case SHUTDOWN: 
            case TERMINATED: {
                this.shutdown();
            }
        }
        return this;
    }

    @Override
    public ServiceAdministrator setState(String state) {
        ServiceAdministrator.State newState;
        ServiceAdministrator.State state2 = newState = state == null ? null : ServiceAdministrator.State.valueOf(state.toUpperCase());
        if (newState == null) {
            throw new IllegalArgumentException(RepositoryI18n.invalidStateString.text(state));
        }
        return this.setState(newState);
    }

    @Override
    public synchronized ServiceAdministrator start() {
        switch (this.state) {
            case STARTED: {
                break;
            }
            case PAUSED: {
                this.logger.trace("Starting \"{0}\"", this.getServiceName());
                this.doStart(this.state);
                this.state = ServiceAdministrator.State.STARTED;
                this.logger.trace("Started \"{0}\"", this.getServiceName());
                break;
            }
            case SHUTDOWN: 
            case TERMINATED: {
                throw new IllegalStateException(RepositoryI18n.serviceShutdowAndMayNotBeStarted.text(this.getServiceName()));
            }
        }
        return this;
    }

    protected void doStart(ServiceAdministrator.State fromState) {
    }

    @Override
    public synchronized ServiceAdministrator pause() {
        switch (this.state) {
            case STARTED: {
                this.logger.trace("Pausing \"{0}\"", this.getServiceName());
                this.doPause(this.state);
                this.state = ServiceAdministrator.State.PAUSED;
                this.logger.trace("Paused \"{0}\"", this.getServiceName());
                break;
            }
            case PAUSED: {
                break;
            }
            case SHUTDOWN: 
            case TERMINATED: {
                throw new IllegalStateException(RepositoryI18n.serviceShutdowAndMayNotBePaused.text(this.getServiceName()));
            }
        }
        return this;
    }

    protected void doPause(ServiceAdministrator.State fromState) {
    }

    @Override
    public synchronized ServiceAdministrator shutdown() {
        switch (this.state) {
            case STARTED: 
            case PAUSED: {
                this.logger.trace("Initiating shutdown of \"{0}\"", this.getServiceName());
                this.state = ServiceAdministrator.State.SHUTDOWN;
                this.doShutdown(this.state);
                this.logger.trace("Initiated shutdown of \"{0}\"", this.getServiceName());
                this.isTerminated();
                break;
            }
            case SHUTDOWN: 
            case TERMINATED: {
                this.isTerminated();
            }
        }
        return this;
    }

    protected void doShutdown(ServiceAdministrator.State fromState) {
    }

    @Override
    public boolean isStarted() {
        return this.state == ServiceAdministrator.State.STARTED;
    }

    @Override
    public boolean isPaused() {
        return this.state == ServiceAdministrator.State.PAUSED;
    }

    @Override
    public boolean isShutdown() {
        return this.state == ServiceAdministrator.State.SHUTDOWN || this.state == ServiceAdministrator.State.TERMINATED;
    }

    @Override
    public boolean isTerminated() {
        switch (this.state) {
            case STARTED: 
            case PAUSED: 
            case SHUTDOWN: {
                if (this.doCheckIsTerminated()) {
                    this.state = ServiceAdministrator.State.TERMINATED;
                    this.logger.trace("Service \"{0}\" has terminated", this.getServiceName());
                    return true;
                }
                return false;
            }
            case TERMINATED: {
                return true;
            }
        }
        return false;
    }

    protected abstract boolean doCheckIsTerminated();

    public String getServiceName() {
        return this.serviceName.text(new Object[0]);
    }

    public String getServiceName(Locale locale) {
        return this.serviceName.text(locale, new Object[0]);
    }
}

