/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene.query;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;

public class MatchNoneQuery
extends Query {
    private static final long serialVersionUID = 1L;

    @Override
    public Weight createWeight(Searcher searcher) {
        return new NoneWeight();
    }

    @Override
    public Object clone() {
        return new MatchNoneQuery();
    }

    @Override
    public String toString(String field) {
        return "NO DOCS";
    }

    protected static class NoneScorer
    extends Scorer {
        private int docId = -1;

        protected NoneScorer(Weight weight) {
            super(weight);
        }

        @Override
        public int docID() {
            return this.docId;
        }

        @Override
        public int nextDoc() {
            this.docId = Integer.MAX_VALUE;
            return this.docId;
        }

        @Override
        public int advance(int target) {
            return Integer.MAX_VALUE;
        }

        @Override
        public float score() {
            return 1.0f;
        }
    }

    protected class NoneWeight
    extends Weight {
        private static final long serialVersionUID = 1L;

        protected NoneWeight() {
        }

        @Override
        public Query getQuery() {
            return MatchNoneQuery.this;
        }

        @Override
        public float getValue() {
            return 1.0f;
        }

        @Override
        public float sumOfSquaredWeights() {
            return 1.0f;
        }

        @Override
        public void normalize(float norm) {
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) {
            return new NoneScorer(this);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) {
            return new Explanation(this.getValue(), "NO VALUES");
        }
    }
}

