/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeExistsException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.jcr.AbstractJcrAccessTest;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;

public class NodeTypeRegistrationTest
extends AbstractJcrAccessTest {
    private NodeTypeManager nodeTypeManager;

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.nodeTypeManager = (NodeTypeManager)this.session().getWorkspace().getNodeTypeManager();
    }

    protected InputStream resourceAsStream(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    protected URL resourceAsUrl(String path) {
        return this.getClass().getClassLoader().getResource(path);
    }

    protected NodeType assertNodeType(String name) throws RepositoryException {
        NodeType type = this.nodeTypeManager.getNodeType(name);
        Assert.assertThat((Object)type, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        return type;
    }

    @Test
    public void shouldAccessCustomNodeTypeManagerViaCasting() throws Exception {
        NodeTypeManager nodeTypeMgr = (NodeTypeManager)this.session().getWorkspace().getNodeTypeManager();
        Assert.assertThat((Object)nodeTypeMgr, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldAccessCustomNodeTypeManagerViaProtectedMethods() throws Exception {
        JcrNodeTypeManager nodeTypeMgr = this.session().workspace().nodeTypeManager();
        Assert.assertThat((Object)nodeTypeMgr, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test(expected=IOException.class)
    public void shouldFailIfResourceFileCouldNotBeFoundAsRelativeFile() throws Exception {
        File file = new File("/this/resource/file/does/not/exist");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)false));
        this.nodeTypeManager.registerNodeTypes(file, true);
    }

    @Test(expected=IOException.class)
    public void shouldFailIfResourceFileCouldNotBeFoundAsUrl() throws Exception {
        File file = new File("/this/resource/file/does/not/exist");
        Assert.assertThat((Object)file.exists(), (Matcher)Is.is((Object)false));
        URL url = file.toURI().toURL();
        this.nodeTypeManager.registerNodeTypes(url, true);
    }

    @Test
    public void shouldLoadNodeTypesFromCndResourceFileFoundOnClasspath() throws Exception {
        this.nodeTypeManager.registerNodeTypes(this.resourceAsStream("cars.cnd"), true);
        this.assertNodeType("car:Car");
    }

    @Test
    public void shouldLoadNodeTypesFromCndResourceFileFoundWithRelativePathOnFileSystem() throws Exception {
        File file = new File("src/test/resources/cnd/cars.cnd");
        if (file.exists()) {
            this.nodeTypeManager.registerNodeTypes(file, true);
            this.assertNodeType("car:Car");
        }
    }

    @Test
    public void shouldLoadNodeTypesFromCndResourceFileFoundWithAbsolutePathOnFileSystem() throws Exception {
        File file = new File("src/test/resources/cnd/cars.cnd");
        if (file.exists()) {
            this.nodeTypeManager.registerNodeTypes(file.getAbsoluteFile(), true);
            this.assertNodeType("car:Car");
        }
    }

    @Test
    public void shouldLoadNodeTypesFromUrlToCndFile() throws Exception {
        this.nodeTypeManager.registerNodeTypes(this.resourceAsUrl("cars.cnd"), true);
        this.assertNodeType("car:Car");
    }

    @Test(expected=NodeTypeExistsException.class)
    public void shouldNotAllowRedefinitionOfExistingTypesFromCndFile() throws Exception {
        this.nodeTypeManager.registerNodeTypes(this.resourceAsUrl("cndNodeTypeRegistration/existingType.cnd"), false);
    }

    @Test
    public void shouldLoadMagnoliaTypesFromCndFile() throws Exception {
        this.nodeTypeManager.registerNodeTypes(this.resourceAsUrl("magnolia.cnd"), true);
        this.assertNodeType("mgnl:contentNode");
    }

    @Test
    public void shouldRegisterValidTypesFromCndFile() throws Exception {
        this.nodeTypeManager.registerNodeTypes(this.resourceAsUrl("cndNodeTypeRegistration/validType.cnd"), true);
        NodeType nodeType = this.assertNodeType("modetest:testType");
        Assert.assertThat((Object)nodeType, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)nodeType.isMixin(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.hasOrderableChildNodes(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)nodeType.getDeclaredSupertypes().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)nodeType.getDeclaredChildNodeDefinitions().length, (Matcher)Is.is((Object)1));
        JcrNodeDefinition childNode = (JcrNodeDefinition)nodeType.getDeclaredChildNodeDefinitions()[0];
        Assert.assertThat((Object)childNode.getName(), (Matcher)Is.is((Object)"modetest:namespace"));
        Assert.assertThat((Object)childNode.getDefaultPrimaryType().getName(), (Matcher)Is.is((Object)"mode:namespace"));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)childNode.getRequiredPrimaryTypes()[0].getName(), (Matcher)Is.is((Object)"mode:namespace"));
        Assert.assertThat((Object)childNode.allowsSameNameSiblings(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)childNode.isMandatory(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)nodeType.getDeclaredPropertyDefinitions().length, (Matcher)Is.is((Object)1));
        JcrPropertyDefinition property = (JcrPropertyDefinition)nodeType.getDeclaredPropertyDefinitions()[0];
        Assert.assertThat((Object)property.getName(), (Matcher)Is.is((Object)"*"));
        Assert.assertThat((Object)property.getRequiredType(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)property.getValueConstraints().length, (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)property.getValueConstraints()[0], (Matcher)Is.is((Object)"foo"));
        Assert.assertThat((Object)property.getValueConstraints()[1], (Matcher)Is.is((Object)"bar"));
        Assert.assertThat((Object)property.getValueConstraints()[2], (Matcher)Is.is((Object)"baz"));
        Assert.assertThat((Object)property.getDefaultValues().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)property.getDefaultValues()[0].getString(), (Matcher)Is.is((Object)"foo"));
    }

    @Test
    public void shouldLoadNodeTypesFromXmlResourceFileFoundOnClasspath() throws Exception {
        this.nodeTypeManager.registerNodeTypes(this.resourceAsStream("xmlNodeTypeRegistration/magnolia_forum_nodetypes.xml"), true);
        this.assertNodeType("mgnl:forum");
    }

    @Test
    public void shouldLoadNodeTypesFromXmlResourceFileFoundWithRelativePathOnFileSystem() throws Exception {
        File file = new File("src/test/resources/xmlNodeTypeRegistration/magnolia_forum_nodetypes.xml");
        if (file.exists()) {
            this.nodeTypeManager.registerNodeTypes(file, true);
            this.assertNodeType("mgnl:forum");
        }
    }

    @Test
    public void shouldLoadNodeTypesFromXmlResourceFileFoundWithAbsolutePathOnFileSystem() throws Exception {
        File file = new File("src/test/resources/xmlNodeTypeRegistration/magnolia_forum_nodetypes.xml");
        if (file.exists()) {
            this.nodeTypeManager.registerNodeTypes(file.getAbsoluteFile(), true);
            this.assertNodeType("mgnl:forum");
        }
    }

    @Test
    public void shouldLoadNodeTypesFromUrl() throws Exception {
        this.nodeTypeManager.registerNodeTypes(this.resourceAsUrl("xmlNodeTypeRegistration/magnolia_forum_nodetypes.xml"), true);
        this.assertNodeType("mgnl:forum");
    }

    @Test
    public void shouldLoadMagnoliaNodeTypesFromXml() throws Exception {
        this.nodeTypeManager.registerNodeTypes(this.resourceAsStream("xmlNodeTypeRegistration/magnolia_forum_nodetypes.xml"), true);
        this.assertNodeType("mgnl:forum");
    }

    @Test
    public void shouldLoadOwfeNodeTypesFromXml() throws Exception {
        this.nodeTypeManager.registerNodeTypes(this.resourceAsStream("xmlNodeTypeRegistration/owfe_nodetypes.xml"), true);
        this.assertNodeType("expression");
    }

    @Test
    public void shouldLoadCustomNodeTypesFromXml() throws Exception {
        this.nodeTypeManager.registerNodeTypes(this.resourceAsStream("xmlNodeTypeRegistration/custom_nodetypes.xml"), true);
        this.assertNodeType("mgnl:reserve");
    }
}

