/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Node;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.modeshape.common.FixFor;

public class ReferencesTest
extends AbstractJCRTest {
    @FixFor(value={"MODE-848"})
    public void testRemovingNodeThatIsUsedInWeakReference() throws RepositoryException {
        try {
            Node node1 = this.testRootNode.addNode("test1");
            Node node2 = this.testRootNode.addNode("test2");
            node2.addMixin("mix:referenceable");
            Value ref = this.superuser.getValueFactory().createValue(node2, true);
            node1.setProperty("ref", ref);
            this.superuser.save();
            node2.remove();
            this.superuser.save();
        }
        catch (ReferentialIntegrityException e) {
            ReferencesTest.fail((String)"Should allow removing a node that has a WEAKREFERENCE pointing to it.");
        }
    }

    @FixFor(value={"MODE-848"})
    public void testRemovingNodeThatIsUsedInNonReference() throws RepositoryException {
        try {
            Node node1 = this.testRootNode.addNode("test1");
            Node node2 = this.testRootNode.addNode("test2");
            node2.addMixin("mix:referenceable");
            Value ref = this.superuser.getValueFactory().createValue(node2.getIdentifier());
            node1.setProperty("ref", ref);
            this.superuser.save();
            node2.remove();
            this.superuser.save();
        }
        catch (ReferentialIntegrityException e) {
            ReferencesTest.fail((String)"Should allow removing a node that has a non-reference value pointing to it.");
        }
    }

    @FixFor(value={"MODE-848"})
    public void testRemovingNodeThatIsUsedInReferenceCreatedExplicitly() throws RepositoryException {
        try {
            Node node1 = this.testRootNode.addNode("test1");
            Node node2 = this.testRootNode.addNode("test2");
            node2.addMixin("mix:referenceable");
            Value ref = this.superuser.getValueFactory().createValue(node2, false);
            node1.setProperty("ref", ref);
            this.superuser.save();
            node2.remove();
            this.superuser.save();
            ReferencesTest.fail((String)"Should not allow removing a node that has a REFERENCE pointing to it.");
        }
        catch (ReferentialIntegrityException referentialIntegrityException) {
            // empty catch block
        }
    }

    @FixFor(value={"MODE-848"})
    public void testRemovingNodeThatIsUsedInReferenceCreatedImplicitly() throws RepositoryException {
        try {
            Node node1 = this.testRootNode.addNode("test1");
            Node node2 = this.testRootNode.addNode("test2");
            node2.addMixin("mix:referenceable");
            Value ref = this.superuser.getValueFactory().createValue(node2);
            node1.setProperty("ref", ref);
            this.superuser.save();
            node2.remove();
            this.superuser.save();
            ReferencesTest.fail((String)"Should not allow removing a node that has a REFERENCE pointing to it.");
        }
        catch (ReferentialIntegrityException referentialIntegrityException) {
            // empty catch block
        }
    }

    @FixFor(value={"MODE-848"})
    public void testRemovingNodeThatIsUsedInReferenceCreatedWithExplicitTypeConversion() throws RepositoryException {
        try {
            Node node1 = this.testRootNode.addNode("test1");
            Node node2 = this.testRootNode.addNode("test2");
            node2.addMixin("mix:referenceable");
            Value ref = this.superuser.getValueFactory().createValue(node2.getIdentifier());
            node1.setProperty("ref", ref, 9);
            this.superuser.save();
            node2.remove();
            this.superuser.save();
            ReferencesTest.fail((String)"Should not allow removing a node that has a REFERENCE pointing to it.");
        }
        catch (ReferentialIntegrityException referentialIntegrityException) {
            // empty catch block
        }
    }

    @FixFor(value={"MODE-848"})
    public void testRemovingNodeThatIsUsedInWeakReferenceCreatedWithExplicitTypeConversion() throws RepositoryException {
        try {
            Node node1 = this.testRootNode.addNode("test1");
            Node node2 = this.testRootNode.addNode("test2");
            node2.addMixin("mix:referenceable");
            Value ref = this.superuser.getValueFactory().createValue(node2.getIdentifier());
            node1.setProperty("ref", ref, 10);
            this.superuser.save();
            node2.remove();
            this.superuser.save();
        }
        catch (ReferentialIntegrityException e) {
            ReferencesTest.fail((String)"Should allow removing a node that has a WEAKREFERENCE pointing to it.");
        }
    }

    @FixFor(value={"MODE-877"})
    public void testRemovingReferencedNodeIfReferenceIsRemovedBeforeReferencedNodeInSameSessionSaveAction() throws RepositoryException {
        Node node1 = this.testRootNode.addNode("test1");
        Node node2 = this.testRootNode.addNode("test2");
        node2.addMixin("mix:referenceable");
        Value ref = this.superuser.getValueFactory().createValue(node2.getIdentifier());
        node1.setProperty("ref", ref, 9);
        this.superuser.save();
        try {
            node1.getProperty("ref").remove();
            node2.remove();
            this.superuser.save();
        }
        catch (ReferentialIntegrityException e) {
            ReferencesTest.fail((String)"Should allow removing a node that has a REFERENCE pointing to it if REFERENCE is removed in same session save().");
        }
    }

    @FixFor(value={"MODE-877"})
    public void testRemovingReferencedNodeIfReferenceIsRemovedAfterReferencedNodeInSameSessionSaveAction() throws RepositoryException {
        Node node1 = this.testRootNode.addNode("test1");
        Node node2 = this.testRootNode.addNode("test2");
        node2.addMixin("mix:referenceable");
        Value ref = this.superuser.getValueFactory().createValue(node2.getIdentifier());
        node1.setProperty("ref", ref, 9);
        this.superuser.save();
        try {
            node2.remove();
            node1.getProperty("ref").remove();
            this.superuser.save();
        }
        catch (ReferentialIntegrityException e) {
            ReferencesTest.fail((String)"Should allow removing a node that has a REFERENCE pointing to it if REFERENCE is removed in same session save().");
        }
    }
}

