/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.text.TextExtractor;
import org.modeshape.jcr.text.TextExtractorContext;
import org.modeshape.jcr.text.TextExtractorOutput;

@Immutable
public final class TextExtractors
implements TextExtractor {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private final List<TextExtractor> extractors;
    private final boolean stopAfterFirst;

    public TextExtractors(JcrRepository.RunningState repository, Collection<RepositoryConfiguration.Component> components) {
        this.stopAfterFirst = true;
        ClassLoader defaultClassLoader = this.getClass().getClassLoader();
        ExecutionContext context = repository.context();
        this.extractors = new ArrayList<TextExtractor>();
        for (RepositoryConfiguration.Component component : components) {
            try {
                ClassLoader cl = context.getClassLoader(component.getClasspath());
                if (cl == null) {
                    cl = defaultClassLoader;
                }
                TextExtractor extractor = (TextExtractor)component.createInstance(cl);
                this.extractors.add(extractor);
            }
            catch (Throwable t) {
                String name = component.getName();
                String repoName = repository.name();
                Logger.getLogger(this.getClass()).error(t, JcrI18n.unableToInitializeTextExtractor, new Object[]{name, repoName, t.getMessage()});
            }
        }
    }

    public int size() {
        return this.extractors.size();
    }

    @Override
    public boolean supportsMimeType(String mimeType) {
        for (TextExtractor extractor : this.extractors) {
            if (!extractor.supportsMimeType(mimeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void extractFrom(InputStream stream, TextExtractorOutput output, TextExtractorContext context) throws IOException {
        if (stream == null) {
            return;
        }
        if (stream.markSupported()) {
            stream.mark(Integer.MAX_VALUE);
        }
        String mimeType = context.getMimeType();
        for (TextExtractor extractor : this.extractors) {
            if (!extractor.supportsMimeType(mimeType)) continue;
            extractor.extractFrom(stream, output, context);
            if (this.stopAfterFirst || !stream.markSupported()) break;
            stream.reset();
        }
    }
}

