/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.SessionCacheMonitor;
import org.modeshape.jcr.cache.document.DocumentCache;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.SessionNode;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.ValueFactories;

public abstract class AbstractSessionCache
implements SessionCache,
DocumentCache {
    protected final WorkspaceCache workspaceCache;
    private final ExecutionContext context;
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final Path rootPath;
    private final SessionCacheMonitor monitor;

    protected AbstractSessionCache(ExecutionContext context, WorkspaceCache workspaceCache, SessionCacheMonitor monitor) {
        this.context = context;
        this.workspaceCache = workspaceCache;
        ValueFactories factories = this.context.getValueFactories();
        this.nameFactory = factories.getNameFactory();
        this.pathFactory = factories.getPathFactory();
        this.rootPath = this.pathFactory.createRootPath();
        this.monitor = monitor;
    }

    @Override
    public final ExecutionContext getContext() {
        return this.context;
    }

    @Override
    public final WorkspaceCache workspaceCache() {
        return this.workspaceCache;
    }

    final DocumentTranslator translator() {
        return this.workspaceCache.translator();
    }

    final ExecutionContext context() {
        return this.context;
    }

    final NameFactory nameFactory() {
        return this.nameFactory;
    }

    final PathFactory pathFactory() {
        return this.pathFactory;
    }

    final Path rootPath() {
        return this.rootPath;
    }

    final SessionCacheMonitor monitor() {
        return this.monitor;
    }

    @Override
    public NodeKey createNodeKey() {
        return this.getRootKey().withId(this.generateIdentifier());
    }

    @Override
    public NodeKey createNodeKeyWithIdentifier(String identifier) {
        return this.getRootKey().withId(identifier);
    }

    @Override
    public NodeKey createNodeKeyWithSource(String sourceName) {
        String sourceKey = NodeKey.keyForSourceName(sourceName);
        return this.getRootKey().withSourceKeyAndId(sourceKey, this.generateIdentifier());
    }

    @Override
    public NodeKey createNodeKey(String sourceName, String identifier) {
        String sourceKey = NodeKey.keyForSourceName(sourceName);
        if (identifier == null) {
            identifier = this.generateIdentifier();
        }
        return this.getRootKey().withSourceKeyAndId(sourceKey, identifier);
    }

    protected String generateIdentifier() {
        return UUID.randomUUID().toString();
    }

    @Override
    public NodeKey getRootKey() {
        return this.workspaceCache.getRootKey();
    }

    @Override
    public NodeCache getWorkspace() {
        return this.workspaceCache;
    }

    @Override
    public CachedNode getNode(NodeKey key) {
        return this.workspaceCache.getNode(key);
    }

    @Override
    public CachedNode getNode(ChildReference reference) {
        return this.getNode(reference.getKey());
    }

    @Override
    public abstract SessionNode mutable(NodeKey var1);

    @Immutable
    protected static final class BasicSaveContext
    implements SessionCache.SaveContext {
        private final DateTime now;
        private final String userId;

        protected BasicSaveContext(ExecutionContext context) {
            this.now = context.getValueFactories().getDateFactory().create();
            this.userId = context.getSecurityContext().getUserName();
        }

        @Override
        public DateTime getTime() {
            return this.now;
        }

        @Override
        public String getUserId() {
            return this.userId;
        }
    }
}

