/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.jcr.query.lucene.MatchNoneQuery;
import org.modeshape.jcr.query.model.And;
import org.modeshape.jcr.query.model.Constraint;

@NotThreadSafe
public class LuceneQuery {
    private Query pushDownQuery;
    private Constraint postProcessingConstraints;
    private boolean matchNone = false;
    private final String pushDownIndexName;

    public LuceneQuery(String pushDownIndexName) {
        this.pushDownIndexName = pushDownIndexName;
    }

    public void addQuery(Query query) {
        if (this.matchNone) {
            return;
        }
        if (query instanceof MatchNoneQuery) {
            this.pushDownQuery = null;
            this.matchNone = true;
            return;
        }
        BooleanQuery booleanQuery = null;
        if (this.pushDownQuery instanceof BooleanQuery) {
            booleanQuery = (BooleanQuery)this.pushDownQuery;
            boolean canMerge = true;
            for (BooleanClause clause : booleanQuery.getClauses()) {
                if (clause.getOccur() != BooleanClause.Occur.SHOULD) continue;
                canMerge = false;
                break;
            }
            if (canMerge) {
                booleanQuery.add(query, BooleanClause.Occur.MUST);
            }
        } else {
            booleanQuery = new BooleanQuery();
            booleanQuery.add(this.pushDownQuery, BooleanClause.Occur.MUST);
            if (query instanceof BooleanQuery) {
                boolean merged = false;
                BooleanQuery booleanSecond = (BooleanQuery)query;
                if (booleanSecond.getClauses().length == 1) {
                    BooleanClause onlyClause = booleanSecond.getClauses()[0];
                    if (onlyClause.isProhibited()) {
                        booleanQuery.add(onlyClause.getQuery(), BooleanClause.Occur.MUST_NOT);
                        merged = true;
                    } else if (onlyClause.isRequired()) {
                        booleanQuery.add(onlyClause.getQuery(), BooleanClause.Occur.MUST);
                        merged = true;
                    }
                }
                if (!merged) {
                    booleanQuery.add(query, BooleanClause.Occur.MUST);
                }
            } else {
                booleanQuery.add(query, BooleanClause.Occur.MUST);
            }
            this.pushDownQuery = booleanQuery;
        }
    }

    public void addConstraintForPostprocessing(Constraint constraint) {
        this.postProcessingConstraints = this.postProcessingConstraints == null ? constraint : new And(this.postProcessingConstraints, constraint);
    }

    public boolean matchesNone() {
        return this.matchNone;
    }

    public Query getPushDownQuery() {
        assert (!this.matchNone || this.pushDownQuery == null);
        return this.pushDownQuery;
    }

    public String getPushDownIndexName() {
        return this.pushDownIndexName;
    }

    public Constraint getPostProcessingConstraints() {
        return this.postProcessingConstraints;
    }
}

