/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.model;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.query.model.LanguageObject;
import org.modeshape.jcr.query.model.Visitor;
import org.modeshape.jcr.query.model.Visitors;

@Immutable
public class Limit
implements LanguageObject,
org.modeshape.jcr.api.query.qom.Limit {
    private static final long serialVersionUID = 1L;
    public static final Limit NONE = new Limit(Integer.MAX_VALUE, 0);
    private final int offset;
    private final int rowLimit;

    public Limit(int rowLimit) {
        CheckArg.isNonNegative((int)rowLimit, (String)"rowLimit");
        this.rowLimit = rowLimit;
        this.offset = 0;
    }

    public Limit(int rowLimit, int offset) {
        CheckArg.isNonNegative((int)rowLimit, (String)"rowLimit");
        CheckArg.isNonNegative((int)offset, (String)"offset");
        this.rowLimit = rowLimit;
        this.offset = offset;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getRowLimit() {
        return this.rowLimit;
    }

    public final boolean isUnlimited() {
        return this.rowLimit == Integer.MAX_VALUE && this.offset == 0;
    }

    public final boolean hasRowLimited() {
        return this.rowLimit != Integer.MAX_VALUE;
    }

    public final boolean isOffset() {
        return this.offset > 0;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.rowLimit;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Limit) {
            Limit that = (Limit)obj;
            return this.offset == that.offset && this.rowLimit == that.rowLimit;
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public Limit withRowLimit(int rowLimit) {
        return new Limit(rowLimit, this.offset);
    }

    public Limit withOffset(int offset) {
        return new Limit(this.rowLimit, offset);
    }
}

