/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.RepositoryI18n;
import org.modeshape.jcr.RepositoryStatistics;
import org.modeshape.jcr.Sequencers;
import org.modeshape.jcr.api.JcrTools;
import org.modeshape.jcr.api.monitor.DurationMetric;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.jcr.api.value.DateTime;

final class SequencingRunner
implements Runnable {
    private final JcrRepository repository;
    private final Sequencers.SequencingWorkItem work;
    protected static final String DERIVED_NODE_TYPE_NAME = "mode:derived";
    protected static final String DERIVED_FROM_PROPERTY_NAME = "mode:derivedFrom";

    protected SequencingRunner(JcrRepository repository, Sequencers.SequencingWorkItem work) {
        this.repository = repository;
        this.work = work;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JcrSession inputSession = null;
        JcrSession outputSession = null;
        JcrRepository.RunningState state = this.repository.runningState();
        RepositoryStatistics stats = state.statistics();
        Object sequencer = null;
        try {
            inputSession = state.loginInternalSession(this.work.getInputWorkspaceName());
            outputSession = this.work.getOutputWorkspaceName() != null && !this.work.getOutputWorkspaceName().equals(this.work.getInputWorkspaceName()) ? state.loginInternalSession(this.work.getOutputWorkspaceName()) : inputSession;
            sequencer = state.sequencers().getSequencer(this.work.getSequencerId());
            if (sequencer == null) {
                return;
            }
            AbstractJcrNode selectedNode = inputSession.getNode(this.work.getSelectedPath());
            AbstractJcrItem inputItem = inputSession.getItem(this.work.getInputPath());
            Property changedProperty = null;
            if (inputItem instanceof Property) {
                changedProperty = (Property)inputItem;
            } else {
                Node changedNode = (Node)inputItem;
                changedProperty = changedNode.getProperty(this.work.getChangedPropertyName());
            }
            assert (changedProperty != null);
            AbstractJcrNode outputNode = null;
            String primaryType = null;
            if (this.work.getSelectedPath().equals(this.work.getOutputPath())) {
                outputNode = selectedNode.getName().equals("jcr:content") ? selectedNode.getParent() : selectedNode;
                primaryType = selectedNode.getPrimaryNodeType().getName();
            } else {
                AbstractJcrNode parentOfOutput = null;
                try {
                    parentOfOutput = outputSession.getNode(this.work.getOutputPath());
                }
                catch (PathNotFoundException e) {
                    JcrTools tools = new JcrTools();
                    parentOfOutput = tools.findOrCreateNode((Session)outputSession, this.work.getOutputPath());
                }
                String outputNodeName = this.computeOutputNodeName(selectedNode);
                this.removeExistingOutputNodes(parentOfOutput, outputNodeName, this.work.getSelectedPath());
                outputNode = parentOfOutput.addNode(outputNodeName, "nt:unstructured");
                outputNode.addMixin(DERIVED_NODE_TYPE_NAME);
                outputNode.setProperty(DERIVED_FROM_PROPERTY_NAME, this.work.getSelectedPath());
            }
            DateTime now = outputSession.dateFactory().create();
            Sequencers.SequencingContext context = new Sequencers.SequencingContext(now, outputSession.getValueFactory(), outputSession.context().getMimeTypeDetector());
            if (inputSession.isLive() && (inputSession == outputSession || outputSession.isLive())) {
                long start = System.nanoTime();
                if (sequencer.execute(changedProperty, (Node)outputNode, (Sequencer.Context)context)) {
                    if (selectedNode == outputNode && !selectedNode.getPrimaryNodeType().getName().equals(primaryType)) {
                        String msg = RepositoryI18n.sequencersMayNotChangeThePrimaryTypeOfTheSelectedNode.text(new Object[0]);
                        throw new RepositoryException(msg);
                    }
                    outputSession.save();
                    long durationInNanos = System.nanoTime() - start;
                    HashMap<String, String> payload = new HashMap<String, String>();
                    payload.put("sequencerName", sequencer.getClass().getName());
                    payload.put("sequencedPath", changedProperty.getPath());
                    payload.put("outputPath", outputNode.getPath());
                    stats.recordDuration(DurationMetric.SEQUENCER_EXECUTION_TIME, durationInNanos, TimeUnit.NANOSECONDS, payload);
                }
            }
        }
        catch (Throwable t) {
            String name;
            Logger logger = Logger.getLogger(this.getClass());
            String string = name = sequencer != null ? sequencer.getClass().getName() : this.work.getSequencerId().toString();
            if (this.work.getOutputWorkspaceName() != null) {
                logger.error(t, RepositoryI18n.errorWhileSequencingNodeIntoWorkspace, new Object[]{name, state.name(), this.work.getInputPath(), this.work.getInputWorkspaceName(), this.work.getOutputPath(), this.work.getOutputWorkspaceName()});
            } else {
                logger.error(t, RepositoryI18n.errorWhileSequencingNode, new Object[]{name, state.name(), this.work.getInputPath(), this.work.getInputWorkspaceName(), this.work.getOutputPath()});
            }
        }
        finally {
            stats.increment(ValueMetric.SEQUENCED_COUNT);
            stats.decrement(ValueMetric.SEQUENCER_QUEUE_SIZE);
            if (inputSession != null && inputSession.isLive()) {
                inputSession.logout();
            }
            if (outputSession != null && outputSession != inputSession && outputSession.isLive()) {
                outputSession.logout();
            }
        }
    }

    protected final String computeOutputNodeName(Node selectedNode) throws RepositoryException {
        String selectedNodeName = selectedNode.getName();
        if (selectedNodeName.equals("jcr:content")) {
            try {
                return selectedNode.getParent().getName();
            }
            catch (ItemNotFoundException itemNotFoundException) {
                // empty catch block
            }
        }
        return selectedNodeName;
    }

    protected final void removeExistingOutputNodes(Node parentOfOutput, String outputNodeName, String selectedPath) throws RepositoryException {
        NodeIterator outputIter = parentOfOutput.getNodes(outputNodeName);
        while (outputIter.hasNext()) {
            String derivedFrom;
            Node outputNode = outputIter.nextNode();
            if (!outputNode.isNodeType(DERIVED_NODE_TYPE_NAME) || !outputNode.hasProperty(DERIVED_FROM_PROPERTY_NAME) || !selectedPath.equals(derivedFrom = outputNode.getProperty(DERIVED_FROM_PROPERTY_NAME).getPath())) continue;
            outputNode.remove();
        }
    }
}

