/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.modeshape.jcr.query.lucene.CompareQuery;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PathFactory;
import org.modeshape.jcr.value.ValueComparators;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;

public class CompareNameQuery
extends CompareQuery<Path.Segment> {
    private static final long serialVersionUID = 1L;
    protected static final CompareQuery.Evaluator<Path.Segment> IS_LESS_THAN = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_COMPARATOR.compare(nodeValue, constraintValue) < 0;
        }

        public String toString() {
            return " < ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_LESS_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_COMPARATOR.compare(nodeValue, constraintValue) <= 0;
        }

        public String toString() {
            return " <= ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_GREATER_THAN = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_COMPARATOR.compare(nodeValue, constraintValue) > 0;
        }

        public String toString() {
            return " > ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_GREATER_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_COMPARATOR.compare(nodeValue, constraintValue) >= 0;
        }

        public String toString() {
            return " >= ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_LESS_THAN_NO_SNS = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_NAME_COMPARATOR.compare(nodeValue, constraintValue) < 0;
        }

        public String toString() {
            return " < ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_LESS_THAN_OR_EQUAL_TO_NO_SNS = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_NAME_COMPARATOR.compare(nodeValue, constraintValue) <= 0;
        }

        public String toString() {
            return " <= ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_GREATER_THAN_NO_SNS = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_NAME_COMPARATOR.compare(nodeValue, constraintValue) > 0;
        }

        public String toString() {
            return " > ";
        }
    };
    protected static final CompareQuery.Evaluator<Path.Segment> IS_GREATER_THAN_OR_EQUAL_TO_NO_SNS = new CompareQuery.Evaluator<Path.Segment>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean satisfiesConstraint(Path.Segment nodeValue, Path.Segment constraintValue) {
            return ValueComparators.PATH_SEGMENT_NAME_COMPARATOR.compare(nodeValue, constraintValue) >= 0;
        }

        public String toString() {
            return " >= ";
        }
    };
    private final String snsIndexFieldName;
    private final ValueFactory<Long> longFactory;
    private final PathFactory pathFactory;
    private final boolean caseSensitive;

    public static CompareNameQuery createQueryForNodesWithNameGreaterThan(Path.Segment constraintValue, String localNameField, String snsIndexFieldName, ValueFactories factories, boolean caseSensitive, boolean includeSns) {
        return new CompareNameQuery(localNameField, snsIndexFieldName, constraintValue, factories.getPathFactory(), factories.getStringFactory(), factories.getLongFactory(), includeSns ? IS_GREATER_THAN : IS_GREATER_THAN_NO_SNS, caseSensitive);
    }

    public static CompareNameQuery createQueryForNodesWithNameGreaterThanOrEqualTo(Path.Segment constraintValue, String localNameField, String snsIndexFieldName, ValueFactories factories, boolean caseSensitive, boolean includeSns) {
        return new CompareNameQuery(localNameField, snsIndexFieldName, constraintValue, factories.getPathFactory(), factories.getStringFactory(), factories.getLongFactory(), includeSns ? IS_GREATER_THAN_OR_EQUAL_TO : IS_GREATER_THAN_OR_EQUAL_TO_NO_SNS, caseSensitive);
    }

    public static CompareNameQuery createQueryForNodesWithNameLessThan(Path.Segment constraintValue, String localNameField, String snsIndexFieldName, ValueFactories factories, boolean caseSensitive, boolean includeSns) {
        return new CompareNameQuery(localNameField, snsIndexFieldName, constraintValue, factories.getPathFactory(), factories.getStringFactory(), factories.getLongFactory(), includeSns ? IS_LESS_THAN : IS_LESS_THAN_NO_SNS, caseSensitive);
    }

    public static CompareNameQuery createQueryForNodesWithNameLessThanOrEqualTo(Path.Segment constraintValue, String localNameField, String snsIndexFieldName, ValueFactories factories, boolean caseSensitive, boolean includeSns) {
        return new CompareNameQuery(localNameField, snsIndexFieldName, constraintValue, factories.getPathFactory(), factories.getStringFactory(), factories.getLongFactory(), includeSns ? IS_LESS_THAN_OR_EQUAL_TO : IS_LESS_THAN_OR_EQUAL_TO_NO_SNS, caseSensitive);
    }

    protected CompareNameQuery(final String localNameField, final String snsIndexFieldName, Path.Segment constraintValue, PathFactory pathFactory, ValueFactory<String> stringFactory, ValueFactory<Long> longFactory, CompareQuery.Evaluator<Path.Segment> evaluator, boolean caseSensitive) {
        super(localNameField, constraintValue, null, stringFactory, evaluator, new FieldSelector(){
            private static final long serialVersionUID = 1L;

            public FieldSelectorResult accept(String fieldName) {
                if (fieldName.equals(localNameField)) {
                    return FieldSelectorResult.LOAD;
                }
                if (fieldName.equals(snsIndexFieldName)) {
                    return FieldSelectorResult.LOAD;
                }
                return FieldSelectorResult.NO_LOAD;
            }
        });
        this.snsIndexFieldName = snsIndexFieldName;
        this.longFactory = longFactory;
        this.pathFactory = pathFactory;
        this.caseSensitive = caseSensitive;
        assert (this.snsIndexFieldName != null);
        assert (this.longFactory != null);
    }

    @Override
    protected Path.Segment readFromDocument(IndexReader reader, int docId) throws IOException {
        Document doc = reader.document(docId, this.fieldSelector);
        String localName = doc.get(this.fieldName);
        if (!this.caseSensitive) {
            localName = localName.toLowerCase();
        }
        int sns = this.longFactory.create(doc.get(this.snsIndexFieldName)).intValue();
        return this.pathFactory.createSegment(localName, sns);
    }

    public Object clone() {
        return new CompareNameQuery(this.fieldName, this.snsIndexFieldName, (Path.Segment)this.constraintValue, this.pathFactory, this.stringFactory, this.longFactory, this.evaluator, this.caseSensitive);
    }
}

