/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.query.InvalidQueryException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.modeshape.common.util.Logger;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.RepositoryCache;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryIndexing;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.lucene.LuceneException;
import org.modeshape.jcr.query.lucene.LuceneProcessingContext;
import org.modeshape.jcr.query.lucene.LuceneQuery;
import org.modeshape.jcr.query.lucene.LuceneSchema;
import org.modeshape.jcr.query.lucene.MatchNoneQuery;
import org.modeshape.jcr.query.lucene.basic.BasicLuceneSchema;
import org.modeshape.jcr.query.lucene.basic.ExistsTupleCollector;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.QueryCommand;
import org.modeshape.jcr.query.optimize.Optimizer;
import org.modeshape.jcr.query.plan.PlanHints;
import org.modeshape.jcr.query.plan.PlanNode;
import org.modeshape.jcr.query.plan.Planner;
import org.modeshape.jcr.query.process.AbstractAccessComponent;
import org.modeshape.jcr.query.process.ProcessingComponent;
import org.modeshape.jcr.query.process.QueryEngine;
import org.modeshape.jcr.query.process.QueryProcessor;
import org.modeshape.jcr.query.process.SelectComponent;
import org.modeshape.jcr.query.validate.Schemata;

public class LuceneQueryEngine
extends QueryEngine {
    private final ExecutionContext repositoryContext;
    private final BasicLuceneSchema schema;

    public LuceneQueryEngine(ExecutionContext context, String repositoryName, Planner planner, Optimizer optimizer, SearchFactoryImplementor searchFactory, Version version) {
        super(planner, optimizer, new LuceneQueryProcessor(repositoryName, (SearchFactory)searchFactory));
        this.repositoryContext = context;
        this.schema = new BasicLuceneSchema(this.repositoryContext, searchFactory, version);
        ((LuceneQueryProcessor)this.processor).initialize(this.schema);
    }

    public QueryIndexing getQueryIndexing() {
        return this.schema;
    }

    public QueryResults query(ExecutionContext context, RepositoryCache repositoryCache, Set<String> workspaceNames, Map<String, NodeCache> overriddenNodeCachesByWorkspaceName, QueryCommand query, Schemata schemata, PlanHints hints, Map<String, Object> variables) throws InvalidQueryException {
        QueryContext queryContext = new QueryContext(context, repositoryCache, workspaceNames, overriddenNodeCachesByWorkspaceName, schemata, hints, null, variables);
        return this.execute(queryContext, query);
    }

    public static abstract class TupleCollector
    extends Collector {
        public abstract List<Object[]> getTuples();

        public final void collect(int doc) throws IOException {
            this.doCollect(doc);
        }

        public abstract float doCollect(int var1) throws IOException;
    }

    protected static class LuceneAccessQuery
    extends AbstractAccessComponent {
        private final LuceneProcessingContext processingContext;
        private final LuceneSchema schema;

        public LuceneAccessQuery(LuceneSchema schema, LuceneProcessingContext processingContext, QueryContext context, QueryResults.Columns resultColumns, PlanNode accessNode) {
            super(context, resultColumns, accessNode);
            this.schema = schema;
            this.processingContext = processingContext;
        }

        @Override
        public List<Object[]> execute() {
            assert (this.andedConstraints != null);
            assert (this.limit != null);
            LuceneQuery queries = this.schema.createQuery(this.sourceName, this.andedConstraints, this.processingContext);
            if (queries.matchesNone()) {
                return Collections.emptyList();
            }
            Query pushDownQuery = queries.getPushDownQuery();
            if (pushDownQuery == null) {
                pushDownQuery = new MatchAllDocsQuery();
            }
            QueryContext queryContext = this.getContext();
            List<Object[]> tuples = null;
            QueryResults.Columns columns = this.getColumns();
            if (pushDownQuery instanceof MatchNoneQuery) {
                tuples = Collections.emptyList();
            } else {
                try {
                    String indexName = queries.getPushDownIndexName();
                    IndexSearcher searcher = this.processingContext.getSearcher(indexName);
                    Logger logger = Logger.getLogger(this.getClass());
                    if (logger.isTraceEnabled()) {
                        Set<String> workspaceNames = this.processingContext.getWorkspaceNames();
                        String repoName = this.processingContext.getRepositoryName();
                        logger.trace("query \"{0}\" workspace(s) in \"{1}\" repository: {2}", new Object[]{repoName, workspaceNames, pushDownQuery});
                    }
                    TupleCollector collector = this.schema.createTupleCollector(queryContext, columns);
                    if (this.getContext().getHints().isExistsQuery) {
                        collector = new ExistsTupleCollector(collector);
                        try {
                            searcher.search(pushDownQuery, (Collector)collector);
                        }
                        catch (ExistsTupleCollector.CompletedException e) {}
                    } else {
                        searcher.search(pushDownQuery, (Collector)collector);
                    }
                    tuples = collector.getTuples();
                }
                catch (IOException e) {
                    throw new LuceneException(e);
                }
            }
            if (!tuples.isEmpty()) {
                Constraint postProcessingConstraints = queries.getPostProcessingConstraints();
                if (postProcessingConstraints != null) {
                    final List<Object[]> allTuples = tuples;
                    ProcessingComponent tuplesProcessor = new ProcessingComponent(queryContext, columns){

                        @Override
                        public List<Object[]> execute() {
                            return allTuples;
                        }
                    };
                    SelectComponent selector = new SelectComponent(tuplesProcessor, postProcessingConstraints, queryContext.getVariables());
                    tuples = selector.execute();
                }
                if (!this.limit.isUnlimited()) {
                    int firstIndex = this.limit.getOffset();
                    int maxRows = Math.min(tuples.size(), this.limit.getRowLimit());
                    if (firstIndex > 0) {
                        if (firstIndex > tuples.size()) {
                            tuples.clear();
                        } else {
                            tuples = tuples.subList(firstIndex, maxRows);
                        }
                    } else {
                        tuples = tuples.subList(0, maxRows);
                    }
                }
            }
            return tuples;
        }
    }

    protected static class LuceneQueryProcessor
    extends QueryProcessor<LuceneProcessingContext> {
        private final SearchFactory searchFactory;
        private final String repositoryName;
        private LuceneSchema schema;

        protected LuceneQueryProcessor(String repositoryName, SearchFactory searchFactory) {
            this.searchFactory = searchFactory;
            this.repositoryName = repositoryName;
        }

        protected void initialize(LuceneSchema schema) {
            this.schema = schema;
            assert (this.schema != null);
        }

        @Override
        protected boolean supportsPushDownExistConstraints() {
            return true;
        }

        @Override
        protected LuceneProcessingContext createProcessingContext(QueryContext queryContext) {
            return new LuceneProcessingContext(queryContext, this.repositoryName, this.searchFactory, this.schema);
        }

        @Override
        protected void closeProcessingContext(LuceneProcessingContext processingContext) {
            assert (processingContext != null);
            processingContext.close();
        }

        @Override
        protected ProcessingComponent createAccessComponent(QueryCommand originalQuery, QueryContext context, PlanNode accessNode, QueryResults.Columns resultColumns, LuceneProcessingContext processingContext) {
            assert (this.schema != null);
            return new LuceneAccessQuery(this.schema, processingContext, context, resultColumns, accessNode);
        }
    }
}

