/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.collection.ArrayListMultimap;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.GraphI18n;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.model.Column;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.FullTextSearch;
import org.modeshape.jcr.query.model.Visitors;

@Immutable
public class QueryResultColumns
implements QueryResults.Columns {
    private static final long serialVersionUID = 1L;
    protected static final List<Column> NO_COLUMNS = Collections.emptyList();
    protected static final List<String> NO_TYPES = Collections.emptyList();
    protected static final QueryResultColumns EMPTY = new QueryResultColumns(false, null, null);
    protected static final String DEFAULT_SELECTOR_NAME = "Results";
    private final int tupleSize;
    private final List<Column> columns;
    private final List<String> columnNames;
    private final List<String> columnTypes;
    private final List<String> selectorNames;
    private List<String> tupleValueNames;
    private final Map<String, String> selectorNameByColumnName;
    private final Map<String, Integer> columnIndexByColumnName;
    private final Map<String, Integer> locationIndexBySelectorName;
    private final Map<String, Integer> locationIndexByColumnName;
    private final Map<Integer, Integer> locationIndexByColumnIndex;
    private final Map<String, Map<String, Integer>> columnIndexByPropertyNameBySelectorName;
    private final Map<String, Integer> fullTextSearchScoreIndexBySelectorName;
    private final Map<String, String> propertyNameByColumnName;

    public static QueryResultColumns empty() {
        return EMPTY;
    }

    public QueryResultColumns(List<? extends Column> columns, List<String> columnTypes, boolean includeFullTextSearchScores) {
        this(includeFullTextSearchScores, columns, columnTypes);
        CheckArg.isNotEmpty(columns, (String)"columns");
        CheckArg.isNotEmpty(columnTypes, (String)"columnTypes");
    }

    protected QueryResultColumns(boolean includeFullTextSearchScores, List<? extends Column> columns, List<String> columnTypes) {
        this.columns = columns != null ? Collections.unmodifiableList(columns) : NO_COLUMNS;
        this.columnTypes = columnTypes != null ? Collections.unmodifiableList(columnTypes) : NO_TYPES;
        this.columnIndexByColumnName = new HashMap<String, Integer>();
        HashSet<String> selectors = new HashSet<String>();
        int columnCount = this.columns.size();
        Integer selectorIndex = new Integer(columnCount - 1);
        this.locationIndexBySelectorName = new HashMap<String, Integer>();
        this.locationIndexByColumnIndex = new HashMap<Integer, Integer>();
        this.locationIndexByColumnName = new HashMap<String, Integer>();
        this.selectorNameByColumnName = new HashMap<String, String>();
        this.columnIndexByPropertyNameBySelectorName = new HashMap<String, Map<String, Integer>>();
        this.propertyNameByColumnName = new HashMap<String, String>();
        ArrayList<String> selectorNames = new ArrayList<String>(columnCount);
        ArrayList<String> names = new ArrayList<String>(columnCount);
        Set<Column> sameNameColumns = QueryResultColumns.findColumnsWithSameNames(this.columns);
        int max = this.columns.size();
        for (int i = 0; i != max; ++i) {
            Column column = this.columns.get(i);
            assert (column != null);
            String selectorName = column.selectorName().name();
            if (selectors.add(selectorName)) {
                selectorNames.add(selectorName);
                selectorIndex = new Integer(selectorIndex + 1);
                this.locationIndexBySelectorName.put(selectorName, selectorIndex);
            }
            String columnName = QueryResultColumns.columnNameFor(column, names, sameNameColumns);
            assert (columnName != null);
            this.propertyNameByColumnName.put(columnName, column.getPropertyName());
            this.selectorNameByColumnName.put(columnName, selectorName);
            this.columnIndexByColumnName.put(columnName, new Integer(i));
            this.locationIndexByColumnIndex.put(new Integer(i), selectorIndex);
            this.locationIndexByColumnName.put(columnName, selectorIndex);
            Map<String, Integer> byPropertyName = this.columnIndexByPropertyNameBySelectorName.get(selectorName);
            if (byPropertyName == null) {
                byPropertyName = new HashMap<String, Integer>();
                this.columnIndexByPropertyNameBySelectorName.put(selectorName, byPropertyName);
            }
            byPropertyName.put(column.getPropertyName(), new Integer(i));
        }
        if (columns != null && selectorNames.isEmpty()) {
            String selectorName = DEFAULT_SELECTOR_NAME;
            selectorNames.add(selectorName);
            this.locationIndexBySelectorName.put(selectorName, 0);
        }
        this.selectorNames = Collections.unmodifiableList(selectorNames);
        this.columnNames = Collections.unmodifiableList(names);
        if (includeFullTextSearchScores) {
            this.fullTextSearchScoreIndexBySelectorName = new HashMap<String, Integer>();
            int numSelectors = selectorNames.size();
            for (String selectorName : selectorNames) {
                int index = this.locationIndexBySelectorName.get(selectorName) + numSelectors;
                this.fullTextSearchScoreIndexBySelectorName.put(selectorName, new Integer(index));
            }
            this.tupleSize = this.columnNames.size() + selectorNames.size() + selectorNames.size();
        } else {
            this.fullTextSearchScoreIndexBySelectorName = null;
            this.tupleSize = this.columnNames.size() + selectorNames.size();
        }
    }

    private QueryResultColumns(List<Column> columns, QueryResultColumns wrappedAround) {
        assert (columns != null);
        this.columns = Collections.unmodifiableList(columns);
        this.columnIndexByColumnName = new HashMap<String, Integer>();
        this.locationIndexBySelectorName = new HashMap<String, Integer>();
        this.locationIndexByColumnIndex = new HashMap<Integer, Integer>();
        this.locationIndexByColumnName = new HashMap<String, Integer>();
        this.columnIndexByPropertyNameBySelectorName = new HashMap<String, Map<String, Integer>>();
        this.propertyNameByColumnName = new HashMap<String, String>();
        this.selectorNameByColumnName = new HashMap<String, String>();
        this.selectorNames = new ArrayList<String>(columns.size());
        ArrayList<String> types = new ArrayList<String>(columns.size());
        ArrayList<String> names = new ArrayList<String>(columns.size());
        Set<Column> sameNameColumns = QueryResultColumns.findColumnsWithSameNames(this.columns);
        int max = this.columns.size();
        for (int i = 0; i != max; ++i) {
            String columnNameWithoutSelector;
            Column column = this.columns.get(i);
            assert (column != null);
            String selectorName = column.selectorName().name();
            if (!this.selectorNames.contains(selectorName)) {
                this.selectorNames.add(selectorName);
            }
            String columnName = QueryResultColumns.columnNameFor(column, names, sameNameColumns);
            assert (columnName != null);
            this.propertyNameByColumnName.put(columnName, column.getPropertyName());
            this.selectorNameByColumnName.put(columnName, selectorName);
            Integer columnIndex = wrappedAround.columnIndexForName(columnName);
            if (columnIndex == null && (columnIndex = wrappedAround.columnIndexForName(columnNameWithoutSelector = column.getColumnName() != null ? column.getColumnName() : column.getPropertyName())) == null) {
                String columnNameWithSelector = column.selectorName() + "." + columnNameWithoutSelector;
                columnIndex = wrappedAround.columnIndexForName(columnNameWithSelector);
            }
            assert (columnIndex != null);
            this.columnIndexByColumnName.put(columnName, columnIndex);
            types.add(wrappedAround.getColumnTypes().get(columnIndex));
            Integer selectorIndex = new Integer(wrappedAround.getLocationIndex(selectorName));
            this.locationIndexBySelectorName.put(selectorName, selectorIndex);
            this.locationIndexByColumnIndex.put(columnIndex, selectorIndex);
            this.locationIndexByColumnName.put(columnName, selectorIndex);
            Map<String, Integer> byPropertyName = this.columnIndexByPropertyNameBySelectorName.get(selectorName);
            if (byPropertyName == null) {
                byPropertyName = new HashMap<String, Integer>();
                this.columnIndexByPropertyNameBySelectorName.put(selectorName, byPropertyName);
            }
            byPropertyName.put(column.getPropertyName(), columnIndex);
        }
        if (this.selectorNames.isEmpty()) {
            String selectorName = DEFAULT_SELECTOR_NAME;
            this.selectorNames.add(selectorName);
            this.locationIndexBySelectorName.put(selectorName, 0);
        }
        this.columnNames = Collections.unmodifiableList(names);
        this.columnTypes = Collections.unmodifiableList(types);
        if (wrappedAround.fullTextSearchScoreIndexBySelectorName != null) {
            this.fullTextSearchScoreIndexBySelectorName = new HashMap<String, Integer>();
            for (String selectorName : this.selectorNames) {
                Integer selectorIndex = new Integer(wrappedAround.getFullTextSearchScoreIndexFor(selectorName));
                this.fullTextSearchScoreIndexBySelectorName.put(selectorName, selectorIndex);
            }
            this.tupleSize = this.columnNames.size() + this.selectorNames.size() + this.selectorNames.size();
        } else {
            this.fullTextSearchScoreIndexBySelectorName = null;
            this.tupleSize = this.columnNames.size() + this.selectorNames.size();
        }
    }

    public static boolean includeFullTextScores(Iterable<Constraint> constraints) {
        for (Constraint constraint : constraints) {
            if (!QueryResultColumns.includeFullTextScores(constraint)) continue;
            return true;
        }
        return false;
    }

    public static boolean includeFullTextScores(Constraint constraint) {
        final AtomicBoolean includeFullTextScores = new AtomicBoolean(false);
        if (constraint != null) {
            Visitors.visitAll(constraint, new Visitors.AbstractVisitor(){

                @Override
                public void visit(FullTextSearch obj) {
                    includeFullTextScores.set(true);
                }
            });
        }
        return includeFullTextScores.get();
    }

    @Override
    public QueryResults.Columns subSelect(List<Column> columns) {
        return new QueryResultColumns(columns, this);
    }

    @Override
    public QueryResults.Columns subSelect(Column ... columns) {
        return new QueryResultColumns(Arrays.asList(columns), this);
    }

    @Override
    public QueryResults.Columns joinWith(QueryResults.Columns rightColumns) {
        if (this == rightColumns) {
            return this;
        }
        ArrayList<Column> columns = new ArrayList<Column>(this.getColumnCount() + rightColumns.getColumnCount());
        columns.addAll(this.getColumns());
        columns.addAll(rightColumns.getColumns());
        ArrayList<String> types = new ArrayList<String>(this.getColumnCount() + rightColumns.getColumnCount());
        types.addAll(this.getColumnTypes());
        types.addAll(rightColumns.getColumnTypes());
        boolean includeFullTextScores = this.hasFullTextSearchScores() || rightColumns.hasFullTextSearchScores();
        return new QueryResultColumns(columns, types, includeFullTextScores);
    }

    @Override
    public List<? extends Column> getColumns() {
        return this.columns;
    }

    @Override
    public Iterator<Column> iterator() {
        return this.getColumns().iterator();
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public List<String> getColumnTypes() {
        return this.columnTypes;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getLocationCount() {
        return this.selectorNames.size();
    }

    @Override
    public List<String> getSelectorNames() {
        return this.selectorNames;
    }

    @Override
    public int getTupleSize() {
        return this.tupleSize;
    }

    @Override
    public List<String> getTupleValueNames() {
        if (this.tupleValueNames == null) {
            String name;
            ArrayList<String> results = new ArrayList<String>(this.getTupleSize());
            results.addAll(this.columnNames);
            for (String selectorName : this.selectorNames) {
                name = "Location(" + selectorName + ")";
                results.add(name);
            }
            if (this.fullTextSearchScoreIndexBySelectorName != null) {
                for (String selectorName : this.selectorNames) {
                    name = "Score(" + selectorName + ")";
                    results.add(name);
                }
            }
            this.tupleValueNames = results;
        }
        return this.tupleValueNames;
    }

    @Override
    public int getLocationIndexForColumn(int columnIndex) {
        if (this.locationIndexByColumnIndex.isEmpty()) {
            return 0;
        }
        Integer result = this.locationIndexByColumnIndex.get(new Integer(columnIndex));
        if (result == null) {
            throw new IndexOutOfBoundsException(GraphI18n.columnDoesNotExistInQuery.text(new Object[]{columnIndex}));
        }
        return result;
    }

    @Override
    public int getLocationIndexForColumn(String columnName) {
        if (this.locationIndexByColumnName.isEmpty()) {
            return 0;
        }
        Integer result = this.locationIndexByColumnName.get(columnName);
        if (result == null) {
            throw new NoSuchElementException(GraphI18n.columnDoesNotExistInQuery.text(new Object[]{columnName}));
        }
        return result;
    }

    @Override
    public int getLocationIndex(String selectorName) {
        Integer result = this.locationIndexBySelectorName.get(selectorName);
        if (result == null) {
            throw new NoSuchElementException(GraphI18n.selectorDoesNotExistInQuery.text(new Object[]{selectorName}));
        }
        return result;
    }

    @Override
    public boolean hasSelector(String selectorName) {
        return this.locationIndexBySelectorName.containsKey(selectorName);
    }

    @Override
    public String getPropertyNameForColumn(int columnIndex) {
        return this.columns.get(columnIndex).getPropertyName();
    }

    @Override
    public String getPropertyNameForColumnName(String columnName) {
        String result = this.propertyNameByColumnName.get(columnName);
        return result != null ? result : columnName;
    }

    @Override
    public int getColumnIndexForName(String columnName) {
        Integer result = this.columnIndexByColumnName.get(columnName);
        if (result == null) {
            throw new NoSuchElementException(GraphI18n.columnDoesNotExistInQuery.text(new Object[]{columnName}));
        }
        return result;
    }

    protected Integer columnIndexForName(String columnName) {
        return this.columnIndexByColumnName.get(columnName);
    }

    @Override
    public String getSelectorNameForColumnName(String columnName) {
        return this.selectorNameByColumnName.get(columnName);
    }

    @Override
    public int getColumnIndexForProperty(String selectorName, String propertyName) {
        Map<String, Integer> byPropertyName = this.columnIndexByPropertyNameBySelectorName.get(selectorName);
        if (byPropertyName == null) {
            throw new NoSuchElementException(GraphI18n.selectorDoesNotExistInQuery.text(new Object[]{selectorName}));
        }
        Integer result = byPropertyName.get(propertyName);
        if (result == null) {
            throw new NoSuchElementException(GraphI18n.propertyOnSelectorIsNotUsedInQuery.text(new Object[]{propertyName, selectorName}));
        }
        return result;
    }

    @Override
    public int getFullTextSearchScoreIndexFor(String selectorName) {
        if (this.fullTextSearchScoreIndexBySelectorName == null) {
            return -1;
        }
        Integer result = this.fullTextSearchScoreIndexBySelectorName.get(selectorName);
        if (result == null) {
            throw new NoSuchElementException(GraphI18n.selectorDoesNotExistInQuery.text(new Object[]{selectorName}));
        }
        return result;
    }

    @Override
    public boolean hasFullTextSearchScores() {
        return this.fullTextSearchScoreIndexBySelectorName != null;
    }

    @Override
    public boolean includes(QueryResults.Columns other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.getColumns().containsAll(other.getColumns());
    }

    @Override
    public boolean isUnionCompatible(QueryResults.Columns other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.hasFullTextSearchScores() != other.hasFullTextSearchScores()) {
            return false;
        }
        if (this.getColumnCount() != other.getColumnCount()) {
            return false;
        }
        return this.getColumns().containsAll(other.getColumns()) && other.getColumns().containsAll(this.getColumns());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QueryResultColumns) {
            QueryResultColumns that = (QueryResultColumns)obj;
            return ((Object)this.getColumns()).equals(that.getColumns());
        }
        return false;
    }

    protected static String columnNameFor(Column column, List<String> columnNames, Set<Column> columnsWithDuplicateNames) {
        String columnName;
        String string = columnName = column.getColumnName() != null ? column.getColumnName() : column.getPropertyName();
        if (columnNames.contains(columnName) || columnsWithDuplicateNames.contains(column)) {
            columnName = column.selectorName() + "." + columnName;
        }
        columnNames.add(columnName);
        return columnName;
    }

    protected static Set<Column> findColumnsWithSameNames(List<Column> columns) {
        ArrayListMultimap columnNames = ArrayListMultimap.create();
        for (Column column : columns) {
            String columnName = column.getColumnName() != null ? column.getColumnName() : column.getPropertyName();
            columnNames.put((Object)columnName, (Object)column);
        }
        HashSet<Column> results = new HashSet<Column>();
        for (Map.Entry entry : columnNames.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            results.addAll((Collection)entry.getValue());
        }
        return results;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        Iterator<String> nameIter = this.columnNames.iterator();
        for (Column column : this.getColumns()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(column);
            sb.append('(').append(this.getColumnIndexForName(nameIter.next())).append(')');
        }
        sb.append("] => Locations[");
        first = true;
        int n = this.getColumnCount();
        for (int i = 0; i != n; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.getLocationIndexForColumn(i));
        }
        sb.append(']');
        return sb.toString();
    }
}

